---
name: scamper-put-to-other-uses
description: Generate innovative ideas by repurposing components for new applications. Part of SCAMPER ideation toolkit. Discover hidden value by finding alternative uses for existing resources—new users, new problems, new contexts. Waste becomes valuable. Secondary becomes primary. Can be used standalone or as part of ideation-scamper orchestration.
---

# SCAMPER: Put to Other Uses - Repurpose Components

## Purpose

Generate innovative ideas by finding alternative applications for existing components. Repurposing reveals hidden value, creates platform opportunities, and generates new revenue from existing assets.

## When to Use This Skill

Use this skill when:
- Have underutilized assets or capabilities
- Want to discover new markets or applications
- Looking for ways to monetize waste or byproducts
- Seeking platform or ecosystem opportunities
- Part of comprehensive SCAMPER session (use ideation-scamper orchestrator)

## The Put to Other Uses Technique

**Core question:** What else can this be used for?

**Philosophy:** Components rarely have only one use. Secondary uses can become primary. Waste can become valuable. The customer you didn't imagine might be your best customer.

## Types of Repurposing

### 1. New User Segments
Same purpose, different users
- Example: Industrial 3D printer → Consumer hobby tool
- Example: Enterprise software → Small business → Individual
- Example: Medical equipment → Home wellness

### 2. New Problems
Same component, different problem
- Example: Bubble wrap: Wallpaper → Packaging protection
- Example: Play-Doh: Wallpaper cleaner → Children's toy
- Example: Arm & Hammer: Cooking → Deodorizing → Toothpaste

### 3. New Contexts
Same function, different environment
- Example: Indoor furniture → Outdoor weather-resistant
- Example: Gym equipment → Home fitness
- Example: Office software → Field operations

### 4. Waste to Value
Byproducts become products
- Example: Sawdust → Particle board
- Example: Whey from cheese → Protein powder
- Example: Data exhaust → Analytics product

### 5. Secondary to Primary
Side feature becomes main purpose
- Example: Twitter: Status updates → News distribution
- Example: Instagram: Photo filters → Social platform
- Example: Slack: Gaming chat → Work communication

### 6. Platform Plays
Single use → Multi-purpose infrastructure
- Example: Amazon logistics → AWS (servers during downtime)
- Example: Uber drivers → Uber Eats delivery
- Example: Payment processor → Financial platform

## Workflow

### Step 1: List All Components
Review your Closed World—every internal and external component.

### Step 2: For Each Component, Ask
- Who else might want this?
- What other problems could this solve?
- Where else could this work?
- What's the waste or byproduct?
- What secondary features exist?

### Step 3: Think Expansively
Don't limit to obvious adjacent uses. Consider radical repurposing.

### Step 4: Identify Hidden Assets
What do you have that others might value differently?

### Step 5: Generate 5-10 Ideas
Document repurposing with new use cases.

## Prompting Questions

**New Users:**
- Who else could use this component?
- What if we targeted [completely different segment]?
- Can we go from B2B to B2C (or vice versa)?
- What about underserved populations?

**New Problems:**
- What other problems does this solve?
- Where else does this capability apply?
- What adjacent pain points exist?
- What can this do that we're not emphasizing?

**New Contexts:**
- Where else could this be deployed?
- What if we moved from online to offline (or vice versa)?
- Can this work in developing markets? Extreme environments?
- What if the context was emergency vs routine?

**Waste/Byproducts:**
- What are we currently discarding?
- What data/assets/outputs are unused?
- Can waste become someone's treasure?
- What secondary effects could be monetized?

**Secondary Features:**
- What features do users mention that we don't emphasize?
- What do people use this for that surprises us?
- What unintended use cases exist?
- Can a side feature become the main product?

**Platform:**
- Can this infrastructure serve others?
- What if this became a marketplace?
- Can we open this to third parties?
- What platform opportunity hiding here?

## Examples from Case Studies

### FairCredit (Nigeria Micro-Lending)

**Put to Other Uses #1:** Transaction analysis → Business insights dashboard
- **Component repurposed:** Transaction history analyzer
- **New use:** Credit assessment → Business intelligence tool
- **Benefit:** Value-add service, helps users grow revenue, differentiation

**Put to Other Uses #2:** SMS system → Emergency alerts & community news
- **Component repurposed:** Notification infrastructure
- **New use:** Loan reminders → Community information channel
- **Benefit:** Engagement, social value, brand building, daily touchpoint

**Put to Other Uses #3:** Loan algorithm → Supplier credit scoring
- **Component repurposed:** Credit scoring engine
- **New use:** Consumer lending → B2B trade credit
- **Benefit:** New market, ecosystem expansion, data leverage

**Put to Other Uses #4:** Customer support chatbot → Financial counseling
- **Component repurposed:** Support bot
- **New use:** Troubleshooting → Proactive financial advice
- **Benefit:** Better outcomes, prevention, differentiation

**Put to Other Uses #5:** Location data → Merchant discovery
- **Component repurposed:** GPS tracking
- **New use:** Risk assessment → Local business directory
- **Benefit:** Connect users to suppliers, marketplace revenue

**Put to Other Uses #6:** Repayment tracking → Personal budgeting
- **Component repurposed:** Payment monitor
- **New use:** Loan tracking → Overall expense management
- **Benefit:** Financial wellness, increased stickiness

**Put to Other Uses #7:** Social network data → Job referrals
- **Component repurposed:** Contact analysis
- **New use:** Credit verification → Employment opportunities
- **Benefit:** Income growth, repayment capacity improvement

### AsyncFlow (Remote Collaboration)

**Put to Other Uses #1:** Message threads → Knowledge base articles
- **Component repurposed:** Discussions
- **New use:** Team communication → Documentation
- **Benefit:** Documentation as byproduct, searchable, onboarding resource

**Put to Other Uses #2:** Timezone data → Work-life balance monitoring
- **Component repurposed:** Scheduling information
- **New use:** Meeting coordination → Burnout prevention
- **Benefit:** Employee wellness, manager insights, retention

**Put to Other Uses #3:** Decision history → Training materials
- **Component repurposed:** Project records
- **New use:** Current work → New employee education
- **Benefit:** Faster onboarding, institutional knowledge preserved

**Put to Other Uses #4:** Integration API → Developer platform
- **Component repurposed:** Internal connectors
- **New use:** Our integrations → Ecosystem marketplace
- **Benefit:** Network effects, third-party innovation

### SolarSeva (India Home Solar)

**Put to Other Uses #1:** Technician network → General appliance repair
- **Component repurposed:** Installation team
- **New use:** Solar-specific → All household repairs
- **Benefit:** Revenue stream, customer touchpoints, asset utilization

**Put to Other Uses #2:** Monitoring system → Home security
- **Component repurposed:** Energy tracking sensors
- **New use:** Performance data → Intrusion detection
- **Benefit:** Value-add, differentiation, higher willingness to pay

**Put to Other Uses #3:** Solar panels → Mobile device charging stations
- **Component repurposed:** Household electricity
- **New use:** Home power → Community charging service
- **Benefit:** Social hub, revenue, marketing

**Put to Other Uses #4:** Customer data → Market research product
- **Component repurposed:** Usage patterns
- **New use:** Internal operations → Insights for appliance manufacturers
- **Benefit:** New revenue, data monetization

### Unbroken (Sweden Disaster Logistics)

**Put to Other Uses #1:** Mesh network → Post-disaster general communication
- **Component repurposed:** Logistics data sync
- **New use:** Supply chain → Emergency public communication
- **Benefit:** Social value, government partnerships, critical infrastructure

**Put to Other Uses #2:** Optimization algorithm → Normal operations
- **Component repurposed:** Disaster routing
- **New use:** Crisis mode → Everyday logistics
- **Benefit:** ROI in peacetime, continuous improvement, adoption

**Put to Other Uses #3:** Offline capability → Remote area deployment
- **Component repurposed:** Disaster resilience
- **New use:** Connectivity backup → Serving underconnected regions
- **Benefit:** New markets, infrastructure-independent value

**Put to Other Uses #4:** Conflict resolution logic → Multi-party negotiation
- **Component repurposed:** Data consistency
- **New use:** Technical sync → Business process arbitration
- **Benefit:** Broader application, platform opportunity

## Output Format

```markdown
# PUT TO OTHER USES Ideas: [Product/Service Name]

## Components with Repurposing Potential
[List components that might have alternative uses]

## Repurposing Ideas

### Idea 1: [Short Name]
**Component repurposed:** [Component from Closed World]
**Original use:** [Current purpose]
**New use:** [Alternative application]
**New user/context/problem:** [Who/where/what for]
**Potential benefits:**
- [Benefit 1: often new revenue, market, or efficiency]
- [Benefit 2]
**Requirements to enable:** [What needs to change to support new use]

### Idea 2: [Short Name]
[Same structure]

[Continue for 5-10 ideas]

## Summary
**Total repurposing ideas:** [count]
**Platform opportunities:** [Any infrastructure that could serve multiple uses]
**Waste-to-value ideas:** [Any byproduct monetization]
**Most surprising:** [Unexpected repurposing that emerged]
**Most promising:** [Top 3]
```

## Tips for Success

**Do:**
- Look at underutilized assets first
- Ask customers what they use for that surprises you
- Think about waste and byproducts as valuable
- Consider platform potential (serving multiple parties)
- Look for secondary features users love

**Don't:**
- Limit to obvious adjacent uses
- Ignore waste streams (often highest value)
- Forget to ask users how they actually use your product
- Miss platform opportunities (infrastructure serving others)

## Common Pitfalls

- **Not seeing waste value:** Sawdust → particle board wealth
- **Ignoring unintended uses:** Users often discover new uses—listen
- **Missing platform plays:** Your infrastructure might serve ecosystem
- **Forgetting bylaws:** Data, time, assets you're not monetizing

## The Amazon Model

**Amazon repurposing pattern:**
- Selling books → Selling everything → Marketplace
- Internal servers → AWS cloud service
- Logistics → Fulfillment by Amazon
- Recommendations → Advertising platform

**Lesson:** Infrastructure built for one use often has platform potential.

## Integration Points

**Input from solution-definition:**
- Closed World components all have potential alternative uses
- Customer interviews might reveal unexpected uses
- Waste and byproducts in current system

**Output to idea-evaluation:**
- Repurposing ideas with new market potential
- Platform opportunity flagged for strategic consideration
- Revenue diversification options

**Used with other SCAMPER techniques:**
- Put to other uses then Modify (repurpose then optimize for new use)
- Combine + Put to other uses (bundle repurposed components)
- Adapt helps identify other uses (how do others use similar components)

## Next Steps

After generating repurposing ideas:
1. **Validate new markets:** Do these users actually want this?
2. **Platform assessment:** Is there a marketplace opportunity?
3. **Continue SCAMPER:** Use other techniques (Eliminate, Reverse)
4. **Monetization analysis:** What's revenue potential of alternative uses?

Repurposing often reveals hidden assets worth more than original purpose—pay special attention to platform opportunities.
