---
name: scamper-reverse
description: Generate innovative ideas by flipping, inverting, or rearranging processes and relationships. Part of SCAMPER ideation toolkit. Challenge assumptions through inversion—reverse roles, direction, timing, sequence, or ownership models. Often generates most disruptive and differentiated innovations. Can be used standalone or as part of ideation-scamper orchestration.
---

# SCAMPER: Reverse/Rearrange - Flip or Reorder

## Purpose

Generate innovative ideas by systematically inverting relationships, flipping processes, or rearranging sequences. Reversal challenges fundamental assumptions and often reveals disruptive business model innovations.

## When to Use This Skill

Use this skill when:
- Want to challenge industry assumptions and norms
- Seeking disruptive or counter-intuitive innovations
- Looking for business model innovations
- Want to differentiate through unconventional approaches
- Part of comprehensive SCAMPER session (use ideation-scamper orchestrator)

## The Reverse Technique

**Core question:** What can you flip, invert, or resequence?

**Philosophy:** Assumptions hide in plain sight. "That's just how it's done" signals opportunity. Reversal forces you to question direction, sequence, roles, and relationships—often revealing breakthrough innovations that competitors miss.

## Types of Reversal

### 1. Process Order Reversal
Flip the sequence
- Example: Freemium—use first, pay later (vs pay first, use later)
- Example: Pre-orders—pay before product exists (vs product first, sales later)
- Example: Flipped classroom—lecture at home, homework at school

### 2. Role Reversal
Provider ↔ Consumer
- Example: YouTube—consumers become creators
- Example: Airbnb—consumers become hotel operators
- Example: Uber—consumers become taxi operators

### 3. Direction Reversal
Push ↔ Pull, Give ↔ Take
- Example: Pull manufacturing (build to order vs build to stock)
- Example: Reverse auctions—buyers set price, sellers compete
- Example: Customer acquisition—inbound vs outbound

### 4. Timing Reversal
Before ↔ After, Proactive ↔ Reactive
- Example: Preventive medicine vs treating illness
- Example: Pre-crime prediction vs post-crime investigation
- Example: Predictive maintenance vs fixing after failure

### 5. Ownership Reversal
Buy ↔ Rent, Keep ↔ Share, Own ↔ Access
- Example: Car ownership → Car sharing (Zipcar)
- Example: Software purchase → Software rental (SaaS)
- Example: Private goods → Shared economy

### 6. Information Flow Reversal
Broadcast ↔ Narrowcast, Central ↔ Distributed
- Example: Mass media → Personalized feeds
- Example: Centralized database → Blockchain
- Example: Top-down → Bottom-up (Wikipedia)

### 7. Power Balance Reversal
Who has control or leverage
- Example: Open source—users have code access
- Example: Crowdfunding—customers fund before product exists
- Example: Platform economics—suppliers compete for customers

## Workflow

### Step 1: Identify Assumptions
What does everyone assume about your industry?
- Who pays whom?
- What happens first, second, third?
- Who provides, who consumes?
- What direction does value flow?

### Step 2: Systematic Inversion
For each assumption, ask: What if the opposite were true?

### Step 3: Explore Sequences
Can you rearrange the order? What happens if step 3 becomes step 1?

### Step 4: Flip Relationships
What if provider and consumer switched? Buyer and seller?

### Step 5: Consider Timing
What if before became after? Proactive became reactive?

### Step 6: Generate 5-10 Ideas
Document reversals with new dynamics they create.

## Prompting Questions

**Process:**
- What if we reversed the sequence?
- What happens last that could happen first?
- Can we flip the entire workflow?
- What if output became input?

**Roles:**
- What if provider and consumer switched places?
- What if users became creators?
- Can customers become distributors?
- What if employees became contractors (or vice versa)?

**Direction:**
- What if we pulled instead of pushed?
- What if distributed instead of centralized?
- Can we reverse the flow?
- What if bottom-up instead of top-down?

**Timing:**
- What if we acted before the problem, not after?
- What if reactive became proactive?
- Can we reverse when payment happens?
- What if permanent became temporary (or vice versa)?

**Ownership:**
- What if rent instead of own?
- What if share instead of keep?
- What if access instead of possession?
- Can we reverse who owns what?

**Power:**
- What if customers had more power than company?
- What if suppliers competed instead of customers?
- Can we flip who has leverage?
- What if transparent instead of opaque (or vice versa)?

## Examples from Case Studies

### FairCredit (Nigeria Micro-Lending)

**Reverse #1:** Flip lending direction—users save/lend to FairCredit first
- **What's reversed:** Money flow (FairCredit → User becomes User → FairCredit first)
- **Benefit:** Builds savings before borrowing, reduces risk, financial discipline

**Reverse #2:** Invert credit-building—start high trust, decrease if fail
- **What's reversed:** Traditional "prove yourself" → "We trust you until proven otherwise"
- **Benefit:** Dignified, optimistic, motivating, culturally appropriate

**Reverse #3:** Flip pricing—borrowers propose their own interest rate
- **What's reversed:** Lender sets price → Borrower bids
- **Benefit:** Market discovery, empowerment, transparency, auction dynamics

**Reverse #4:** Reverse teaching—borrowers educate others about finance
- **What's reversed:** FairCredit teaches users → Users teach each other
- **Benefit:** Community ownership, peer learning, scale, authenticity

**Reverse #5:** Flip timing—repay before borrowing (pay-forward)
- **What's reversed:** Borrow then repay → Repay then borrow
- **Benefit:** Zero default risk, builds savings, proves commitment

**Reverse #6:** Invert verification—merchants verify users, not FairCredit
- **What's reversed:** Centralized verification → Distributed community verification
- **Benefit:** Community trust, accuracy, relationships, cultural fit

**Reverse #7:** Flip disbursement—pull not push (credit line, user controls timing)
- **What's reversed:** Lump sum on approval → Credit line, withdraw when needed
- **Benefit:** Flexibility, only borrow what's needed, lower interest

**Reverse #8:** Invert growth—start urban, move rural (opposite of typical microfinance)
- **What's reversed:** Rural-first → Urban-first to build proof
- **Benefit:** Faster traction, easier infrastructure, different market entry

### AsyncFlow (Remote Collaboration)

**Reverse #1:** Flip meeting default—async-first, justify sync
- **What's reversed:** Default to meetings → Require justification for live sessions
- **Benefit:** Dramatic meeting reduction, thoughtful use of sync time

**Reverse #2:** Invert response expectations—depth valued over speed
- **What's reversed:** Fast response expected → Thoughtful response valued
- **Benefit:** Better decisions, reduced pressure, deep work protection

**Reverse #3:** Reverse work visibility—show completion not activity
- **What's reversed:** Presence/activity tracking → Outcome demonstration
- **Benefit:** Focus on results, not performative work, true flexibility

**Reverse #4:** Flip documentation timing—during not after
- **What's reversed:** Work then document → Documentation as you work
- **Benefit:** Better capture, less burden, real-time knowledge base

**Reverse #5:** Invert communication—reader optimizes, not writer
- **What's reversed:** Writer clarity burden → Reader controls when/how they consume
- **Benefit:** Async-friendly, timezone respectful, digestible on own schedule

### SolarSeva (India Home Solar)

**Reverse #1:** Flip ownership—SolarSeva owns, user pays for electricity
- **What's reversed:** User buys system → Utility model
- **Benefit:** No capital barrier, maintenance responsibility stays with provider

**Reverse #2:** Reverse flow—community solar instead of individual
- **What's reversed:** Personal system → Shared community resource
- **Benefit:** Lower per-household cost, collective investment, social model

**Reverse #3:** Invert sales—customers recruit, not sales team
- **What's reversed:** Company sells → Users evangelize and earn
- **Benefit:** Lower CAC, authentic testimonials, viral growth

**Reverse #4:** Flip value flow—sell excess to grid instead of consume
- **What's reversed:** One-way consumption → Two-way trading
- **Benefit:** Revenue opportunity, faster ROI, prosumer model

**Reverse #5:** Reverse timing—insurance before failure not after
- **What's reversed:** Reactive repair → Proactive protection
- **Benefit:** Peace of mind, revenue stream, better risk management

### Unbroken (Sweden Disaster Logistics)

**Reverse #1:** Invert data flow—edge-to-center, not center-to-edge
- **What's reversed:** Central database → Distributed sources of truth
- **Benefit:** Works when center unreachable, resilient, offline-capable

**Reverse #2:** Flip priority—availability over consistency
- **What's reversed:** Data must be perfect → Data must be accessible
- **Benefit:** Works in degraded conditions, eventual accuracy acceptable

**Reverse #3:** Reverse sync direction—pull when available, not push constantly
- **What's reversed:** Continuous push → Opportunistic pull
- **Benefit:** Battery conservation, bandwidth efficiency, resilience

**Reverse #4:** Flip use case—peacetime tool that happens to work in disasters
- **What's reversed:** Disaster-only → Everyday use with disaster capability
- **Benefit:** Continuous value, adoption, familiarity when needed

**Reverse #5:** Invert authentication—trust first, verify later
- **What's reversed:** Authenticate before access → Open during crisis, audit after
- **Benefit:** Speed when seconds matter, removes barrier

## Output Format

```markdown
# REVERSE Ideas: [Product/Service Name]

## Assumptions to Challenge
[List industry assumptions about sequence, roles, direction, timing, ownership]

## Reversal Ideas

### Idea 1: [Short Name]
**What's reversed:** [Relationship/process/flow/timing]
**Type of reversal:** [Process/Role/Direction/Timing/Ownership/Information/Power]
**From:** [Current assumption]
**To:** [Inverted approach]
**New dynamics created:** [How this changes the game]
**Potential benefits:**
- [Benefit 1: often differentiation, efficiency, or disruption]
- [Benefit 2]
**Challenges to address:** [What makes this difficult]
**Disruption level:** [🚀 Revolutionary | ⚡ Significant | ✓ Incremental]

### Idea 2: [Short Name]
[Same structure]

[Continue for 5-10 ideas]

## Summary
**Total reversal ideas:** [count]
**Most disruptive:** [The most radical inversion]
**Business model innovations:** [Any reversals that change revenue/value model]
**Assumptions challenged:** [List of industry norms questioned]
**Most promising:** [Top 3]
```

## Tips for Success

**Do:**
- Question "that's just how it's done" assumptions
- Look for power imbalances to flip
- Consider timing and sequence reversals
- Think about role inversions (prosumer models)
- Explore ownership model flips (access vs possession)

**Don't:**
- Reverse for sake of reversing—must create value
- Ignore why current approach exists (usually some reason)
- Forget that reversals can be culturally specific
- Miss business model implications

## Common Pitfalls

- **Reverse without purpose:** Inversion must improve something
- **Ignoring historical context:** Current approach might have good reasons
- **Missing cultural fit:** Some reversals work in some cultures not others
- **Forgetting trade-offs:** Every reversal creates new challenges

## Powerful Reversals in Practice

**Freemium (timing reversal):**
- Pay first, use later → Use first, pay later
- Result: Massive adoption, conversion funnel

**Airbnb (role reversal):**
- Hotel company provides rooms → Consumers become hotel operators
- Result: Asset-light, massive inventory, disruption

**Pull manufacturing (direction reversal):**
- Build to stock → Build to order
- Result: Less waste, better match to demand

**Preventive medicine (timing reversal):**
- Treat illness → Prevent illness
- Result: Better outcomes, lower costs

**Open source (power reversal):**
- Company controls code → Users have access and can modify
- Result: Community innovation, quality improvements

## Integration Points

**Input from solution-definition:**
- PRFAQ reveals assumed sequence and roles
- Closed World shows current flows and relationships
- FAQ assumptions about "how it works"

**Output to idea-evaluation:**
- Reversal ideas with disruption potential
- Business model innovation flagged
- Cultural fit considerations noted
- Implementation complexity assessed

**Used with other SCAMPER techniques:**
- Reverse + Eliminate (flip then simplify)
- Reverse + Modify (invert then adjust)
- Adapt can suggest reversals from other industries

## Testing Reversals

**Thought experiment:**
1. State current assumption clearly
2. Invert it completely
3. Ask: Could this possibly work?
4. If yes: What would need to be true?
5. If interesting: How to test cheaply?

**Example:**
1. Assumption: Lender sets interest rate
2. Invert: Borrower proposes interest rate
3. Could work? Maybe as reverse auction
4. Need: Enough lenders to compete
5. Test: Try with 10 borrowers, see if it works

## Next Steps

After generating reversal ideas:
1. **Challenge assumptions:** Which industry "truths" are just conventions?
2. **Business model implications:** Do reversals suggest new revenue models?
3. **Cultural testing:** Do inversions work in target markets?
4. **Prototype quickly:** Test reversed approaches with small experiments

Reversal often generates the most disruptive ideas—pay special attention to business model inversions.
