---
name: scamper-substitute
description: Generate innovative ideas by replacing components with alternatives. Part of SCAMPER ideation toolkit. Explore what happens when you substitute materials, processes, people, power sources, or channels with different options. Works within your Closed World or suggests smart additions. Can be used standalone or as part of ideation-scamper orchestration.
---

# SCAMPER: Substitute - Replace with Alternatives

## Purpose

Generate innovative ideas by systematically exploring what can be replaced in your solution. Substitution often reveals better, cheaper, faster, or more accessible alternatives that unlock new value.

## When to Use This Skill

Use this skill when:
- You want to explore alternative approaches to existing components
- Cost reduction is a priority
- You're seeking accessibility improvements
- You need ideas for simplification or optimization
- You want to challenge "we've always done it this way" thinking
- Part of comprehensive SCAMPER session (use ideation-scamper orchestrator)

## The Substitute Technique

**Core question:** What can you replace or swap out?

**Philosophy:** The first solution is rarely optimal. By systematically considering alternatives for each component, you discover improvements often hiding in plain sight.

## Types of Substitution

### 1. Materials
Replace physical materials with alternatives
- Example: Plastic → Bamboo (sustainable packaging)
- Example: Paper → Digital (documents)
- Example: Metal → Carbon fiber (lightweight strength)

### 2. Components
Swap out functional parts
- Example: Mechanical → Electronic (car keys)
- Example: Human → AI (customer service)
- Example: Centralized → Distributed (servers)

### 3. Processes
Replace how things are done
- Example: Manual → Automated (assembly)
- Example: Sequential → Parallel (workflows)
- Example: Batch → Real-time (processing)

### 4. People/Roles
Change who does what
- Example: Expert → User (Wikipedia)
- Example: Individual → Crowd (Wikipedia)
- Example: Employee → Contractor (Uber)

### 5. Power Sources
Replace energy/fuel types
- Example: Gas → Electric (vehicles)
- Example: Battery → Solar (calculators)
- Example: Grid → Generator (backup power)

### 6. Channels
Swap distribution or communication paths
- Example: Physical → Digital (retail)
- Example: Direct → Platform (marketplace)
- Example: Broadcast → Targeted (advertising)

### 7. Business Models
Replace revenue or value exchange models
- Example: Purchase → Subscription (software)
- Example: Free → Freemium (Dropbox)
- Example: B2C → B2B2C (wholesale platform)

## Workflow

### Step 1: Review Your Closed World
Have your solution-definition Closed World map ready. List all internal and external components.

### Step 2: Systematic Exploration
For each component, ask:
- What could replace this?
- What's a cheaper alternative?
- What's a better performing alternative?
- What's a more accessible alternative?
- What's a simpler alternative?
- What if we borrowed from another industry?

### Step 3: Consider Categories
Work through substitution types:
- Materials substitutions
- Technology substitutions
- Process substitutions
- Role substitutions
- Channel substitutions

### Step 4: Generate 5-10 Ideas
Don't stop at the obvious. Push past first ideas to breakthrough thinking.

### Step 5: Capture and Document
Record each idea with:
- What's being substituted
- What it's replaced with
- Potential benefit

## Prompting Questions

Use these to stimulate thinking:

**Materials/Components:**
- What if we used [alternative material]?
- Can we substitute digital for physical?
- What's the biodegradable version?
- What's the premium version? Budget version?

**Technology:**
- Can AI/automation substitute for human effort?
- Can smartphone substitute for specialized device?
- Can blockchain substitute for central authority?
- Can we use existing tech differently?

**Process:**
- Can async substitute for sync?
- Can pull substitute for push?
- Can self-service substitute for assisted?
- Can prevention substitute for cure?

**People/Roles:**
- Can users substitute for experts?
- Can crowd substitute for individual?
- Can peer-to-peer substitute for centralized?

**Channels:**
- Can online substitute for offline?
- Can direct substitute for intermediary?
- Can mobile substitute for desktop?
- Can voice substitute for text?

**Business Model:**
- Can subscription substitute for purchase?
- Can usage-based substitute for flat-fee?
- Can revenue-share substitute for fixed price?

## Examples from Case Studies

### FairCredit (Nigeria Micro-Lending)

**Substitute #1:** Replace traditional credit score with merchant trust score
- **What's substituted:** Formal credit bureau data → Merchant endorsements
- **Benefit:** Serves unbanked, builds community ties, culturally appropriate

**Substitute #2:** Replace SMS with WhatsApp for notifications
- **What's substituted:** SMS → WhatsApp Business API
- **Benefit:** Richer interactions, lower cost, better engagement, read receipts

**Substitute #3:** Replace smartphone app with USSD (feature phones)
- **What's substituted:** Smartphone requirement → Feature phone USSD codes
- **Benefit:** Reaches users without smartphones, truly inclusive, 10x market expansion

**Substitute #4:** Replace monthly repayment with daily micro-payments
- **What's substituted:** Monthly lump sum → Daily small amounts
- **Benefit:** Matches cash flow for daily traders, reduces default risk

**Substitute #5:** Replace interest payments with revenue sharing
- **What's substituted:** Fixed interest → Percentage of sales
- **Benefit:** Aligns incentives, fair during slow periods

### AsyncFlow (Remote Collaboration)

**Substitute #1:** Replace synchronous notifications with daily digests
- **What's substituted:** Real-time alerts → Scheduled summaries
- **Benefit:** Reduces interruptions, supports deep work, respects time zones

**Substitute #2:** Replace live video calls with async video messages
- **What's substituted:** Zoom meetings → Loom-style recordings
- **Benefit:** No scheduling needed, rewatch-able, faster to consume

**Substitute #3:** Replace text chat with voice messages
- **What's substituted:** Typing → Speaking
- **Benefit:** Faster, more nuance, hands-free, multilingual easier

### SolarSeva (India Home Solar)

**Substitute #1:** Replace upfront payment with lease-to-own
- **What's substituted:** Large cash payment → Monthly installments
- **Benefit:** Accessibility, affordability, immediate savings vs diesel

**Substitute #2:** Replace battery bank with grid-tie and net metering
- **What's substituted:** Expensive batteries → Selling back to grid
- **Benefit:** Lower cost, simpler system, revenue opportunity

**Substitute #3:** Replace traditional warranty with micro-insurance
- **What's substituted:** Free replacement → Insurance premium
- **Benefit:** Risk pooling, predictable cost, covers more scenarios

### Unbroken (Sweden Disaster Logistics)

**Substitute #1:** Replace cloud servers with fully distributed system
- **What's substituted:** Central servers → Peer-to-peer architecture
- **Benefit:** Works without internet, no single point of failure

**Substitute #2:** Replace GPS routing with offline maps
- **What's substituted:** Real-time GPS → Pre-loaded maps + manual updates
- **Benefit:** Works when satellites unreachable, predictable

**Substitute #3:** Replace real-time sync with batch synchronization
- **What's substituted:** Continuous sync → Periodic when connectivity available
- **Benefit:** Lower bandwidth, works with intermittent connectivity

## Complete Examples

For more worked examples, see `references/substitute-examples.md` showing 10+ substitution ideas for each of our four case studies.

## Output Format

```markdown
# SUBSTITUTE Ideas: [Product/Service Name]

## Component Being Analyzed
[Name of component from Closed World]

## Substitution Ideas

### Idea 1: [Short Name]
**What's substituted:** [Original] → [Alternative]
**Type of substitution:** [Material/Component/Process/Role/Channel/Model]
**Potential benefits:**
- [Benefit 1]
- [Benefit 2]
**Potential risks:**
- [Risk 1]
**Feasibility:** [High/Medium/Low]

### Idea 2: [Short Name]
[Same structure]

[Continue for 5-10 ideas]

## Summary
**Total substitute ideas:** [count]
**Most promising:** [List top 3]
**Ready for:** Evaluation phase or continue with other SCAMPER techniques
```

## Tips for Success

**Do:**
- Challenge every component—even "essential" ones
- Consider substitutions that seem radical
- Look across industries for alternatives
- Think about both upgrade and downgrade substitutions
- Consider cultural context (what works in one market may not in another)

**Don't:**
- Stop at the first obvious alternative
- Dismiss ideas as "too different"—that's often where innovation hides
- Forget cost implications—cheaper can be better
- Ignore accessibility—simpler substitutions often win

## Common Pitfalls

- **Only considering tech upgrades:** Sometimes downgrading (smartphone → feature phone) reveals bigger opportunities
- **Forgetting business model substitutions:** Changing how you charge can be more innovative than changing what you charge for
- **Cultural blindness:** Cash → digital works in Sweden, not everywhere
- **Not challenging assumptions:** "We need an app" → maybe you need USSD

## Integration Points

**Input from solution-definition:**
- Closed World components are substitution candidates
- PRFAQ customer pains suggest what needs better alternatives
- FAQ "hard problems" may need substitute approaches

**Output to idea-evaluation:**
- Substitution ideas with clear benefit hypotheses
- Feasibility notes for each
- Cultural/market considerations

**Used with other SCAMPER techniques:**
- Substitute creates alternatives, Combine merges them
- Substitute with Adapt (borrow substitutions from other industries)
- Substitute then Eliminate (replace then remove original)

## Next Steps

After generating substitute ideas:
1. **Continue SCAMPER:** Use ideation-scamper orchestrator for Combine, Adapt, Modify, Put to other uses, Eliminate, Reverse
2. **Evaluate:** Use idea-evaluation skill to rate substitution ideas
3. **Validate:** Test assumptions about "better" with critical-validation skill
4. **Solve barriers:** If substitution faces technical challenges, use technical-breakthrough skill

Substitution is often the most accessible SCAMPER technique—start here if new to systematic ideation.
