# Closed World Component Mapping

## Overview

The Closed World principle from Systematic Inventive Thinking (SIT) states: **solve problems using only resources already present in the system or its immediate environment**. This constraint forces creative thinking and leads to elegant, efficient innovations.

## Why Map the Closed World?

1. **Identifies all available resources** for innovation
2. **Prevents premature addition** of new components
3. **Reveals unexpected combinations** and relationships
4. **Focuses creativity** within realistic constraints
5. **Leads to simpler, cheaper solutions**

## Two Types of Components

### Internal Components
**Elements you own, control, and can directly modify**

Internal components are anything your organization has direct control over and can change, remove, or recombine at will. Think: "What can we change without asking anyone's permission?"

**Categories to consider:**

**1. People:**
- Employees (by role: developers, designers, sales, support, managers, executives)
- Staff characteristics (expertise, skills, experience, personalities, communication style, specializations)
- Contractors, freelancers, advisors

**2. Processes:**
- How work gets done (workflows, procedures, protocols)
- How decisions are made (approval processes, governance)
- How quality is ensured (testing, reviews, standards)
- How people are managed (hiring, training, performance management)
- How customers are served (onboarding, support, escalation)

**3. Content & Intellectual Property:**
- What you create (code, designs, copy, videos, documentation)
- Data you own (customer data, analytics, research, algorithms)
- Branding (name, logo, messaging, voice, positioning)
- Knowledge (documentation, playbooks, best practices)

**4. Technology & Infrastructure:**
- Software (applications, platforms, tools, APIs, integrations)
- Hardware you own (servers, devices, equipment)
- Digital assets (databases, file storage, backups)
- Code and architecture (frontend, backend, infrastructure as code)

**5. Physical Assets (if applicable):**
- Facilities (offices, stores, warehouses, clinics)
- Equipment (computers, furniture, tools, machinery)
- Inventory (products, supplies, materials)
- Space characteristics (layout, lighting, temperature control, décor)

**6. Offerings:**
- Products and services (what you sell)
- Features and capabilities (what they do)
- Formats and variations (versions, tiers, SKUs)
- Pricing and packaging (cost structure, bundles, plans)

**7. Business Operations:**
- Marketing and distribution (campaigns, channels, partnerships, contracts)
- Sales processes (lead gen, qualification, closing, onboarding)
- Finance and billing (payment methods, invoicing, refunds, accounting)
- Legal and compliance (terms, policies, procedures)

**Key principle:** If you can change it without anyone's permission, it's internal.

---

### External Components
**Elements you interact with but don't control**

External components are everything that comes into physical or functional contact with your product/service but is outside your direct control. Think: "What exists in the environment our solution operates in?"

**Categories to consider:**

**1. Users & Customers:**
- Who they are (demographics: age, gender, location, occupation, income)
- What they bring (characteristics: skills, preferences, behaviors, attitudes, needs)
- Their context (family situation, daily routines, pain points, motivations)
- Their history (experience level, past usage, expectations)

**2. Physical Environment:**
- Location factors (geography, climate, infrastructure, proximity to services)
- Spaces where used (home, office, car, outdoors, urban/rural)
- Environmental conditions (lighting, temperature, noise, connectivity quality)
- Physical objects present (furniture, devices, tools, vehicles)

**3. Devices & Technology:**
- User devices (smartphones, computers, tablets, TVs, wearables)
- Operating systems and platforms (iOS, Android, Windows, browsers)
- Input/output mechanisms (touchscreens, keyboards, remotes, voice assistants)
- Connectivity (internet, cellular, wifi, Bluetooth)

**4. Ecosystem & Partners:**
- Competitors (direct and indirect alternatives)
- Complementary services (integrations, adjacent products)
- Distribution channels (app stores, marketplaces, retailers, platforms)
- Service providers (payment processors, hosting, third-party APIs)
- Content creators and suppliers (if applicable)
- Industry bodies and standards organizations

**5. Regulatory & Social Environment:**
- Laws and regulations (privacy, safety, licensing, taxation)
- Compliance requirements (data protection, accessibility, industry standards)
- Cultural norms and expectations (language, customs, social practices)
- Public perception and trust (brand reputation, reviews, social media sentiment)

**6. Economic Factors:**
- Market conditions (supply/demand, competition intensity)
- Pricing environment (what customers can afford, willingness to pay)
- Currency and payment systems (local payment methods, exchange rates)
- Economic trends (recessions, booms, industry shifts)

**7. Temporal & Event-Based:**
- Time factors (time of day, day of week, seasons)
- Calendar events (holidays, school breaks, fiscal periods)
- Current events (news, sports, local happenings, trends)
- Life events (birthdays, anniversaries, major purchases)

**8. External Data & Information:**
- Public data sources (weather, traffic, news, market data)
- User-generated content (reviews, ratings, social posts)
- Third-party information (credit scores, public records, research)

**Key principle:** If it exists in the environment but you can't directly control it, it's external.

---

## Internal vs External: The Control Test

**Ask: "Can I change this tomorrow without anyone's permission?"**

- **YES → Internal:** Your UI, your pricing, your employees, your features, your processes
- **NO → External:** User's age, weather, competitors, regulations, user's devices, market conditions

**Common mistakes:**

❌ **Listing "user" as internal** - You don't control users; they're external
✅ **Listing "customer support team" as internal** - You control who's on the team and how they work

❌ **Listing "mobile app" as external** - You built and control the app; it's internal
✅ **Listing "user's smartphone" as external** - You don't control what device they use

❌ **Listing "payment" as external** - Payment is part of your service; it's internal
✅ **Listing "payment processor (Stripe)" as external** - You don't control Stripe's policies

---

## Component Mapping Process

### Step 1: Define System Boundaries
Be clear about what you're analyzing:
- A specific product (e.g., "Amazon Prime Video streaming service")
- A service experience (e.g., "dental clinic visit")
- A complete offering (e.g., "FairCredit mobile lending platform")

### Step 2: List Internal Components (10-20 typical)
Work systematically through categories:
1. **People & their characteristics** (who works here, what they bring)
2. **Processes** (how work flows, how decisions happen)
3. **Content & IP** (what you create, data you own)
4. **Technology** (software, infrastructure, tools)
5. **Physical assets** (if applicable: facilities, equipment)
6. **Offerings** (products, services, features, pricing)
7. **Operations** (marketing, sales, finance, legal)

**Aim for 10-20 internal components** - enough to capture the richness of what you control.

### Step 3: List External Components (8-15 typical)
Consider the operating environment:
1. **Users** (who they are, what they bring, their context)
2. **Physical environment** (where it's used, conditions present)
3. **Devices & technology** (what users have, connectivity)
4. **Ecosystem** (competitors, partners, platforms, suppliers)
5. **Regulatory & social** (laws, norms, public perception)
6. **Economic** (market conditions, pricing environment)
7. **Temporal** (time patterns, events, seasons)
8. **External data** (information sources you don't control)

**Aim for 8-15 external components** - the most relevant contextual factors.

### Step 4: Note Key Relationships
For each component, briefly note:
- What it connects to
- What it enables or constrains
- Dependencies and tensions

---

## Comprehensive Examples

### Example 1: Amazon Prime Video (Streaming Service)

**System Definition:** Subscription streaming video service offering movies, TV shows, and original content

**Internal Components:**

**Content:**
- Content library (movies, TV shows, documentaries, originals)
- Content types, lengths, languages, genres, formats
- Descriptions, metadata, thumbnails, trailers
- Content acquisition process, licensing agreements

**Technology & Infrastructure:**
- Streaming apps (mobile, TV, web, tablet versions)
- Backend infrastructure (servers, CDN, encoding, storage)
- Recommendation algorithm
- Search and discovery features
- APIs and integrations
- Data analytics systems
- App updates and versioning
- Documentation

**UI/UX:**
- Home screen layout and organization
- Navigation structure, categories, collections
- Search interface
- Favorites/watchlist functionality
- Playback controls, caption settings
- Profile management

**Content Creation (Originals):**
- Production teams, directors, writers, actors
- Studios, production staff, post-production
- Screenplay development process
- Quality control procedures

**Pricing & Payment:**
- Subscription cost and structure
- Currency options, regional pricing
- Payment plans (monthly/annual)
- Refund policies, special offers, bundles
- Billing system

**Marketing & Distribution:**
- Advertising campaigns, media buys
- Social media presence and content
- Partnership contracts (devices, platforms)
- Promotional strategies
- PR and communications

**Operations:**
- Customer service and support team
- Support processes and scripts
- Employees (engineering, product, business roles)
- Office facilities
- Training programs
- Quality assurance processes

**External Components:**

**Physical Environment:**
- User's room (lighting, seating, noise level)
- User's location (city, country, timezone)
- Viewing environments (home, car, airplane, hotel)
- Internet connectivity quality and stability

**Devices:**
- TVs (brands, models, capabilities)
- Smartphones and tablets (iOS, Android, various models)
- Laptops and desktop computers
- Streaming devices (Roku, Fire TV, Apple TV, Chromecast)
- Operating systems and versions
- App stores (Apple App Store, Google Play, etc.)
- Remote controls, keyboards, mice
- Headphones, speakers, sound systems

**Users:**
- Account owners (primary subscribers)
- Family members with shared access
- Neighbors, friends (account sharing)
- User demographics (age, gender, location, occupation)
- Viewing preferences, habits, tastes
- Birth dates, anniversary dates
- Technical proficiency levels
- Language preferences
- Viewing time availability

**Partners & Ecosystem:**
- Content studios and producers
- Content creators and rights holders
- Talent agencies, casting agencies
- Other streaming service providers
- Platform providers (smart TV manufacturers)
- Internet service providers
- App developers, service providers
- Film festivals, competitions, awards
- Critics and reviewers
- Regulatory authorities (FCC, regional media regulators)
- Open-source community (for technology components)

**Other Services:**
- Amazon Music (bundling opportunity)
- Amazon Retail (cross-selling)
- AWS (infrastructure provider)
- Social networks (sharing, discovery)
- Gaming platforms
- Virtual reality platforms
- Cable/satellite TV services (competitors)

**Time/Events:**
- Seasons (content preferences change)
- Holidays (viewing patterns shift)
- Time of day (peak viewing hours)
- Current events (topical content interest)
- Sports events (competition for attention)
- News events (documentary interest)
- Local events and festivals
- Release schedules (competitor content launches)

**Key Relationships:**
- Content quality ↔ User retention
- App performance ↔ Internet connectivity
- Recommendation algorithm ↔ User viewing history
- Pricing ↔ Competitive landscape
- Original content ↔ Brand differentiation

---

### Example 2: Dental Clinic

**System Definition:** Local dental practice providing preventive, restorative, and cosmetic dental services

**Internal Components:**

**People:**
- Dentists (general, specialists)
- Dental hygienists
- Dental assistants
- Receptionists
- Finance and billing staff
- Practice manager
- Lab technicians (if in-house)
- IT support staff (if in-house)

**Staff Characteristics:**
- Clinical expertise and specializations
- Years of experience, certifications
- Communication styles (patient-friendly, reassuring)
- Personalities (warm, professional, efficient)
- Attire and appearance (scrubs, professional dress)
- Language skills, cultural competencies

**Processes:**
- Hiring and onboarding procedures
- Training and continuing education programs
- Daily team briefings
- Performance reviews and feedback
- Customer service protocols
- Safety and hygiene practices
- Emergency procedures
- Quality control processes
- Inventory management

**Equipment & Tools:**
- Dental chairs (models, features, adjustability)
- Dental tools (scalers, drills, mirrors, probes, suction devices)
- X-ray machines and imaging equipment
- Sterilization equipment
- Handpieces (drills, polishers)
- Lighting systems
- Monitors and intraoral cameras
- Lab equipment (if applicable)

**Clinic Environment:**
- Waiting area (layout, comfort, design)
- Magazines, TV, music, ambient sound
- Kids' play area, toys
- Decorations, artwork, plants
- Scents (neutral, calming)
- Temperature control
- Furniture (chairs, tables, coat racks)
- Signage and wayfinding

**Treatment Rooms:**
- Room layout and workflow design
- Lighting (overhead, task lighting)
- Hygiene and cleanliness standards
- Color schemes and aesthetics
- Seating arrangements (patient chair, stool, guest chair)
- Soundproofing
- Privacy measures (curtains, doors)
- Storage and organization

**Procedures & Services:**
- Routine check-ups and examinations
- Cleanings and preventive care
- Fillings, crowns, bridges
- Root canals
- Extractions
- Orthodontics (braces, aligners)
- Cosmetic treatments (whitening, veneers)
- Emergency care protocols
- Pediatric dentistry approaches
- Sedation options

**Appointment System:**
- Scheduling process (phone, online, walk-in)
- Rescheduling and cancellation policies
- Reminder systems (SMS, email, phone calls)
- Online booking portal
- Walk-in and emergency slot management
- Waitlist procedures

**Patient Information Management:**
- Medical and dental history records (digital/paper)
- Forms and consent documents
- Privacy and security measures (HIPAA compliance)
- Feedback collection methods (surveys, reviews)
- Record retention policies
- Patient communication logs

**Pricing & Payment:**
- Treatment cost structure and fee schedules
- Insurance processing procedures
- Payment plans and financing options
- Discounts and promotions (new patients, referrals, seniors)
- Cash, card, and digital payment handling
- Billing and invoicing systems
- Refund and dispute resolution policies

**Marketing & Promotion:**
- Promotional offers and campaigns
- Social media presence and content
- Website design and content
- Referral programs and incentives
- Community events and sponsorships
- Partnership agreements (schools, businesses)
- Advertising (local media, online)

**External Components:**

**Patients:**
- Age and life stage (children, adults, seniors)
- Dental health history (conditions, past treatments)
- Overall health status (chronic conditions, medications)
- Lifestyle habits (diet, smoking, oral hygiene practices)
- Dietary habits (sugar intake, acidic foods, frequency of eating)
- Income level and financial situation
- Insurance coverage status
- Pain tolerance levels
- Dental anxiety levels
- Expectations and preferences (cosmetic focus, pain-free, speed)
- Cultural background (views on dental care)
- Language and communication preferences

**Location Factors:**
- Proximity to public transportation
- Parking availability and cost
- Neighborhood characteristics (urban/suburban, safety, walkability)
- Nearby businesses and foot traffic
- Accessibility (wheelchair access, elevators)
- Visibility and signage from street

**Health Insurance Providers:**
- Coverage policies and benefit structures
- Claims submission processes
- Co-payment and deductible requirements
- Network participation and preferred provider status
- Pre-authorization requirements
- Reimbursement rates and timing

**Regulatory Environment:**
- Health and safety standards (OSHA, CDC guidelines)
- Licensing bodies and requirements
- Patient data protection regulations (HIPAA)
- Medical waste disposal regulations
- Infection control standards
- Occupational health requirements
- ADA compliance requirements

**Competitors:**
- Nearby dental clinics and practices
- Specialized practices (orthodontists, oral surgeons, cosmetic dentists)
- Mobile dentists offering home visits
- Dental school clinics
- Corporate dental chains
- Teledentistry services

**Seasonal Factors & Events:**
- Holidays (scheduling patterns change)
- Back-to-school periods (pediatric surge)
- Tax refund season (elective treatment uptick)
- Weather impacts (cancellations, walk-ins)
- Flu season (infection control heightened)
- Local events affecting traffic and access

**Local Community & Partners:**
- Pharmacies (prescriptions, referrals)
- Nearby medical facilities (specialists, hospitals, urgent care)
- Wellness centers, gyms, yoga studios
- Schools and daycare centers
- Dental laboratories (external)
- Equipment suppliers
- Medical waste disposal services
- Insurance brokers and financial planners

**Economic Factors:**
- Local economy and employment rates
- Disposable income trends
- Dental insurance penetration rates
- Cost of dental materials and supplies
- Labor market (hiring costs, wage expectations)
- Real estate costs (rent, property values)

**Technological Advancements:**
- Tele-dentistry platforms
- Remote patient monitoring tools
- Latest equipment innovations (not yet adopted)
- Online review platforms (Yelp, Google, Healthgrades)
- Appointment booking systems (third-party)
- Digital payment solutions

**Health Trends & Public Perceptions:**
- Public awareness of oral health importance
- Popular dental care products (electric toothbrushes, whitening)
- Social media influencers promoting dental aesthetics
- Trending treatments (invisible braces, at-home whitening)
- Health and wellness movement
- Natural/holistic dental care trends
- Stigma or fear associated with dentistry

**Key Relationships:**
- Staff expertise ↔ Patient confidence
- Equipment quality ↔ Treatment outcomes
- Insurance partnerships ↔ Patient acquisition
- Location ↔ Patient convenience
- Pricing ↔ Patient financial capacity
- Clinic environment ↔ Patient anxiety levels

---

## Using the Closed World for Innovation

Once mapped, the Closed World becomes the foundation for SCAMPER and other innovation techniques:

1. **Substitute:** Replace internal components with alternatives (different processes, different pricing models)
2. **Combine:** Merge internal components (combine services, integrate processes)
3. **Adapt:** Borrow approaches from external environment (how competitors solve problems)
4. **Modify:** Change attributes of internal components (scale up/down, speed up/slow down)
5. **Put to other uses:** Repurpose internal components (use data differently, leverage assets for new purposes)
6. **Eliminate:** Remove internal components to simplify (cut features, reduce steps)
7. **Reverse:** Flip relationships between internal and external (change who does what, reverse flow)

**Key insight:** Internal components are your levers for innovation. External components are your constraints and opportunities—you work with them, not against them.

---

## Output Format

```markdown
# Closed World Map: [Product/Service/System Name]

## System Definition
[1-2 sentence description of what you're analyzing]

## Internal Components (10-20)

### People
- [Role/title] - [key characteristics]
- [Staff attributes] - [expertise, style, traits]

### Processes
- [Process name] - [what it does, how it works]

### Content/IP
- [Asset] - [what it is, what it does]

### Technology/Infrastructure
- [System/tool] - [function, capability]

### Physical Assets (if applicable)
- [Facility/equipment] - [characteristics, purpose]

### Offerings
- [Product/service] - [what it does, variations]
- [Pricing/packaging] - [structure, options]

### Operations
- [Function] - [how it works, who does it]

## External Components (8-15)

### Users/Customers
- [Segment] - [who they are, what they bring, their context]

### Physical Environment
- [Location/space] - [characteristics, conditions]

### Devices/Technology
- [Device/platform] - [what users have, how they access]

### Ecosystem/Partners
- [Entity] - [role, relationship, influence]

### Regulatory/Social
- [Factor] - [requirements, norms, perceptions]

### Economic
- [Factor] - [market conditions, financial constraints]

### Temporal/Events
- [Time factor/event] - [patterns, impacts]

### External Data/Information
- [Source] - [what it provides, how it's used]

## Key Relationships
- [Internal component] ↔ [External component]: [nature of relationship, implications]
- [Dependency or tension]
- [Innovation opportunity revealed by relationship]
```

---

## Common Mistakes to Avoid

**1. Treating users as internal**
- ❌ "User behavior" as internal
- ✅ "Customer service process" as internal, "User characteristics" as external

**2. Being too vague**
- ❌ "Technology" (too broad)
- ✅ "Mobile app", "Recommendation algorithm", "Payment processing system" (specific)

**3. Forgetting people and processes**
- ❌ Only listing physical or digital components
- ✅ Including teams, roles, workflows, decision-making processes

**4. Missing the ecosystem**
- ❌ Focusing only on product and users
- ✅ Including competitors, partners, regulations, market conditions

**5. Mixing categories**
- ❌ Listing "user's smartphone app" as external (the app itself is internal)
- ✅ "Mobile app" (internal), "User's smartphone device" (external)

---

## When to Map the Closed World

**In the innovation journey:**
- **After** customer-discovery (you understand needs)
- **After** Working Backwards/PRFAQ (you know what you're building)
- **Before** ideation (SCAMPER needs components to work with)

The Closed World mapping should happen in the solution-definition phase, immediately after creating your PRFAQ. You can't map components until you know what system you're analyzing.
