# Working Backwards Framework

## Overview

Working Backwards is Amazon's customer-centric product development methodology. Start with the customer experience you want to create, then work backwards to determine what to build. This prevents building products nobody wants.

## Core Principle

**Start with the customer,** not the technology or capabilities you have. Define the ideal customer experience first, then figure out how to deliver it.

## The Press Release / FAQ (PRFAQ) Approach

The centerpiece of Working Backwards is writing a mock press release and FAQ for your product **before you build it**. This forces clarity about:
- What you're building
- Who it's for
- Why it matters
- What makes it different

## Press Release Structure: The 7-Paragraph Framework

A complete press release follows a specific 7-paragraph structure. Each paragraph serves a distinct purpose in communicating your vision.

### Paragraph 1: The "Elevator Pitch"

**Purpose:** Grab attention and communicate the core value proposition in seconds.

**Structure:**
- **Date and location** of announcement
- **First sentence:** Product name, customer characterization, main benefit
- **Context:** When/where is the solution relevant?
- **How it works:** The gist (not all details)
- **Availability:** Who can get it?
- **Selected metrics:** Customer-relevant numbers (cost, speed, availability)

**Template:**
"[LOCATION] – [Publication] – [Date]. [Product Name] now allows [customer segment] to [core benefit]. The service works with/for [use cases/contexts]. It works through [delivery mechanism]. By [key capability], [Product Name] empowers users to [outcome] with [key differentiator]."

**Example (ID-me):**
"STOCKHOLM – Dagens Nyheter – 1/1/2025. ID-me now allows Swedish residents to easily and securely login to all online digital services. The service works with everything from financial services to healthcare and government platforms. It works through a free mobile app with a few simple taps. By providing a single, secure digital identity, ID-me empowers users to control and manage their personal information across a wide range of essential services with a single and hassle-free solution."

**Tips:**
- Should clearly answer: who, what, when, where, why
- Metrics and details should be ones customers care about—cost, speed, availability
- Use customer language, not marketing jargon

---

### Paragraph 2: The Problem or Opportunity

**Purpose:** Make the customer pain vivid and relatable. Show you understand their world.

**Guidelines:**
- Clearly explain the opportunity or problem you are solving
- **Focus on the customer problem** (not the business problem)
- Be factual, but compelling—avoid overstatement
- Include metrics that demonstrate extent and impact of the problem
- 3-5 sentences that build the case for why this matters

**Example (ID-me):**
"In today's digital world, verifying identity across different platforms has become cumbersome and frustrating. People need to remember countless passwords for different services - with different rules and security measures. Many existing methods of verification are unreliable, making it difficult to prove who you are. This leads to wasted time, frustration, and a lack of trust in online systems. The average person logs in to digital services 30-50 times a week. In the past year, thousands of fraudulent logins led to the loss of 12bn SEK."

**Connection to Discovery:** This paragraph should draw directly from customer pains identified in JTBD and validated through evidence gathering.

---

### Paragraph 3: The Approach or Solution

**Purpose:** Explain your vision for solving the customer problem.

**Guidelines:**
- Overall description of the new product or service you are launching
- Use clear customer-friendly language and avoid jargon or marketing fluff
- Focus on customer experience, not technical implementation
- Explain **how** it solves the pain from paragraph 2
- 3-4 sentences

**Example (ID-me):**
"ID-me solves these problems by providing one simple and secure way to verify your identity for all the services you need. Whether you're logging into your bank account, accessing healthcare, or signing important documents, you can use ID-me from any device. Instead of juggling passwords or carrying physical identification, you can confirm your identity with just your phone. Your personal information stays safe while you enjoy the convenience of fast, easy access to everything that matters."

**Connection to Discovery:** Solution addresses functional, emotional, and social jobs from JTBD.

---

### Paragraph 4: Leader Quote

**Purpose:** Reinforce value and articulate the vision from leadership perspective.

**Guidelines:**
- Quote from an appropriate leader within your company
- Reinforce the value that will be provided to customers at launch
- Articulate the vision of the solution and how it changes people's lives
- Should feel authentic, not corporate-speak
- 2-3 sentences

**Example (ID-me):**
"'ID-me isn't just a digital identity - it's the future of secure, hassle-free access to essential services. We've listened to what people need and created a service that makes life simpler and more secure. Our goal is to make sure everyone in Sweden can access the services they rely on without worrying about security or complexity,' said Eva Svensson, CEO of ID-me."

**Tips:**
- Leader should speak about customer impact, not company milestones
- Vision-focused, not feature-focused

---

### Paragraph 5: Customer Experience or Journey

**Purpose:** Show how easy it is to use. Make the reader want to try it.

**Guidelines:**
- Describe how customers typically encounter and use the new product or service
- Walk through the typical usage scenario step-by-step
- Emphasize simplicity and naturalness of the experience
- 3-4 sentences showing the flow

**Example (ID-me):**
"When a user logs into a service using ID-me, they open the ID-me app on their smartphone and scan the QR code provided on the website. Next, they confirm their identity with a fingerprint or a quick code, and within seconds, they can securely access services like banking, healthcare, or government platforms. They may also perform actions that require a verification step, such as money transfers, personal information updates, and ordering of services."

**Connection to Discovery:** Journey should map to persona's context and capabilities.

---

### Paragraph 6: Customer Testimonial

**Purpose:** Bring the value to life through a specific, believable customer story.

**THIS IS CRITICAL:** The testimonial should be structured to tell a complete transformation story.

**Anatomy of a Great Customer Testimonial:**
1. **Frustration before the solution** - Start with the pain (1 sentence)
2. **Name and relevant info about the customer** - Make them real
3. **Discovery of the solution** - How they started using it
4. **Key benefit(s)** - What improved in their life
5. **One delightful moment** - Specific event demonstrating value
6. **How it changed their reality** - Broader transformation
7. **Optional: Converted to ambassador** - Now advocating to others

**Template:**
"Before [Product], I struggled with [specific frustration]," said [Full Name], [Age], [Relevant Detail], from [Location]. "With [Product], [how experience changed]. [Specific example of delight]. [Impact statement]. [Optional: advocacy statement]."

**Example (ID-me):**
"'Before ID-me, I struggled with keeping track of countless passwords and annoying verification processes every time I needed to access my accounts,' said Johan Andersson, 35, from Stockholm. 'With ID-me, things are much easier. Just yesterday, I made payments in my bank, booked a doctor's meeting for our son, and submitted an address change on Skatteverket – all in just 15 minutes and no SMS codes. It made my digital life so much simpler. I am telling all my family and friends that they have to use it, too!'"

**Tips:**
- **Use their style and vocabulary** - They are NOT from your marketing department!
- **Make the emotion evident** - Joy, relief, empowerment should come through
- **Be specific** - "15 minutes and no SMS codes" beats "it's faster"
- **Include a delightful moment** - The "just yesterday" example shows real usage

**Connection to Discovery:** Should sound like persona's authentic voice and reference jobs-to-be-done.

---

### Paragraph 7: Call to Action

**Purpose:** Tell readers exactly how to get started.

**Guidelines:**
- Describe where users go to start using the product or service
- Can include: website URL, app store, physical location, phone number
- When can they get it (availability)
- Keep it simple and clear - one sentence is often enough

**Example (ID-me):**
"Visit www.ID-me.se or download the app in the Appstore to get started."

**Example (Unbroken):**
"Go to Unbroken.work to find out more and get started."

**Tips:**
- Make the path to first value crystal clear
- Remove any friction or ambiguity
- If phased rollout, be specific about who can access when

## FAQ Section

After the press release, answer key questions that clarify the vision:

### Customer FAQs

**1. Who is this for?**
- Primary customer segment
- Use cases and contexts
- Who it's NOT for (helps focus)

**2. What are the key features/benefits?**
- 3-5 core features with benefits
- What makes it different from alternatives
- What's included vs. optional

**3. How much does it cost?**
- Pricing model
- Comparison to alternatives
- Value justification

**4. How do I get it?**
- Availability (when, where)
- Purchase/signup process
- Time to value

**5. What if it doesn't work for me?**
- Guarantees, trial periods, refunds
- Support available
- Risk mitigation

### Stakeholder FAQs

These are internal questions that address business strategy, technical feasibility, and operational considerations.

**6. Why now?**
- What's changed that makes this possible/necessary?
- Technology enablers
- Market timing
- Why is this the right moment to launch?

**7. What are the hard problems to solve?**
- Technical challenges
- Operational challenges
- Go-to-market challenges
- What could prevent success?

**8. What are we NOT doing?**
- Scope boundaries
- Features deliberately excluded
- Adjacent opportunities for later
- What are we saying no to?

**9. How will we measure success?**
- Key metrics (customer-focused)
- Success criteria in 6 months, 1 year, 3 years
- Business metrics (revenue, growth, retention)

**10. Why will customers choose us?**
- Competitive advantages
- Moats or defensibility
- Network effects or scale benefits
- What makes us different/better?

## Working Backwards Process

### 1. Write the Press Release
Start with the press release. If you can't write a compelling press release that makes the value clear, you don't have a good product idea yet.

**Tip:** Write it as if announcing to real customers on launch day. Make it exciting and clear.

### 2. Refine Until It's Great
The press release should make someone reading it think "I want that!" If it doesn't, refine:
- Is the problem vivid and relatable?
- Is the solution clear and valuable?
- Does the customer quote ring true?
- Would you use this product?

**Iterate 3-5 times** until it's compelling.

### 3. Write the FAQ
Answer the hard questions honestly. This is where you think through feasibility, economics, and strategy.

**Be realistic:** If you can't answer "how much will it cost?" or "what's the hard problem?", you need more thinking.

### 4. Share and Get Feedback
Share the PRFAQ with stakeholders, potential customers, team members.

**Listen for:**
- Confusion (= need to clarify)
- Excitement (= you're onto something)
- Skepticism about feasibility (= need to address risks)
- "I'd use that!" (= validation)

### 5. Iterate Based on Learning
Refine the PRFAQ based on feedback. It's a living document that evolves as you learn.

## Benefits of Working Backwards

**Clarity:** Forces clear articulation of value proposition  
**Customer focus:** Prevents building for technology's sake  
**Alignment:** Entire team understands what success looks like  
**Decision-making:** Easy to say no to features that don't serve the vision  
**Communication:** PRFAQ is shareable artifact for stakeholders  

## Common Pitfalls

**Jargon and buzzwords:** Press release should be understandable to target customer  
**Feature lists:** Focus on benefits and experience, not technical specs  
**Vague problem:** "People want better X" isn't compelling—make pain vivid  
**Unrealistic:** If FAQ reveals product is impossible or uneconomical, that's valuable learning  
**Too long:** Keep press release under one page, FAQ under 2-3 pages  

## Output Template

```markdown
# PRESS RELEASE: [Product Name]

## Heading
[Product Name]: [One-sentence description]

## Subheading
[Product] helps [customer] [achieve benefit]

---

## Paragraph 1: Elevator Pitch
[LOCATION] – [Publication] – [Date]. [Product Name] now allows [customer segment] to [core benefit]. The service works with/for [use cases]. It works through [delivery mechanism]. By [key capability], [Product Name] empowers users to [outcome] with [differentiator].

## Paragraph 2: Problem
[3-5 sentences describing customer pain vividly with metrics demonstrating extent and impact]

## Paragraph 3: Solution
[3-4 sentences explaining what it is and how it solves the pain, using customer-friendly language]

## Paragraph 4: Leader Quote
"[Quote reinforcing value and vision]," said [Name, Title, Company].

## Paragraph 5: Customer Experience/Journey
[3-4 sentences describing how customers encounter and use the product, step-by-step]

## Paragraph 6: Customer Testimonial
"[Frustration before]. [Discovery and benefits]. [Specific delightful moment]. [How it changed reality]. [Optional: advocacy]," said [Full Name, Age/Detail], from [Location].

## Paragraph 7: Call to Action
[Simple, clear instruction on how to get started - URL, app store, etc.]

---

# FAQ

## Customer FAQs

**Q: Who is this for?**
A: [Primary segment, use cases, who it's NOT for]

**Q: What are the key features/benefits?**
A: [3-5 core features with benefits]

**Q: How much does it cost?**
A: [Pricing model, comparison to alternatives, value justification]

**Q: How do I get it?**
A: [Availability, purchase/signup process, time to value]

**Q: What if it doesn't work for me?**
A: [Guarantees, trial periods, support, risk mitigation]

## Stakeholder FAQs

**Q: Why now?**
A: [Technology enablers, market timing, what's changed]

**Q: What are the hard problems to solve?**
A: [Technical, operational, GTM challenges, what could prevent success]

**Q: What are we NOT doing?**
A: [Scope boundaries, excluded features, what we're saying no to]

**Q: How will we measure success?**
A: [Key metrics, success criteria at 6mo/1yr/3yr, business metrics]

**Q: Why will customers choose us?**
A: [Competitive advantages, moats, defensibility, what makes us different]
```

## Integration with Discovery Phase

Working Backwards builds directly on customer discovery:

**From JTBD:**
- Problem statement comes from pains
- Solution addresses functional, emotional, social jobs
- Customer quote reflects persona voice

**From Persona:**
- Write as if persona is the target reader
- Customer quote in persona's authentic voice
- Context and language match persona's reality

**From Evidence:**
- "Why now?" informed by trends and enablers
- Competitive advantages informed by gaps
- Pricing informed by willingness to pay
- Hard problems informed by what exists/doesn't

## Optional: Adding Visuals to Your PRFAQ

While the Press Release and FAQ are the core deliverables, adding visuals can significantly enhance communication and alignment.

**Three types of visuals to consider:**

### 1. User Interface Sketches
- Key screens or interfaces customers will interact with
- Doesn't need to be polished—wireframes or hand sketches work
- Shows what the experience actually looks like
- Helps identify UX problems early

### 2. Customer Journey Storyboard
- Visual walkthrough of the customer experience from discovery to delight
- Can be simple stick figures or illustrations
- Shows emotional arc alongside functional flow
- Makes the transformation tangible

### 3. System Architecture or Components Diagram
- High-level view of how the solution works
- Key components and their relationships
- Can connect to Closed World mapping
- Helps technical stakeholders understand feasibility

**When to use visuals:**
- When the product involves significant UI/UX
- When explaining the solution requires showing not just telling
- When stakeholders are visual thinkers
- When the customer journey is complex

**When to skip visuals:**
- Early exploration phase (press release first, visuals later)
- Simple, familiar product categories
- Time-constrained scenarios

**Tip:** Visuals should complement, not replace, the written PRFAQ. The press release must stand alone.

---

## Next Step: Closed World

After defining the solution vision with Working Backwards, use Closed World mapping to identify all available resources and components for innovation. This grounds the ambitious vision in what's actually available to work with.
