# Conversion Patterns Skill

Proven conversion rate optimization (CRO) patterns for Next.js applications to maximize signups, sales, and engagement.

## Features

- **Hero Sections** - High-converting hero layouts
- **CTA Components** - Action-oriented buttons with social proof
- **Pricing Tables** - Three-tier comparison with popular badge
- **Social Proof** - Logo clouds, testimonials, stats
- **Form Optimization** - Multi-step forms with progress
- **Urgency Elements** - Countdown timers, scarcity indicators
- **A/B Testing** - Simple variant testing hooks

## Quick Start

```typescript
// Load this skill
!{skill conversion-patterns}

// Use components from SKILL.md
import { HeroSection, CTAWithProof, PricingTable } from './components/marketing'
```

## Key Patterns

### Hero Section
- Benefit-focused headline
- Social proof badge
- Primary + secondary CTA
- Trust signals below CTA

### CTA Best Practices
- Action-oriented text ("Start Free Trial" not "Submit")
- Social proof nearby
- Supporting text (no credit card, etc.)
- Sticky on mobile

### Pricing Table
- Three tiers maximum
- "Most Popular" badge on middle tier
- Yearly savings badge
- Money-back guarantee

### Social Proof
- Logo cloud with hover effects
- Testimonials with ratings
- Specific metrics (not vague)

## Related

- `conversion-specialist-agent` - AI agent for CRO
- `/build-landing-page` - Build complete landing page
- `seo-2025-patterns` - SEO optimization patterns
