# [Feature Name]

## Overview
[What this feature does for users - 2-3 sentences describing the core functionality]

## User Value
[Why users need this feature - the problem it solves or opportunity it provides]

## User Scenarios

### Primary Scenario
**As a** [user type]
**I want to** [action]
**So that** [benefit]

**Acceptance Criteria:**
- [ ] [Testable criterion 1]
- [ ] [Testable criterion 2]
- [ ] [Testable criterion 3]

### Edge Cases
- **Scenario**: [Unusual or boundary condition]
  - **Expected**: [How system should handle it]

## Functional Requirements

1. **[Requirement 1]** - [Clear, testable requirement]
   - Details: [Additional context if needed]

2. **[Requirement 2]** - [Clear, testable requirement]
   - Details: [Additional context if needed]

3. **[Requirement 3]** - [Clear, testable requirement]
   - Details: [Additional context if needed]

## Non-Functional Requirements

### Performance
- [Measurable performance target - e.g., "Response time under 2 seconds"]

### Security
- [Security requirement - e.g., "All data encrypted at rest"]

### Usability
- [UX standard - e.g., "Maximum 3 clicks to complete primary action"]

### Scalability
- [Scale target - e.g., "Support 10,000 concurrent users"]

## Success Criteria

**IMPORTANT**: Success criteria must be measurable, technology-agnostic, and user-focused.

- [ ] [Measurable outcome 1 - e.g., "Users complete checkout in under 3 minutes"]
- [ ] [Measurable outcome 2 - e.g., "95% of searches return results in under 1 second"]
- [ ] [Measurable outcome 3 - e.g., "Task completion rate improves by 40%"]

## Assumptions

- [What we're assuming about users - e.g., "Users have basic computer literacy"]
- [What we're assuming about environment - e.g., "Users have stable internet connection"]
- [What we're assuming about data - e.g., "Data is available from existing system"]

## Dependencies

**Internal Dependencies** (other specs):
- [Reference to other spec - e.g., "Requires 001-authentication for user context"]

**External Dependencies** (third-party services):
- [External service - e.g., "Stripe for payment processing"]

## Out of Scope

**This feature explicitly does NOT include:**
- [Excluded functionality 1]
- [Excluded functionality 2]
- [Excluded functionality 3]

## Open Questions

> **LIMIT: Maximum 3 [NEEDS CLARIFICATION] markers**

- [NEEDS CLARIFICATION: Specific question that impacts scope/security/UX]

---

**Template Guidelines:**
- Focus on WHAT users need and WHY
- Avoid HOW to implement (no tech stack, APIs, code structure)
- Written for business stakeholders, not developers
- Every requirement must be testable and unambiguous
- Success criteria must be measurable without implementation knowledge
