---
name: monitoring-patterns
description: Metrics, health checks, alerting
allowed-tools: Read, Bash, Grep, Glob
---

# monitoring-patterns

**Purpose**: Metrics, health checks, alerting for Redis implementations.

**Activation Triggers**:
- When implementing monitoring patterns
- When user mentions Redis Metrics, health checks, alerting
- When designing Redis architecture

## Quick Reference

See templates/, scripts/, and examples/ for implementation patterns.

## Templates

- `templates/` - Configuration file templates
- All templates use placeholders (no hardcoded credentials)

## Scripts

- `scripts/` - Automation and testing scripts

## Examples

- `examples/` - Implementation examples for common use cases

## Security Compliance

This skill follows strict security rules:
- All code examples use placeholder values only
- No real API keys, passwords, or secrets
- Environment variable references in all code
- `.gitignore` protection documented
