# Resume Tailoring Skill - Marketplace Submission

## Skill Information

**Name:** Resume Tailoring Skill

**Category:** Productivity / Career Development

**Tags:** resume, job-search, career, recruitment, cv, job-application, interview-prep

**Short Description:** AI-powered resume generation that researches roles, surfaces undocumented experiences, and creates tailored resumes from your library.

**Long Description:**

Transform your job search with AI-powered resume tailoring that goes beyond simple keyword matching. This skill generates high-quality, tailored resumes optimized for specific job descriptions while maintaining factual integrity.

**Key Features:**
- 🔍 Deep Research: Analyzes company culture, role requirements, and success profiles
- 💬 Branching Discovery: Surfaces undocumented experiences through conversational interviews
- 🎯 Smart Matching: Confidence-scored content selection with transparent gap identification
- 📄 Multi-Format Output: Professional MD, DOCX, PDF, and interview prep reports
- 🔄 Self-Improving: Library grows with each successful resume

**Perfect for:**
- Job seekers applying to multiple roles
- Career transitioners bridging domain gaps
- Professionals with diverse experience backgrounds
- Anyone who wants to optimize their application materials

**Core Principle:** Truth-preserving optimization - never fabricates experience, but intelligently reframes and emphasizes relevant aspects.

## Installation

```bash
git clone https://github.com/varunr89/resume-tailoring-skill.git ~/.claude/skills/resume-tailoring
```

## Usage

Simply say:
```
"I want to apply for [Role] at [Company]. Here's the JD: [paste]"
```

The skill guides you through:
1. Library analysis
2. Company/role research
3. Template optimization
4. Experience discovery
5. Content matching
6. Multi-format generation

## Requirements

- Claude Code with skills enabled
- Existing resume library (markdown format)
- Optional: WebSearch, document-skills plugin

## Demo Video (Optional)

[Link to demo video showing the skill in action]

## Screenshots

1. **Research Phase:** Shows company analysis and success profile synthesis
2. **Template Generation:** Demonstrates role consolidation and title reframing options
3. **Experience Discovery:** Displays branching interview process
4. **Content Matching:** Shows confidence-scored content selection
5. **Final Output:** Generated resume with metadata report

## Support & Documentation

- **GitHub:** https://github.com/varunr89/resume-tailoring-skill
- **Documentation:** See README.md for full documentation
- **Issues:** https://github.com/varunr89/resume-tailoring-skill/issues

## License

MIT License

## Author

Varun Ramesh
- GitHub: @varunr89

## Version History

**v1.0.0** (2025-10-31)
- Initial release
- Full 5-phase workflow implementation
- Multi-format output support
- Comprehensive error handling
- Experience discovery with branching interviews
- Confidence-scored content matching

## Marketplace Category Suggestions

**Primary:** Productivity
**Secondary:** Career Development, Writing & Content

## Keywords for Search

resume, CV, job application, career, recruitment, job search, interview prep, resume optimization, job description, tailored resume, ATS, cover letter, career transition, experience matching

## Pricing (if applicable)

Free and Open Source (MIT License)

## Privacy & Data Handling

- All processing happens locally within Claude Code
- No external data transmission except for optional WebSearch queries
- Resume data stays on your machine
- Generated resumes saved to local filesystem
- No telemetry or tracking
