# Rust Plugin Sources

This file documents the sources used to create the rust plugin skills.

## Rust Skill

### Official Rust Documentation
- **URL**: https://doc.rust-lang.org/stable/
- **Purpose**: Official Rust language documentation
- **Date Accessed**: 2025-11-15
- **Key Topics**: Rust language features, standard library, best practices, patterns

### The Rust Programming Language Book
- **URL**: https://doc.rust-lang.org/book/
- **Purpose**: Comprehensive guide to learning Rust
- **Key Topics**:
  - Ownership and borrowing
  - Lifetimes
  - Error handling with Result and Option
  - Traits and generics
  - Smart pointers
  - Concurrency
  - Async programming

### Rust by Example
- **URL**: https://doc.rust-lang.org/rust-by-example/
- **Purpose**: Learning Rust through practical examples
- **Key Topics**: Pattern matching, modules, crates, error handling, testing

### Rust Standard Library Documentation
- **URL**: https://doc.rust-lang.org/std/
- **Purpose**: Standard library API reference
- **Key Topics**:
  - Collections (Vec, HashMap, etc.)
  - Iterators and functional programming
  - I/O operations
  - File system operations
  - Threading and synchronization

### Async Rust Book
- **URL**: https://rust-lang.github.io/async-book/
- **Purpose**: Asynchronous programming in Rust
- **Key Topics**:
  - async/await syntax
  - Futures and executors
  - Tokio runtime
  - Async streams
  - Pinning

### Rust API Guidelines
- **URL**: https://rust-lang.github.io/api-guidelines/
- **Purpose**: Best practices for designing Rust APIs
- **Key Topics**:
  - Naming conventions
  - Type safety
  - Error handling patterns
  - Documentation standards

### Cargo Book
- **URL**: https://doc.rust-lang.org/cargo/
- **Purpose**: Rust's package manager and build system
- **Key Topics**:
  - Project structure
  - Dependencies management
  - Build configuration
  - Testing and benchmarking
  - Publishing crates

## Plugin Information

- **Name**: rust
- **Version**: 0.1.0
- **Description**: Rust programming skills: ownership, borrowing, lifetimes, async, and best practices
- **Skills**: 1 comprehensive Rust skill
- **Created**: 2025-11-15
