---
name: research-methodology
description: Activate when conducting topic research with complexity assessment, thinking mode selection, and comprehensive documentation generation
license: MIT
---

# Research Methodology

Guide for systematic topic research with complexity-based thinking mode selection and comprehensive documentation generation for knowledge capture.

## When to Use This Skill

Activate when:
- Researching new topics or technologies
- Creating comprehensive knowledge documentation
- Assessing topic complexity for appropriate depth
- Generating expert agent prompts from research
- Building reference materials for teams
- Filling knowledge gaps in project domains

## Complexity Assessment Framework

### Scoring Criteria

Evaluate topics using these dimensions:

**Scope Breadth (1-3)**
- 1: Single domain focus
- 2: Cross-domain interactions
- 3: Multi-domain integration

**Technical Depth (1-3)**
- 1: Basic concepts and usage
- 2: Intermediate patterns and optimization
- 3: Advanced/cutting-edge techniques

**Integration Complexity (1-2)**
- 1: Standalone topic
- 2: Multiple systems/tools integration

**Source Availability (1-2)**
- 1: Well-documented, mature topic
- 2: Limited/new documentation

**Total Score: 4-10**

### Thinking Mode Selection

Based on total complexity score:

**Standard Mode (4-5)**
- Basic research process
- Core concepts and common patterns
- Standard documentation structure

**Think Mode (6-8)**
- Deeper reasoning and cross-referencing
- Multiple perspective analysis
- Trade-off considerations
- Enhanced troubleshooting

**Ultrathink Mode (9-10)**
- Comprehensive multi-perspective analysis
- Complex integration scenarios
- Advanced edge cases
- Scenario planning and decision frameworks

## Research Process

### Information Gathering
1. Core concepts and principles
2. Best practices and methodologies
3. Common tools and technologies
4. Typical use cases and applications
5. Known challenges and pain points
6. Recent developments and trends

### Enhanced Analysis (Think/Ultrathink)
- Alternative approaches and viewpoints
- Trade-offs and decision matrices
- Integration considerations
- Edge cases and failure modes
- Future direction and evolution

## Documentation Structure

```markdown
# [Topic] Research

## Complexity Assessment
- **Score**: [X]/10
- **Thinking Mode**: [Standard/Think/Ultrathink]
- **Key Complexity Factors**: [Summary]

## Role Definition
[How an expert in this topic operates]

## Knowledge Base
### Core Concepts
[Fundamental principles]

### Best Practices
[Recommended approaches]

### Tools and Technologies
[Key tools with use cases]

## Examples
[3-5 concrete, practical examples]

## Troubleshooting
### Common Issues
1. **Issue**: [Description]
   - **Symptoms**: [Observable signs]
   - **Solution**: [Fix steps]
   - **Prevention**: [How to avoid]

## Advanced Topics (Think/Ultrathink)
### Multi-Perspective Analysis
[Different approaches and viewpoints]

### Trade-off Considerations
[Decision frameworks and matrices]

### Integration Patterns
[How topic connects with other systems]

## Resources
[Documentation, tools, references]
```

## Output Types

### Agent Prompt
Generates specialized expert agent prompts:
- Role definition
- Knowledge base from research
- Response guidelines
- Troubleshooting reference

### Reference Documentation
Creates comprehensive knowledge docs:
- overview.md - Core concepts and patterns
- troubleshooting.md - Issues and solutions
- examples/ - Practical implementations

## Key Principles

- **Complexity-Driven Depth**: Match research depth to topic complexity
- **Practical Focus**: Emphasize actionable, real-world information
- **Structured Output**: Use consistent documentation templates
- **Source Attribution**: Reference authoritative sources
- **Continuous Update**: Plan for knowledge evolution
- **Integration Awareness**: Consider connections to related topics
