# Template: Dashboard de Métricas B2B SaaS

## 📊 Dashboard Executivo - [Nome da Empresa]

**Período**: [Mês/Ano] | **Última atualização**: [Data]

---

## 🎯 North Star Metric

**[Nome da sua North Star Metric]**: [Valor atual]

[Gráfico de linha mostrando evolução nos últimos 6-12 meses]

**Meta do Quarter**: [Meta] | **Progress**: [X]% atingido

---

## 💰 Receita e Crescimento

### MRR (Monthly Recurring Revenue)

| Métrica | Valor | vs. Mês Anterior | vs. Ano Anterior |
|---------|-------|------------------|------------------|
| **MRR Total** | R$ [X] | +[Y]% | +[Z]% |
| New MRR | R$ [X] | +[Y]% | +[Z]% |
| Expansion MRR | R$ [X] | +[Y]% | +[Z]% |
| Contraction MRR | -R$ [X] | [Y]% | [Z]% |
| Churned MRR | -R$ [X] | [Y]% | [Z]% |

**ARR (Annual Recurring Revenue)**: R$ [MRR × 12]

**Growth Rate**: [X]% MoM (month-over-month)

[Gráfico de barras empilhadas: New, Expansion, Contraction, Churn por mês]

---

## 👥 Clientes

### Clientes Ativos

| Métrica | Valor | vs. Mês Anterior |
|---------|-------|------------------|
| **Total de Clientes** | [X] | +[Y] |
| Novos Clientes | [X] | +[Y] |
| Churned Clientes | [X] | [Y] |
| Net New Customers | [X] | [Y] |

**Por Segmento**:
- SMB (<50 funcionários): [X] clientes | R$ [Y] MRR
- Mid-Market (50-500): [X] clientes | R$ [Y] MRR
- Enterprise (500+): [X] clientes | R$ [Y] MRR

[Gráfico de pizza: Distribuição de clientes por segmento]

---

## 🔄 Retenção e Churn

### Churn Mensal

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **Revenue Churn** | [X]% | <[Y]% | 🟢/🟡/🔴 |
| Customer Churn | [X]% | <[Y]% | 🟢/🟡/🔴 |
| **Net Revenue Retention** | [X]% | >[Y]% | 🟢/🟡/🔴 |
| Gross Revenue Retention | [X]% | >[Y]% | 🟢/🟡/🔴 |

**Churn Anualizado**: [X]%

[Gráfico de linha: Revenue Churn e NRR ao longo do tempo]

### Análise de Cohort (6 meses)

| Cohort | Mês 1 | Mês 2 | Mês 3 | Mês 4 | Mês 5 | Mês 6 |
|--------|-------|-------|-------|-------|-------|-------|
| Jan/24 | 100% | 98% | 96% | 95% | 94% | 92% |
| Fev/24 | 100% | 97% | 95% | 93% | 92% | - |
| Mar/24 | 100% | 99% | 97% | 96% | - | - |
| Abr/24 | 100% | 98% | 96% | - | - | - |
| Mai/24 | 100% | 97% | - | - | - | - |
| Jun/24 | 100% | - | - | - | - | - |

---

## 💵 Unit Economics

### CAC e LTV

| Métrica | Valor | Benchmark | Status |
|---------|-------|-----------|--------|
| **CAC** (Customer Acquisition Cost) | R$ [X] | - | - |
| **LTV** (Lifetime Value) | R$ [X] | - | - |
| **LTV:CAC Ratio** | [X]:1 | >3:1 | 🟢/🟡/🔴 |
| **CAC Payback Period** | [X] meses | <12m | 🟢/🟡/🔴 |
| **ARPA** (Avg Revenue Per Account) | R$ [X] | - | - |

**Gross Margin**: [X]%

[Gráfico: Evolução de CAC, LTV e LTV:CAC ratio]

---

## 📈 Funil de Vendas

### Pipeline e Conversão

| Estágio | Quantidade | MRR Potencial | Conversion |
|---------|------------|---------------|------------|
| Leads | [X] | - | - |
| MQLs | [X] | - | [Y]% |
| SQLs | [X] | - | [Y]% |
| Oportunidades | [X] | R$ [Z] | [Y]% |
| **Fechados** | [X] | R$ [Z] | [Y]% |

**Win Rate**: [X]% (Opp → Fechado)

**Sales Cycle Length**: [X] dias (média)

**Pipeline Coverage**: [X]x do target ([Pipeline MRR] / [Target MRR])

[Funil visual mostrando conversão entre estágios]

---

## 🎯 Vendas

### Performance do Time

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **Novos Clientes Fechados** | [X] | [Y] | 🟢/🟡/🔴 |
| **New MRR Adicionado** | R$ [X] | R$ [Y] | 🟢/🟡/🔴 |
| **ACV Médio** | R$ [X] | R$ [Y] | 🟢/🟡/🔴 |

**Performance por Rep**:

| Rep | Deals Fechados | MRR Fechado | % of Quota |
|-----|----------------|-------------|------------|
| [Nome 1] | [X] | R$ [Y] | [Z]% |
| [Nome 2] | [X] | R$ [Y] | [Z]% |
| [Nome 3] | [X] | R$ [Y] | [Z]% |

**CAC por Canal**:
- Inbound: R$ [X] ([Y]% dos clientes)
- Outbound: R$ [X] ([Y]% dos clientes)
- Partnerships: R$ [X] ([Y]% dos clientes)
- Outros: R$ [X] ([Y]% dos clientes)

---

## 📊 Produto e Engajamento

### Usage Metrics

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **DAU** (Daily Active Users) | [X] | [Y] | 🟢/🟡/🔴 |
| **MAU** (Monthly Active Users) | [X] | [Y] | 🟢/🟡/🔴 |
| **DAU/MAU Ratio** (Stickiness) | [X]% | >[Y]% | 🟢/🟡/🔴 |

**Feature Adoption** (% de clientes usando):
- Feature A: [X]%
- Feature B: [X]%
- Feature C: [X]%

**Time-to-Value**: [X] dias (médio até ativação)

**Activation Rate**: [X]% (trial/signup → ativo)

[Gráfico: DAU e MAU ao longo do tempo]

---

## 😊 Satisfação do Cliente

### NPS e CSAT

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **NPS** (Net Promoter Score) | [X] | >[Y] | 🟢/🟡/🔴 |
| Promoters (9-10) | [X]% | - | - |
| Passives (7-8) | [X]% | - | - |
| Detractors (0-6) | [X]% | - | - |
| **CSAT** (Customer Satisfaction) | [X]/5 | >[Y] | 🟢/🟡/🔴 |

**Top Razões de Churn**:
1. [Razão 1] - [X]% dos churns
2. [Razão 2] - [X]% dos churns
3. [Razão 3] - [X]% dos churns

---

## 🏥 Health Score

### Distribuição de Clientes por Health

| Status | Quantidade | % Total | MRR |
|--------|------------|---------|-----|
| 🟢 Green (Saudável) | [X] | [Y]% | R$ [Z] |
| 🟡 Yellow (At-risk) | [X] | [Y]% | R$ [Z] |
| 🔴 Red (Crítico) | [X] | [Y]% | R$ [Z] |

**MRR at Risk**: R$ [X] (Yellow + Red)

**Ações em andamento**:
- [X] contas em plano de recuperação
- [X] Executive escalations
- [X] Renovações próximas (30-60 dias)

---

## 💸 Financeiro

### Burn e Runway

| Métrica | Valor |
|---------|-------|
| **Cash Balance** | R$ [X] |
| **Monthly Burn Rate** | R$ [X] |
| **Runway** | [X] meses |
| **Monthly Revenue** | R$ [X] |
| **Net Burn** | R$ [X] (Burn - Revenue) |

**Break-even MRR**: R$ [X] (quando receita = custos)

[Gráfico: Cash balance projection com runway]

---

## 👥 Time e Recursos

### Headcount

| Departamento | Headcount | % do Total |
|--------------|-----------|------------|
| Engineering | [X] | [Y]% |
| Sales | [X] | [Y]% |
| Customer Success | [X] | [Y]% |
| Marketing | [X] | [Y]% |
| Ops/Admin | [X] | [Y]% |
| **Total** | [X] | 100% |

**Hiring Pipeline**: [X] offers out, [Y] em processo

**Revenue per Employee**: R$ [ARR / Headcount]

---

## 🎯 OKRs do Quarter

### Progresso dos OKRs

**O1: [Nome do Objective]** - Score: [X]/1.0
- KR1: [Descrição] - [X]% complete
- KR2: [Descrição] - [X]% complete
- KR3: [Descrição] - [X]% complete

**O2: [Nome do Objective]** - Score: [X]/1.0
- KR1: [Descrição] - [X]% complete
- KR2: [Descrição] - [X]% complete
- KR3: [Descrição] - [X]% complete

**O3: [Nome do Objective]** - Score: [X]/1.0
- KR1: [Descrição] - [X]% complete
- KR2: [Descrição] - [X]% complete
- KR3: [Descrição] - [X]% complete

---

## 🚨 Alertas e Action Items

### Red Flags

- 🔴 [Alerta 1: ex: "Churn aumentou 50% no último mês"]
- 🔴 [Alerta 2: ex: "Pipeline está 2x abaixo do target"]
- 🟡 [Alerta 3: ex: "CAC payback aumentou para 15 meses"]

### Top 3 Prioridades

1. **[Prioridade 1]**
   - Owner: [Nome]
   - Deadline: [Data]
   - Status: [Em andamento/Bloqueado]

2. **[Prioridade 2]**
   - Owner: [Nome]
   - Deadline: [Data]
   - Status: [Em andamento/Bloqueado]

3. **[Prioridade 3]**
   - Owner: [Nome]
   - Deadline: [Data]
   - Status: [Em andamento/Bloqueado]

---

---

# EXEMPLO PREENCHIDO

---

## 📊 Dashboard Executivo - AcmeCRM

**Período**: Junho/2024 | **Última atualização**: 01/Jul/2024

---

## 🎯 North Star Metric

**MRR de Clientes Ativos**: R$300.000

[Gráfico: Jan R$100k → Fev R$130k → Mar R$160k → Abr R$210k → Mai R$260k → Jun R$300k]

**Meta do Q2**: R$350k | **Progress**: 86% atingido

---

## 💰 Receita e Crescimento

### MRR (Monthly Recurring Revenue)

| Métrica | Valor | vs. Mês Anterior | vs. Ano Anterior |
|---------|-------|------------------|------------------|
| **MRR Total** | R$ 300.000 | +15% | +200% |
| New MRR | R$ 60.000 | +10% | +180% |
| Expansion MRR | R$ 5.000 | +25% | +300% |
| Contraction MRR | -R$ 2.000 | 0% | +50% |
| Churned MRR | -R$ 6.000 | +20% | +100% |

**ARR**: R$ 3.6M

**Growth Rate**: 15% MoM

---

## 👥 Clientes

### Clientes Ativos

| Métrica | Valor | vs. Mês Anterior |
|---------|-------|------------------|
| **Total de Clientes** | 80 | +10 |
| Novos Clientes | 15 | +2 |
| Churned Clientes | 5 | +2 |
| Net New Customers | 10 | 0 |

**Por Segmento**:
- SMB: 60 clientes | R$ 120k MRR (R$2k/cliente)
- Mid-Market: 18 clientes | R$ 144k MRR (R$8k/cliente)
- Enterprise: 2 clientes | R$ 36k MRR (R$18k/cliente)

---

## 🔄 Retenção e Churn

### Churn Mensal

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **Revenue Churn** | 2.0% | <3% | 🟢 |
| Customer Churn | 2.5% | <3% | 🟢 |
| **Net Revenue Retention** | 110% | >100% | 🟢 |
| Gross Revenue Retention | 97% | >95% | 🟢 |

**Churn Anualizado**: 21.6%

---

## 💵 Unit Economics

### CAC e LTV

| Métrica | Valor | Benchmark | Status |
|---------|-------|-----------|--------|
| **CAC** | R$ 800 | - | - |
| **LTV** | R$ 12.000 | - | - |
| **LTV:CAC Ratio** | 15:1 | >3:1 | 🟢 |
| **CAC Payback** | 3 meses | <12m | 🟢 |
| **ARPA** | R$ 3.750 | - | - |

**Gross Margin**: 85%

---

## 📈 Funil de Vendas

### Pipeline e Conversão

| Estágio | Quantidade | MRR Potencial | Conversion |
|---------|------------|---------------|------------|
| Leads | 500 | - | - |
| MQLs | 150 | - | 30% |
| SQLs | 75 | - | 50% |
| Oportunidades | 40 | R$ 180k | 53% |
| **Fechados** | 15 | R$ 60k | 38% |

**Win Rate**: 38%

**Sales Cycle Length**: 45 dias

**Pipeline Coverage**: 3x (R$180k pipeline / R$60k target)

---

## 🎯 Vendas

### Performance do Time

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **Novos Clientes** | 15 | 12 | 🟢 |
| **New MRR** | R$ 60k | R$ 50k | 🟢 |
| **ACV Médio** | R$ 4.800 | R$ 4.000 | 🟢 |

**Performance por Rep**:

| Rep | Deals | MRR | % of Quota |
|-----|-------|-----|------------|
| Pedro | 7 | R$ 28k | 112% |
| Ana | 5 | R$ 20k | 80% |
| Carlos | 3 | R$ 12k | 48% |

**CAC por Canal**:
- Inbound: R$ 500 (60%)
- Outbound: R$ 1.200 (30%)
- Partnerships: R$ 400 (10%)

---

## 📊 Produto e Engajamento

### Usage Metrics

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **DAU** | 1.200 | 1.500 | 🟡 |
| **MAU** | 4.800 | 5.000 | 🟡 |
| **DAU/MAU Ratio** | 25% | >20% | 🟢 |

**Feature Adoption**:
- Pipeline view: 95%
- Automations: 68%
- WhatsApp integration: 52%

**Time-to-Value**: 5 dias

**Activation Rate**: 78%

---

## 😊 Satisfação

### NPS e CSAT

| Métrica | Atual | Meta | Status |
|---------|-------|------|--------|
| **NPS** | 48 | >40 | 🟢 |
| Promoters | 58% | - | - |
| Passives | 32% | - | - |
| Detractors | 10% | - | - |
| **CSAT** | 4.2/5 | >4.0 | 🟢 |

**Top Razões de Churn**:
1. Não viu valor / ROI - 40%
2. Preço - 30%
3. Mudança interna - 20%
4. Dificuldade de uso - 10%

---

## 🏥 Health Score

| Status | Qtd | % | MRR |
|--------|-----|---|-----|
| 🟢 Green | 65 | 81% | R$ 255k |
| 🟡 Yellow | 10 | 13% | R$ 30k |
| 🔴 Red | 5 | 6% | R$ 15k |

**MRR at Risk**: R$ 45k

**Ações**:
- 8 contas em recovery plan
- 2 Executive escalations
- 12 Renovações em 30-60 dias

---

## 💸 Financeiro

| Métrica | Valor |
|---------|-------|
| **Cash Balance** | R$ 800k |
| **Monthly Burn** | R$ 150k |
| **Runway** | 12 meses |
| **Monthly Revenue** | R$ 300k |
| **Net Burn** | R$ 50k |

**Break-even MRR**: R$ 450k

---

## 👥 Time

| Depto | Headcount |
|-------|-----------|
| Engineering | 3 |
| Sales | 3 |
| CS | 1 |
| Marketing | 1 |
| **Total** | 8 |

**Hiring**: 2 offers (1 eng, 1 sales)

**Revenue/Employee**: R$450k ARR

---

## 🎯 OKRs Q2

**O1: Validar PMF** - 0.67
- KR1: R$100k MRR - 75% ✓
- KR2: 50 clientes - 84% ✓
- KR3: 90% retention - 60% 🟡

**O2: Produto que clientes amam** - 0.86
- KR1: NPS > 50 - 87% ✓
- KR2: 70% uso semanal - 90% ✓
- KR3: 3 features - 80% ✓

**O3: GTM replicável** - 0.75
- KR1: CAC payback <12m - 75% ✓
- KR2: Win rate >25% - 70% ✓
- KR3: ICP + playbook - 80% ✓

---

## 🚨 Alertas

- 🟡 MRR target do Q2 (R$350k) em risco - precisa R$50k em julho
- 🟡 Carlos (AE) abaixo de quota - coaching necessário
- 🟢 Churn estável e controlado

### Top 3 Prioridades - Julho

1. **Fechar R$50k MRR em julho**
   - Owner: Pedro (Head of Sales)
   - Deadline: 31/Jul
   - Status: Pipeline de R$150k, 🟢 on-track

2. **Reduzir churn de "não viu valor"**
   - Owner: Ana (CS)
   - Deadline: 31/Jul
   - Status: Novo onboarding em teste, 🟡

3. **Contratar 1 AE e 1 Eng**
   - Owner: João (CEO)
   - Deadline: 15/Jul
   - Status: 2 offers out, 🟢

---

## 📌 Como Usar Este Dashboard

### Frequência de Atualização

- **Diária**: MRR, novos clientes, churn do dia
- **Semanal**: Pipeline, vendas, health score
- **Mensal**: Todas as métricas completas, cohorts, OKRs
- **Trimestral**: Deep dive em cohorts, financials, strategic review

### Distribuição

- **CEO/Founders**: Dashboard completo
- **Board**: Dashboard executivo (top-level) mensalmente
- **Time**: Métricas relevantes para cada função
- **Investidores**: Versão trimestral + highlights mensais

### Ferramentas

**Gratuitas**:
- Google Sheets (este template)
- Data Studio (visualizações)
- Metabase (BI open-source)

**Pagas**:
- ChartMogul (SaaS metrics específico)
- Baremetrics (similar a ChartMogul)
- Looker / Tableau / Power BI (enterprise)

**Integrações**:
- Stripe/Chargebee (billing data)
- Salesforce/Pipedrive (CRM data)
- Mixpanel/Amplitude (product data)
- Segment (data pipeline)

---

## 📚 Recursos

**Templates**:
- [ChartMogul Metrics Guide](https://chartmogul.com/resources/)
- [SaaStr Metrics Template](https://www.saastr.com/)
- [OpenView SaaS Benchmarks](https://openviewpartners.com/benchmarks/)

**Benchmarks**:
- [SaaS Capital Index](https://www.saas-capital.com/research/)
- [KeyBanc SaaS Survey](https://www.keybanc.com/)
- [Pacific Crest SaaS Survey](https://www.bvp.com/atlas/saas-survey)
