# Template de OKRs para B2B SaaS Startups

## Q[X] [Ano] - OKRs da [Nome da Empresa]

---

## Como Usar Este Template

1. **Defina 3-5 Objectives** para o quarter
2. Para cada Objective, crie **3-5 Key Results** mensuráveis
3. **Revise mensalmente** o progresso
4. **Score no final do quarter**: 0.0 (nenhum progresso) a 1.0 (completamente atingido)

**Target de scoring**: 0.7-0.9 é ideal (mostra ambição + realização)

---

## Objective 1: [Nome do Objetivo - Qualitativo e Inspirador]

**Contexto**: [1-2 frases explicando POR QUE este objetivo importa agora]

**Owner**: [Nome do responsável principal]

### Key Results:

**KR1**: [Métrica específica de X para Y]
- **Baseline**: [Valor atual]
- **Target**: [Valor desejado]
- **Atual**: [Atualizar mensalmente]
- **Status**: 🟢 On-track | 🟡 At-risk | 🔴 Off-track
- **Score**: [0.0 - 1.0]

**KR2**: [Métrica específica de X para Y]
- **Baseline**: [Valor atual]
- **Target**: [Valor desejado]
- **Atual**: [Atualizar mensalmente]
- **Status**: 🟢 On-track | 🟡 At-risk | 🔴 Off-track
- **Score**: [0.0 - 1.0]

**KR3**: [Métrica específica de X para Y]
- **Baseline**: [Valor atual]
- **Target**: [Valor desejado]
- **Atual**: [Atualizar mensalmente]
- **Status**: 🟢 On-track | 🟡 At-risk | 🔴 Off-track
- **Score**: [0.0 - 1.0]

**Objective 1 Score**: [Média dos KRs]

---

## Objective 2: [Nome do Objetivo]

**Contexto**: [Por que este objetivo?]

**Owner**: [Nome]

### Key Results:

**KR1**: [Descrição]
- **Baseline**:
- **Target**:
- **Atual**:
- **Status**:
- **Score**:

**KR2**: [Descrição]
- **Baseline**:
- **Target**:
- **Atual**:
- **Status**:
- **Score**:

**KR3**: [Descrição]
- **Baseline**:
- **Target**:
- **Atual**:
- **Status**:
- **Score**:

**Objective 2 Score**: [Média]

---

## Objective 3: [Nome do Objetivo]

**Contexto**: [Por que este objetivo?]

**Owner**: [Nome]

### Key Results:

**KR1**: [Descrição]
- **Baseline**:
- **Target**:
- **Atual**:
- **Status**:
- **Score**:

**KR2**: [Descrição]
- **Baseline**:
- **Target**:
- **Atual**:
- **Status**:
- **Score**:

**KR3**: [Descrição]
- **Baseline**:
- **Target**:
- **Atual**:
- **Status**:
- **Score**:

**Objective 3 Score**: [Média]

---

## Overall Quarter Score

**Company OKR Score**: [Média de todos os Objectives]

---

## Exemplo Preenchido: Startup B2B SaaS Seed Stage

---

## Q1 2024 - AcmeCRM OKRs

---

## Objective 1: Validar Product-Market Fit com primeiros clientes

**Contexto**: Estamos no estágio seed e precisamos provar que há demanda real e retenção forte antes de escalar vendas. Foco em qualidade de clientes, não quantidade.

**Owner**: João Silva (CEO)

### Key Results:

**KR1**: Alcançar R$100k MRR
- **Baseline**: R$30k MRR (início do Q1)
- **Target**: R$100k MRR (fim do Q1)
- **Atual**: R$75k MRR (após 2 meses)
- **Status**: 🟡 At-risk (precisa acelerar no último mês)
- **Score**: 0.64

**KR2**: Conseguir 50 clientes pagantes ativos
- **Baseline**: 15 clientes
- **Target**: 50 clientes
- **Atual**: 42 clientes
- **Status**: 🟢 On-track
- **Score**: 0.77

**KR3**: Revenue Retention > 90% (cohort de 6 meses)
- **Baseline**: 85% retention
- **Target**: 90% retention
- **Atual**: 88% retention
- **Status**: 🟡 At-risk
- **Score**: 0.60

**Objective 1 Score**: 0.67

---

## Objective 2: Construir produto que clientes amam e usam diariamente

**Contexto**: Retenção e engajamento são sinais mais importantes que crescimento neste estágio. Precisamos de clientes que vejam o produto como indispensável.

**Owner**: Maria Santos (CTO)

### Key Results:

**KR1**: NPS > 50
- **Baseline**: NPS 35
- **Target**: NPS 50
- **Atual**: NPS 48
- **Status**: 🟢 On-track
- **Score**: 0.87

**KR2**: 70% dos clientes usam produto semanalmente
- **Baseline**: 50% uso semanal
- **Target**: 70% uso semanal
- **Atual**: 68% uso semanal
- **Status**: 🟢 On-track
- **Score**: 0.90

**KR3**: Lançar 3 features críticas baseadas em feedback
- **Baseline**: 0 features lançadas
- **Target**: 3 features lançadas
- **Atual**: 2 features lançadas, 1 em QA
- **Status**: 🟢 On-track
- **Score**: 0.80

**Objective 2 Score**: 0.86

---

## Objective 3: Definir go-to-market replicável e escalável

**Contexto**: Para levantar Series A, precisamos mostrar que sabemos adquirir clientes de forma previsível e com unit economics saudáveis.

**Owner**: Pedro Alves (Head of Sales)

### Key Results:

**KR1**: CAC payback < 12 meses
- **Baseline**: CAC payback 16 meses
- **Target**: CAC payback < 12 meses
- **Atual**: CAC payback 13 meses
- **Status**: 🟡 At-risk
- **Score**: 0.75

**KR2**: Win rate > 25% de oportunidades qualificadas
- **Baseline**: Win rate 15%
- **Target**: Win rate 25%
- **Atual**: Win rate 22%
- **Status**: 🟢 On-track
- **Score**: 0.70

**KR3**: Documentar ICP e playbook de vendas completo
- **Baseline**: ICP vago, processo ad-hoc
- **Target**: ICP documentado + playbook completo (discovery, demo, fechamento)
- **Atual**: ICP documentado, playbook 80% completo
- **Status**: 🟢 On-track
- **Score**: 0.80

**Objective 3 Score**: 0.75

---

## Overall Q1 2024 Score: 0.76

**Retrospectiva**:
- ✅ **O que deu certo**: Produto e engajamento foram foco e resultados foram ótimos (Obj 2 = 0.86)
- ⚠️ **O que precisa melhorar**: Crescimento de MRR ficou abaixo (KR1 do Obj 1), precisamos acelerar vendas
- 🔄 **Próximo quarter**: Focar em escalar vendas mantendo qualidade, contratar 1 AE adicional

---

## Templates por Estágio

### Template: Pre-Seed / Seed (0-20 clientes)

**Foco**: Validar PMF

**Objective 1: Validar problema e solução com primeiros clientes**
- KR1: Conseguir [10-20] clientes pagantes
- KR2: Alcançar R$[30-50k] MRR
- KR3: Revenue retention > [85]% após 3 meses

**Objective 2: Construir produto que clientes amam**
- KR1: NPS > [40]
- KR2: [80]% dos clientes usam produto semanalmente
- KR3: Time-to-value < [7] dias

**Objective 3: Definir ICP e go-to-market inicial**
- KR1: Documentar ICP claramente (persona, tamanho, vertical)
- KR2: Fechar [5] deals com ciclo de vendas < [60] dias
- KR3: Identificar [2-3] canais de aquisição viáveis

---

### Template: Series A (R$500k - R$2M ARR)

**Foco**: Escalar vendas e produto

**Objective 1: Acelerar crescimento de receita**
- KR1: Crescer de R$[500k] para R$[1.5M] MRR
- KR2: Adicionar [100+] novos clientes
- KR3: Expansion MRR = [20]% de New MRR

**Objective 2: Construir máquina de vendas escalável**
- KR1: Contratar e onboard [3] AEs produtivos
- KR2: Pipeline = [4x] do quarterly target
- KR3: Win rate > [25]%

**Objective 3: Alcançar excelência em retenção**
- KR1: Churn < [2]% mensal
- KR2: NRR > [105]%
- KR3: [90]% de clientes renovam

---

### Template: Series B+ (R$2M+ ARR)

**Foco**: Eficiência e escala

**Objective 1: Alcançar crescimento eficiente**
- KR1: Crescer de R$[2M] para R$[5M] MRR
- KR2: Rule of 40 > [40]%
- KR3: CAC payback < [9] meses

**Objective 2: Dominar segmento [X]**
- KR1: Fechar [10] deals > R$[100k] ACV
- KR2: Construir pipeline de R$[5M] no segmento
- KR3: Lançar features enterprise (SSO, SAML, etc.)

**Objective 3: Construir organização de classe mundial**
- KR1: eNPS (employee NPS) > [40]
- KR2: Contratar [20] pessoas em roles críticos
- KR3: Diversity: [40]% mulheres, [30]% pessoas negras

---

## Templates por Função/Time

### Sales Team OKRs

**Objective: Escalar pipeline de forma previsível**
- KR1: Gerar R$[X] em pipeline ([4x] do target)
- KR2: Conversion rate MQL → SQL > [X]%
- KR3: Cycle time médio < [X] dias

**Objective: Melhorar eficiência de fechamento**
- KR1: Win rate > [25]%
- KR2: ACV médio > R$[X]
- KR3: Cada AE fecha R$[X] por mês

---

### Product Team OKRs

**Objective: Lançar features que desbloqueiam crescimento**
- KR1: Lançar feature [X] com adoption de [Y]% em 30 dias
- KR2: Feature [Z] gera R$[X] em expansion MRR
- KR3: Reduzir bugs críticos de [X] para [Y]

**Objective: Melhorar experiência do usuário**
- KR1: Time-to-value < [X] dias
- KR2: Activation rate > [X]%
- KR3: CSAT de onboarding > [X]/5

---

### Marketing Team OKRs

**Objective: Construir motor de crescimento orgânico**
- KR1: Crescer tráfego orgânico de [X] para [Y] visitantes/mês
- KR2: Converter [X]% de visitantes em MQLs
- KR3: [X] keywords no top 3 do Google

**Objective: Otimizar funil de conversão**
- KR1: MQL → SQL conversion > [X]%
- KR2: CAC blended < R$[X]
- KR3: CAC payback < [X] meses

---

### Customer Success OKRs

**Objective: Maximizar retenção e expansão**
- KR1: Churn < [2]% mensal
- KR2: NRR > [110]%
- KR3: [90]% de clientes renovam

**Objective: Escalar CS de forma eficiente**
- KR1: CSM gerencia [X] contas cada (com health score verde)
- KR2: [X]% de onboardings são tech-touch (sem CSM)
- KR3: Time-to-value < [X] dias

---

## Check-in Mensal

**Data**: [Data do check-in]

**Participantes**: [Liderança da empresa]

### Status de cada Objective

**O1**: [Nome]
- Status geral: 🟢/🟡/🔴
- Progresso: [X]% dos KRs on-track
- Bloqueios: [Lista de bloqueios]
- Needs help: [O que precisa para desbloquear]

**O2**: [Nome]
- Status geral:
- Progresso:
- Bloqueios:
- Needs help:

**O3**: [Nome]
- Status geral:
- Progresso:
- Bloqueios:
- Needs help:

### Decisions e Actions

**Decisões tomadas**:
1. [Decisão 1]
2. [Decisão 2]

**Action items**:
- [ ] [Action 1] - Owner: [Nome] - Due: [Data]
- [ ] [Action 2] - Owner: [Nome] - Due: [Data]

---

## Retrospectiva de Final de Quarter

**Data**: [Fim do quarter]

### O Que Deu Certo? 🎉

1. [Item 1]
2. [Item 2]
3. [Item 3]

### O Que Não Deu Certo? 🤔

1. [Item 1] - **Por quê?** [Análise raiz]
2. [Item 2] - **Por quê?** [Análise raiz]
3. [Item 3] - **Por quê?** [Análise raiz]

### Learnings para Próximo Quarter 📚

1. [Learning 1] → **Ação**: [O que vamos fazer diferente]
2. [Learning 2] → **Ação**: [O que vamos fazer diferente]
3. [Learning 3] → **Ação**: [O que vamos fazer diferente]

### Ajustes Estratégicos?

- [ ] Manter estratégia atual
- [ ] Pequenos ajustes: [Descrever]
- [ ] Pivot significativo: [Descrever]

---

## Dicas de Uso

### Bons OKRs

✅ **Objective inspirador**: "Dominar o mercado de CRM para startups"
✅ **KR mensurável**: "Crescer MRR de R$100k para R$300k"
✅ **KR desafiador**: 70% de confiança de alcançar
✅ **3-5 KRs por Objective**

### OKRs Ruins

❌ **Objective vago**: "Melhorar o produto"
❌ **KR não mensurável**: "Fazer clientes mais felizes"
❌ **KR é tarefa**: "Lançar feature X" (use outcomes, não outputs)
❌ **Muitos OKRs**: >5 Objectives (falta de foco)

### Scoring

- **0.0 - 0.3**: Pouco progresso (problema sério)
- **0.4 - 0.6**: Progresso abaixo da expectativa (entender por quê)
- **0.7 - 0.9**: Sucesso (objetivo substancialmente alcançado)
- **1.0**: Completamente alcançado (talvez não ambicioso o suficiente)

### Frequência

- **Definir OKRs**: 2 semanas antes do quarter começar
- **Check-ins**: Mensalmente (mínimo)
- **Scoring**: Final do quarter
- **Retrospectiva**: 1 semana após quarter terminar

---

## Ferramentas

**Gratuitas**:
- Google Sheets (este template)
- Notion (templates de OKR)
- Markdown (documentos simples)

**Pagas**:
- Lattice
- 15Five
- Ally
- Weekdone
- Asana / Monday (com módulo de OKRs)

---

## Recursos

**Livros**:
- Measure What Matters - John Doerr
- Radical Focus - Christina Wodtke

**Templates**:
- [Google OKR Playbook](https://www.whatmatters.com/resources/google-okr-playbook/)
- [Weekdone OKR Examples](https://weekdone.com/okr-examples)

**Blogs**:
- [What Matters (John Doerr)](https://www.whatmatters.com/)
- [Christina Wodtke on OKRs](https://eleganthack.com/)
