# Template: One-Pager Executivo

## [Logo da Empresa]

# [Nome da Empresa]
## [Tagline em uma linha]

**Website**: [URL]
**Contato**: [Nome] - [Email] - [Telefone]
**Localização**: [Cidade, Estado]
**Estágio**: [Pre-Seed / Seed / Series A] | **Fundação**: [Ano]

---

## 🎯 Problema

[2-3 frases descrevendo o problema que você resolve. Seja específico e quantifique o impacto.]

**Exemplo**:
Startups brasileiras perdem 15-20h por semana gerenciando vendas em planilhas desconectadas. 70% das oportunidades são perdidas por falta de follow-up. O resultado são milhões de reais em receita perdida anualmente.

---

## 💡 Solução

[2-3 frases descrevendo sua solução e por que é única.]

**Exemplo**:
AcmeCRM é o CRM simples e acessível feito para startups brasileiras. Setup em 5 minutos, preço 50% menor que competidores, e integrações nativas com ferramentas que startups usam (Slack, WhatsApp).

---

## 📊 Tração

**Métricas principais**:
- **MRR**: R$[X] (crescendo [Y]%/mês)
- **ARR**: R$[X]
- **Clientes**: [X] clientes ativos
- **Churn**: [X]%/mês
- **NRR**: [X]%

**Milestones recentes**:
- [Marco 1: ex: "Alcançamos R$100k MRR"]
- [Marco 2: ex: "Fechamos primeiro cliente enterprise"]
- [Marco 3: ex: "NRR ultrapassou 100%"]

---

## 🎁 Produto

**Features principais**:
- [Feature 1]: [Benefício em 1 frase]
- [Feature 2]: [Benefício em 1 frase]
- [Feature 3]: [Benefício em 1 frase]

**Diferencial competitivo**:
- [Diferencial 1]
- [Diferencial 2]
- [Diferencial 3]

---

## 💰 Modelo de Negócio

**Pricing**:
- [Plano Starter]: R$[X]/mês
- [Plano Professional]: R$[X]/mês
- [Plano Enterprise]: R$[X]/mês

**Unit Economics**:
- **CAC**: R$[X]
- **LTV**: R$[X]
- **LTV:CAC**: [X]:1
- **CAC Payback**: [X] meses
- **Gross Margin**: [X]%

---

## 🎯 Mercado

**TAM** (Total Addressable Market): $[X]B
[1 frase explicando o cálculo]

**ICP** (Ideal Customer Profile):
[Descrição do cliente ideal em 1-2 frases]

**Competição**:
[2-3 principais competidores e como você se diferencia]

---

## 👥 Time

**[Nome do Founder 1]** - [Cargo]
[1 frase de background relevante]

**[Nome do Founder 2]** - [Cargo]
[1 frase de background relevante]

**[Nome do Founder 3]** - [Cargo] *(se aplicável)*
[1 frase de background relevante]

**Time total**: [X] pessoas

---

## 💸 Investimento

**Já levantado**: R$[X] em [Round anterior]
**Investidores**: [Lista de investidores notáveis]

**Levantando agora**: R$[X] em [Seed/Series A]
**Use of funds**: [Breve descrição de como vai usar o capital]

---

## 📞 Contato

**[Nome do CEO/Founder]**
Email: [email]
Telefone: [telefone]
LinkedIn: [URL]

**Pitch Deck**: [Link para deck]
**Demo**: [Link para agendar ou ver demo]

---

---

# EXEMPLO PREENCHIDO

---

## [Logo: AcmeCRM]

# AcmeCRM
## O CRM feito para startups brasileiras

**Website**: acmecrm.com.br
**Contato**: João Silva - joao@acmecrm.com - (11) 99999-9999
**Localização**: São Paulo, SP
**Estágio**: Seed | **Fundação**: 2023

---

## 🎯 Problema

Startups brasileiras perdem 15-20h por semana gerenciando vendas em planilhas e ferramentas desconectadas. 70% das oportunidades são perdidas por falta de follow-up. CRMs tradicionais são caros (USD $100+/usuário), complexos demais, e não aceitam boleto nem têm suporte em português.

---

## 💡 Solução

AcmeCRM é o primeiro CRM desenhado especificamente para startups brasileiras em estágio inicial (seed/Series A). Setup em 5 minutos, preço 50% mais acessível que competidores, e integrações nativas com WhatsApp, Slack, e ferramentas que startups usam. Interface em português, suporte local, e aceita boleto/PIX.

---

## 📊 Tração

**Métricas principais**:
- **MRR**: R$300k (crescendo 20%/mês)
- **ARR**: R$3.6M
- **Clientes**: 80 clientes ativos
- **Churn**: 2%/mês
- **NRR**: 110%

**Milestones recentes**:
- Alcançamos R$100k MRR em Maio/2024
- Fechamos primeira aceleradora como cliente (Endeavor Scale-Up)
- NRR ultrapassou 100% pela primeira vez
- Lançados em Product Hunt (2º lugar do dia)

---

## 🎁 Produto

**Features principais**:
- **Pipeline visual**: Veja todas as oportunidades de relance, arraste-e-solte
- **Automação inteligente**: Follow-ups automáticos por WhatsApp/Email
- **Integrações nativas**: WhatsApp Business, Slack, Gmail, Calendly
- **Relatórios simples**: Forecast de vendas, conversão de funil, performance de rep

**Diferencial competitivo**:
- ✓ Setup em 5 minutos (vs. dias de Salesforce/HubSpot)
- ✓ Preço 50% menor (R$99/usuário vs. $100 USD dos competidores)
- ✓ Feito para Brasil (boleto, PIX, NF automática, suporte PT-BR)
- ✓ Integrações com ferramentas de startups (não apenas enterprise)

---

## 💰 Modelo de Negócio

**Pricing**:
- **Starter**: R$99/mês (até 3 usuários)
- **Professional**: R$399/mês (até 10 usuários)
- **Enterprise**: R$1.999/mês (usuários ilimitados + SSO)

**Unit Economics**:
- **CAC**: R$800
- **LTV**: R$12.000
- **LTV:CAC**: 15:1
- **CAC Payback**: 3 meses
- **Gross Margin**: 85%

---

## 🎯 Mercado

**TAM**: $1B
15.000 startups brasileiras × $5k ACV médio

**ICP** (Ideal Customer Profile):
Startups B2B brasileiras em estágio seed ou Series A, entre 10-50 funcionários, vendendo para SMB ou mid-market, com time de vendas de 2-10 pessoas.

**Competição**:
- **Salesforce/HubSpot**: Caros (USD $75-150/user), complexos, sem suporte BR
- **Pipedrive**: Bom mas genérico, não entende dores de startups BR
- **Planilhas**: Status quo de 70% das startups, manual e ineficiente

**Nosso diferencial**: Simplicidade + Preço + Contexto brasileiro

---

## 👥 Time

**João Silva** - CEO & Co-founder
Ex-Head of Sales na StartupXYZ (R$50M ARR), vendeu CRM para 100+ startups nos últimos 5 anos

**Maria Santos** - CTO & Co-founder
Ex-Engineering Manager na TechCorp, 10 anos construindo produtos SaaS escaláveis

**Pedro Alves** - Head of Product & Co-founder
Ex-PM na BigSaaS, lançou 3 produtos B2B do zero

**Time total**: 8 pessoas (3 eng, 2 sales, 1 CS, 1 marketing, 1 ops)

---

## 💸 Investimento

**Já levantado**: R$500k em Pre-Seed (Jun/2023)
**Investidores**: Canary Ventures, 5 anjos (ex-founders de SaaS BR)

**Levantando agora**: R$3M em Seed
**Use of funds**:
- 50% Time (contratar 10 pessoas: eng, vendas, CS)
- 30% Marketing/Vendas (CAC, eventos, conteúdo)
- 15% Produto (infra, features enterprise)
- 5% Ops (legal, fiscal, ferramentas)

**Milestones em 18 meses**:
- R$300k → R$2M MRR
- 80 → 500 clientes
- Preparar para Series A

---

## 📞 Contato

**João Silva** - CEO & Co-founder
Email: joao@acmecrm.com
Telefone: (11) 99999-9999
LinkedIn: linkedin.com/in/joaosilva

**Pitch Deck**: [link para deck]
**Demo ao vivo**: [calendly link para agendar]

---

---

# Template Alternativo: One-Pager Focado em Vendas (B2B)

Use esta versão quando estiver prospectando grandes clientes enterprise ou parceiros (não investidores)

---

## [Logo da Empresa]

# [Nome da Empresa]
## [Value Proposition em uma linha]

---

## Por Que Clientes Como [Nome do Prospect] Escolhem [Sua Empresa]?

[2-3 bullet points de benefícios específicos para este tipo de cliente]

**Exemplo**:
- ✓ Feche 30% mais deals com pipeline organizado e follow-ups automáticos
- ✓ Economize 10h/semana que sua equipe gasta em planilhas e emails
- ✓ Visibilidade completa do funil de vendas em tempo real

---

## Clientes que Confiam em Nós

[Logos de 6-8 clientes relevantes, preferencialmente similares ao prospect]

---

## Como Funciona

**1. Setup Rápido** ⏱️
[1 frase explicando o onboarding]

**2. Integração Simples** 🔗
[1 frase sobre integrações]

**3. Resultados Rápidos** 📈
[1 frase sobre time-to-value]

---

## Resultados Reais

**[Cliente A] - [Vertical]**
"[Quote curto sobre resultado]"
Resultado: [Métrica, ex: "30% mais deals fechados em 3 meses"]

**[Cliente B] - [Vertical]**
"[Quote curto]"
Resultado: [Métrica]

---

## Planos e Pricing

| Plano | Preço | Ideal Para |
|-------|-------|-----------|
| Starter | R$[X]/mês | [Descrição] |
| Professional | R$[X]/mês | [Descrição] |
| Enterprise | Custom | [Descrição] |

**Inclui**:
- [Feature 1]
- [Feature 2]
- [Feature 3]
- Suporte em português via chat/email
- Onboarding guiado

---

## Próximos Passos

**Agende uma demo de 15 minutos**
[Link de calendário] ou [email/telefone]

**Experimente grátis por 14 dias**
[Link de trial] - Sem cartão de crédito necessário

**Perguntas?**
[Nome] - [Email] - [Telefone]

---

---

# Dicas de Uso do One-Pager

## Quando Usar

### Para Investidores
- Anexar em email de warm intro
- Deixar após pitch presencial
- Enviar antes de meeting (context setting)

### Para Vendas
- Prospecção de clientes enterprise
- Materiais de eventos/conferências
- Deixar após reunião comercial

### Para Parcerias
- Apresentação inicial a potencial parceiro
- Proposta de parceria estratégica

### Para Mídia
- Press kit
- Background para jornalistas

## Design e Formato

**Formato**:
- 1 página (frente e verso ok)
- PDF de alta qualidade
- Versão digital (pode ter links clicáveis)

**Design**:
- Visual > Texto (use ícones, gráficos, imagens)
- Brand consistent (cores, tipografia)
- Profissional mas não excessivamente formal

**Ferramentas**:
- Canva (templates prontos)
- Figma (design customizado)
- Google Docs/Slides (simples)
- InDesign (profissional)

## Distribuição

**Digital**:
- PDF por email
- Link no site (página "About" ou "Press")
- LinkedIn (post ou mensagem direta)

**Impresso**:
- Eventos e conferências
- Reuniões presenciais
- Materiais de marketing

## Versões

**Mantenha múltiplas versões**:
- Versão para investidores (foco em tração e mercado)
- Versão para vendas (foco em benefícios e ROI)
- Versão para parceiros (foco em sinergia e co-marketing)
- Versão para mídia/press (foco em história e impacto)

## Atualização

**Quando atualizar**:
- Mensalmente (métricas de tração)
- Após milestones importantes (funding, lançamentos, clientes)
- Antes de eventos importantes (conferências, pitches)

---

## Checklist Final

Antes de enviar/imprimir:

- [ ] Todas as informações estão atualizadas (especialmente métricas)
- [ ] Contato está correto e responsivo
- [ ] Links funcionam (se versão digital)
- [ ] Design é profissional e on-brand
- [ ] Não há typos ou erros
- [ ] Cabe em 1 página (2 páginas max)
- [ ] É fácil de escanear (hierarquia visual clara)
- [ ] CTA (call-to-action) é claro
- [ ] PDF está otimizado (não muito pesado)

---

## Recursos

**Templates de design**:
- Canva: [One Pager Templates](https://www.canva.com/one-pagers/templates/)
- Figma Community: Busque "one pager startup"
- Creative Market: Templates premium

**Inspiração**:
- [AngelList Startups](https://angel.co/): Ver perfis de outras startups
- [Crunchbase](https://www.crunchbase.com/): Company profiles
