# Template de Pitch Deck para B2B SaaS

## Estrutura Geral (12-15 slides)

### Slide 1: Cover / Capa

**Elementos**:
- Nome da empresa + logo
- Tagline (uma frase que resume o que você faz)
- Seus dados de contato
- [Opcional] Tração resumida (ex: "R$500k ARR, 100+ clientes")

**Exemplo**:
```
[Logo]
AcmeCRM
O CRM feito para startups brasileiras

João Silva - joao@acmecrm.com
R$300k ARR | 80 clientes | Crescendo 20%/mês
```

---

### Slide 2: Problem / Problema

**Objetivo**: Estabelecer que existe um problema sério e urgente

**Elementos**:
- Descrição do problema (1-2 frases)
- Por que é doloroso? (impacto quantificado)
- Como é resolvido hoje? (alternativas inadequadas)
- [Opcional] Storytelling (caso real de cliente)

**Exemplo**:
```
## O Problema

Startups brasileiras perdem 15-20h por semana gerenciando vendas em planilhas e ferramentas desconectadas.

**Hoje eles usam**:
- Planilhas Excel/Google Sheets (70%)
- CRMs americanos caros e complexos (20%)
- Email + lembrança mental (10%)

**Resultado**: Leads perdidos, follow-ups esquecidos, falta de visibilidade do pipeline

[Imagem: Screenshot de planilha caótica ou quote de cliente]
```

**Dicas**:
- Seja específico (não "empresas perdem dinheiro")
- Quantifique o problema (tempo, dinheiro, oportunidade)
- Mostre que soluções atuais são inadequadas

---

### Slide 3: Solution / Solução

**Objetivo**: Mostrar como seu produto resolve o problema de forma única

**Elementos**:
- Como funciona (1-2 frases)
- Screenshot ou demo visual
- Por que é melhor que alternativas?
- [Opcional] Value proposition clara

**Exemplo**:
```
## A Solução

AcmeCRM é o CRM simples e acessível feito para startups brasileiras.

[Screenshot do produto em uso]

**Diferencial**:
✓ Setup em 5 minutos (não dias)
✓ Preço 50% menor que competidores
✓ Em português com suporte local
✓ Integrações com ferramentas que startups usam (Slack, WhatsApp)
```

**Dicas**:
- Visual > texto (mostre o produto)
- Foque em benefícios, não features técnicas
- Seja claro no diferencial (por que você vs. outros?)

---

### Slide 4: Why Now / Por Que Agora

**Objetivo**: Mostrar que o timing é perfeito para sua solução

**Elementos**:
- Mudanças recentes no mercado
- Tendências tecnológicas
- Mudanças regulatórias
- Comportamento do consumidor mudando

**Exemplo**:
```
## Por Que Agora?

**1. Explosão de startups no Brasil**
- 15.000+ startups ativas (crescimento de 30% ao ano)
- Investimento VC cresceu 5x nos últimos 5 anos

**2. Digitalização pós-COVID**
- Vendas remotas viraram padrão
- Ferramentas digitais são essenciais, não opcionais

**3. Ferramentas internacionais não atendem**
- Preço em dólar inviável para early-stage BR
- Sem suporte em português
- Não aceitam boleto/PIX
```

**Dicas**:
- Mostre tendências (dados de mercado)
- Conecte tendências ao seu produto
- Crie senso de urgência

---

### Slide 5: Market Size / Tamanho de Mercado

**Objetivo**: Mostrar que o mercado é grande o suficiente para ser um unicórnio

**Elementos**:
- TAM (Total Addressable Market)
- SAM (Serviceable Available Market)
- SOM (Serviceable Obtainable Market)
- Bottom-up calculation (melhor que só citar relatórios)

**Exemplo**:
```
## Tamanho de Mercado

**TAM**: $5B
- 500.000 empresas no Brasil entre 10-500 funcionários
- × $10k ACV médio por CRM

**SAM**: $1B
- 100.000 startups e scale-ups (nosso foco)
- × $10k ACV

**SOM**: $100M (nos próximos 5 anos)
- 10% de market share do SAM
- 10.000 clientes × $10k ACV

[Gráfico visual mostrando TAM > SAM > SOM]
```

**Dicas**:
- Bottom-up > top-down (mais confiável)
- Seja realista no SOM (10-20% do SAM é razoável)
- Mostre caminho para $100M+ ARR (unicórnio)

---

### Slide 6: Product / Produto

**Objetivo**: Demonstrar que o produto funciona e entrega valor

**Elementos**:
- Screenshots ou demo breve
- Features principais (top 3-4)
- Workflow típico de uso
- [Opcional] Video demo

**Exemplo**:
```
## Produto

[Screenshots mostrando 3 telas principais]

**Features principais**:
1. Pipeline visual: Veja todas as oportunidades de relance
2. Automação de follow-ups: Nunca perca um lead
3. Integrações: WhatsApp, Slack, Email nativamente
4. Relatórios simples: Saiba exatamente como suas vendas vão

[Opcionalmente: Link para demo ou QR code]
```

**Dicas**:
- Mostre, não conte (visual)
- Foco em value, não features
- Demonstre simplicidade (UX clara)

---

### Slide 7: Business Model / Modelo de Negócio

**Objetivo**: Mostrar como você ganha dinheiro e unit economics

**Elementos**:
- Modelo de receita (subscription, usage-based, etc.)
- Pricing tiers
- CAC e LTV
- Gross margins

**Exemplo**:
```
## Modelo de Negócio

**SaaS por assinatura mensal/anual**

| Plano | Preço | Target |
|-------|-------|--------|
| Starter | R$99/mês | Startups <10 pessoas |
| Pro | R$399/mês | Startups 10-50 pessoas |
| Enterprise | R$1.999/mês | Scale-ups 50+ pessoas |

**Unit Economics**:
- CAC: R$800
- ACV: R$4.000 (R$333/mês × 12 meses)
- LTV: R$12.000 (36 meses avg)
- **LTV:CAC = 15:1**
- CAC payback: 3 meses
- Gross margin: 85%
```

**Dicas**:
- Unit economics saudáveis são críticos
- LTV:CAC > 3:1 é esperado
- Gross margin > 70% para SaaS

---

### Slide 8: Traction / Tração

**Objetivo**: Provar que há demanda e crescimento real

**Elementos**:
- MRR/ARR atual
- Crescimento mês a mês
- Número de clientes
- Retenção e NRR
- Logos de clientes (se tiver grandes nomes)

**Exemplo**:
```
## Tração

**Crescimento de MRR**
[Gráfico mostrando crescimento de R$10k → R$300k MRR nos últimos 12 meses]

**Métricas principais**:
- R$300k MRR | R$3.6M ARR
- 80 clientes ativos
- Crescendo 20% ao mês
- Churn: 2% mensal
- NRR: 110%

**Clientes**:
[Logos de 6-8 clientes conhecidos]
```

**Dicas**:
- Gráficos visuais (up and to the right)
- Mostre growth rate (não só absoluto)
- Retenção é crítica (prove que clientes ficam)
- Logos dão credibilidade

---

### Slide 9: Go-to-Market / Estratégia de Mercado

**Objetivo**: Mostrar que você sabe como adquirir clientes de forma escalável

**Elementos**:
- ICP (Ideal Customer Profile)
- Canais de aquisição
- Estratégia de vendas
- CAC por canal

**Exemplo**:
```
## Go-to-Market

**ICP**: Startups brasileiras B2B entre seed e Series A, 10-50 funcionários

**Canais de aquisição**:
1. **Inbound** (50% dos clientes)
   - SEO + blog em português
   - CAC: R$500

2. **Outbound** (30%)
   - SDR cold outreach
   - CAC: R$1.200

3. **Partnerships** (20%)
   - Aceleradoras e VCs indicam
   - CAC: R$400

**Sales model**: Inside sales (remote) + self-service para Starter plan
```

**Dicas**:
- Mostre que entende seu ICP profundamente
- Múltiplos canais > dependência de 1
- CAC deve ser escalável

---

### Slide 10: Competition / Competição

**Objetivo**: Mostrar landscape competitivo e seu posicionamento único

**Elementos**:
- Principais competidores
- Alternativas (incluindo status quo)
- Comparison matrix ou quadrante mágico
- Seu diferencial claro

**Exemplo**:
```
## Competição

[Gráfico 2x2: Eixo X = Preço (baixo → alto), Eixo Y = Simplicidade (simples → complexo)]

**Quadrante 1** (Alto preço, Complexo): Salesforce, HubSpot
**Quadrante 2** (Alto preço, Simples): Pipedrive
**Quadrante 3** (Baixo preço, Complexo): Open-source CRMs
**Quadrante 4** (Baixo preço, Simples): **AcmeCRM ← Aqui** + Competidor X

**Nosso diferencial**:
✓ Feito para contexto BR (boleto, NF, suporte PT)
✓ 50% mais barato que alternativas internacionais
✓ Setup em minutos, não dias
✓ Integrações com ferramentas de startups BR
```

**Dicas**:
- Não ignore competidores (mostra que você conhece mercado)
- Posicione-se claramente (não tente ser tudo para todos)
- Admita trade-offs (ex: "não temos todas features de Salesforce, mas somos 10x mais simples")

---

### Slide 11: Team / Time

**Objetivo**: Provar que vocês são as pessoas certas para executar

**Elementos**:
- Founders (foto, nome, role)
- Background relevante (empresas anteriores, expertise)
- Por que vocês especificamente?
- [Opcional] Key hires e advisors

**Exemplo**:
```
## Time

**João Silva** - CEO
- Ex-Head of Sales na StartupXYZ (R$50M ARR)
- Vendeu CRM para 100+ startups nos últimos 5 anos

**Maria Santos** - CTO
- Ex-Engineering Manager na TechCorp
- 10 anos construindo produtos SaaS escaláveis

**Pedro Alves** - Head of Product
- Ex-PM na BigSaaS
- Lançou 3 produtos B2B do zero

**Advisors**:
- Carlos Mentor (ex-VP Latam do Salesforce)
- Ana Investor (Partner na VentureCapital)

[Fotos profissionais do time]
```

**Dicas**:
- Mostre credibilidade (experiências relevantes)
- Complementaridade (tech + business + produto)
- Pele no jogo (full-time, comprometidos)

---

### Slide 12: Financials / Projeções Financeiras

**Objetivo**: Mostrar trajetória financeira e path to profitability

**Elementos**:
- Histórico de receita (se houver)
- Projeções 3-5 anos
- Key assumptions
- Break-even point

**Exemplo**:
```
## Financials

[Gráfico de linhas: 2022-2027]

| Ano | ARR | Clientes | Burn | Headcount |
|-----|-----|----------|------|-----------|
| 2023 (Real) | R$1M | 80 | -R$50k/mês | 8 |
| 2024 (Proj) | R$5M | 350 | -R$100k/mês | 20 |
| 2025 | R$15M | 900 | -R$150k/mês | 45 |
| 2026 | R$35M | 1.800 | Break-even | 80 |
| 2027 | R$70M | 3.200 | +R$500k/mês | 120 |

**Key assumptions**:
- Crescimento 3-4x ao ano (anos 2-4)
- Churn estável em 2%/mês
- CAC payback mantém <6 meses
- Gross margin ~85%
```

**Dicas**:
- Seja ambicioso mas realista
- Explique key assumptions (como vai chegar lá?)
- Mostre path to profitability (mesmo que distante)

---

### Slide 13: The Ask / Pedido de Investimento

**Objetivo**: Dizer claramente quanto você quer e para quê

**Elementos**:
- Quanto está levantando
- Valuation (se já definido)
- Use of funds breakdown
- Milestones que vai alcançar

**Exemplo**:
```
## The Ask

**Levantando R$3M em Seed Round**

**Uso do capital (18 meses de runway)**:
- 50% - Time (contratar 10 pessoas: eng, vendas, CS)
- 30% - Marketing e vendas (CAC, ferramentas, eventos)
- 15% - Produto (infra, ferramentas, desenvolvimento)
- 5% - Operações (legal, contador, escritório)

**Milestones nos próximos 18 meses**:
- R$300k → R$2M MRR
- 80 → 500 clientes
- Churn < 1.5%/mês
- NRR > 115%
- Break-even month em 24 meses
- Preparar para Series A
```

**Dicas**:
- Seja específico no valor
- Use of funds realista e detalhado
- Milestones ambiciosos mas alcançáveis
- Mostre que vai chegar em Series A com esse capital

---

### Slide 14: Appendix / Anexo (Slides de backup)

Slides extras para responder perguntas comuns (não apresentar na pitch inicial)

**Possíveis slides de appendix**:
- Roadmap de produto detalhado
- Case studies de clientes
- Detalhamento de métricas (cohorts, CAC por canal)
- Organograma e hiring plan
- Detalhes técnicos (arquitetura, segurança)
- Press mentions e awards
- Análise competitiva detalhada
- GTM playbooks

---

## Dicas Gerais de Design e Apresentação

### Design

**Visual > Texto**:
- Máximo 5-7 linhas de texto por slide
- Use imagens, gráficos, screenshots
- Fonte grande (>24pt)

**Consistência**:
- Palette de cores consistente (2-3 cores + preto/branco)
- Tipografia uniforme
- Template limpo

**Ferramentas**:
- Google Slides (simples, colaborativo)
- Figma (design customizado)
- Pitch.com (templates prontos)
- Canva (fácil de usar)

### Apresentação (Pitch Verbal)

**Timing**:
- 10-15 minutos para apresentar
- 10-15 minutos para Q&A
- Pratique para não ultrapassar (respeita tempo do investor)

**Storytelling**:
- Comece com hook (problema impactante ou stat surpreendente)
- Narrativa fluida (não leia slides)
- Paixão e energia (você precisa convencer)

**Preparação para perguntas**:
- Por que vocês vs. outros times?
- Por que agora?
- Como vocês vão vencer [competitor X]?
- Qual seu churn? CAC? LTV?
- O que acontece se [hipótese X] não der certo?

**Follow-up**:
- Enviar deck no mesmo dia
- Email de thank you
- Propor próximos passos (demo, data room, reference calls)

---

## Versões do Pitch Deck

### 1. Teaser Deck (5-7 slides)

Para cold outreach inicial ou primeiro contato

Inclui apenas:
- Cover
- Problem
- Solution
- Traction (high-level)
- Team
- The Ask

### 2. Full Deck (12-15 slides)

Template acima, para pitches formais

### 3. Demo Deck (Produto-focado)

Para demo calls com investidores técnicos

Foco em:
- Product slides (mais detalhado)
- Arquitetura e tech stack
- Roadmap
- Diferenciação técnica

### 4. Data Room Deck (Read-only)

Deck para investidor ler sozinho (mais texto ok)

Inclui:
- Todos os slides do full deck
- Appendix robusto
- Detalhes financeiros
- Métricas completas

---

## Checklist Final

Antes de enviar seu deck, valide:

- [ ] Menos de 15 slides (excluindo appendix)
- [ ] Visual e fácil de ler (não muito texto)
- [ ] Narrativa clara (problema → solução → traction → ask)
- [ ] Números precisos (não arredondamento suspeito)
- [ ] Sem typos ou erros gramaticais
- [ ] Design profissional (não amador)
- [ ] Contato claro (email, telefone, LinkedIn)
- [ ] Exportado em PDF (não mandar link editável)
- [ ] Testado com feedback de mentores/advisors

---

## Recursos

**Exemplos de pitch decks**:
- [Sequoia Pitch Deck Template](https://www.sequoiacap.com/article/writing-a-business-plan/)
- [Y Combinator Template](https://www.ycombinator.com/library/2u-how-to-build-your-seed-round-pitch-deck)
- [Pitch Deck Examples](https://www.pitchdeckfire.com/) (decks reais de startups)

**Ferramentas**:
- Pitch.com
- Google Slides
- Figma
- Canva

**Livros**:
- Pitch Anything - Oren Klaff
- The Art of the Start - Guy Kawasaki
