# Fundraising para B2B SaaS no Brasil

## Estágios de Investimento

### Pre-Seed (Ideia → MVP)

**Momento**: Validando problema, construindo MVP inicial

**Ticket**: R$200k - R$1M

**Dilution**: 10-20%

**Valuation**: R$1-5M pre-money

**Fontes**:
- Investidores-anjo
- Aceleradoras (YC, Endeavor, ACE, InovAtiva)
- Friends & Family
- Venture Studios
- Programas de governo (FAPESP PIPE, BNDES, etc.)

**Métricas esperadas**:
- MVP funcional ou em desenvolvimento
- 5-20 entrevistas com potenciais clientes
- Talvez 1-3 clientes piloto
- Time fundador completo (tech + business)

### Seed (PMF inicial → Validação)

**Momento**: Provando que tem Product-Market Fit inicial

**Ticket**: R$1-5M

**Dilution**: 15-25%

**Valuation**: R$5-25M pre-money

**Fontes**:
- VCs de Seed (Canary, Astella, Bossanova, Maya, Indicator)
- Corporate VCs (Bradesco Ventures, Itaú Asset, Banco do Brasil)
- Syndicate de anjos
- Aceleradoras corporativas

**Métricas esperadas**:
- 20-50 clientes pagantes
- R$30-100k MRR
- Churn < 5% mensal
- Crescimento 15-30% mensal
- Tempo de vida: 12-24 meses

### Series A (Escala inicial)

**Momento**: Escalar vendas e produto com PMF provado

**Ticket**: R$5-20M

**Dilution**: 20-30%

**Valuation**: R$25-100M pre-money

**Fontes**:
- VCs tradicionais (Kaszek, Monashees, Valor, Redpoint, Endeavor Catalyst)
- VCs internacionais com operação no Brasil
- Growth-stage VCs em early stage

**Métricas esperadas**:
- R$100-500k MRR (R$1.2-6M ARR)
- NRR > 100%
- CAC payback < 12 meses
- Crescimento 10-15% mensal
- Go-to-market replicável

### Series B+ (Escala e internacionalização)

**Momento**: Domínio de mercado, eficiência operacional, expansão

**Ticket**: R$20M+

**Dilution**: 15-25%

**Valuation**: R$100M+

**Fontes**:
- Late-stage VCs (SoftBank, Tiger Global, Sequoia)
- VCs internacionais
- Private Equity
- Corporate VCs estratégicos

**Métricas esperadas**:
- R$2M+ MRR (R$24M+ ARR)
- Rule of 40 > 40%
- Net Revenue Retention > 110%
- CAC < 12 meses payback
- Time completo de liderança

## Cenário de VC no Brasil

### Principais VCs de Seed/Early Stage

**Seed Stage (R$1-5M)**:
- **Canary**: B2B SaaS, marketplace
- **Astella**: Fintech, SaaS, infra
- **Bossanova**: B2B SaaS, tech empresas
- **Maya Capital**: B2B, infrastructure
- **Indicator Capital**: Early stage tech
- **Alive Ventures**: Seed, early stage
- **Atlantico**: Seed, Series A
- **ACE Ventures**: Aceleradora + investimento

**Series A (R$5-20M)**:
- **Kaszek Ventures**: Maior VC da América Latina
- **Monashees**: Early stage multi-sector
- **Valor Capital**: Brasil + US
- **Redpoint eventures**: Early stage, tech
- **Endeavor Catalyst**: Portfolio de Endeavor Scale-Ups

**Growth Stage (R$20M+)**:
- **SoftBank**: Late stage, checks grandes
- **Tiger Global**: Growth, global
- **Sequoia**: Começando a investir no Brasil
- **Riverwood**: Growth stage empresas

### O Que VCs Brasileiros Procuram

**Seed Stage**:
1. **Time fundador**: Complementar, experiente, resiliência
2. **Problema validado**: Evidência de problema urgente e doloroso
3. **Tracção inicial**: Clientes pagantes ou forte evidência de demanda
4. **TAM grande**: Mercado endereçável > R$1B
5. **Visão ambiciosa**: Potencial de ser unicórnio (R$5B+)

**Series A+**:
1. **Product-Market Fit**: Métricas provam que PMF está consolidado
2. **Unit economics**: LTV:CAC > 3, CAC payback < 12m
3. **Retenção**: Churn < 3% mensal, NRR > 100%
4. **Crescimento**: MRR crescendo 10-20% mês a mês
5. **Escalabilidade**: Processos replicáveis, não dependente de founders

## Preparação para Fundraising

### Timeline

**3-6 meses antes**:
- [ ] Definir quanto precisa levantar e por quê
- [ ] Mapear investidores potenciais (20-30 alvos)
- [ ] Preparar data room
- [ ] Alinhar time fundador em narrativa
- [ ] Começar warm intros

**2-3 meses antes**:
- [ ] Pitch deck finalizado
- [ ] Modelo financeiro robusto
- [ ] One-pager criado
- [ ] Referências de clientes preparadas
- [ ] Demo environment perfeito

**Durante processo** (1-3 meses):
- [ ] Pitches iniciais (50+ meetings)
- [ ] Follow-ups e due diligence (10-15 sérios)
- [ ] Negociação de term sheet (2-5 interessados)
- [ ] Fechamento e legal (1-2 meses)

### Quanto Levantar

**Regra geral**: 18-24 meses de runway

**Cálculo**:
```
Capital necessário = (Burn rate mensal × 24 meses) - Receita projetada

Exemplo:
Custos: R$150k/mês
Runway desejado: 24 meses
Receita atual: R$50k/mês, crescendo 15%/mês
Capital necessário: ~R$2.5-3M
```

**Buffer**: Levante 20-30% a mais do que modelo matemático sugere
- Sempre demora mais e custa mais
- Ter cushion evita emergência de fundraising

### Data Room

Organize documentos para compartilhar com investidores:

**Empresa**:
- Contrato social e alterações
- Cap table atualizado
- Histórico de investimentos anteriores
- Acordos de acionistas

**Financeiro**:
- Demonstrativos financeiros (últimos 12-24 meses)
- Modelo financeiro (projeções 3-5 anos)
- Breakdown de MRR, churn, CAC, LTV
- Detalhamento de custos

**Legal**:
- Contratos de clientes (template)
- Contratos de funcionários
- Contratos de fornecedores críticos
- IP e propriedade intelectual

**Clientes e Produto**:
- Lista de clientes (com MRR, churn)
- NPS e testimonials
- Roadmap de produto
- Documentação técnica (arquitectura)

**Time**:
- Org chart
- Bios de liderança
- Estrutura de equity (vesting, options)

## Pitch Deck

### Estrutura Ideal (12-15 slides)

**1. Cover**
- Nome da empresa
- Tagline (o que você faz em 1 linha)
- Seus dados de contato

**2. Problem**
- Problema que você resolve
- Quão doloroso e urgente é?
- Como é resolvido hoje (alternativas inadequadas)

**3. Solution**
- Como seu produto resolve o problema
- Demo rápida ou screenshots
- Por que sua abordagem é superior?

**4. Why Now**
- Por que agora é o momento certo?
- Mudanças de mercado, tecnologia, regulatória

**5. Market Size**
- TAM (Total Addressable Market)
- SAM (Serviceable Available Market)
- SOM (Serviceable Obtainable Market)
- Bottom-up (não só research reports)

**6. Product**
- Features principais
- Demo ou video
- Diferenciais técnicos

**7. Business Model**
- Como você ganha dinheiro?
- Pricing e packaging
- Unit economics (CAC, LTV)

**8. Traction**
- MRR, crescimento, clientes
- Retenção e expansão
- Milestones alcançados
- Logos de clientes (se houver grandes nomes)

**9. Go-to-Market**
- Como você adquire clientes?
- Canais de distribuição
- Estratégia de vendas
- Custo de aquisição

**10. Competition**
- Competitors e alternativas
- Positioning (por que você vence?)
- Magic quadrant / comparison matrix

**11. Team**
- Founders e key hires
- Por que vocês são as pessoas certas?
- Advisors relevantes

**12. Financials**
- Histórico de receita (se houver)
- Projeções 3-5 anos
- Key metrics dashboard

**13. The Ask**
- Quanto está levantando?
- Como vai usar o capital?
- Milestones que atingirá

**14. Appendix** (slides de backup)
- Detalhes técnicos
- Case studies de clientes
- Press e menções
- Awards e reconhecimentos

### Storytelling

**Narrativa forte**:
1. **Início**: Mundo com problema sério
2. **Chamado à ação**: Por que você decidiu resolver?
3. **Jornada**: O que descobriu construindo?
4. **Solução**: Como resolve de forma única?
5. **Futuro**: Visão de onde quer chegar

**Erros comuns**:
- Feature dump (listar features sem contexto)
- Números sem narrativa
- Muito texto (slides devem ser visuais)
- Não explicar por que VOCÊ especificamente vai vencer

### Adaptação por Estágio

**Pre-Seed**:
- Foco em problema e visão
- Time e por que vocês
- Pode ter menos tracção (tudo bem)

**Seed**:
- Foco em tracção inicial e PMF
- Métricas de validação
- Go-to-market que está funcionando

**Series A+**:
- Foco em métricas e crescimento
- Unit economics saudáveis
- Plano detalhado de escala

## Métricas para Apresentar

### Seed Stage

**Must-have**:
- MRR e crescimento mês a mês
- Número de clientes
- Revenue churn
- ACV (Average Contract Value)

**Nice-to-have**:
- CAC e LTV
- NRR
- Cohort analysis

### Series A+

**Must-have**:
- ARR e crescimento
- Net Revenue Retention
- CAC payback period
- LTV:CAC ratio
- Gross margin
- Sales efficiency

**Nice-to-have**:
- Rule of 40
- Magic Number
- Win rate e sales cycle
- Cohorts detalhados

## Processo de Due Diligence

### O Que Investidores Avaliam

**1. Produto** (2-3 semanas)
- Demo hands-on
- Arquitetura técnica (conversa com CTO)
- Roadmap e diferenciação
- Segurança e compliance

**2. Mercado** (1-2 semanas)
- TAM validation
- Competitive landscape
- Reference calls com clientes
- Reference calls com experts do setor

**3. Time** (ongoing)
- Background checks de founders
- Conversas 1-1 com liderança
- Dinâmica de time (co-founders se dão bem?)
- Referências de empregos anteriores

**4. Financeiro** (2-3 semanas)
- Audit de números apresentados
- Análise de unit economics
- Modelo financeiro (projeções razoáveis?)
- Legal e fiscal (dívidas, processos?)

**5. Legal** (1-2 semanas)
- Cap table clean?
- IP propriedade da empresa?
- Contratos de clientes/fornecedores ok?
- Nenhum red flag legal

### Red Flags para Investidores

**Time**:
- Co-founders brigando
- Turnover alto de funcionários
- Founder não full-time
- Ética questionável

**Produto**:
- Clientes não usam regularmente
- Feedback de clientes morno
- Muita customização (não é produto)
- Tech debt crítico

**Mercado**:
- TAM muito pequeno
- Competição entrincheirada impossível de vencer
- Timing errado (muito cedo ou muito tarde)

**Financeiro**:
- Churn alto (> 5% mensal em Seed)
- Unit economics ruins (LTV:CAC < 2)
- Burn descontrolado
- Projeções irrealistas

**Legal**:
- Cap table confuso
- Processos trabalhistas/cíveis sérios
- IP não pertence à empresa
- Pendências fiscais

## Term Sheet e Negociação

### Termos Principais

**Valuation**:
- **Pre-money**: Valor da empresa antes do investimento
- **Post-money**: Valor depois (pre-money + investimento)
- **Dilution**: % que você cede = Investimento / Post-money

**Exemplo**:
```
Levantando: R$3M
Pre-money valuation: R$12M
Post-money: R$15M
Dilution: R$3M / R$15M = 20%
```

**Tipo de Ação**:
- **Ações Ordinárias**: Voto + dividendos
- **Ações Preferenciais**: Preferência em liquidação + proteções

**Preferências de Liquidação**:
- **1x não-participating**: Investidor recebe investimento de volta primeiro, depois pro-rata
- **1x participating**: Investidor recebe investimento + pro-rata (melhor para investidor)
- **2x-3x**: Múltiplos do investimento (evite se possível)

**Exemplo** (exit por R$20M com investimento de R$3M e 20% equity):
- **1x não-participating**: Investidor escolhe R$3M ou 20% de R$20M (R$4M) → Recebe R$4M
- **1x participating**: Investidor recebe R$3M + 20% de R$17M → Recebe R$6.4M

**Anti-Dilution**:
- **Full ratchet**: Proteção total em down round (duro para founders)
- **Weighted average**: Proteção proporcional (mais justo)

**Vesting**:
- Founders têm vesting de 4 anos (típico: 1 ano cliff + 3 anos mensal)
- Se founder sai, empresa recompra ações não vested

**Drag-along e Tag-along**:
- **Drag-along**: Maioria pode forçar minoria a vender em M&A
- **Tag-along**: Minoria pode vender junto se maioria vende

**Board**:
- Composição do conselho (normalmente founders + investidores + independente)
- Frequência de reuniões

### O Que Negociar

**Mais importante** (negociar firmemente):
1. **Valuation**: Quanto você está cedendo
2. **Liquidation preference**: Evitar > 1x, evitar participating se possível
3. **Vesting de founders**: 4 anos com 1 ano cliff é padrão
4. **Board composition**: Manter controle ou pelo menos equilíbrio

**Menos importante** (aceitar termos de mercado):
1. **Anti-dilution**: Weighted average é justo
2. **Drag/Tag along**: Padrão de mercado
3. **Information rights**: Investidores merecem transparência
4. **Pro-rata rights**: Justo investidor poder manter %

### Múltiplos Term Sheets

Se você tem mais de um interessado:

1. **Não minta**: Seja transparente que está falando com múltiplos
2. **Crie senso de urgência**: "Estamos definindo nos próximos 10 dias"
3. **Não faça leilão explícito**: Queima pontes
4. **Escolha o melhor fit, não só maior valuation**: Smart money > dumb money

**Smart money vs. Dumb money**:
- **Smart**: Expertise no setor, network forte, mão na massa, respeitado
- **Dumb**: Só capital, não agrega, pode atrapalhar

## Alternativas a VC

### 1. Bootstrapping

**Prós**:
- Mantém controle total
- Não dilui equity
- Foco em rentabilidade desde cedo

**Contras**:
- Crescimento mais lento
- Menos recursos para investir
- Difícil competir com startups financiadas

**Quando faz sentido**:
- Mercado não requer blitzscaling
- Founders têm capital próprio ou receita rápida
- Quer construir lifestyle business (não unicórnio)

### 2. Venture Debt

**O que é**: Empréstimo para startups que já levantaram equity

**Prós**:
- Menos dilutivo que equity (juros ~1-2% ao mês)
- Estende runway sem novo fundraising
- Rápido (30-60 dias vs. 3-6 meses de VC)

**Contras**:
- Precisa pagar de volta (com juros)
- Covenants e warrants (opções de compra de ações)
- Só disponível após equity round

**Quando usar**:
- Bridge entre rounds
- Investir em crescimento sem diluir
- Já tem receita mas quer acelerar

**Provedores no Brasil**:
- Banco BV
- Vortx
- Cedro Capital

### 3. Revenue-Based Financing

**O que é**: Investimento pago de volta com % da receita mensal

**Prós**:
- Não dilui equity
- Pagamento flexível (baseado em receita)
- Aprovação rápida

**Contras**:
- Mais caro que VC no longo prazo (paga 1.5-2.5x)
- Só para startups com receita significativa

**Quando usar**:
- MRR > R$100k
- Crescimento estável
- Precisa de capital para marketing/vendas

**Provedores**:
- Pipe
- Clearco (ex-Clearbanc)

### 4. Aceleradoras

**O que é**: Programa de 3-6 meses + investimento pequeno (~R$200k)

**Prós**:
- Capital + mentoria + network
- Acelera aprendizado e tracção
- Brand (ser "aluno de YC/Endeavor")

**Contras**:
- Dilui equity (5-10%)
- Programa intenso (3-6 meses dedicação)
- Precisa se mudar (às vezes)

**Principais no Brasil**:
- **Y Combinator**: Melhor do mundo, ~$500k por ~7%
- **Endeavor Scale-Up**: Para startups já com tracção
- **ACE**: Aceleradora + seed investment
- **InovAtiva**: Governo federal, sem investimento

## Dicas Práticas

### Warm Intros

**Por que importa**: VCs recebem 100s de cold emails por semana, a maioria ignorada

**Como conseguir**:
1. **Portfólio do VC**: Peça intro via founder que eles investiram
2. **Mentores e advisors**: Conecte-se com pessoas que conhecem VCs
3. **Eventos e conferências**: Networking presencial
4. **LinkedIn**: Conexões de 2º grau

**Template de pedido**:
```
Oi [Pessoa],

Estamos levantando Seed round para a [Empresa], que faz [problema/solução em 1 linha].

Você conhece alguém na [VC X]? Eles investiram em [empresa similar] e acho que faria sentido
para o portfólio deles.

Se você puder fazer uma intro, ficaria muito grato! Anexei nosso deck para contexto.

Abs,
[Nome]
```

### Follow-Ups

**Após pitch inicial**:
- Envie email no mesmo dia agradecendo
- Anexe deck (ou link para data room)
- Reitere 1-2 pontos-chave da conversa
- Proponha próximos passos

**Se investidor sumiu**:
- Follow-up educado após 1 semana
- Compartilhe update de tracção (novo cliente, feature, métrica)
- Não seja insistente demais (2-3 follow-ups max)

### Mantendo Momentum

**Objetivo**: Fechar em 2-3 meses (não 6-12)

**Táticas**:
- Comprimir agenda (50 pitches em 4 semanas, não espalhado)
- Comunicar urgência (outras conversas avançadas)
- Atualizar investidores semanalmente (mostra traction contínua)
- Ter data de "decisão" (vamos fechar em [data])

### Erros Comuns

1. **Levantar muito cedo**: Sem tracção, valuation ruim + dilui demais
2. **Levantar muito tarde**: Ficou sem dinheiro, negocia em posição fraca
3. **Pitch genérico**: Mesma conversa para todos VCs (personalize!)
4. **Não saber números**: Investidor pergunta CAC e você não sabe
5. **Overselling**: Prometendo mais do que pode entregar
6. **Ser defensivo**: Ficar na defensiva com perguntas difíceis
7. **Não ter senso de urgência**: Processo arrasta por 6+ meses

## Recursos

**Blogs e Guides**:
- Both Sides of the Table (Mark Suster)
- A16Z blog
- Venture Hacks / AngelList guides
- Fred Wilson (AVC)

**Templates**:
- Y Combinator template de pitch deck
- Sequoia pitch deck template
- DocSend fundraising research

**Brasileiros**:
- Distrito Dataminer (dados de fundraising BR)
- Abstartups
- Baguete (tech news)
