# Go-to-Market e Estratégias de Vendas B2B SaaS

## Modelos de GTM para B2B SaaS

### 1. Self-Service / Product-Led Growth (PLG)

**Características**:
- Cliente pode se cadastrar e começar a usar sem contato com vendas
- Onboarding automático e intuitivo
- Monetização por cartão de crédito
- Time de vendas toca apenas em expansão (land-and-expand)

**Quando funciona**:
- ACV < $10k/ano
- Produto simples de entender e usar
- Usuário final tem autoridade de compra (bottom-up adoption)
- Time-to-value muito rápido (< 1 dia)

**Exemplos**: Notion, Figma, Slack, Calendly

**Desafios no Brasil**:
- Empresas acostumadas com vendedor e negociação
- Menos adoção de cartão de crédito corporativo
- Cultura de solicitar desconto e proposta formal

### 2. Sales-Led / Inside Sales

**Características**:
- Lead entra no funil e é contatado por vendedor
- Vendedor faz demo, qualifica, propõe e fecha
- Vendas remotas (calls, demos via Zoom)
- Ciclo de 30-90 dias

**Quando funciona**:
- ACV entre $5k-50k/ano
- Produto requer explicação mas não é ultra complexo
- Decisor é gerente ou diretor
- Mercado mid-market ou SMB sofisticado

**Exemplos**: HubSpot, Pipedrive, RD Station, Resultados Digitais

**Estrutura de time**:
- SDR (Sales Development Rep): Qualificação e agendamento
- AE (Account Executive): Condução e fechamento
- CS (Customer Success): Onboarding e renovação

### 3. Field Sales / Enterprise Sales

**Características**:
- Vendedor visita cliente presencialmente (ou várias calls)
- Múltiplos stakeholders envolvidos
- POC/Pilot é comum
- Ciclo de 3-12+ meses
- Negociação e contratos complexos

**Quando funciona**:
- ACV > $50k/ano (idealmente > $100k)
- Produto complexo, requer customização ou integração
- Decisor é C-level (CEO, CFO, CTO)
- Enterprise e grandes corporações

**Exemplos**: Salesforce, Workday, SAP, Oracle

**Estrutura de time**:
- SDR/BDR: Prospecção e agendamento
- AE: Condução do ciclo e fechamento
- SE (Sales Engineer): Apoio técnico e demos
- CS/AM: Onboarding, adoção e expansão

### 4. Hybrid / Modelo Misto

**Características**:
- Começa self-service ou low-touch
- Vendas entra para expansão (upsell)
- Diferentes motions para diferentes segmentos

**Quando funciona**:
- Serve múltiplos segmentos (SMB, Mid-Market, Enterprise)
- Land-and-expand strategy
- Produto simples para começar, complexo para escalar

**Exemplos**: Zoom, Dropbox, Atlassian

## Processo de Vendas B2B SaaS

### Estágio 1: Prospecção

**Objetivo**: Gerar lista de potenciais clientes (ICP)

**Atividades**:
- **Inbound**: Marketing gera leads (conteúdo, ads, SEO)
- **Outbound**: SDRs fazem cold email e cold call
- **Partnerships**: Parceiros indicam leads
- **Eventos**: Conferências, webinars, meetups

**Qualificação inicial (BANT)**:
- **B**udget: Cliente tem orçamento para comprar?
- **A**uthority: Pessoa é decisora ou influenciadora?
- **N**eed: Problema é urgente e doloroso?
- **T**imeline: Quando precisa resolver?

### Estágio 2: Discovery / Qualificação

**Objetivo**: Entender profundamente problema e contexto

**Framework MEDDIC** (para vendas complexas):
- **M**etrics: Que métricas o cliente quer melhorar?
- **E**conomic Buyer: Quem assina o contrato?
- **D**ecision Criteria: Como vão decidir?
- **D**ecision Process: Qual o processo de compra?
- **I**dentify Pain: Qual a dor mais crítica?
- **C**hampion: Tem alguém interno vendendo por você?

**Perguntas-chave**:
- "Como vocês fazem isso hoje?"
- "Qual o custo de não resolver esse problema?"
- "Por que olhar para isso agora?"
- "Quem mais precisa estar envolvido na decisão?"
- "Qual seu orçamento e timeline?"

### Estágio 3: Demo / Apresentação

**Estrutura de uma boa demo**:

1. **Contexto** (5 min)
   - Recapitular problema entendido
   - Confirmar agenda e expectativas
   - "Se resolvermos X, Y e Z, você avança?"

2. **Discovery adicional** (10 min)
   - Aprofundar entendimento
   - Fazer cliente falar mais que você

3. **Demo focada na dor** (20 min)
   - Mostrar APENAS features que resolvem problema deles
   - Usar dados/contexto do cliente se possível
   - Demonstrar ROI tangível

4. **Próximos passos** (5 min)
   - Agendar follow-up específico
   - Definir próximo milestone
   - Confirmar interesse e objeções

**Erros comuns**:
- Feature dump (mostrar tudo)
- Falar demais, ouvir de menos
- Não personalizar demo para contexto do cliente
- Não definir next steps claros

### Estágio 4: Proposta / Negociação

**Elementos de uma proposta B2B SaaS**:

1. **Resumo executivo**
   - Problema identificado
   - Solução proposta
   - ROI esperado

2. **Escopo**
   - Módulos/features incluídos
   - Número de usuários
   - Volume de dados/transações
   - Integrações

3. **Investimento**
   - Plano mensal/anual
   - Setup fee (se houver)
   - Opções de pagamento
   - Descontos (anual, multi-year)

4. **Implementação**
   - Timeline de onboarding
   - Recursos necessários (cliente e vendor)
   - Treinamento incluído

5. **Termos**
   - Duração do contrato
   - Renovação automática
   - Política de cancelamento
   - SLA e suporte

**Negociação**:
- Preço não é a única variável (prazo, escopo, termos)
- Evite desconto > 20% sem contrapartida (case study, referência, contrato mais longo)
- Seja firme mas flexível
- Crie urgência (oferta válida até X)

### Estágio 5: Fechamento

**Como fechar**:
- **Trial close**: "Faz sentido até aqui?"
- **Assumptive close**: "Quando podemos começar o onboarding?"
- **Direct close**: "Estamos prontos para avançar?"

**Lidando com objeções**:

**"Muito caro"**
- Reframe para ROI: "Comparado com o custo de [problema atual]?"
- Mostrar payback: "Você economiza X em Y meses"
- Oferecer plano menor: "Podemos começar com escopo reduzido?"

**"Preciso conversar com [outro stakeholder]"**
- "Ótimo, podemos fazer uma call com ele agora?"
- "Quais são as preocupações dele especificamente?"
- "Você está confortável em ser nosso sponsor interno?"

**"Vou pensar e te retorno"**
- "Há algo específico que está te deixando inseguro?"
- "O que seria necessário para você decidir hoje?"
- "Posso sugerir: vamos agendar um follow-up para [data] e você me traz suas dúvidas?"

**"Já usamos [competitor]"**
- "O que está faltando na solução atual?"
- "Você está satisfeito ou aberto a melhorar?"
- "Posso mostrar como somos diferentes em [X, Y, Z]?"

### Estágio 6: Onboarding / Implementação

**Objetivo**: Cliente ativado e vendo valor em < 30 dias

**Processo**:
1. **Kickoff call**: Alinhar expectativas e timeline
2. **Setup técnico**: Integrações, importação de dados, configurações
3. **Treinamento**: Admins e usuários finais
4. **First wins**: Cliente alcança quick wins mensuráveis
5. **Adoption**: Uso regular e expansão para mais usuários/use cases

**Métricas de onboarding**:
- Time-to-value (primeiro valor alcançado)
- Activation rate (% de usuários ativos)
- Time-to-activation (quanto tempo até ativar)

## Canais de Aquisição

### Inbound Marketing

**Conteúdo**:
- Blog posts otimizados para SEO
- Whitepapers e eBooks
- Webinars e workshops
- Case studies e depoimentos

**Mídia paga**:
- Google Ads (search e display)
- LinkedIn Ads (B2B mais efetivo)
- Facebook/Instagram (dependendo de ICP)
- Retargeting

**Benchmarks de conversão**:
- Visitante → Lead: 1-5%
- Lead → MQL: 20-40%
- MQL → SQL: 30-50%
- SQL → Oportunidade: 50-70%
- Oportunidade → Cliente: 20-30%

### Outbound Sales

**Cold Email**:
- Personalização em escala (pesquisar empresa, mencionar contexto)
- Sequências de 5-7 emails ao longo de 2-3 semanas
- Subject lines diretos e curiosos
- Calls-to-action simples (agendar 15min)

**Exemplo de sequência**:
1. Email 1: Problema + Curiosidade
2. Email 2 (3 dias): Social proof + Case study
3. Email 3 (3 dias): Breakup email ("última tentativa")
4. Email 4 (1 semana): Ângulo diferente
5. Email 5 (2 semanas): Conteúdo útil sem pedir nada

**Cold Call**:
- Script flexível (não robótico)
- Foco em agendar, não vender no telefone
- Lidar com gatekeepers (secretárias, recepcionistas)

**LinkedIn Outreach**:
- Conectar com mensagem personalizada
- Engajar com conteúdo antes de pedir call
- InMail para decisores importantes

### Partnerships

**Tipos de parcerias**:
- **Referral partners**: Indicam clientes por comissão
- **Integration partners**: Integrações técnicas que geram co-marketing
- **Resellers**: Vendem seu produto como parte de solução maior
- **Agency partners**: Agências implementam e recomendam seu produto

**Como estruturar**:
- Programa de parceiros com tiers (bronze, prata, ouro)
- Comissionamento claro (% de MRR ou flat fee)
- Portal do parceiro com materiais e leads
- Co-marketing (webinars, conteúdo, eventos)

### Eventos e Comunidades

**Eventos**:
- Conferências do setor (patrocínio, palestras, booth)
- Meetups e eventos locais
- Webinars próprios
- Road shows (visitar clientes em várias cidades)

**Comunidades**:
- Comunidade própria (Slack, Discord, Circle)
- Participação ativa em comunidades de nicho
- User groups de clientes
- Open source / Developer relations (se aplicável)

## Estratégias Específicas para Brasil

### Desafios Únicos

1. **Cultura de negociação**
   - Cliente espera negociar preço
   - Prepare-se com room para desconto
   - Amarre desconto a contrapartida (case study, testimonal, contrato anual)

2. **Decisão por comitê**
   - Mesmo em empresas pequenas, decisão envolve múltiplas pessoas
   - Identifique champion interno
   - Prepare materiais para champion vender internamente

3. **Burocracia de procurement**
   - Empresas médias/grandes têm processos lentos
   - Antecipe documentação (contrato, CNPJ, certidões)
   - Considere parceiros de revenda para facilitar

4. **Preferência por contato humano**
   - Brasileiro prefere ligar/enviar WhatsApp que preencher form
   - Tenha canal de WhatsApp Business
   - Responda rápido (expectativa de resposta imediata)

5. **Nota fiscal e impostos**
   - Ter CNPJ facilita muito
   - Empresas grandes exigem nota fiscal
   - Considere ter holding de serviços se for PJ

### Táticas que Funcionam no Brasil

**Relacionamento**:
- Brasileiro compra de quem confia
- Invista tempo em construir relação antes de vender
- Ligue, não apenas email (brasileiro atende telefone)

**Social proof local**:
- Case studies de empresas brasileiras conhecidas
- Depoimentos em português
- Logos de clientes nacionais no site

**Pricing em Reais**:
- Se possível, precifique em BRL
- Se em USD, explique claramente conversão e variação cambial
- Ofereça opção de hedge cambial (preço fixo em BRL)

**Flexibilidade de pagamento**:
- Boleto bancário (ainda muito usado)
- PIX
- Cartão de crédito
- NET30/60 para empresas estabelecidas

## Estrutura de Time de Vendas por Estágio

### Pre-Seed / Seed (0-$1M ARR)

**Time**:
- Founders vendem (founder-led sales é crítico no início)
- Talvez 1 SDR/BDR para prospecção

**Por que founders vendem**:
- Aprendem sobre cliente e mercado
- Definem ICP e proposta de valor
- Criam playbook que será replicado

### Series A ($1M-5M ARR)

**Time**:
- 1-2 AEs (Account Executives)
- 1-2 SDRs (Sales Development Reps)
- 1 Customer Success Manager
- Head of Sales (pode ser um dos AEs sênior)

**Foco**:
- Documentar processo de vendas
- Criar playbooks e templates
- Contratar e treinar primeiros vendedores

### Series B+ ($5M+ ARR)

**Time**:
- Múltiplos AEs (segmentados por vertical, geografia, ou tamanho)
- Time de SDRs (1 SDR para cada 2-3 AEs)
- Sales Engineers (para demos técnicas)
- Customer Success (1 CSM para cada $1-2M ARR)
- Sales Operations (reporting, CRM, ferramentas)
- VP of Sales / CRO (Chief Revenue Officer)

**Foco**:
- Escalar time com hiring e treinamento
- Otimizar eficiência (CAC, cycle time, win rate)
- Construir previsibilidade (forecasting)

## Ferramentas Essenciais

### CRM
- **HubSpot**: Gratuito para começar, bom para SMB
- **Pipedrive**: Popular no Brasil, interface simples
- **Salesforce**: Enterprise, mais robusto e caro

### Prospecção/Outbound
- **Apollo.io**: Banco de dados de leads + outreach
- **Lemlist**: Cold email sequences
- **LinkedIn Sales Navigator**: Prospecção no LinkedIn

### Demos e Calls
- **Zoom**: Chamadas de vídeo
- **Loom**: Gravar demos assíncronas
- **Calendly**: Agendamento automático

### Propostas e Contratos
- **PandaDoc**: Propostas e assinaturas eletrônicas
- **DocuSign**: Assinatura eletrônica
- **Google Docs/Slides**: Propostas simples

### Análise e Inteligência
- **Gong / Chorus**: Gravação e análise de calls
- **Metabase / Looker**: Dashboards de vendas

## Playbooks de Vendas

### Cold Email Template (Prospecting)

**Subject**: [Nome da empresa] + [Problema específico]

Oi [Nome],

Vi que a [Empresa] está [contexto específico - crescendo, lançou produto X, contratando, etc].

Trabalho com [setor/função similar] e percebi que muitos enfrentam [problema específico] quando [situação].

[Cliente similar] estava com o mesmo desafio e conseguiu [resultado concreto] depois que [solução breve].

Faz sentido uma conversa rápida de 15min para eu entender se faz sentido para vocês também?

[Seu nome]

---

**Por que funciona**:
- Personalizado (demonstra pesquisa)
- Focado no problema deles, não em você
- Social proof relevante
- CTA simples e de baixo compromisso

### Discovery Call Script

**Abertura** (2 min)
- "Obrigado por aceitar a call. Antes de começar, queria confirmar: temos 30 minutos, certo?"
- "Meu plano é: entender melhor [problema/contexto], te mostrar brevemente como ajudamos empresas similares, e ver se faz sentido continuarmos a conversa. Faz sentido?"

**Discovery** (15-20 min)
- "Me conta um pouco sobre [contexto da empresa/time/desafio]"
- "Como vocês fazem [processo X] hoje?"
- "O que funciona bem? O que poderia ser melhor?"
- "Se você pudesse mudar uma coisa, o que seria?"
- "Qual o impacto de não resolver isso? (tempo perdido, receita perdida, etc)"
- "Por que olhar para isso agora? O que mudou?"

**Apresentação breve** (5 min)
- "Baseado no que você falou, faz sentido eu te mostrar brevemente como resolvemos isso para [cliente similar]?"
- Mostrar 2-3 features que atacam dores específicas mencionadas
- Quantificar resultado: "Cliente X economizou Y horas/reais por mês"

**Next steps** (3 min)
- "Faz sentido para o contexto de vocês?"
- "Quem mais deveria estar envolvido nessa conversa?"
- "Qual o processo de decisão de vocês para algo assim?"
- "Próximo passo: [agendar demo completa / trial / proposta]?"

## Métricas de Vendas

### Métricas de Atividade (Leading Indicators)

- Emails enviados por SDR por dia (meta: 50-100)
- Calls feitos por SDR por dia (meta: 30-50)
- Meetings agendados por SDR por semana (meta: 5-10)
- Demos realizadas por AE por semana (meta: 5-10)

### Métricas de Conversão

- Lead → MQL: 20-40%
- MQL → SQL: 30-50%
- SQL → Opp: 50-70%
- Opp → Cliente: 20-30%
- Overall Lead → Cliente: 1-3%

### Métricas de Eficiência

- Quota attainment: % de AEs que batem meta (meta: >70%)
- Sales cycle length: Dias do primeiro contato ao fechamento
- Win rate: % de opps que fecham (meta: >20%)
- Average Contract Value: $ médio por cliente fechado
- Ramp time: Tempo para AE novo atingir produtividade total (meta: 3-6 meses)

## Recursos

**Livros**:
- Predictable Revenue - Aaron Ross
- The Sales Acceleration Formula - Mark Roberge
- SPIN Selling - Neil Rackham
- The Challenger Sale - Matthew Dixon

**Podcasts**:
- SaaStr (Harry Stebbings)
- Sales Hacker
- 30 Minutes to President's Club

**Blogs**:
- Close.com blog
- Sales Hacker
- Gong Labs
