# OKRs e Planejamento Estratégico

## O Que São OKRs

**OKR = Objectives and Key Results**

**Objective**: O QUE você quer alcançar (qualitativo, inspirador)
**Key Results**: COMO você vai medir sucesso (quantitativo, específico)

**Exemplo**:
- **Objective**: Dominar o mercado de CRM para startups brasileiras
- **Key Results**:
  - Crescer de R$200k para R$500k MRR
  - Reduzir churn de 3% para 1.5% mensal
  - Alcançar NPS de 50+

## Por Que Usar OKRs

### Benefícios

1. **Alinhamento**: Todo mundo sabe as prioridades da empresa
2. **Foco**: Dizer não para o que não importa
3. **Transparência**: OKRs são públicos dentro da empresa
4. **Ambição**: Metas aspiracionais (não apenas incrementais)
5. **Medição**: Progress é objetivo e mensurável

### Quando Adotar

- **Pre-Seed/Seed** (0-20 pessoas): OKRs informais, revisão mensal
- **Series A** (20-50 pessoas): OKRs formalizados, revisão trimestral
- **Series B+** (50+ pessoas): OKRs em cascata (empresa → time → pessoa)

## Framework de OKRs

### Características de Bons Objectives

**Qualitativo e inspirador**:
- ✅ "Tornar o onboarding inesquecível"
- ❌ "Aumentar activation rate em 10%"

**Acionável pelo time**:
- ✅ "Dominar vendas enterprise"
- ❌ "Ser reconhecido como líder de mercado" (muito vago)

**Temporal** (associado a ciclo de OKR):
- ✅ "Construir motor de crescimento orgânico este trimestre"
- ❌ "Ser a melhor empresa do mundo" (sem prazo)

**Ambicioso mas alcançável**:
- ✅ Meta de crescer 3x MRR (difícil mas possível)
- ❌ Meta de crescer 100x MRR (implausível)

### Características de Bons Key Results

**Mensuráveis e específicos**:
- ✅ "Crescer MRR de R$100k para R$300k"
- ❌ "Melhorar receita significativamente"

**Desafiadores** (70% de confiança de alcançar):
- Não fáceis demais (senão não são ambiciosos)
- Não impossíveis (senão desmotiva)

**Orientados a resultado, não atividade**:
- ✅ "Reduzir churn de 3% para 1.5%"
- ❌ "Fazer 20 check-ins com clientes por mês" (atividade)

**3-5 Key Results por Objective**:
- Menos de 3: Falta cobertura
- Mais de 5: Perda de foco

### Estrutura de OKRs por Nível

**Company-level** (O que importa para empresa?)
- CEO define com liderança
- 3-5 objectives
- Revisão trimestral
- Público para toda empresa

**Team-level** (Como meu time contribui?)
- Time define alinhado aos OKRs da empresa
- Cada time tem 2-4 objectives
- Revisão trimestral

**Individual** (O que EU vou fazer?)
- Indivíduo define com manager
- 2-3 objectives
- Revisão mensal ou trimestral
- Mais granular e específico

## OKRs por Estágio da Startup

### Pre-Seed / Seed (0-$500k ARR)

**Foco**: Validar Product-Market Fit

**Exemplo de OKRs**:

**O1: Validar PMF com primeiros clientes**
- KR1: Conseguir 20 clientes pagantes
- KR2: Alcançar R$50k MRR
- KR3: Revenue retention > 85% (6 meses)

**O2: Construir produto que clientes amam**
- KR1: NPS > 40
- KR2: 80% dos clientes usam produto semanalmente
- KR3: 3+ features principais em produção

**O3: Definir e documentar Go-to-Market**
- KR1: Identificar ICP claramente (persona, tamanho, vertical)
- KR2: Fechar 5 deals com ciclo de vendas < 60 dias
- KR3: CAC payback < 12 meses

### Series A (R$500k - R$2M ARR)

**Foco**: Escalar vendas e produto de forma previsível

**Exemplo de OKRs**:

**O1: Acelerar crescimento de receita**
- KR1: Crescer de R$500k para R$1.5M MRR
- KR2: Adicionar 100+ novos clientes
- KR3: Expansion MRR = 20% de New MRR

**O2: Construir máquina de vendas escalável**
- KR1: Contratar e onboard 3 AEs produtivos
- KR2: Pipeline = 4x do quarterly target
- KR3: Win rate > 25%

**O3: Alcançar excelência em retenção**
- KR1: Churn < 2% mensal
- KR2: NRR > 105%
- KR3: 90% de clientes renovam

### Series B+ (R$2M+ ARR)

**Foco**: Eficiência operacional e domínio de mercado

**Exemplo de OKRs**:

**O1: Alcançar crescimento eficiente**
- KR1: R$2M → R$5M MRR
- KR2: Rule of 40 > 40%
- KR3: CAC payback < 9 meses

**O2: Dominar segmento enterprise**
- KR1: Fechar 10 deals > R$100k ACV
- KR2: Construir pipeline enterprise de R$5M
- KR3: Lançar features enterprise (SSO, SAML, etc.)

**O3: Construir organização de classe mundial**
- KR1: eNPS (employee NPS) > 40
- KR2: Contratar 20 pessoas em roles críticos
- KR3: Diversity: 40% mulheres, 30% pessoas negras

## Ciclo de OKRs

### Trimestral (Mais comum para startups)

**Timeline**:

**Semana -2 (antes do quarter)**:
- Revisão de OKRs do quarter passado
- Liderança propõe OKRs do próximo quarter
- Feedback e iteração

**Semana -1**:
- OKRs da empresa finalizados e comunicados
- Times definem OKRs alinhados

**Semana 1 (início do quarter)**:
- Kickoff de OKRs: Comunicação para toda empresa
- Cada time apresenta seus OKRs
- Indivíduos definem OKRs pessoais

**Durante o quarter (Semana 4, 8, 12)**:
- Check-ins mensais: Progresso e bloqueios
- Ajustes táticos (não mudar OKRs, mas como atingi-los)

**Última semana do quarter**:
- Scoring de OKRs (0-1.0)
- Retrospectiva: O que funcionou? O que não?
- Preparação para próximo quarter

### Mensal (Para early stage ou times específicos)

**Quando usar**: Pre-seed/Seed, times pequenos, alta incerteza

**Diferença**: Ciclo mais rápido permite iterar mais rápido

### Anual (Para visão estratégica)

**OKRs anuais** = Direção estratégica
**OKRs trimestrais** = Marcos táticos para chegar lá

**Exemplo**:

**Anual**: Alcançar Series A ($1M ARR)
**Q1**: Validar PMF (20 clientes, R$50k MRR)
**Q2**: Escala inicial (60 clientes, R$200k MRR)
**Q3**: Crescimento acelerado (150 clientes, R$500k MRR)
**Q4**: Preparar para Series A (250 clientes, R$1M MRR)

## Definindo OKRs: Processo

### Passo 1: Revisar Contexto

**Perguntas para refletir**:
- Onde estamos hoje? (Métricas atuais)
- O que aprendemos no último quarter?
- Quais são os principais bloqueios ao crescimento?
- O que mudou no mercado/competição?

### Passo 2: Definir Prioridades Estratégicas

**Ferramenta: Priority Matrix**

|  | **Alto Impacto** | **Baixo Impacto** |
|---|---|---|
| **Alta Urgência** | Faz agora (OKRs aqui) | Delega ou automatiza |
| **Baixa Urgência** | Planeja (pode ser próximo quarter) | Elimina |

**Identificar top 3-5 prioridades** para o quarter

### Passo 3: Traduzir Prioridades em OKRs

Para cada prioridade:
1. Escrever Objective (qualitativo)
2. Definir 3-5 Key Results (quantitativos)
3. Validar: Se atingirmos os KRs, o Objective foi alcançado?

### Passo 4: Alinhar com Time

**Top-down + Bottom-up**:
- Liderança propõe OKRs da empresa (top-down)
- Times contribuem com input e definem OKRs próprios (bottom-up)
- Iteração até alinhamento

**Reunião de alinhamento**:
- Apresentar proposta de OKRs
- Discussão: Ambiciosos o suficiente? Mensuráveis?
- Comprometimento: Time está comprado na ideia?

### Passo 5: Comunicar Amplamente

**All-hands/Town hall**:
- CEO apresenta OKRs da empresa
- Heads de time apresentam OKRs de seus times
- Q&A

**Documentação**:
- OKRs publicados em local acessível (Notion, Confluence, etc.)
- Contexto: POR QUE esses OKRs? Por que não outros?

## Acompanhamento e Scoring

### Check-ins Regulares

**Mensal** (recomendado):
- Status de cada Key Result (on-track, at-risk, off-track)
- Bloqueios e como desbloquear
- Pedidos de ajuda

**Formato de check-in**:
```
Objective: [Nome]

KR1: [Descrição]
- Target: X → Y
- Atual: X → Z (70% do caminho)
- Status: 🟢 On-track
- Bloqueios: Nenhum

KR2: [Descrição]
- Target: A → B
- Atual: A → C (40% do caminho)
- Status: 🟡 At-risk
- Bloqueios: Precisa contratar mais 1 pessoa
- Plano: Acelerando hiring
```

### Scoring no Final do Quarter

**Escala de 0.0 a 1.0**:
- **0.0 - 0.3**: Pouco ou nenhum progresso
- **0.4 - 0.6**: Progresso, mas abaixo da expectativa
- **0.7 - 0.9**: Objetivo substancialmente alcançado (ideal)
- **1.0**: Completamente alcançado (talvez não ambicioso o suficiente?)

**Exemplo de scoring**:

**O1: Acelerar crescimento de receita** (Score: 0.75)
- KR1: Crescer R$500k → R$1.5M MRR (**Atingido: R$1.3M**) → Score: 0.8
- KR2: Adicionar 100+ clientes (**Atingido: 85**) → Score: 0.85
- KR3: Expansion MRR = 20% de New (**Atingido: 15%**) → Score: 0.6

**O2: Construir máquina de vendas** (Score: 0.6)
- KR1: Contratar 3 AEs (**Atingido: 2**) → Score: 0.67
- KR2: Pipeline = 4x target (**Atingido: 3x**) → Score: 0.75
- KR3: Win rate > 25% (**Atingido: 20%**) → Score: 0.4

### Retrospectiva

**Perguntas para discutir**:
- O que deu certo? Por quê?
- O que não deu certo? Por quê?
- OKRs foram bem escolhidos? Ambiciosos? Mensuráveis?
- O que vamos fazer diferente no próximo quarter?
- Há aprendizados que mudam nossa estratégia?

## Erros Comuns em OKRs

### 1. Confundir OKRs com Tarefas

**Errado**:
- O: Melhorar o produto
- KR: Lançar feature X, Y, Z

**Certo**:
- O: Produto se torna indispensável para clientes
- KR1: NPS > 50
- KR2: 80% de clientes usam diariamente
- KR3: Churn < 2%

### 2. Key Results Não São Mensuráveis

**Errado**:
- KR: Melhorar experiência do cliente

**Certo**:
- KR: Aumentar CSAT de 3.5 para 4.5 (escala 1-5)

### 3. Muitos Objectives (Falta de Foco)

**Errado**: 10 objectives para o quarter

**Certo**: 3-5 objectives (mais que isso = sem foco)

### 4. Sandbagging (Metas Fáceis Demais)

**Problema**: Time define metas que sabe que vai bater facilmente

**Solução**:
- OKRs devem ser ambiciosos (70% de confiança)
- Scoring 1.0 consistente = precisa de mais ambição

### 5. OKRs Secretos (Falta de Transparência)

**Problema**: OKRs não são compartilhados

**Solução**:
- OKRs devem ser públicos dentro da empresa
- Todos sabem no que todos estão trabalhando

### 6. "Set and Forget"

**Problema**: Definir OKRs e só olhar no final do quarter

**Solução**:
- Check-ins mensais obrigatórios
- Cultura de falar sobre OKRs em 1-1s e reuniões

### 7. Não Conectar OKRs com Execução

**Problema**: OKRs existem em PowerPoint, mas dia-a-dia não alinha

**Solução**:
- Sprint planning e roadmap baseados em OKRs
- Toda iniciativa deve conectar a um KR

## OKRs vs. Outras Frameworks

### OKRs vs. KPIs

**KPIs** (Key Performance Indicators):
- Métricas de saúde do negócio (MRR, Churn, etc.)
- Sempre monitoradas, não mudam trimestre a trimestre
- "Business as usual"

**OKRs**:
- Metas aspiracionais para período específico
- Mudam a cada quarter
- "O que queremos melhorar este quarter?"

**Relação**: OKRs definem metas sobre KPIs
- KPI: MRR (sempre monitorado)
- OKR: Crescer MRR de X para Y este quarter

### OKRs vs. SMART Goals

**SMART** (Specific, Measurable, Achievable, Relevant, Time-bound):
- Mais conservador (Achievable)
- Usado para metas individuais, avaliação de performance

**OKRs**:
- Mais ambicioso (70% confiança, não 100%)
- Para alinhamento organizacional, não avaliação

**Diferença crítica**: OKRs não devem ser tied to compensation (senão sandbagging)

### OKRs vs. North Star Metric

**North Star**:
- UMA métrica que melhor representa valor entregue
- Long-term, não muda frequentemente
- Ex: Usuários ativos semanais, MRR, transações processadas

**OKRs**:
- Múltiplos objetivos de curto prazo
- Muda trimestralmente

**Relação**: North Star pode ser um Key Result recorrente em vários quarters

## Templates de OKRs

### Template: Company OKRs (Seed Stage)

**Q[X] 2024 - [Nome da empresa]**

**O1: [Objetivo sobre crescimento]**
- KR1: Crescer MRR de R$[X] para R$[Y]
- KR2: Adicionar [N] novos clientes
- KR3: [Métrica de eficiência: CAC, payback, etc.]

**O2: [Objetivo sobre produto/PMF]**
- KR1: [Métrica de retenção: churn, NRR]
- KR2: [Métrica de engajamento: DAU/MAU, feature adoption]
- KR3: [Métrica de satisfação: NPS, CSAT]

**O3: [Objetivo sobre time/operações]**
- KR1: [Hiring: contratar N pessoas em roles X]
- KR2: [Cultura: eNPS, retention]
- KR3: [Processo: implementar X, documentar Y]

### Template: Sales Team OKRs

**O1: Escalar pipeline de forma previsível**
- KR1: Gerar R$[X] em pipeline (4x do target)
- KR2: Conversion rate MQL → SQL > [X]%
- KR3: Cycle time médio < [X] dias

**O2: Melhorar eficiência de fechamento**
- KR1: Win rate > [X]%
- KR2: ACV médio > R$[X]
- KR3: Cada AE fecha R$[X] por mês

**O3: Construir capacidade do time**
- KR1: Contratar e onboard [N] AEs
- KR2: Ramp time de novos AEs < [X] meses
- KR3: Playbooks documentados para cada etapa do funil

### Template: Product Team OKRs

**O1: Lançar features que desbloqueiam crescimento**
- KR1: Lançar feature [X] com adoption de [Y]% em 30 dias
- KR2: Feature [Z] gera R$[X] em expansion MRR
- KR3: Reduzir bugs críticos de [X] para [Y]

**O2: Melhorar experiência do usuário**
- KR1: Time-to-value < [X] dias
- KR2: Activation rate > [X]%
- KR3: CSAT de onboarding > [X]/5

**O3: Construir fundação técnica**
- KR1: Uptime > 99.9%
- KR2: API response time < [X]ms (p95)
- KR3: Tech debt sprint: [X] items resolvidos

## Planejamento Estratégico de Longo Prazo

### Horizonte de Planejamento

**1 ano** (Anual planning):
- Onde queremos estar em 12 meses?
- Métricas principais (ARR, clientes, team size)
- Investimentos grandes (fundraising, expansão, novos produtos)

**3 anos** (Estratégia de médio prazo):
- Visão de mercado e posicionamento
- Domínio de qual segmento/vertical?
- Expansão internacional?

**5-10 anos** (Visão de longo prazo):
- "Onde queremos chegar?" (IPO, M&A, líder de mercado)
- Impacto que queremos ter no mundo

### Framework: Planejamento Anual

**Processo** (Inicia 2-3 meses antes do ano novo):

**1. Revisar ano passado**
- O que funcionou? O que não?
- Métricas: MRR, clientes, churn, CAC, etc.
- Marcos alcançados ou não

**2. Analisar mercado e competição**
- Mudanças no mercado?
- Competidores novos ou movimentos grandes?
- Oportunidades ou ameaças?

**3. Definir metas anuais**
- ARR target
- Número de clientes
- Team size e headcount budget
- Fundraising (se aplicável)

**4. Alocar recursos**
- Budget por departamento (Sales, Marketing, Produto, Ops)
- Headcount plan (contratar quando e quem)
- Investimentos (infra, ferramentas, escritório)

**5. Quebrar em quarters**
- Q1, Q2, Q3, Q4: Marcos esperados
- OKRs de cada quarter alinhados ao anual

**6. Comunicar plano**
- All-hands com liderança
- Documento escrito acessível
- Q&A e feedback

## Recursos e Ferramentas

**Livros**:
- Measure What Matters - John Doerr
- Radical Focus - Christina Wodtke
- High Output Management - Andy Grove

**Ferramentas de OKR**:
- Notion (templates gratuitos)
- Google Sheets (simples e funcional)
- Ally, Lattice, 15Five (softwares pagos de OKR)
- Asana, Monday (project management com OKRs)

**Templates**:
- [Google: OKR Template](https://www.whatmatters.com/resources/google-okr-playbook/)
- [Notion: OKR Template](https://www.notion.so/templates/okr-template)
- [Weekdone OKR Examples](https://weekdone.com/okr-examples)
