# Growth Hacking Frameworks para SaaS

## AARRR (Pirate Metrics) - Framework de Dave McClure

Framework fundamental para medir e otimizar o funil de crescimento de SaaS:

### 1. Acquisition (Aquisição)
- Como usuários descobrem o produto
- Canais: SEO, SEM, Content Marketing, Social Media, Referral, etc.
- Métricas: Tráfego, CPL (Cost Per Lead), CAC por canal

### 2. Activation (Ativação)
- Primeira experiência positiva do usuário
- Momento "Aha!" - quando o usuário percebe o valor
- Métricas: % de usuários que completam setup, tempo até primeira ação de valor, taxa de onboarding completo

### 3. Retention (Retenção)
- Usuários retornando e usando o produto
- Métricas: DAU/MAU, Churn rate, Retention cohorts, Stickiness

### 4. Revenue (Receita)
- Monetização e conversão
- Métricas: MRR, ARR, ARPU, LTV, Conversion rate trial-to-paid

### 5. Referral (Indicação)
- Crescimento viral e word-of-mouth
- Métricas: NPS, K-factor, Viral coefficient, % de usuários que indicam

## Framework T2D3 (Triple, Triple, Double, Double, Double)

Padrão de crescimento para SaaS B2B bem-sucedidos que alcançam $100M ARR:
- Ano 1-2: Triplicar ARR (3x, 3x)
- Ano 3-5: Dobrar ARR (2x, 2x, 2x)

Exemplo:
- Ano 0: $2M ARR
- Ano 1: $6M ARR (3x)
- Ano 2: $18M ARR (3x)
- Ano 3: $36M ARR (2x)
- Ano 4: $72M ARR (2x)
- Ano 5: $144M ARR (2x)

## Framework de Product-Led Growth (PLG)

Estratégia onde o produto é o principal vetor de crescimento:

### Pilares do PLG:
1. **Freemium ou Free Trial** - Baixa barreira de entrada
2. **Time to Value rápido** - Usuário vê valor rapidamente
3. **Viral Loops** - Produto incentiva compartilhamento
4. **Self-Service** - Onboarding sem necessidade de vendas
5. **Usage-Based Pricing** - Preço escala com valor

### Exemplos de PLG SaaS:
- Slack, Dropbox, Notion, Figma, Calendly, Loom

## Framework de North Star Metric

Uma métrica única que melhor captura o valor entregue aos clientes:

### Características de uma boa North Star:
- Expressa valor para o cliente
- Reflete engajamento ativo
- Correlaciona com receita
- É acionável pela equipe

### Exemplos por tipo de SaaS:
- **Collaboration tools**: Mensagens enviadas/semana (Slack)
- **Storage**: Arquivos salvos/mês (Dropbox)
- **CRM**: Deals criados/mês (Pipedrive)
- **Analytics**: Insights visualizados/semana (Mixpanel)
- **Project Management**: Projetos ativos (Asana)

## Framework de Growth Loops

Loops de crescimento auto-sustentáveis:

### 1. Viral Loop
Input → Usuário usa produto → Compartilha com outros → Novos usuários → Input

### 2. Content Loop
Input → Usuários criam conteúdo → SEO/descoberta → Novos usuários → Input

### 3. Paid Loop
Input → Receita → Investimento em ads → Novos usuários → Mais receita → Input

### 4. Sales Loop
Input → Usuários → Dados/cases → Facilita vendas → Novos usuários → Input

## Framework de Stage-Based Growth Strategy

### Early Stage (0-$1M ARR)
Foco: Product-Market Fit
- Identificar ICP (Ideal Customer Profile)
- Validar solução para problema real
- Métricas: Retention, NPS, qualitative feedback

### Growth Stage ($1M-$10M ARR)
Foco: Escalar canais que funcionam
- Diversificar canais de aquisição
- Otimizar conversão do funil
- Métricas: CAC, LTV, Payback period

### Scale Stage ($10M+ ARR)
Foco: Eficiência e previsibilidade
- Automação de processos
- Expansão geográfica/vertical
- Métricas: Rule of 40, Net Revenue Retention, Magic Number

## Framework ICE para Priorização de Experimentos

Pontuar cada experimento de growth de 1-10 em:

- **Impact**: Qual o impacto potencial?
- **Confidence**: Qual a confiança de que funcionará?
- **Ease**: Quão fácil é implementar?

**ICE Score = (Impact + Confidence + Ease) / 3**

Priorizar experimentos com maior score ICE.

## Framework de Unit Economics

Matemática fundamental de SaaS:

### Fórmulas Essenciais:

**LTV (Lifetime Value)**
```
LTV = ARPU × Gross Margin % ÷ Churn Rate
```

**CAC (Customer Acquisition Cost)**
```
CAC = Total Sales & Marketing Spend ÷ New Customers Acquired
```

**LTV:CAC Ratio**
- < 1: Insustentável
- 1-3: Precisa melhorar
- 3-5: Saudável
- > 5: Sub-investindo em crescimento

**CAC Payback Period**
```
Months to recover CAC = CAC ÷ (ARPU × Gross Margin %)
```
- Meta: < 12 meses para SaaS saudável

**Magic Number**
```
Magic Number = (ARR Trimestre Atual - ARR Trimestre Anterior) ÷ Sales & Marketing Spend Trimestre Anterior
```
- < 0.5: Ineficiente
- 0.5-0.75: Ok
- > 0.75: Eficiente, hora de acelerar investimento

## Framework de Retenção Cohort-Based

Análise de retenção por cohort (grupos de usuários que começaram no mesmo período):

### Métricas por Cohort:
- **Day 1, 7, 30, 90 Retention**
- **Revenue Retention por cohort**
- **Feature adoption por cohort**

### Sinais de Product-Market Fit:
- 40%+ retention no Day 30
- Curva de retenção achata (não vai a zero)
- Cohorts recentes retêm melhor que antigas
