# Plano de Ação: Melhorar [Aspecto Específico] - [Nome do Produto]

**Gap Identificado:** [Nome do gap específico]
**Área do Framework:** [Trigger / Action / Reward / Investment / Padrão de Retenção]
**ICE Score:** [Score]
**Data:** [Data]
**Owner:** [Nome/Time responsável]

---

## 1. Definição do Problema

### 1.1 Descrição Detalhada

[Explicação completa e específica do gap ou problema identificado]

**Evidências:**
- Métrica 1: [Dados que mostram o problema]
- Métrica 2: [Dados]
- Feedback qualitativo: [Quotes de usuários, se disponível]

### 1.2 Impacto Atual

**Quanto este problema está custando?**
- Em retenção: [Estimativa de % de usuários perdidos]
- Em receita: [Estimativa se possível]
- Em engajamento: [Métricas específicas]

**Exemplo:**
"Sem trigger interno forte, 60% dos usuários não retornam após dia 7. Se melhorarmos trigger de 40% para 60%, potencialmente salvamos 200 usuários/mês."

---

## 2. Hipótese

### 2.1 Declaração da Hipótese

**Formato:**
"Acreditamos que [ação específica] vai resultar em [impacto mensurável] em [métrica] porque [raciocínio baseado em framework/pesquisa]."

**Exemplo:**
"Acreditamos que implementar notificações personalizadas de insights inesperados vai aumentar D7 retention de 40% para 55% porque cria um trigger interno de curiosidade e injeta variabilidade na reward."

### 2.2 Premissas

**Esta hipótese assume:**
1. [Premissa #1]
2. [Premissa #2]
3. [Premissa #3]

**Validação de Premissas:**
[Como validar essas premissas antes de implementar solução completa]

---

## 3. Solução Proposta

### 3.1 Descrição da Solução

[Descrição detalhada do que será implementado]

**Componentes:**
1. **[Componente 1]**: [Descrição]
2. **[Componente 2]**: [Descrição]
3. **[Componente 3]**: [Descrição]

### 3.2 Como Funciona (User Journey)

**Antes:**
1. [Passo 1 do fluxo atual]
2. [Passo 2]
3. [Passo 3]

**Depois:**
1. [Passo 1 do novo fluxo]
2. [Passo 2 - destacar mudanças]
3. [Passo 3]

### 3.3 Wireframes / Mockups

[Incluir wireframes, screenshots, ou descrições visuais detalhadas]

**Tela 1:**
[Descrição ou imagem]

**Tela 2:**
[Descrição ou imagem]

### 3.4 Copy / Microcopy

**Notificação:**
"[Copy exato da notificação]"

**CTA:**
"[Copy do botão/link]"

**Empty State:**
"[Copy]"

---

## 4. Exemplos de Sucesso

### 4.1 Produtos que Fazem Bem

**Exemplo 1: [Nome do Produto]**
- **O que fazem:** [Descrição]
- **Por que funciona:** [Análise]
- **Como adaptar:** [Aplicação ao seu contexto]

**Exemplo 2: [Nome do Produto]**
- **O que fazem:** [Descrição]
- **Por que funciona:** [Análise]
- **Como adaptar:** [Aplicação]

### 4.2 Aplicação ao Nosso Contexto

[Como os exemplos acima se aplicam especificamente ao seu produto]

---

## 5. Implementação

### 5.1 Requisitos Técnicos

**Backend:**
- [ ] [Requisito técnico 1]
- [ ] [Requisito 2]
- [ ] [Requisito 3]

**Frontend:**
- [ ] [Requisito 1]
- [ ] [Requisito 2]

**Data/Analytics:**
- [ ] [Setup de tracking necessário]
- [ ] [Métricas a instrumentar]

**Terceiros:**
- [ ] [APIs ou ferramentas necessárias]

### 5.2 Esforço Estimado

| Disciplina | Esforço | Detalhe |
|------------|---------|---------|
| Product | [X dias] | [Detalhamento] |
| Design | [X dias] | [Detalhamento] |
| Eng - Backend | [X dias] | [Detalhamento] |
| Eng - Frontend | [X dias] | [Detalhamento] |
| Data/Analytics | [X dias] | [Detalhamento] |
| **Total** | **[X dias]** | |

### 5.3 Timeline

**Milestone 1: Design & Spec** (Semana 1)
- [ ] Finalizar spec detalhado
- [ ] Design mockups
- [ ] Review com stakeholders

**Milestone 2: Implementação** (Semana 2-3)
- [ ] Backend implementation
- [ ] Frontend implementation
- [ ] Tracking setup
- [ ] QA

**Milestone 3: Launch** (Semana 4)
- [ ] Deploy to % de usuários (beta)
- [ ] Monitor métricas iniciais
- [ ] Iterar se necessário
- [ ] Full rollout

### 5.4 Dependências

**Dependências Internas:**
1. [Dependência 1 - o que precisa estar pronto antes]
2. [Dependência 2]

**Dependências Externas:**
3. [Dependência externa se houver]

**Bloqueadores Potenciais:**
- [Risco 1]
- [Risco 2]

---

## 6. Métricas de Sucesso

### 6.1 Métricas Primárias

**Métrica #1: [Nome da Métrica]**
- **Baseline:** [Valor atual]
- **Meta:** [Valor alvo]
- **Timeline:** [Quando esperar atingir]

**Métrica #2: [Nome da Métrica]**
- **Baseline:** [Valor atual]
- **Meta:** [Valor alvo]
- **Timeline:** [Quando esperar atingir]

### 6.2 Métricas Secundárias

- [Métrica secundária 1]: [Baseline] → [Meta]
- [Métrica secundária 2]: [Baseline] → [Meta]

### 6.3 Guardrail Metrics

**Métricas que NÃO podem piorar:**
- [Métrica guardrail 1]: Manter ≥ [valor]
- [Métrica guardrail 2]: Manter ≥ [valor]

### 6.4 Success Criteria

**Consideramos esta iniciativa um sucesso se:**
1. [Critério específico #1]
2. [Critério específico #2]
3. [Critério específico #3]

**Prazo para avaliar:** [X semanas após full launch]

---

## 7. Experimento (se aplicável)

### 7.1 Setup A/B Test

**Variante A (Control):**
[Descrição do fluxo atual - grupo de controle]

**Variante B (Test):**
[Descrição do novo fluxo - grupo de teste]

**Alocação:**
- Control: [%]
- Test: [%]

**Duração:**
[X semanas - justificar duração baseado em tráfego e efeito esperado]

### 7.2 Análise

**Como vamos analisar:**
- [Ferramenta de A/B test]
- [Significance level: geralmente 95%]
- [Minimum detectable effect: X%]

**Quando declarar vencedor:**
[Critérios específicos de quando roll out para 100%]

---

## 8. Riscos e Mitigação

### 8.1 Riscos Identificados

**Risco #1: [Descrição do risco]**
- **Probabilidade:** [Alta / Média / Baixa]
- **Impacto:** [Alto / Médio / Baixo]
- **Mitigação:** [Como mitigar ou plano B]

**Risco #2: [Descrição]**
- **Probabilidade:** [Alta / Média / Baixa]
- **Impacto:** [Alto / Médio / Baixo]
- **Mitigação:** [Como mitigar]

**Risco #3: [Descrição]**
- **Probabilidade:** [Alta / Média / Baixa]
- **Impacto:** [Alto / Médio / Baixo]
- **Mitigação:** [Como mitigar]

### 8.2 Rollback Plan

**Se algo der errado:**
1. [Passo 1 para rollback]
2. [Passo 2]
3. [Passo 3]

**Critérios para rollback:**
- [Métrica X cai mais de Y%]
- [Feedback negativo acima de Z%]
- [Bug crítico detectado]

---

## 9. Comunicação

### 9.1 Stakeholders

**Quem precisa saber:**

| Stakeholder | Papel | Update Frequency |
|-------------|-------|------------------|
| [Nome/Time] | [Decision maker/Informed/etc] | [Semanal/Milestones] |
| [Nome/Time] | [Papel] | [Frequência] |

### 9.2 Launch Communication

**Interno (Time):**
- [Como comunicar para o time]
- [Treinamento necessário]

**Externo (Usuários):**
- [ ] Changelog entry
- [ ] In-app announcement
- [ ] Email campaign
- [ ] Blog post
- [ ] Social media

**Copy sugerido:**
"[Draft do announcement]"

---

## 10. Aprendizados e Iteração

### 10.1 Post-Launch Review (Após X semanas)

**O que funcionou:**
- [Aprendizado positivo #1]
- [Aprendizado positivo #2]

**O que não funcionou:**
- [Aprendizado negativo #1]
- [Aprendizado negativo #2]

**Surpresas:**
- [Algo inesperado #1]
- [Algo inesperado #2]

### 10.2 Próximos Passos

**Se bem-sucedido:**
1. [Próxima iteração para melhorar ainda mais]
2. [Feature relacionada para implementar]

**Se não bem-sucedido:**
1. [Hipótese alternativa para testar]
2. [Pivô na abordagem]

---

## 11. Referências

### 11.1 Research

- [Link para research #1]
- [Link para case study relevante #2]
- [Link para artigo #3]

### 11.2 Documentação Interna

- [Link para spec técnico]
- [Link para design files]
- [Link para tracking plan]

---

## Status Tracking

### Checklist de Progresso

**Design & Planning:**
- [ ] Spec completo
- [ ] Design finalized
- [ ] Stakeholder buy-in
- [ ] Technical feasibility confirmed

**Development:**
- [ ] Backend implementation
- [ ] Frontend implementation
- [ ] Tracking instrumented
- [ ] QA passed

**Launch:**
- [ ] Beta deployed
- [ ] Metrics validated
- [ ] Full rollout
- [ ] Communication sent

**Post-Launch:**
- [ ] Métricas atingidas
- [ ] Review completo
- [ ] Learnings documented
- [ ] Next steps defined

---

**Última Atualização:** [Data]
**Status Atual:** [Planning / In Progress / In QA / Launched / Complete]
**Próximo Update:** [Data]
