# Audit de Retenção: [Nome do Produto SaaS]

**Data do Audit**: [Data]
**Versão do Produto**: [Versão]
**Conduzido por**: Claude - Hooked SaaS Retention Specialist

---

## Executive Summary

### Pontuação Geral de Habit-Forming

**Score:** [X]/100

**Classificação:**
- 80-100: Produto altamente viciante, hábito forte ✅
- 60-79: Hábito moderado, oportunidades de melhoria 🟡
- 40-59: Hábito fraco, ação necessária 🟠
- 0-39: Sem formação de hábito, urgente ❌

### Top 3 Forças

1. **[Força #1]**: [Breve descrição de 1-2 linhas]
2. **[Força #2]**: [Breve descrição]
3. **[Força #3]**: [Breve descrição]

### Top 3 Lacunas Críticas

1. **[Gap #1]**: [Breve descrição + impacto estimado]
2. **[Gap #2]**: [Breve descrição + impacto estimado]
3. **[Gap #3]**: [Breve descrição + impacto estimado]

### Recomendação Prioritária

[Ação #1 de maior impacto que deve ser implementada imediatamente, com justificativa]

---

## 1. Contexto do Produto

### 1.1 Informações Básicas

- **Categoria**: [Ex: CRM, Analytics, Project Management]
- **Modelo**: [B2B SaaS, B2C, Freemium, etc.]
- **Target**: [ICP específico]
- **Estágio**: [Early, Growth, Scale]

### 1.2 Métricas Atuais

| Métrica | Valor Atual | Benchmark da Indústria | Status |
|---------|-------------|------------------------|--------|
| D1 Retention | __% | 40-60% | 🔴🟡🟢 |
| D7 Retention | __% | 25-40% | 🔴🟡🟢 |
| D30 Retention | __% | 15-25% | 🔴🟡🟢 |
| DAU/MAU | __% | 20%+ | 🔴🟡🟢 |
| Weekly Active % | __% | 30-50% | 🔴🟡🟢 |
| Habit Testing Score | __% | 40%+ | 🔴🟡🟢 |

**Interpretação:**
[Análise breve do estado atual das métricas]

---

## 2. Análise do Framework Hooked

### 2.1 TRIGGER (Gatilho)

#### Score: [X]/25

**Triggers Externos:**

**Status Atual:**
- Owned triggers (email, push): [✅ / ⚠️ / ❌]
- Relationship triggers (convites): [✅ / ⚠️ / ❌]
- Frequência otimizada: [✅ / ⚠️ / ❌]

**Análise:**
[Descrição dos triggers externos atualmente implementados e sua efetividade]

**Triggers Internos:**

**Emoção Core Identificada:** [Ansiedade / Incerteza / FOMO / Tédio / etc.]

**Avaliação:**
- Emoção claramente definida: [✅ / ❌]
- Emoção é frequente (diária/semanal): [✅ / ❌]
- Associação produto-emoção estabelecida: [✅ / ⚠️ / ❌]
- Evidência qualitativa: [✅ / ❌]

**Análise:**
[Avaliação de quão bem o trigger interno está estabelecido. Incluir quotes de usuários se disponível]

**Gaps Identificados:**
1. [Gap específico #1]
2. [Gap específico #2]

**Oportunidades:**
1. [Oportunidade #1 para melhorar triggers]
2. [Oportunidade #2]

---

### 2.2 ACTION (Ação)

#### Score: [X]/25

**Facilidade (Ability):**

**Métricas de Fricção:**
- Time to first value: [X minutos] (meta: <5min)
- Clicks até primeira ação: [X] (meta: <5)
- % completion de onboarding: [X%] (meta: >60%)

**Avaliação:**

| Elemento | Status | Nota |
|----------|--------|------|
| Tempo | 🟢🟡🔴 | [Comentário] |
| Esforço físico (clicks) | 🟢🟡🔴 | [Comentário] |
| Esforço mental (complexidade) | 🟢🟡🔴 | [Comentário] |
| Dinheiro (barreira) | 🟢🟡🔴 | [Comentário] |
| Social deviance | 🟢🟡🔴 | [Comentário] |
| Non-routine | 🟢🟡🔴 | [Comentário] |

**Análise:**
[Descrição detalhada da facilidade/fricção atual]

**Motivação:**

**Core Motivators Utilizados:**
- Prazer/Dor: [Como é usado]
- Esperança/Medo: [Como é usado]
- Aceitação Social: [Como é usado]

**Heurísticas Implementadas:**
- Social proof: [✅ / ❌]
- Scarcity: [✅ / ❌]
- Endowed progress: [✅ / ❌]
- Framing: [✅ / ❌]

**Gaps Identificados:**
1. [Gap específico #1]
2. [Gap específico #2]

**Oportunidades:**
1. [Oportunidade #1 para reduzir fricção]
2. [Oportunidade #2 para aumentar motivação]

---

### 2.3 VARIABLE REWARD (Recompensa Variável)

#### Score: [X]/25

**Tipos de Reward Implementados:**

**Rewards of the Tribe (Social):**
- Presente: [✅ / ⚠️ / ❌]
- Exemplos: [Descrição]
- Efetividade: [Alta / Média / Baixa]

**Rewards of the Hunt (Material/Info):**
- Presente: [✅ / ⚠️ / ❌]
- Exemplos: [Descrição]
- Efetividade: [Alta / Média / Baixa]

**Rewards of the Self (Maestria):**
- Presente: [✅ / ⚠️ / ❌]
- Exemplos: [Descrição]
- Efetividade: [Alta / Média / Baixa]

**Variabilidade:**

**Checklist:**
- Experiência varia uso-a-uso: [✅ / ❌]
- Surpresas positivas ocasionais: [✅ / ❌]
- Personalização/algoritmo: [✅ / ❌]
- Imprevisibilidade saudável: [✅ / ❌]

**Análise:**
[Avaliação de quão variável e surpreendente é a experiência do produto]

**Gaps Identificados:**
1. [Gap específico #1]
2. [Gap específico #2]

**Oportunidades:**
1. [Oportunidade #1 para adicionar variabilidade]
2. [Oportunidade #2 para surpreender usuários]

---

### 2.4 INVESTMENT (Investimento)

#### Score: [X]/25

**Tipos de Investment Presentes:**

| Tipo | Presente | Descrição | Efetividade |
|------|----------|-----------|-------------|
| Data | ✅⚠️❌ | [Como usuário adiciona dados] | Alta/Média/Baixa |
| Time | ✅⚠️❌ | [Tempo investido em config/learning] | Alta/Média/Baixa |
| Effort | ✅⚠️❌ | [Criação de conteúdo/customização] | Alta/Média/Baixa |
| Social | ✅⚠️❌ | [Convites, network] | Alta/Média/Baixa |
| Money | ✅⚠️❌ | [Commits financeiros] | Alta/Média/Baixa |

**Stored Value:**

**Avaliação:**
- Produto melhora com uso: [✅ / ⚠️ / ❌]
- Investment hoje → valor amanhã: [✅ / ⚠️ / ❌]
- Switching cost aumenta com tempo: [✅ / ⚠️ / ❌]
- Perder o que construiu seria doloroso: [✅ / ⚠️ / ❌]

**Métricas de Investment:**
- % usuários com dados significativos: [X%]
- Volume médio de dados: [Métrica relevante]
- % usuários que convidaram alguém: [X%]
- Tempo médio investido: [X minutos]

**Timing:**
- Investment vem APÓS reward: [✅ / ❌]
- Fácil de fazer: [✅ / ⚠️ / ❌]
- Valor comunicado claramente: [✅ / ❌]

**Análise:**
[Avaliação de quão bem investment está implementado e fecha o loop]

**Gaps Identificados:**
1. [Gap específico #1]
2. [Gap específico #2]

**Oportunidades:**
1. [Oportunidade #1 para aumentar investment]
2. [Oportunidade #2 para acumular stored value]

---

### 2.5 LOOP (Fechamento)

**Avaliação do Loop:**

**O Loop se Fecha?**
- Investment → Trigger: [✅ / ⚠️ / ❌]
- Loop é auto-sustentável: [✅ / ⚠️ / ❌]

**Exemplo de Loop Completo:**
1. Trigger: [Descrever]
2. Action: [Descrever]
3. Reward: [Descrever]
4. Investment: [Descrever]
5. → Próximo Trigger: [Descrever]

**Frequência:**
- Loop acontece diariamente: [✅ / ❌]
- Se não, frequência: [Semanal / Mensal]

**Análise:**
[Avaliação de quão bem o loop fecha e se auto-sustenta]

---

## 3. Padrões de Retenção

### 3.1 Data Moats

**Score: [X]/15**

**Padrões Presentes:**

**Historical Value Accumulation:**
- Implementado: [✅ / ⚠️ / ❌]
- Descrição: [Como valor histórico funciona]
- Impacto: [Alto / Médio / Baixo]

**Learning Algorithms:**
- Implementado: [✅ / ⚠️ / ❌]
- Descrição: [Como sistema aprende]
- Impacto: [Alto / Médio / Baixo]

**User-Generated Content:**
- Implementado: [✅ / ⚠️ / ❌]
- Descrição: [Conteúdo criado por usuário]
- Impacto: [Alto / Médio / Baixo]

**Análise:**
[Avaliação de quão bem dados criam fosso defensivo]

---

### 3.2 Network Effects

**Score: [X]/15**

**Padrões Presentes:**

**Direct Network Effects:**
- Implementado: [✅ / ⚠️ / ❌]
- Descrição: [Como funciona]
- Força: [Forte / Moderado / Fraco]

**Data Network Effects:**
- Implementado: [✅ / ⚠️ / ❌]
- Descrição: [Como funciona]

**Marketplace Dynamics:**
- Implementado: [✅ / ⚠️ / ❌]
- Descrição: [Se aplicável]

**Análise:**
[Avaliação de efeitos de rede]

---

### 3.3 Switching Cost Builders

**Score: [X]/15**

**Padrões Presentes:**

**Deep Integrations:**
- Implementado: [✅ / ⚠️ / ❌]
- Número de integrações disponíveis: [X]
- Profundidade: [Alta / Média / Baixa]

**Customization & Configuration:**
- Implementado: [✅ / ⚠️ / ❌]
- Nível de customização: [Alto / Médio / Baixo]

**Financial Lock-in:**
- Implementado: [✅ / ⚠️ / ❌]
- Ético? [✅ / ❌]

**Análise:**
[Avaliação de switching costs]

---

### 3.4 Engagement Loops

**Score: [X]/10**

**Collaboration Loops:**
- Implementado: [✅ / ⚠️ / ❌]

**Content/Feed Loops:**
- Implementado: [✅ / ⚠️ / ❌]

**Gamification Loops:**
- Implementado: [✅ / ⚠️ / ❌]

---

### 3.5 Behavioral Change

**Score: [X]/10**

**Workflow Replacement:**
- Implementado: [✅ / ⚠️ / ❌]

**Skill Development:**
- Implementado: [✅ / ⚠️ / ❌]

---

### 3.6 Progressive Investment

**Score: [X]/10**

**Freemium → Paid → Expansion:**
- Implementado: [✅ / ⚠️ / ❌]

**Seat Expansion:**
- Implementado: [✅ / ⚠️ / ❌]

**Feature Expansion:**
- Implementado: [✅ / ⚠️ / ❌]

---

## 4. Análise Competitiva

### 4.1 Benchmarking

**Principais Competidores Analisados:**
1. [Competitor 1]
2. [Competitor 2]
3. [Competitor 3]

### 4.2 Matriz Comparativa

| Aspecto | Seu Produto | Competitor 1 | Competitor 2 | Competitor 3 |
|---------|-------------|--------------|--------------|--------------|
| Trigger Interno | [Score] | [Score] | [Score] | [Score] |
| Facilidade de Action | [Score] | [Score] | [Score] | [Score] |
| Variabilidade de Reward | [Score] | [Score] | [Score] | [Score] |
| Investment/Stored Value | [Score] | [Score] | [Score] | [Score] |
| Network Effects | [Score] | [Score] | [Score] | [Score] |
| Switching Costs | [Score] | [Score] | [Score] | [Score] |
| **TOTAL** | [Score] | [Score] | [Score] | [Score] |

### 4.3 Insights Competitivos

**O que Competitors Fazem Melhor:**
1. [Insight #1]
2. [Insight #2]
3. [Insight #3]

**Onde Você Tem Vantagem:**
1. [Vantagem #1]
2. [Vantagem #2]

**Oportunidades de Diferenciação:**
1. [Oportunidade #1]
2. [Oportunidade #2]

---

## 5. Considerações Éticas

### 5.1 Manipulation Matrix

**Classificação:** [Facilitator / Peddler / Entertainer / Dealer]

**Justificativa:**
[Por que essa classificação]

### 5.2 Checklist Ético

- [ ] Produto genuinamente melhora vida/trabalho dos usuários
- [ ] Criadores usam o próprio produto
- [ ] Transparência sobre mecanismos
- [ ] Facilidade de sair (export, delete)
- [ ] Respeito à autonomia do usuário
- [ ] Controles de bem-estar (pausar, limitar)

**Análise Ética:**
[Avaliação da ética do produto]

**Recomendações Éticas:**
[Se houver red flags, como resolver]

---

## 6. Gaps Críticos e Priorização

### 6.1 Todos os Gaps Identificados

| # | Gap | Área | Impacto | Esforço | ICE Score |
|---|-----|------|---------|---------|-----------|
| 1 | [Gap] | [Trigger/Action/etc] | [1-10] | [1-10] | [Score] |
| 2 | [Gap] | [Área] | [1-10] | [1-10] | [Score] |
| 3 | [Gap] | [Área] | [1-10] | [1-10] | [Score] |
| 4 | [Gap] | [Área] | [1-10] | [1-10] | [Score] |
| 5 | [Gap] | [Área] | [1-10] | [1-10] | [Score] |
| ... | | | | | |

### 6.2 Top 5 Prioridades

#### Prioridade #1: [Nome do Gap]

**ICE Score:** [Score]

**Problema:**
[Descrição detalhada do problema]

**Impacto Esperado:**
[Como resolver vai melhorar retenção - ser específico com métricas]

**Solução Recomendada:**
[O que implementar - específico e acionável]

**Exemplos de Implementação:**
[Exemplos de como outros produtos fazem, ou mockups conceituais]

**Métricas de Sucesso:**
- Primária: [Métrica]
- Secundária: [Métrica]
- Meta: [Número específico]

**Timeline Sugerido:** [X semanas]

**Esforço Estimado:** [Baixo / Médio / Alto]

**Stakeholders:** [Quem precisa estar envolvido]

---

#### Prioridade #2: [Nome do Gap]
[Repetir estrutura]

---

#### Prioridade #3: [Nome do Gap]
[Repetir estrutura]

---

#### Prioridade #4: [Nome do Gap]
[Repetir estrutura]

---

#### Prioridade #5: [Nome do Gap]
[Repetir estrutura]

---

## 7. Roadmap de Implementação

### 7.1 Quick Wins (Primeiras 2-4 semanas)

**Objetivo:** Gerar momentum com melhorias de baixo esforço e impacto visível.

| Ação | Owner | Timeline | Métrica de Sucesso |
|------|-------|----------|-------------------|
| [Ação 1] | [Pessoa] | [Prazo] | [Métrica] |
| [Ação 2] | [Pessoa] | [Prazo] | [Métrica] |
| [Ação 3] | [Pessoa] | [Prazo] | [Métrica] |

### 7.2 Foundations (Mês 2-3)

**Objetivo:** Estabelecer bases para formação de hábito sustentável.

| Ação | Owner | Timeline | Métrica de Sucesso |
|------|-------|----------|-------------------|
| [Ação 1] | [Pessoa] | [Prazo] | [Métrica] |
| [Ação 2] | [Pessoa] | [Prazo] | [Métrica] |
| [Ação 3] | [Pessoa] | [Prazo] | [Métrica] |

### 7.3 Scale (Mês 4-6)

**Objetivo:** Escalar o que funciona, experimentar com táticas de maior risco/recompensa.

| Ação | Owner | Timeline | Métrica de Sucesso |
|------|-------|----------|-------------------|
| [Ação 1] | [Pessoa] | [Prazo] | [Métrica] |
| [Ação 2] | [Pessoa] | [Prazo] | [Métrica] |
| [Ação 3] | [Pessoa] | [Prazo] | [Métrica] |

---

## 8. Metas de Retenção

### 8.1 Baseline Atual

| Métrica | Atual |
|---------|-------|
| D1 Retention | __% |
| D7 Retention | __% |
| D30 Retention | __% |
| DAU/MAU | __% |
| Habit Testing Score | __% |

### 8.2 Metas (30 dias)

| Métrica | Meta |
|---------|------|
| D1 Retention | __% |
| D7 Retention | __% |
| D30 Retention | __% |
| DAU/MAU | __% |

### 8.3 Metas (90 dias)

| Métrica | Meta |
|---------|------|
| D1 Retention | __% |
| D7 Retention | __% |
| D30 Retention | __% |
| DAU/MAU | __% |
| Habit Testing Score | __% |

**Justificativa das Metas:**
[Por que essas metas são realistas e ambiciosas]

---

## 9. Experimentos Propostos

### Experimento #1: [Nome]

**Hipótese:**
[Se fizermos X, esperamos Y impacto em Z métrica porque...]

**Setup:**
- **Variante A** (Control): [Descrição]
- **Variante B** (Test): [Descrição]
- **Alocação**: 50/50
- **Duração**: [X semanas]

**Métricas:**
- Primária: [Métrica]
- Secundária: [Métricas]
- Guardrail: [Métricas que não podem piorar]

**Success Criteria:**
[Quando consideramos experimento um sucesso]

---

### Experimento #2: [Nome]
[Repetir estrutura]

---

### Experimento #3: [Nome]
[Repetir estrutura]

---

## 10. Monitoramento e Iteração

### 10.1 Dashboard de Retenção

**Métricas para Rastrear Semanalmente:**
- [ ] Cohort retention (D1, D7, D30)
- [ ] DAU/MAU ratio
- [ ] % usuários com investment significativo
- [ ] Velocidade dos loops
- [ ] Churn rate e razões

**Ferramentas:**
[Analytics tools usadas: Amplitude, Mixpanel, etc.]

### 10.2 Cadência de Revisão

- **Semanal**: Review de métricas core
- **Mensal**: Review de experimentos e próximos passos
- **Trimestral**: Audit completo de hábito/retenção

### 10.3 Success Criteria

**Este plano é considerado sucesso se:**
1. [Critério #1 - específico e mensurável]
2. [Critério #2]
3. [Critério #3]

---

## 11. Recursos Adicionais

### 11.1 Leituras Recomendadas

- **Hooked** - Nir Eyal
- **The Power of Habit** - Charles Duhigg
- **Atomic Habits** - James Clear
- **Tiny Habits** - BJ Fogg

### 11.2 Case Studies Relevantes

1. [Produto similar]: [Link para case study]
2. [Produto similar]: [Link]
3. [Produto similar]: [Link]

---

## 12. Conclusão

### 12.1 Summary

[Parágrafo resumindo estado atual, principais gaps, e caminho forward]

### 12.2 Call to Action

**Próximo Passo Imediato:**
[Ação específica que deve ser tomada hoje/esta semana]

**Próximos 30 Dias:**
[Foco para o próximo mês]

**Visão 90 Dias:**
[Onde o produto deve estar em termos de formação de hábito]

---

**Preparado por:** Claude - Hooked SaaS Retention Specialist
**Data:** [Data]
**Versão:** 1.0

**Próxima Revisão Agendada:** [Data + 30 dias]
