# Framework Hooked: Como Criar Produtos Formadores de Hábitos

Baseado no livro "Hooked: How to Build Habit-Forming Products" de Nir Eyal.

## O Modelo Hooked

O modelo Hooked é um framework de 4 fases que produtos viciantes usam para criar hábitos nos usuários:

```
TRIGGER → ACTION → VARIABLE REWARD → INVESTMENT
    ↑                                      ↓
    └──────────────────────────────────────┘
```

Cada ciclo completo aumenta a probabilidade do usuário retornar, criando um loop de hábito.

---

## Fase 1: TRIGGER (Gatilho)

O gatilho é o atuador do comportamento - a faísca que inicia a ação.

### Tipos de Triggers

#### 1. Triggers Externos
Informações no ambiente que dizem ao usuário o que fazer em seguida.

**Tipos de Triggers Externos:**

**a) Paid Triggers (Pagos)**
- Anúncios, SEM, display ads
- Eficazes para aquisição, não para formação de hábito
- Caros e insustentáveis no longo prazo

**b) Earned Triggers (Conquistados)**
- Menções na mídia, press coverage
- Viral coverage, boca-a-boca
- Requer conteúdo favorável e notável

**c) Relationship Triggers (Relacionamento)**
- Recomendações de pessoas
- Notificações de "João convidou você"
- Mais efetivos quando vêm de amigos/família
- Social proof poderoso

**d) Owned Triggers (Próprios)**
- Notificações push, emails, newsletters
- Ícone do app na tela inicial
- Só funcionam depois de permissão/instalação
- Gratuitos após conquistar usuário

**Progressão Ideal:**
1. Paid → atrair usuários
2. Earned → gerar interesse
3. Relationship → construir confiança
4. Owned → manter engajamento
5. Internal → criar hábito

#### 2. Triggers Internos (Objetivo Final)

Associações automáticas na mente do usuário.

**Características:**
- Emoções, rotinas, situações específicas
- "Estou entediado" → abro Instagram
- "Tenho dúvida" → Google
- "Me sinto sozinho" → WhatsApp

**Principais Emoções que Disparam Uso:**
- **Tédio** → entretenimento, redes sociais
- **Solidão** → comunicação, comunidades
- **Ansiedade** → notícias, email, Slack
- **Incerteza** → busca, informação
- **Medo de perder** (FOMO) → feeds, atualizações
- **Necessidade de validação** → likes, métricas

**Como criar triggers internos:**
1. Identificar a emoção/dor do usuário
2. Construir associação forte entre emoção e solução
3. Repetir experiência até virar automático

**Para SaaS B2B:**
- "Preciso ver números" → Dashboard
- "Tenho que responder cliente" → CRM
- "Devo checar performance" → Analytics
- "Reunião vindo" → Calendário integrado

---

## Fase 2: ACTION (Ação)

A ação é o comportamento mais simples feito em antecipação de recompensa.

### Fórmula de Fogg

**B = MAT**

Onde:
- **B** (Behavior) = Comportamento
- **M** (Motivation) = Motivação
- **A** (Ability) = Habilidade/Facilidade
- **T** (Trigger) = Gatilho

Para ação acontecer, os 3 elementos devem convergir simultaneamente.

### Motivation (Motivação)

**3 Core Motivators (pares primitivos):**

1. **Prazer / Dor**
   - Buscar prazer, evitar dor
   - Mais imediato e visceral

2. **Esperança / Medo**
   - Esperança de resultado positivo
   - Medo de resultado negativo

3. **Aceitação Social / Rejeição**
   - Ser aceito pelo grupo
   - Evitar rejeição/exclusão

**Para SaaS:**
- Esperança: "Vou fechar mais vendas"
- Medo: "Vou perder clientes se não usar"
- Aceitação: "Minha equipe usa isso"

### Ability (Facilidade)

Quanto mais fácil, mais provável a ação.

**6 Elementos de Simplicidade:**

1. **Time (Tempo)**
   - Quanto tempo leva?
   - Meta: Reduzir a zero

2. **Money (Dinheiro)**
   - Custo financeiro?
   - Freemium reduz barreira

3. **Physical Effort (Esforço Físico)**
   - Quantos cliques/toques?
   - Quanto typing?

4. **Brain Cycles (Esforço Mental)**
   - Quão complexo?
   - Requer aprendizado?

5. **Social Deviance (Desvio Social)**
   - É socialmente aceitável?
   - Vai contra normas?

6. **Non-Routine (Não-Rotineiro)**
   - Quão novo/diferente?
   - Rompe rotina existente?

**Princípio Chave:**
> Aumentar motivação é difícil. Aumentar facilidade é mais fácil.

**Como aumentar Ability em SaaS:**
- Reduzir campos em forms
- Onboarding super simples
- Defaults inteligentes
- Progressive disclosure (revelar gradualmente)
- Empty states que guiam ação
- Integrar com ferramentas existentes
- Single Sign-On (SSO)
- Templates e starter packs

### Heurísticas que Influenciam Ação

**1. Scarcity Effect (Escassez)**
- Pessoas valorizam mais o que é raro
- "Só 3 vagas restantes"
- "Oferta expira em 24h"

**2. Framing Effect**
- Como informação é apresentada importa
- "90% de sucesso" vs "10% de falha"
- "Economize $100" vs "Perca $100"

**3. Anchoring Effect**
- Primeira informação ancora julgamento
- Mostrar preço alto antes do baixo
- Comparar com alternativa cara

**4. Endowed Progress Effect**
- Progresso artificial aumenta motivação
- "Seu perfil está 30% completo"
- Dar "head start" em recompensas

**5. Social Proof**
- Seguimos o que outros fazem
- "10.000 empresas confiam"
- Testemunhos, casos de sucesso

---

## Fase 3: VARIABLE REWARD (Recompensa Variável)

O combustível do loop de hábito. Recompensas variáveis (imprevisíveis) criam muito mais dopamina que recompensas fixas.

### Por que Variável?

**Dopamina:**
- Liberada na ANTECIPAÇÃO da recompensa
- Variabilidade = mais antecipação = mais dopamina
- Slot machines > salário fixo em termos de vício

**Pesquisa:**
- Ratos apertam alavanca 10x mais por comida variável vs. fixa
- Humanos fazem refresh obsessivamente (email, feed) pela variabilidade

### 3 Tipos de Recompensas Variáveis

#### 1. Rewards of the Tribe (Recompensas da Tribo)

Recompensas sociais: conexão, competição, cooperação, reconhecimento.

**Exemplos:**
- **Likes, upvotes, favs** (validação social variável)
- **Comentários, menções** (atenção de pessoas)
- **Followers, subscribers** (status, aprovação)
- **Leaderboards** (competição, ranking)
- **Badges, títulos** ("Power User", "Top Contributor")

**Para SaaS B2B:**
- Dashboard de performance do time (competição saudável)
- Reconhecimento de "Deal fechado" visível
- Menções em all-hands, newsletters
- Rankings de adoção de features
- Badges de expertise/certificações

**Variabilidade:**
- Número de likes varia
- Quem vai comentar é imprevisível
- Quando vai chegar reconhecimento

#### 2. Rewards of the Hunt (Recompensas da Caça)

Recompensas materiais: dinheiro, informação, recursos.

**Exemplos:**
- **Feed infinito** (próximo post pode ser incrível)
- **Busca** (próximo resultado pode resolver)
- **Notifications** (próxima pode ser importante)
- **Deals/promoções variáveis**
- **Loot boxes, gacha** (gaming)

**Para SaaS:**
- **Insights variáveis** no dashboard ("Descobrimos uma anomalia!")
- **Relatórios semanais** com discoveries
- **Recomendações de otimização** (nem sempre iguais)
- **Notificações de oportunidades** ("Cliente X está quente")
- **Data discovery** (encontrar padrões novos nos dados)

**Variabilidade:**
- Nem sempre há insight novo
- Gravidade das notificações varia
- Valor da informação flutua

#### 3. Rewards of the Self (Recompensas do Eu)

Recompensas intrínsecas: maestria, competência, consistência, completude.

**Exemplos:**
- **Progress bars** ("80% completo")
- **Streaks** (Duolingo, GitHub contributions)
- **Achievements, conquests**
- **Leveling up, XP**
- **Completion** (inbox zero, task lists)
- **Maestria** (skill development visível)

**Para SaaS:**
- **Setup/onboarding completion** (satisfaction de completar)
- **Feature adoption tracking** ("Você dominou 7/10 features")
- **Usage streaks** ("15 dias consecutivos logando")
- **Data quality scores** (gamificar limpeza de dados)
- **Certification paths** (progressão de expertise)
- **Personal bests** ("Seu melhor mês de vendas!")

**Variabilidade:**
- Tempo para completar varia
- Dificuldade de próximo milestone
- Reconhecimento inesperado de progresso

### Elementos Importantes

**1. Satisfação mas Deixar Querendo Mais**
- Recompensa satisfaz, mas não completamente
- Mantém usuário voltando
- "Foi bom, mas próxima pode ser melhor"

**2. Autonomia é Crítica**
- Usuário deve sentir controle
- Não pode sentir manipulação
- Deve ser escolha, não obrigação

**3. Variabilidade ≠ Aleatoriedade Total**
- Deve haver lógica subjacente
- Usuário entende as regras do jogo
- Mas não consegue prever exatamente

**4. Evitar "Recompensas Finitas"**
- Se todas as recompensas podem ser esgotadas, hábito morre
- Precisa ser fonte infinita (social é naturalmente infinito)

---

## Fase 4: INVESTMENT (Investimento)

A fase onde usuário põe algo de valor no produto, aumentando probabilidade de retorno.

### O que é Investment?

**Não é monetização** (apesar de poder ser).

Investment é quando usuário:
- Adiciona valor ao produto
- Melhora experiência em uso futuro
- Aumenta custo de sair (switching cost)

### Por que Investment Funciona?

**1. Stored Value (Valor Armazenado)**

Quanto mais usuário põe no produto, mais valioso produto fica PARA ELE.

**Exemplos de Stored Value:**
- **Conteúdo**: Posts, fotos, documentos criados
- **Dados**: Histórico, preferências, configurações
- **Seguidores/conexões**: Rede social construída
- **Reputação**: Reviews, karma, ratings recebidos
- **Aprendizado**: Tempo investido dominando ferramenta
- **Customização**: Setups, workflows personalizados

**Para SaaS:**
- **Dados históricos**: Mais dados = mais insights
- **Integrações configuradas**: Custo de replicar é alto
- **Workflows customizados**: Adaptado ao processo único
- **Permissões e roles**: Estrutura organizacional mapeada
- **Templates criados**: Automações construídas
- **Treinamento da equipe**: Switching cost aumenta

**2. Consistency (Consistência)**

**Princípio:** Humanos desejam ser consistentes com ações passadas.

Se investi tempo/esforço, quero que valha a pena.

**Experimentos:**
- Pessoas que escrevem meta têm mais probabilidade de alcançar
- Declarações públicas aumentam commitment
- Pequenos investimentos levam a maiores

**Aplicação:**
- Pedir pequeno investment inicial (ex: criar perfil)
- Progressivamente pedir mais
- Cada step aumenta commitment

**3. Sunk Cost Fallacy (Falácia do Custo Afundado)**

Quanto mais investimos, mais difícil sair (mesmo que racional seria sair).

**Exemplo:**
- Netflix: Quanto mais filmes na lista, mais difícil trocar
- CRM: Quanto mais dados, mais amarrado
- Notion: Quanto mais páginas, mais locked-in

### Tipos de Investment

#### 1. Time (Tempo)

**Exemplos:**
- Tempo configurando produto
- Tempo aprendendo features
- Tempo criando conteúdo/dados
- Tempo construindo seguidores

**Para SaaS:**
- Onboarding bem-feito é investment (não friction)
- Criar primeiro dashboard, report, workflow
- Treinar equipe no produto

#### 2. Data (Dados)

**Exemplos:**
- Preferências informadas
- Histórico de uso
- Uploads de arquivos/informações
- Conexões com outras ferramentas

**Para SaaS:**
- Importar contatos, leads, clientes
- Configurar integrações (cada integração é investment)
- Adicionar membros do time (mais stakeholders)
- Upload de documentos, assets

#### 3. Effort (Esforço)

**Exemplos:**
- Esforço criando algo dentro do produto
- Curadoria (playlists, listas)
- Customização, personalização
- Contribuições (reviews, ratings)

**Para SaaS:**
- Criar templates customizados
- Configurar automações, triggers
- Personalizar views, dashboards
- Documentar processos internos na ferramenta

#### 4. Social Capital (Capital Social)

**Exemplos:**
- Seguidores, followers
- Reputação, karma, ratings
- Conexões, network
- Status na comunidade

**Para SaaS:**
- Convites enviados (investment social)
- Reputação dentro da empresa (power user)
- Network de integrações com parceiros
- Visibilidade em success cases

#### 5. Money (Dinheiro)

**Quando vira investment:**
- Planos anuais (maior commitment)
- Comprar add-ons, seats adicionais
- Custom features desenvolvidas
- Não é só transação, é commitment

### Timing do Investment

**CRÍTICO:** Investment vem APÓS recompensa, não antes.

**Sequência Correta:**
1. Trigger
2. Action (baixa fricção)
3. Variable Reward (satisfação)
4. **Investment** (quando usuário está satisfeito)

**Por quê:**
- Usuário está no pico de satisfação pós-recompensa
- Momento perfeito para pedir algo
- "Quer salvar isso?" após boa experiência

**Exemplos:**
- Instagram: Após postar foto e ver primeiros likes → "Siga 5 amigos"
- LinkedIn: Após completar perfil e ver views → "Adicione skills"
- SaaS: Após gerar primeiro report útil → "Salve como template"

### O Loop se Fecha

**Investment carrega próximo trigger:**

- **Stored Value** → Razão para voltar
- **Mais dados** → Melhores insights → Notificação
- **Mais conexões** → Mais atividade social → Trigger
- **Customização** → Produto mais útil → Uso frequente

**Exemplo Completo (LinkedIn):**
1. **Trigger**: "5 pessoas viram seu perfil" (notificação)
2. **Action**: Abrir LinkedIn (fácil, um clique)
3. **Reward**: Ver quem visitou, descobrir oportunidade (hunt), sentir validado (tribe)
4. **Investment**: Adicionar nova skill, postar conteúdo, conectar com alguém
5. **Loop**: Investment gera novos triggers ("João aceitou seu convite", "Seu post teve 50 likes")

---

## Frequência e Vitamin vs. Painkiller

### Frequência de Uso

**Para formar hábito, comportamento precisa ocorrer com frequência suficiente.**

**Benchmarks:**
- **Diário ou mais**: Hábito forte (Instagram, Slack, Email)
- **Semanal**: Hábito moderado (LinkedIn, Fitness apps)
- **Mensal ou menos**: Difícil formar hábito (Airbnb, Booking)

**Para SaaS:**
- Idealmente, criar razões para uso diário
- Se não diário, pelo menos semanal
- Mais frequência = mais chances de loop Hooked rodar

### Vitamin vs. Painkiller

**Painkiller (Analgésico):**
- Resolve dor óbvia
- Necessidade clara
- Usuário sabe que precisa
- Exemplo: CRM para vendedor, Slack para time remoto

**Vitamin (Vitamina):**
- Melhoria agradável
- "Nice to have"
- Benefício não tão claro
- Exemplo: Fitness trackers, alguns social apps

**Hooked funciona melhor com Painkiller que resolve dor EMOCIONAL frequente.**

**Ideal:** Produto que é Painkiller (dor clara) E cria hábito (frequência + loop).

---

## Considerações Éticas

Nir Eyal enfatiza o **"Manipulation Matrix"**:

|                    | Criador USA o produto | Criador NÃO USA |
|--------------------|----------------------|-----------------|
| **Melhora vida**   | **FACILITATOR** ✅   | PEDDLER ⚠️      |
| **Não melhora**    | ENTERTAINER 🤷       | DEALER ❌       |

**Facilitator (Ideal):**
- Você usa o próprio produto
- Genuinamente melhora vida dos usuários
- Exemplo: Ferramenta que você mesmo precisa

**Peddler (Cuidado):**
- Você não usa
- Mas acredita que melhora vidas
- Risco: Não sentir impactos negativos

**Entertainer (Questionável):**
- Você usa
- Mas não melhora vidas (só entretém)
- Não é necessariamente mal

**Dealer (Evitar):**
- Você não usa
- Sabe que não melhora vidas
- Puramente exploratório

**Princípio Ético:**
> Só construa loops de hábito em produtos que genuinamente melhoram a vida dos seus usuários.

---

## Aplicação do Framework Hooked em SaaS

### Dashboard/Analytics Products

**Trigger:**
- Externo: Email semanal "Seu report está pronto"
- Interno: Ansiedade ("Preciso ver os números")

**Action:**
- Abrir dashboard (fácil, um clique)

**Variable Reward:**
- **Hunt**: Insights inesperados, anomalias detectadas
- **Self**: Ver progresso, bater metas
- **Tribe**: Compartilhar vitórias com time

**Investment:**
- Criar dashboards customizados
- Configurar alertas personalizados
- Adicionar integrações de fontes de dados
- Convidar membros do time

### CRM/Sales Tools

**Trigger:**
- Externo: "Prospect X abriu seu email 3x"
- Interno: Ansiedade ("Devo follow-up?"), medo (perder deal)

**Action:**
- Checar pipeline, ver atividades

**Variable Reward:**
- **Hunt**: Novo lead quente, deal progrediu
- **Tribe**: Ver quem do time fechou deal
- **Self**: Aproximar da cota, completar tarefas

**Investment:**
- Adicionar notas em contatos
- Atualizar stage de deals
- Importar contatos
- Convidar time de vendas

### Project Management Tools

**Trigger:**
- Externo: "3 tarefas atribuídas a você"
- Interno: Ansiedade (deadlines), medo (atrasar projeto)

**Action:**
- Abrir ferramenta, ver tarefas

**Variable Reward:**
- **Hunt**: Descobrir atualizações de colegas
- **Self**: Completar tarefas (satisfação), ver progresso
- **Tribe**: Reconhecimento de conclusão

**Investment:**
- Criar novos projetos, tarefas
- Adicionar contexto, anexos
- Convidar colaboradores
- Customizar workflows

---

## Diagnóstico de Loops de Hábito Fracos

### Perguntas para Cada Fase

**Trigger:**
- [ ] Qual dor emocional frequente nosso produto resolve?
- [ ] Usuários pensam em nós quando sentem essa dor?
- [ ] Temos owned triggers funcionando (email, push)?
- [ ] Com que frequência acionamos triggers?

**Action:**
- [ ] Quantos cliques/steps para usuário ter valor?
- [ ] É mais fácil que alternativas?
- [ ] Onboarding é simples ou complexo?
- [ ] Temos defaults inteligentes?

**Variable Reward:**
- [ ] Que tipo de recompensa oferecemos? (Tribe/Hunt/Self)
- [ ] A recompensa é variável ou sempre igual?
- [ ] Usuário sai satisfeito MAS querendo mais?
- [ ] Há surpresas positivas?

**Investment:**
- [ ] O que usuário adiciona que melhora próxima visita?
- [ ] Stored value aumenta com tempo?
- [ ] Switching cost aumenta com uso?
- [ ] Pedimos investment APÓS recompensa?

### Red Flags Comuns

**❌ Trigger Fraco:**
- "Só usam quando lembram"
- "Dependemos de emails que ninguém abre"
- Não há trigger interno (emoção) associado

**❌ Action Difícil:**
- Onboarding longo e complexo
- Muitos cliques para valor
- "Precisa de treinamento"

**❌ Reward Previsível:**
- Experiência é sempre igual
- Não há variabilidade
- "Depois de usar uma vez, já vi tudo"

**❌ Sem Investment:**
- Produto não melhora com uso
- Usuário não adiciona nada de valor
- Fácil trocar de ferramenta (baixo switching cost)

---

## Estratégias de Retenção Específicas

### 1. Aumentar Frequência de Triggers Internos

**Táticas:**
- Mapear emoções-chave da persona
- Criar associação forte entre emoção e produto
- Multi-trigger: diferentes emoções → mesmo produto

**Exemplo:**
- Ansiedade + Incerteza + Medo → Checar dashboard

### 2. Reduzir Fricção da Action

**Táticas:**
- Progressive onboarding (não tudo de uma vez)
- Smart defaults (já vem configurado)
- Empty states que guiam próxima ação
- Mobile app (reduzir fricção de acesso)
- Integrar com workflow existente

### 3. Injetar Variabilidade nas Rewards

**Táticas:**
- Insights inesperados, não apenas reports fixos
- Surpresas positivas ("Você bateu recorde!")
- Gamificação (badges variados)
- Social elements (ver atividade de outros)
- Personalização (cada usuário vê coisas diferentes)

### 4. Maximizar Opportunities de Investment

**Táticas:**
- Múltiplos tipos de investment (dados, tempo, social, $)
- Timing correto (pós-recompensa)
- Make it easy (não deve ser fricção)
- Mostrar valor do investment ("Salvar vai deixar próxima vez mais rápida")

### 5. Acelerar o Loop

**Táticas:**
- Reduzir tempo entre Investment → próximo Trigger
- Notificações inteligentes (não spam)
- Criar razões para voltar diariamente
- Weekly/monthly rituals

---

## Métricas de Hábito

### Habit Testing Score

**Pergunta:** "Como você se sentiria se não pudesse mais usar [produto]?"

Respostas:
- **Muito desapontado** = Hábito forte
- **Somewhat desapontado** = Hábito fraco
- **Não importa** = Sem hábito

**Benchmark:** 40%+ "Muito desapontado" = Product-Market Fit forte

### Frequência de Uso

- % usuários que retornam diariamente (DAU/MAU)
- % usuários em streak de X dias
- Tempo médio até retornar

### Velocidade dos Loops

- Tempo médio de cada loop completo
- Número de loops por usuário por semana
- % usuários que completam loop (não abandonam)

### Profundidade de Investment

- % usuários que fazem pelo menos 1 investment
- Número médio de investments por usuário
- Correlation entre investments e retenção

### Retenção Cohort

- D1, D7, D30 retention
- Curva de retenção achata? (hábito formado)
- Cohorts recentes retêm melhor? (produto melhorando)

---

## Caso de Estudo: Slack

**Perfeito exemplo de produto Hooked para B2B.**

**Trigger:**
- **Externo inicial**: Convite de colega (relationship)
- **Interno**: Ansiedade ("Estou perdendo mensagens?"), FOMO

**Action:**
- Extremamente fácil: notificação → um clique → mensagem
- Mobile + Desktop = sempre acessível

**Variable Reward:**
- **Hunt**: Próxima mensagem pode ser importante (variável)
- **Tribe**: Menções, reações, reconhecimento social
- **Self**: Completar conversas, resolver issues

**Investment:**
- Criar channels (stored value)
- Adicionar integrações (switching cost alto)
- Histórico de conversas (valor acumula)
- Convidar mais pessoas (network effect)
- Customizar (bots, workflows)

**Loop se fecha:**
- Quanto mais invisto (channels, integrations), mais notificações relevantes recebo
- Cada investment gera novos triggers

**Resultado:**
- Altíssima frequência (dezenas de vezes/dia)
- Forte hábito (muito difícil sair)
- Expansão natural (equipe inteira entra)

---

## Implementação Prática

### Phase 1: Audit Atual (Semana 1-2)

1. Mapear loop Hooked atual do seu produto
2. Identificar onde cada fase está fraca
3. Priorizar maior gap

### Phase 2: Hypothesis (Semana 2-3)

1. Para cada fase fraca, gerar hipóteses de melhoria
2. Priorizá-las por impacto esperado vs. esforço
3. Definir métricas de sucesso

### Phase 3: Experiment (Semana 4-8)

1. Implementar top 3 hipóteses
2. A/B test quando possível
3. Medir impacto em retention

### Phase 4: Iterate (Ongoing)

1. Analisar resultados
2. Double down no que funciona
3. Kill o que não move a agulha
4. Repetir

---

## Resumo Executivo

**Para criar produto formador de hábitos:**

1. **Identifique trigger interno** (emoção frequente)
2. **Facilite action** ao máximo (remover fricção)
3. **Injete variabilidade nas rewards** (surpreender)
4. **Crie opportunities de investment** (stored value)
5. **Feche o loop** (investment → próximo trigger)
6. **Aumente frequência** (diário > semanal > mensal)
7. **Meça retenção cohort** (curva achata = hábito)
8. **Seja ético** (só construa o que melhora vidas)

**Meta Final:**
Quando usuário sente [emoção], automaticamente pensa no seu produto como solução. Sem pensar. Por hábito.
