# Framework de Análise de Conteúdo LinkedIn

## Análise Estrutural de Posts

### Hook Analysis (Score 0-10)

Avaliar a força do hook baseado em:

**Critérios de Avaliação:**
- **Parada de scroll** (0-3 pontos): Para a atenção nos primeiros 2 segundos?
- **Especificidade** (0-3 pontos): É específico ou genérico demais?
- **Emoção/Curiosidade** (0-2 pontos): Gera reação emocional ou curiosidade?
- **Clareza** (0-2 pontos): Está claro sobre o que é o post?

**Tipos de Hook:**
- Pergunta provocativa
- Estatística surpreendente
- Afirmação controversa
- História pessoal
- Promessa de valor
- Identificação com dor
- Curiosidade (gap de informação)

**Exemplo de Análise:**
```
Hook Original: "Você quer ser mais produtivo?"
Score: 2/10
- Parada de scroll: 0/3 (genérico demais)
- Especificidade: 0/3 (não há especificidade)
- Emoção: 1/2 (pergunta clichê)
- Clareza: 1/2 (muito vago)

Hook Melhorado: "Trabalho 4 horas por dia e fecho mais negócios que quando trabalhava 12h."
Score: 8/10
- Parada de scroll: 3/3 (contraintuitivo)
- Especificidade: 3/3 (números específicos)
- Emoção: 2/2 (curiosidade forte)
- Clareza: 0/2 (não fica claro de cara o tema)
```

### Body Structure Analysis

**Elementos a Avaliar:**

1. **Clareza da Mensagem Central**
   - Há uma ideia principal clara?
   - Leitor consegue resumir em 1 frase?
   - Foco está mantido ou disperso?

2. **Tipo de Conteúdo**
   - Storytelling (narrativa pessoal)
   - Informacional (dicas, listas, frameworks)
   - Opinião (hot take, contrarian)
   - Case study (resultados, análise)
   - Misto (híbrido de tipos)

3. **Ritmo e Espaçamento**
   - Parágrafos curtos (1-3 linhas)?
   - Quebras estratégicas a cada 3-4 linhas?
   - Uso de linhas em branco para respiração?
   - Nunca blocos de texto > 5 linhas?

4. **Comprimento**
   - Curto (200-400 chars): ideal para insights rápidos
   - Médio (500-800 chars): storytelling pessoal
   - Longo (1000-1500 chars): análises profundas
   - Muito longo (>1500 chars): apenas se valor excepcional

5. **Elementos Visuais**
   - Uso de símbolos (→ ✓ •)
   - Listas numeradas ou bullet points
   - Negrito em conceitos-chave (quando aplicável)
   - Emojis (máximo 3-5, uso estratégico)

### Call-to-Action Analysis

**Tipos de CTA:**
- Pergunta aberta específica
- Pergunta de experiência pessoal
- Convite a debate/discordância
- Pedido de ação (salvar, compartilhar)
- Oferta (recurso, template, guia)
- Continuação (interesse em mais sobre X)

**Critérios de Qualidade (0-10):**
- **Especificidade** (0-4): Pergunta específica ou genérica?
- **Facilidade de responder** (0-3): Fácil ou exige muito esforço?
- **Alinhamento** (0-3): Alinhado com conteúdo do post?

**CTAs Ruins (evitar):**
- "Concorda?"
- "Thoughts?"
- "O que acham?"
- "Deixe seu like"
- Qualquer CTA genérico

**CTAs Bons:**
- "Qual dessas técnicas você já usa?"
- "Você já passou por situação similar?"
- "Discorda? Me diga onde meu raciocínio falha."
- "Comenta 'GUIA' que te envio o material completo"

## Análise de Performance

### Métricas Primárias

**1. Impressões**
- Total de vezes que o post foi visto
- Indica alcance bruto
- Influenciado por: tamanho da rede, engajamento inicial, algoritmo

**2. Engagement Rate**
```
ER = (Reações + Comentários + Compartilhamentos) / Impressões × 100
```

**Benchmarks:**
- <1%: precisa melhorar significativamente
- 1-2%: abaixo da média
- 2-4%: média saudável
- 4-6%: acima da média
- >6%: excelente performance

**3. Comment-to-Like Ratio**
```
CLR = Comentários / Reações × 100
```

**Benchmarks:**
- <5%: conteúdo raso (reação rápida, sem reflexão)
- 5-10%: média
- 10-15%: bom engajamento
- >15%: excelente qualidade de conversa

**4. Share Rate**
```
SR = Compartilhamentos / Impressões × 100
```

**Importância:** Compartilhamentos têm peso MUITO alto no algoritmo.
- >0.5%: conteúdo valioso
- >1%: conteúdo excepcional

**5. Profile Clicks**
- Quantas pessoas visitaram seu perfil após o post
- Indica interesse no criador, não apenas no conteúdo
- Pode levar a novos seguidores

### Diagnóstico de Performance

**Cenário 1: Alto Alcance, Baixo Engajamento**
- **Problema:** Hook forte mas conteúdo raso, ou clickbait
- **Solução:** Aprofundar insights, entregar valor real prometido no hook

**Cenário 2: Baixo Alcance, Alto Engajamento**
- **Problema:** Conteúdo bom, mas algoritmo não distribuiu (hook fraco ou timing ruim)
- **Solução:** Melhorar hook, testar horários diferentes, warm up antes de postar

**Cenário 3: Muitos Likes, Poucos Comentários**
- **Problema:** Conteúdo agradável mas não provoca reflexão/conversa
- **Solução:** CTA mais específico, conteúdo mais provocativo/profundo

**Cenário 4: Poucos Likes, Muitos Comentários**
- **Problema:** Conteúdo polarizante ou confuso
- **Solução:** Analisar sentimento dos comentários (positivo/negativo)

**Cenário 5: Performance Consistentemente Baixa**
- **Problema:** Posicionamento não claro, conteúdo genérico, ou audiência errada
- **Solução:** Redefinir pilares, estudar audiência, analisar concorrentes

### Análise Qualitativa de Comentários

**O que buscar:**

**Sinais Positivos:**
- Comentários longos (>20 palavras)
- Pessoas compartilhando experiências pessoais
- Debate construtivo
- Perguntas de aprofundamento
- Pedidos de mais conteúdo sobre o tema
- Menções/tags de outras pessoas

**Sinais Negativos:**
- Comentários genéricos ("Great post!", "Thanks for sharing")
- Emojis sem texto
- Spam ou autopromoção
- Críticas destrutivas
- Silêncio total (sem comentários)

**Ação:** Comentários genéricos indicam que conteúdo não provocou reflexão real.

## Framework Completo de Avaliação de Post

Usar este framework para analisar qualquer post:

```
POST ANALYSIS REPORT

═══════════════════════════════════════

1. HOOK ANALYSIS
   Score: __/10
   Tipo: [identificar]
   Pontos Fortes:
   - [listar]
   Oportunidades:
   - [listar]
   Sugestão de Hook Alternativo:
   "[reescrever]"

2. STRUCTURE ANALYSIS
   Formato: [listicle/story/framework/opinion/case]
   Comprimento: [ideal/longo/curto]
   Espaçamento: [adequado/precisa ajuste]

   Mensagem Central:
   "[resumir em 1 frase]"

   Pontos Fortes:
   - [listar]

   Oportunidades:
   - [listar]

3. CONTENT QUALITY
   Clareza: __/10
   "[justificativa]"

   Valor Entregue: __/10
   "[justificativa]"

   Originalidade: __/10
   "[justificativa]"

   Storytelling: [presente/ausente/parcial]
   "[comentário]"

4. CTA ANALYSIS
   Score: __/10
   Tipo: [identificar]
   Especificidade: __/4
   Facilidade: __/3
   Alinhamento: __/3

   Sugestão de CTA Alternativo:
   "[reescrever]"

5. FORMATTING
   Espaçamento Visual: [✓ / precisa ajuste]
   Uso de Símbolos: [✓ / ausente / excessivo]
   Legibilidade: [✓ / precisa melhoria]
   Hashtags: [presentes / ausentes / inadequadas]

6. PERFORMANCE ANALYSIS (se dados disponíveis)
   Impressões: [número]
   Engagement Rate: [%] - [classificação]
   Comment/Like Ratio: [%] - [classificação]
   Shares: [número] - [classificação]

   Diagnóstico:
   "[análise de cenário]"

   Algoritmo Favoreceu: [SIM / NÃO]
   Razão: "[explicação]"

7. OVERALL ASSESSMENT
   Score Geral: __/10

   Top 3 Pontos Fortes:
   1. [ponto]
   2. [ponto]
   3. [ponto]

   Top 3 Oportunidades:
   1. [oportunidade]
   2. [oportunidade]
   3. [oportunidade]

   Recomendação: [manter / ajustar / reescrever]

   Performance Estimada: [baixa / média / alta]
   Razão: "[justificativa]"

8. ACTIONABLE INSIGHTS
   O que replicar em futuros posts:
   - [insight]
   - [insight]

   O que evitar:
   - [insight]
   - [insight]

   Próximos passos sugeridos:
   1. [ação]
   2. [ação]
   3. [ação]

═══════════════════════════════════════
```

## Identificação de Padrões

Após analisar 10-20 posts, identificar:

**Padrões de Sucesso:**
- Quais temas geram mais engajamento?
- Quais formatos performam melhor?
- Qual tom de voz ressoa mais?
- Quais horários têm melhor performance?
- Quais tipos de hook funcionam melhor?
- Quais CTAs geram mais comentários?

**Padrões de Baixa Performance:**
- Quais temas não ressoam?
- Quais formatos a audiência ignora?
- Quais erros se repetem?
- Há algum padrão de timing ruim?

**Documentação:**
Manter planilha ou documento com:
- Data do post
- Tema/tópico
- Formato usado
- Hook type
- Métricas principais
- Observações qualitativas

Isso permite decisões baseadas em dados, não intuição.
