# Cadência e Rituais de OKRs

Guia completo sobre ciclos, check-ins, reviews e retrospectivas de OKRs.

---

## 🔄 Ciclos de OKRs

### Ciclo Trimestral (Recomendado)

**Duração**: 13 semanas (1 trimestre)

**Por que trimestral**:
- ✅ Tempo suficiente para impacto real
- ✅ Curto o suficiente para manter foco
- ✅ Alinha com ano fiscal (Q1, Q2, Q3, Q4)
- ✅ Permite 4 iterações por ano

**Quando usar**:
- Startups em growth stage (post-PMF)
- Empresas estabelecidas
- Times com processos maduros

---

### Ciclo Mensal ou 6 Semanas (Alternativo)

**Quando usar**:
- Early-stage startups (pré-PMF)
- Contexto de alta incerteza
- Pivots frequentes

**Vantagens**:
- Feedback mais rápido
- Maior flexibilidade
- Ajustes mais frequentes

**Desvantagens**:
- Menos tempo para impacto profundo
- Overhead de planejamento (12x/ano)

---

### Ciclo Anual (Strategic)

**Quando usar**:
- Company-level vision
- OKRs estratégicos de longo prazo
- Empresas maduras

**Estrutura recomendada**:
```
ANUAL (Strategic)
  ↓
TRIMESTRAL (Execution)
  ↓
MENSAL (Check-ins)
  ↓
SEMANAL (Progresso)
```

---

## 📅 Timeline de um Ciclo Trimestral

### Semana -2: Planejamento de Liderança

**Quem**: CEO + Leadership Team

**Atividades**:
1. **Review do trimestre anterior**:
   - Scoring final de OKRs
   - Análise de sucessos e falhas
   - Learnings capturados

2. **Análise de contexto estratégico**:
   - Mudanças de mercado
   - Feedback de clientes
   - Métricas de saúde do negócio
   - Prioridades do board

3. **Draft de Company OKRs**:
   - 3-5 Objectives
   - 3-5 KRs por Objective
   - Alinhamento com visão anual

**Output**: Company OKRs draft (80% pronto)

---

### Semana -1: Planejamento de Times

**Quem**: Heads de área + Times

**Atividades**:

**Segunda-feira**:
- Leadership apresenta Company OKRs draft
- Q&A sobre contexto estratégico
- Direcionamento para times

**Terça a Quinta**:
- Times propõem seus OKRs alinhados
- 60% alinhados com Company
- 40% iniciativas bottom-up
- Validação com head de área

**Sexta-feira**:
- **OKR Review Session** (toda empresa):
  - Cada time apresenta seus OKRs
  - Identificação de dependências
  - Ajustes de alinhamento
  - Finalização

**Output**: Todos OKRs publicados e comunicados

---

### Semanas 1-6: Primeira Metade do Trimestre

#### Check-ins Semanais (toda segunda-feira)

**Formato**: 15-30 minutos

**Agenda**:
1. Progresso em cada KR (score atual 0.0-1.0)
2. Confidence rating:
   - 🟢 On track
   - 🟡 At risk
   - 🔴 Off track
3. Blockers e dependências
4. Ações da semana

**Template**:
```
Week 3 of 13 | 20/Jan/2024

KR1: Crescer MRR de R$100k para R$300k
├─ Score atual: 0.25 (R$150k)
├─ Confidence: 🟢 On track
└─ Update: 8 novos clientes, pipeline forte

KR2: Atingir NPS 50+
├─ Score atual: 0.15 (NPS 38)
├─ Confidence: 🟡 At risk
├─ Blocker: Bug crítico afetou experiência
└─ Action: Fix programado para sexta

KR3: Alcançar retention 90%+
├─ Score atual: 0.50 (retention 85%)
├─ Confidence: 🟢 On track
└─ Update: Onboarding melhorado ajudou
```

#### Monthly Business Review (Fim do Mês 1 e 2)

**Quem**: Leadership + Stakeholders

**Duração**: 1-2 horas

**Agenda**:
1. Progresso geral em Company OKRs
2. Deep dive em 1-2 OKRs críticos
3. Decisões estratégicas se necessário
4. Realocação de recursos se needed

---

### Semana 7: Mid-Quarter Review

**Timing**: Metade do trimestre

**Por que fazer**:
- Revisar se OKRs ainda fazem sentido
- Ajustar se contexto mudou drasticamente
- Refocalizar energia em OKRs mais críticos

**Agenda** (2 horas, all-hands):

1. **Progresso geral** (30min):
   - Company OKRs: onde estamos?
   - Quais OKRs on track vs at risk?

2. **Deep dives** (60min):
   - 2-3 OKRs com maior risco
   - Root cause analysis
   - Plano de ação para recuperar

3. **Decisões** (30min):
   - Manter todos OKRs? Ou ajustar?
   - Alocar recursos diferentes?
   - Deprecar algum OKR?

**Possíveis outcomes**:
- ✅ **Manter todos OKRs**: Contexto estável
- ⚠️ **Ajustar KRs**: Metas muito agressivas/conservadoras
- ⚠️ **Adicionar/remover OKR**: Prioridades mudaram
- ❌ **Deprecar todos**: Pivot estratégico (raro)

---

### Semanas 8-12: Segunda Metade

**Foco**: Execução acelerada

#### Check-ins Semanais (continuam)

Igual ao formato anterior, mas com mais urgência:

**Adições**:
- **Sprint final planning**: O que fazer nas últimas 5 semanas?
- **Re-priorização**: Focar em OKRs mais críticos
- **Kill tasks**: Cortar o que não contribui para OKRs

#### Weekly Sprint (opcional)

Para OKRs at-risk:
```
Segunda: Planejar sprint da semana focado no KR
Sexta: Demo/review de progresso
```

---

### Semana 13: Fechamento e Retrospectiva

**Segunda a Quarta: Scoring**

**Cada time calcula scores**:
```
Para cada KR:
Score = Progresso real / Meta estabelecida

Exemplo:
KR: Crescer MRR de R$100k para R$300k
Meta = +R$200k
Progresso real = +R$140k
Score = 140/200 = 0.70 ✅
```

**Para cada Objective**:
```
Score do O = Média dos scores dos KRs
```

**Quinta: OKR Review (all-hands, 2 horas)**

**Agenda**:

1. **Company OKRs Results** (30min):
   - CEO apresenta scores finais
   - Celebra sucessos
   - Reconhece esforços (não apenas resultados)

2. **Team OKRs Highlights** (60min):
   - Cada time compartilha (5-7min):
     - O que funcionou?
     - O que não funcionou?
     - Key learning

3. **Retrospectiva** (30min):
   - Como foi o processo de OKR?
   - O que melhorar no próximo ciclo?
   - Capturar aprendizados

**Sexta: Documentação**

- Finalizar grading
- Documentar learnings
- Arquivar OKRs do trimestre
- Preparar inputs para próximo ciclo

---

## 🎯 Formatos de Check-in

### 1. Check-in Assíncrono (Escrito)

**Ferramenta**: Notion, Google Docs, Slack

**Frequência**: Semanal (toda segunda)

**Template**:
```markdown
# Week 5 of 13 | Q1 2024

## KR1: [descrição]
**Score atual**: 0.35 / 0.70 (target)
**Confidence**: 🟢 On track
**Update**: [2-3 linhas de progresso]
**Next steps**: [bullet points]

## KR2: [descrição]
**Score atual**: 0.20 / 0.70 (target)
**Confidence**: 🟡 At risk
**Blocker**: [descrição do bloqueio]
**Ask**: [ajuda necessária]
**Action plan**: [plano para desbloquear]

## Overall
**Top priority this week**: [foco da semana]
**Risks**: [riscos principais]
```

**Vantagens**:
- Rápido (10-15min)
- Documentado automaticamente
- Time pode ler no próprio ritmo

---

### 2. Check-in Síncrono (Meeting)

**Frequência**: Semanal (15-30min)

**Estrutura**:

**Opening (2min)**:
- Quick wins da semana

**KR by KR Review (10-20min)**:
```
Para cada KR:
1. Score atual (número)
2. Trend: ↗️ melhorando, → estável, ↘️ piorando
3. Blocker? Action plan?
```

**Closing (5min)**:
- Prioridade #1 da próxima semana
- Asks (ajuda necessária)

---

### 3. Check-in Híbrido (Recomendado)

**Formato**:
1. **Segunda de manhã**: Check-in escrito (assíncrono)
2. **Segunda à tarde**: Meeting rápido (15min) apenas para:
   - KRs 🟡 at risk ou 🔴 off track
   - Blockers que precisam decisão
   - Alinhamento rápido

**Vantagens**:
- Eficiência (escrito cobre maioria)
- Foco (meeting só para críticos)
- Documentação automática

---

## 🎬 Rituais por Nível

### Company-Level

**Mensal**:
- Monthly Business Review (MBR)
  - Progresso em Company OKRs
  - Decisões estratégicas

**Mid-Quarter**:
- Mid-Quarter Review (all-hands)
  - Ajustes de rota se necessário

**Fim de Ciclo**:
- OKR Review & Retrospective (all-hands)
  - Scoring, learnings, celebração

---

### Team-Level

**Semanal**:
- Team Check-in (15-30min)
  - Progresso, blockers, ações

**Bi-semanal** (opcional):
- Deep dive em 1 KR
  - Análise detalhada de progresso
  - Tática de execução

**Fim de Ciclo**:
- Team Retrospective
  - O que melhorar no processo

---

### Individual-Level (se aplicável)

**Semanal**:
- 1:1 com manager
  - Progresso em OKRs individuais
  - Alinhamento com Team OKRs

**Fim de Ciclo**:
- Performance conversation (desacoplado de score de OKR)

---

## 📊 Dashboard e Tracking

### Métricas para Acompanhar

```
SAÚDE DOS OKRs:
├─ % de OKRs on track (target: >60%)
├─ % de OKRs at risk (flag se >30%)
├─ % de OKRs off track (flag se >20%)
└─ Trend semanal (melhorando/piorando)

PROCESSO:
├─ % de check-ins completados (target: 100%)
├─ Tempo médio de check-in (target: <20min)
└─ Engagement em rituais (presença, participação)
```

### Dashboard Simples (Google Sheets)

```
| OKR | Owner | Score | Confidence | Week 1 | Week 2 | ... | Week 13 |
|-----|-------|-------|------------|--------|--------|-----|---------|
| O1  | Time  | 0.65  | 🟢         | 0.05   | 0.12   | ... | 0.65    |
|  KR1| Jane  | 0.70  | 🟢         | 0.10   | 0.15   | ... | 0.70    |
|  KR2| John  | 0.60  | 🟡         | 0.05   | 0.10   | ... | 0.60    |
```

---

## 🔍 Mid-Quarter Review: Deep Dive

### Preparação (antes do meeting)

**Cada time prepara**:
1. Scores atuais de todos KRs
2. Análise de KRs at risk:
   - Por que está at risk?
   - O que tentamos?
   - O que precisamos mudar?
3. Proposta de ação ou ajuste

**Liderança analisa**:
- Quais OKRs precisam atenção?
- Há padrões? (ex: todos Marketing OKRs at risk)
- Recursos precisam ser realocados?

---

### Agenda do Meeting (2 horas)

**Parte 1: Overview (30min)**

CEO apresenta:
```
Company OKRs - Mid-Quarter Status

O1: [Objective] | Score: 0.35 | 🟢 On track
  KR1: 0.40 🟢
  KR2: 0.30 🟡
  KR3: 0.35 🟢

O2: [Objective] | Score: 0.20 | 🟡 At risk
  KR1: 0.15 🔴
  KR2: 0.20 🟡
  KR3: 0.25 🟢

Overall: 2/3 OKRs on track, 1 needs attention
```

**Parte 2: Deep Dives (60min)**

Para cada OKR 🟡 at risk ou 🔴 off track:

**Framework 5 Whys**:
```
KR: Crescer MRR de R$100k para R$300k
Status: R$130k (+R$30k, esperava +R$100k)

Por quê estamos atrás?
→ Pipeline está fraco

Por quê pipeline está fraco?
→ Marketing não está gerando MQLs suficientes

Por quê Marketing não está gerando MQLs?
→ SEO não decolou como esperado

Por quê SEO não decolou?
→ Conteúdo não está ranqueando

Ação: Contratar consultor SEO externo (decisão: sim/não?)
```

**Parte 3: Decisões (30min)**

Para cada OKR at risk:
- [ ] Manter como está (aceitar score menor)
- [ ] Alocar mais recursos (pessoas, budget)
- [ ] Ajustar meta (se contexto mudou)
- [ ] Deprecar OKR (se não faz mais sentido)

---

## 🏆 End-of-Quarter Review

### Scoring Rigoroso

**Regras**:
1. **Seja objetivo**: Score = progresso real / meta
2. **Não arredonde para cima**: 0.68 é 0.68, não 0.7
3. **Celebre 0.6-0.7**: É sucesso! (stretch goal)
4. **Questione 1.0 consistente**: Sandbagging?
5. **Não puna 0.3-0.5**: Esforço ambicioso, aprendizado valioso

**Exemplo de Scoring**:
```
O1: Atingir product-market fit | Score: 0.63

  KR1: Crescer MRR de R$100k para R$300k
    Target: +R$200k
    Real: +R$140k
    Score: 140/200 = 0.70 ✅

  KR2: Atingir NPS 50+
    Target: 50
    Baseline: 30
    Real: 42
    Score: (42-30)/(50-30) = 12/20 = 0.60 ✅

  KR3: Alcançar retention 90%+
    Target: 90%
    Baseline: 75%
    Real: 85%
    Score: (85-75)/(90-75) = 10/15 = 0.67 ✅

  O1 Score: (0.70 + 0.60 + 0.67) / 3 = 0.66 🎉
```

---

### Retrospectiva Estruturada

**Framework: 4 Ls**

**1. Loved (O que amamos)**:
```
- Check-ins semanais mantiveram foco
- Transparência de OKRs ajudou alinhamento
- Mid-quarter review salvou KR que estava off track
```

**2. Learned (O que aprendemos)**:
```
- Subestimamos tempo de SEO (6 meses, não 3)
- Freemium conversion é mais difícil que pensávamos
- Partnership com X foi game-changer inesperado
```

**3. Lacked (O que faltou)**:
```
- Recursos de Engineering foram bottleneck
- Dados de Analytics atrasaram decisões
- Comunicação entre Sales e Product falhou
```

**4. Longed for (O que gostaríamos)**:
```
- Contratar PM adicional
- Automatizar tracking de OKRs
- Fazer check-ins mais curtos (10min vs 30min)
```

---

### Captura de Learnings

**Template de Learning**:
```markdown
## Learning #1: SEO leva 6+ meses, não 3 meses

**Contexto**: KR era "Crescer tráfego orgânico de 5k para 20k/mês"
Score: 0.35 (atingimos apenas 10k)

**O que aprendemos**:
- Google leva 4-6 meses para rankear conteúdo novo
- Autoridade de domínio é fator crítico (não tínhamos)
- Backlinks são mais importantes que pensávamos

**O que faremos diferente**:
- Próximo trimestre: KR será "Publicar 30 artigos + conseguir 50 backlinks"
- Contratar consultor SEO para acelerar
- Medir progresso em leading indicators (artigos, backlinks) não apenas tráfego

**Aplicável a**: Marketing, Product (SEO de produto)
```

---

## 📈 Otimizando Rituais ao Longo do Tempo

### Trimestre 1: Aprendendo

**Foco**: Entender mecânica
- Check-ins podem ser longos (30-45min)
- Mid-quarter review pode ser caótico
- Scoring final é processo manual

**É normal**: Overhead alto, insegurança

---

### Trimestre 2-3: Iterando

**Foco**: Eficiência
- Check-ins ficam mais rápidos (15-20min)
- Facilitação melhora (menos tangentes)
- Templates e processos são refinados

**Melhorias típicas**:
- Adotar check-ins assíncronos
- Dashboard automático
- Rituais mais estruturados

---

### Trimestre 4+: Maduro

**Foco**: Cultura incorporada
- Check-ins: 10-15min, alta qualidade
- Rituais fluem naturalmente
- OKRs viraram "sistema operacional" da empresa

**Sinais de maturidade**:
- Time PEDE OKRs (não resiste)
- Decisões são tomadas com base em OKRs
- Ambição natural (não precisa forçar stretch goals)

---

## 🛠️ Ferramentas e Automação

### Tools para Tracking

**Simples (Free)**:
- Google Sheets
- Notion
- Asana

**Dedicadas (Paid)**:
- Gtmhub (enterprise)
- Perdoo (mid-market)
- Weekdone (startups)
- 15Five
- Lattice

**Integrações**:
- Slack (notificações de check-ins)
- Jira (link de projetos a OKRs)
- Analytics tools (auto-update de KRs)

---

### Automações Úteis

**Check-in Reminder**:
```
Slack bot (toda segunda 9am):
"Reminder: Weekly OKR check-in! Post update no #okr-checkins"
```

**Dashboard Auto-Update**:
```
KR: Crescer MRR de R$100k para R$300k
└─ Puxa automaticamente de Stripe API
└─ Atualiza score real-time
```

**Confidence Tracking**:
```
Survey semanal:
"Qual sua confidence de atingir cada KR? (1-5)"
└─ Identifica early warning signs
```

---

**Próximos guias**:
- [okr-common-mistakes.md](okr-common-mistakes.md) - Erros comuns e como evitar
- [okr-examples-library.md](okr-examples-library.md) - 50+ exemplos reais
