# Erros Comuns em OKRs e Como Evitá-los

Guia completo dos 25+ erros mais comuns ao implementar OKRs e como corrigi-los.

---

## ❌ CATEGORIA 1: Erros de Escrita

### Erro #1: Confundir Objective com Key Result

**Problema**: Objective tem número (é métrica)

```
❌ Ruim:
O: Crescer MRR de R$100k para R$300k
└─ Isso é Key Result, não Objective

✅ Bom:
O: Construir base sustentável de receita recorrente
  KR1: Crescer MRR de R$100k para R$300k
  KR2: Atingir NRR de 110%+
  KR3: Reduzir churn de 5% para 2%
```

**Como evitar**: Se tem número, é KR. Objective é qualitativo.

---

### Erro #2: Key Results são outputs, não outcomes

**Problema**: KRs são tarefas/entregas, não resultados de negócio

```
❌ Ruim:
O: Melhorar produto
  KR1: Lançar feature de relatórios
  KR2: Fazer 20 entrevistas com usuários
  KR3: Redesenhar dashboard

✅ Bom:
O: Tornar produto indispensável para usuários
  KR1: Aumentar DAU/MAU de 25% para 45%
  KR2: Atingir NPS de 60+
  KR3: Reduzir churn de 8% para 3%
```

**Teste**: Pergunte "Por quê isso importa?" até chegar no outcome real.

---

### Erro #3: KRs não são mensuráveis

**Problema**: Impossível saber objetivamente se foi atingido

```
❌ Ruim:
KR1: Melhorar produto
KR2: Aumentar satisfação
KR3: Fortalecer brand

✅ Bom:
KR1: Atingir NPS de 50+
KR2: Alcançar retention de 90%+
KR3: Atingir 40% brand awareness (pesquisa)
```

**Regra**: Se não tem número, não é KR válido.

---

### Erro #4: Objectives vagos e não inspiradores

**Problema**: Não motiva, não direciona

```
❌ Ruim:
O: Melhorar a empresa
O: Fazer mais vendas
O: Ser melhor

✅ Bom:
O: Tornar-se a plataforma líder de CRM para PMEs no Brasil
O: Criar produto que usuários recomendam entusiasticamente
O: Construir engine de vendas previsível e escalável
```

---

### Erro #5: KRs que time não controla

**Problema**: Time não tem influência sobre o resultado

```
❌ Ruim (fora de controle):
KR: Atingir market share de 40%
└─ Depende muito de concorrentes

KR: Ser featured na TechCrunch
└─ Depende de decisão externa

✅ Bom (com controle):
KR: Crescer de 50 para 200 clientes pagantes
KR: Gerar 100 pitches para mídia, conseguir 10 publicações
```

---

## ❌ CATEGORIA 2: Erros de Ambição

### Erro #6: OKRs não são stretch goals (muito conservadores)

**Problema**: Score esperado é 1.0 (100%)

```
❌ Conservador demais:
Situação: Crescendo 10%/trimestre organicamente
KR: Crescer de R$100k para R$110k MRR (+10%)
└─ Apenas BAU, não desafia

✅ Stretch goal:
KR: Crescer de R$100k para R$180k MRR (+80%)
└─ Score esperado: 0.6-0.7
```

**Como evitar**: Pergunte "Temos 90%+ de certeza?" Se sim, aumente ambição.

---

### Erro #7: OKRs moonshot demais (impossíveis)

**Problema**: Score esperado <0.3, desmotiva time

```
❌ Moonshot demais:
Situação: Startup com R$50k MRR, 2 vendedores
KR: Crescer para R$1M MRR em 1 trimestre (+1900%)
└─ Impossível, frustra time

✅ Ambicioso mas possível:
KR: Crescer de R$50k para R$120k MRR (+140%)
└─ Score esperado: 0.6-0.7
```

---

### Erro #8: Sandbagging (metas fáceis de propósito)

**Problema**: Time define OKRs conservadores para garantir score 1.0

**Sinais**:
- Scores sempre 1.0 ou próximo
- Times não são desafiados
- Pouca inovação

**Como evitar**:
1. Celebrar scores 0.6-0.7 (não apenas 1.0)
2. Questionar scores 1.0 consistentes
3. Desacoplar OKRs de performance review

---

## ❌ CATEGORIA 3: Erros de Processo

### Erro #9: Muitos OKRs (falta de foco)

**Problema**: Time tem 10 Objectives, 50 Key Results

```
❌ Ruim:
8 Objectives
40 Key Results
└─ Dispersão total, nada é prioridade

✅ Bom:
3-5 Objectives
9-15 Key Results total
└─ Foco claro
```

**Regra**: Se tudo é prioridade, nada é prioridade.

---

### Erro #10: OKRs definidos top-down (sem buy-in)

**Problema**: Leadership define, jogapor cima do time

**Consequências**:
- Falta de ownership
- Time não se compromete
- Execução fraca

**Solução**: 60% top-down, 40% bottom-up
```
Leadership: Define direção estratégica (Company OKRs)
Times: Propõem COMO atingir (Team OKRs)
```

---

### Erro #11: OKRs são definidos e esquecidos

**Problema**: Sem check-ins, sem tracking

**Sinais**:
- Ninguém lembra dos OKRs na semana 3
- Sem rituais de acompanhamento
- OKRs ficam em documento de gaveta

**Solução**:
- Check-ins semanais (15-30min)
- Mid-quarter review
- Dashboard visível

---

### Erro #12: Não fazer mid-quarter review

**Problema**: Time descobre na semana 13 que falhou

**Consequência**: Sem chance de corrigir rota

**Solução**: Mid-quarter review (semana 6-7)
- Identificar OKRs at risk
- Ajustar táticas (ou OKRs se contexto mudou)
- Realocar recursos

---

### Erro #13: OKRs individuais não alinhados com Team

**Problema**: ICs trabalham em coisas fora dos OKRs do time

```
❌ Ruim:
Team OKR: Crescer MRR
IC OKR: Melhorar doc técnica
└─ Desalinhado

✅ Bom:
Team OKR: Crescer MRR de R$100k para R$300k
IC OKR (Sales): Aumentar win rate de 15% para 30%
└─ Contribui diretamente para Team OKR
```

---

## ❌ CATEGORIA 4: Erros de Alinhamento

### Erro #14: Sem cascata (silos)

**Problema**: Times não sabem como contribuem para Company OKRs

```
❌ Ruim:
Company OKRs ≠ Team OKRs
Times trabalham em paralelo, desalinhados

✅ Bom:
Company OKR: Atingir PMF
  ↓
Product OKR: Criar produto indispensável
Engineering OKR: Reduzir time-to-market
Sales OKR: Construir engine escalável
```

**Regra**: 60% dos Team OKRs devem alinhar com Company

---

### Erro #15: Duplicação de OKRs

**Problema**: Time apenas copia Company OKR

```
❌ Ruim (duplicação):
Company KR: Crescer MRR de R$100k para R$300k
Sales KR: Crescer MRR de R$100k para R$300k
└─ Time apenas repete

✅ Bom (contribuição):
Company KR: Crescer MRR de R$100k para R$300k
Sales KR: Aumentar win rate de 15% para 30%
Marketing KR: Crescer pipeline de 50 para 150 SQLs/mês
└─ Times contribuem com pedaços específicos
```

---

### Erro #16: Dependências não mapeadas

**Problema**: OKR do time depende de outro time, mas não foi coordenado

**Exemplo**:
```
Product OKR: Lançar feature X
Depende de: Engineering entregar API Y

Problema: Engineering não priorizou API Y
Resultado: Product OKR falha
```

**Solução**: OKR Planning Session
- Identificar dependências cross-team
- Alinhar prioridades
- Documentar explicitamente

---

## ❌ CATEGORIA 5: Erros de Cultura

### Erro #17: OKRs afetam bônus/promoção

**Problema**: Score baixo = punição

**Consequência**: Sandbagging (metas conservadoras)

**Solução**: Desacoplar completamente
```
OKR score 0.4 ≠ Performance ruim
Avalia-se: Esforço, qualidade, contribuição (não score final)
```

---

### Erro #18: Punir falhas em OKRs ambiciosos

**Problema**: Time tem medo de falhar, evita stretch goals

**Caso real**:
```
Time teve OKR ambicioso, score 0.35
Manager: "Vocês falharam, isso é inaceitável"
Próximo trimestre: Time define OKRs conservadores (score 1.0)
```

**Solução**: Celebrar aprendizado
```
"Score 0.35 em OKR ambicioso > Score 1.0 em OKR conservador"
Pergunte: "O que aprendemos?" não "Por que falhamos?"
```

---

### Erro #19: Falta de transparência

**Problema**: OKRs não são públicos

**Consequências**:
- Silos (times não sabem o que outros fazem)
- Desalinhamento
- Falta de accountability

**Solução**:
- Publicar todos OKRs (Company, Team, Individual)
- Acessível a todos (Notion, intranet)
- Apresentar em All-Hands

---

### Erro #20: Leadership não segue OKRs

**Problema**: CEO define OKRs mas não acompanha

**Sinais**:
- CEO toma decisões fora dos OKRs
- Prioriza projetos não relacionados
- "OKRs são para times, não para mim"

**Consequência**: Time não leva a sério

**Solução**: Leadership lidera pelo exemplo
- CEO tem OKRs (Company-level)
- Faz check-ins públicos
- Toma decisões baseadas em OKRs

---

## ❌ CATEGORIA 6: Erros de Métricas

### Erro #21: Usar apenas lagging indicators

**Problema**: KRs só têm resultados finais (revenue, customers)

```
❌ Só lagging:
KR1: Crescer MRR de R$100k para R$300k
KR2: Atingir 200 clientes
└─ Time tem pouco controle direto

✅ Mix leading + lagging:
KR1: Crescer MRR de R$100k para R$300k (lagging)
KR2: Aumentar pipeline de 50 para 150 SQLs/mês (leading)
KR3: Elevar win rate de 15% para 30% (leading)
```

---

### Erro #22: Métricas de vaidade

**Problema**: KRs focam em números que não importam

```
❌ Vaidade:
KR: Atingir 100k seguidores no Instagram
KR: Gerar 1M de impressões

✅ Impacto real:
KR: Gerar 5.000 MQLs via social media
KR: Atingir 20% de conversion de social → trial
```

---

### Erro #23: Não ter baseline

**Problema**: "Aumentar X" sem dizer DE ONDE

```
❌ Sem baseline:
KR: Aumentar NPS para 50+
└─ Aumentar de quanto? 10? 45?

✅ Com baseline:
KR: Aumentar NPS de 30 para 50+
└─ Claro progresso esperado
```

---

## ❌ CATEGORIA 7: Erros de Timing

### Erro #24: Ciclos muito longos (anual)

**Problema**: 12 meses é muito tempo, mundo muda

**Para startups**:
- Contexto muda rápido
- Aprendizado demora
- Ajustes raros

**Solução**: Ciclos trimestrais
- 13 semanas é sweet spot
- 4 iterações por ano

---

### Erro #25: Mudar OKRs toda semana

**Problema**: OKRs mudam constantemente, sem foco

**Consequência**: Time não sabe o que priorizar

**Regra**: OKRs são firmes (com exceções)
- Mude táticas (como atingir), não OKRs
- Exceção: Pivot estratégico, contexto mudou radicalmente
- Limite: 1 ajuste de OKR por trimestre (mid-quarter review)

---

## ✅ Checklist Anti-Erros

Antes de finalizar OKRs, valide:

### Escrita
- [ ] Objectives são qualitativos (sem número)?
- [ ] KRs são 100% mensuráveis?
- [ ] KRs são outcomes, não outputs?
- [ ] Linguagem clara, não vaga?

### Ambição
- [ ] Score esperado é 0.6-0.7 (não 1.0)?
- [ ] Desafia time (não é BAU)?
- [ ] Não é moonshot impossível?

### Alinhamento
- [ ] 60% dos Team OKRs alinhados com Company?
- [ ] Dependências mapeadas?
- [ ] Sem duplicação?

### Processo
- [ ] 3-5 Objectives (não 10)?
- [ ] Check-ins semanais planejados?
- [ ] Mid-quarter review agendada?
- [ ] Dashboard de tracking pronto?

### Cultura
- [ ] OKRs desacoplados de bônus?
- [ ] Transparência (todos veem)?
- [ ] Leadership compra a ideia?
- [ ] Time tem ownership?

---

## 🚨 Red Flags de Implementação Ruim

Sinais de que OKRs NÃO estão funcionando:

```
🚩 Scores sempre 1.0
🚩 Ninguém olha OKRs após semana 1
🚩 Times trabalham em coisas fora dos OKRs
🚩 "OKRs são só burocracia"
🚩 Medo de falhar em OKRs
🚩 Sem alinhamento (silos)
🚩 Leadership não acompanha
🚩 Mudanças constantes de OKRs
```

**Ação**: Se >3 red flags, pause e corrija processo.

---

## 🎯 Padrões de Sucesso

Sinais de que OKRs ESTÃO funcionando:

```
✅ Time tem clareza de prioridades
✅ Decisões são tomadas com base em OKRs
✅ Scores na faixa 0.6-0.7
✅ Cross-functional alignment melhorou
✅ Check-ins são rápidos e produtivos
✅ Ambição aumentou (pensam +100%, não +10%)
✅ Foco melhorou (menos projetos paralelos)
✅ Transparência e accountability altas
```

---

**Próximo guia**: [okr-examples-library.md](okr-examples-library.md) - 50+ exemplos de OKRs bons
