# Biblioteca de Exemplos de OKRs

50+ exemplos reais de OKRs organizados por área/função e tipo.

---

## 🏢 COMPANY-LEVEL OKRs

### Exemplo 1: Early-Stage (Validação PMF)

```
Q1 2024 | Pre-Seed | R$50k MRR

O1: Validar product-market fit no segmento PME Brasil
  KR1: Alcançar 50 clientes pagantes (atual: 10)
  KR2: Atingir retention rate 85%+ mês a mês (atual: 65%)
  KR3: Conseguir NPS 40+ (atual: 25)
  KR4: Obter 10 case studies de ROI positivo

O2: Construir motor inicial de aquisição
  KR1: Gerar 200 SQLs via outbound (atual: 50)
  KR2: Atingir 15% win rate (atual: 8%)
  KR3: Reduzir CAC de R$8k para R$4k

O3: Estabelecer fundação de produto
  KR1: Reduzir time-to-value de 14 dias para 3 dias
  KR2: Atingir 60% onboarding completion rate (atual: 30%)
  KR3: 70% dos usuários usando ≥2 features core
```

### Exemplo 2: Growth Stage (Escala)

```
Q2 2024 | Series A | R$500k MRR

O1: Acelerar crescimento sustentável
  KR1: Crescer MRR de R$500k para R$1M
  KR2: Manter CAC Payback <6 meses
  KR3: Atingir NRR 120%+ (atual: 105%)

O2: Dominar canal Enterprise
  KR1: Fechar 10 deals Enterprise (ACV >R$50k)
  KR2: Construir pipeline de R$5M em oportunidades Enterprise
  KR3: Reduzir sales cycle de 4 meses para 2 meses

O3: Tornar produto indispensável
  KR1: Aumentar DAU/MAU de 30% para 50%
  KR2: Atingir NPS 60+
  KR3: Reduzir churn de 5% para 2%
```

---

## 📱 PRODUCT OKRs

### Exemplo 1: Engagement

```
Q1 2024 | Product Team

O: Criar produto que usuários usam diariamente

  KR1: Aumentar DAU/MAU de 25% para 45%
  KR2: Elevar sessões/usuário de 2 para 5 por semana
  KR3: 80% dos usuários ativos usando ≥3 features core
  KR4: Reduzir % de usuários dormentes (0 uso em 30 dias) de 40% para 15%
```

### Exemplo 2: Onboarding

```
Q2 2024 | Product Team

O: Criar experiência de onboarding excepcional

  KR1: Aumentar completion rate de 40% para 80%
  KR2: Reduzir time-to-first-value de 7 dias para 1 dia
  KR3: Atingir CSAT 4.5+ no onboarding survey
  KR4: 70% dos novos usuários completam "aha moment" em 24h
```

### Exemplo 3: Retention

```
Q3 2024 | Product Team

O: Transformar produto em hábito diário

  KR1: Alcançar retention D30 de 60%+ (atual: 35%)
  KR2: Aumentar retained revenue de 90% para 95%
  KR3: Reduzir % de usuários que abandonam após trial de 70% para 40%
  KR4: Atingir 40% de usuários com >10 dias de uso consecutivo
```

---

## 💻 ENGINEERING OKRs

### Exemplo 1: Performance

```
Q1 2024 | Engineering Team

O: Construir infraestrutura de classe mundial

  KR1: Reduzir P95 latency de 800ms para 200ms
  KR2: Atingir uptime 99.95%+ (atual: 99.5%)
  KR3: Reduzir deploy failures de 15% para 3%
  KR4: Acelerar build time de 25min para 5min
```

### Exemplo 2: Velocity

```
Q2 2024 | Engineering Team

O: Acelerar entrega de valor para clientes

  KR1: Aumentar deploy frequency de 1x/semana para 3x/semana
  KR2: Reduzir cycle time de 2 semanas para 3 dias
  KR3: Diminuir WIP (work in progress) de 30 para 10 tasks
  KR4: Atingir 85%+ de sprints cumprindo commitments
```

### Exemplo 3: Qualidade

```
Q3 2024 | Engineering Team

O: Elevar qualidade e confiabilidade do código

  KR1: Reduzir bug rate de 10/sprint para 2/sprint
  KR2: Aumentar code coverage de 40% para 80%
  KR3: Reduzir tech debt score de 300 para 100 (SonarQube)
  KR4: Atingir 90%+ de code reviews em <24h
```

---

## 💰 SALES OKRs

### Exemplo 1: Growth

```
Q1 2024 | Sales Team

O: Construir engine de vendas escalável

  KR1: Crescer MRR de R$200k para R$500k
  KR2: Aumentar pipeline de 100 para 300 SQLs/mês
  KR3: Elevar win rate de 20% para 35%
  KR4: Reduzir sales cycle de 45 para 30 dias
```

### Exemplo 2: Eficiência

```
Q2 2024 | Sales Team

O: Otimizar eficiência de vendas

  KR1: Reduzir CAC de R$6k para R$3k
  KR2: Aumentar ACV médio de R$12k para R$24k
  KR3: Atingir CAC Payback <4 meses
  KR4: Elevar quota attainment de 60% para 85%
```

### Exemplo 3: Enterprise

```
Q3 2024 | Sales Team

O: Dominar canal Enterprise

  KR1: Fechar 15 deals >R$50k ACV
  KR2: Construir pipeline de R$8M em opp Enterprise
  KR3: Reduzir sales cycle Enterprise de 6 para 3 meses
  KR4: Atingir 40% win rate em deals Enterprise
```

---

## 📢 MARKETING OKRs

### Exemplo 1: Demand Generation

```
Q1 2024 | Marketing Team

O: Construir motor de geração de demanda

  KR1: Gerar 5.000 MQLs (atual: 1.000)
  KR2: Atingir 25% de MQL→SQL conversion (atual: 15%)
  KR3: Reduzir CPL de R$150 para R$75
  KR4: 50% dos MQLs vindo de canais orgânicos
```

### Exemplo 2: Brand Awareness

```
Q2 2024 | Marketing Team

O: Estabelecer brand como líder de pensamento

  KR1: Crescer tráfego orgânico de 10k para 50k/mês
  KR2: Atingir 40% brand awareness no segmento PME (pesquisa)
  KR3: Conquistar 5 publicações em mídia tier-1
  KR4: Crescer LinkedIn followers de 2k para 10k
```

### Exemplo 3: Content Marketing

```
Q3 2024 | Marketing Team

O: Tornar conteúdo motor principal de aquisição

  KR1: Publicar 30 artigos high-quality (>2k palavras)
  KR2: Rankear 20 keywords em top 3 do Google
  KR3: Gerar 3.000 MQLs via conteúdo orgânico
  KR4: Atingir 100k pageviews/mês em blog
```

---

## 🤝 CUSTOMER SUCCESS OKRs

### Exemplo 1: Retention

```
Q1 2024 | CS Team

O: Transformar clientes em promotores

  KR1: Reduzir churn de 6% para 2%
  KR2: Atingir NPS 65+ (atual: 45)
  KR3: Alcançar GRR 95%+ (atual: 88%)
  KR4: 80% dos clientes com health score >80
```

### Exemplo 2: Expansion

```
Q2 2024 | CS Team

O: Acelerar expansion revenue

  KR1: Atingir NRR 130%+ (atual: 105%)
  KR2: 40% dos clientes fazendo upsell em 12 meses
  KR3: Crescer expansion MRR de R$50k para R$150k
  KR4: Aumentar ACV médio via expansion de R$3k para R$8k
```

### Exemplo 3: Onboarding

```
Q3 2024 | CS Team

O: Criar experiência de onboarding world-class

  KR1: Reduzir time-to-value de 30 para 7 dias
  KR2: Atingir 90% de clientes com onboarding completo
  KR3: Alcançar CSAT 4.8+ no onboarding
  KR4: 85% dos clientes atingem "first win" em 14 dias
```

---

## 👥 PEOPLE/HR OKRs

### Exemplo 1: Hiring

```
Q1 2024 | People Team

O: Construir time de alta performance

  KR1: Contratar 15 pessoas (5 Eng, 5 Sales, 3 Product, 2 CS)
  KR2: Atingir offer acceptance rate 85%+
  KR3: Reduzir time-to-hire de 60 para 30 dias
  KR4: 90% dos novos hires passam probation
```

### Exemplo 2: Culture & Engagement

```
Q2 2024 | People Team

O: Estabelecer cultura de excelência

  KR1: Atingir eNPS 60+ (atual: 35)
  KR2: Reduzir turnover voluntário de 15% para 8%
  KR3: 90% dos funcionários recomendam empresa (Glassdoor 4.5+)
  KR4: 85% de participation em employee surveys
```

---

## 🎯 Padrões por Tipo

### Growth OKRs
```
Foco: Escalar métricas principais
KRs típicos: MRR, clientes, pipeline, tráfego
Ambição: 2-3x de crescimento
```

### Efficiency OKRs
```
Foco: Fazer mais com menos
KRs típicos: CAC, cycle time, conversion rates
Ambição: 30-50% de melhoria
```

### Quality OKRs
```
Foco: Elevar padrão de excelência
KRs típicos: NPS, CSAT, retention, uptime
Ambição: Benchmark industry (top 10%)
```

### Innovation OKRs
```
Foco: Explorar novo terreno
KRs típicos: Validações, betas, pilotos
Ambição: Aprendizado (não apenas sucesso)
```

---

## 📋 Template Rápido por Área

**Product**: Engagement + Quality + Retention
**Engineering**: Performance + Velocity + Quality
**Sales**: Growth + Efficiency + Pipeline
**Marketing**: Demand Gen + Brand + Content
**CS**: Retention + Expansion + Satisfaction
**People**: Hiring + Culture + Development

Use estes exemplos como inspiração, sempre adaptando ao seu contexto específico.
EXAMPLES