# OKRs para Startups: Adaptações por Estágio

Guia de como adaptar OKRs para diferentes estágios de startup.

---

## 🚀 ESTÁGIO 1: Pre-Seed (Validação)

### Contexto
- **MRR**: R$0-R$100k
- **Time**: 2-10 pessoas
- **Foco**: Encontrar PMF
- **Incerteza**: Muito alta

### Adaptações de OKRs

**Ciclo**: Mensal ou 6 semanas (NÃO trimestral)
- Feedback mais rápido
- Pivots são comuns
- Aprendizado é prioridade

**Quantidade**: 2-3 OKRs Company (não 5)
- Time pequeno, foco extremo
- Sem cascata de Team OKRs

**Ambição**: Validação > Crescimento
- KRs focam em "descobrir" não "escalar"
- Experimentos são KRs válidos

**Exemplo**:
```
Ciclo: Janeiro-Fevereiro (6 semanas)

O1: Validar que PMEs pagariam por solução de CRM
  KR1: Conseguir 10 paying customers (qualquer preço)
  KR2: Atingir retention >80% após 30 dias
  KR3: Obter 5 depoimentos de "não consigo viver sem isso"

O2: Descobrir canal de aquisição que funciona
  KR1: Testar 5 canais diferentes (cold email, LinkedIn, ads, etc.)
  KR2: Identificar 1 canal com CAC <R$500 e conversion >10%
  KR3: Gerar 50 leads qualificados do canal vencedor
```

---

## 💪 ESTÁGIO 2: Seed (Tração Inicial)

### Contexto
- **MRR**: R$100k-R$500k
- **Time**: 10-30 pessoas
- **Foco**: Provar PMF, escalar devagar
- **Incerteza**: Alta

### Adaptações

**Ciclo**: Trimestral (13 semanas)
- Já tem tração, pode planejar trimestre
- Ainda mantém flexibilidade

**Quantidade**: 3-4 OKRs Company + 2-3 OKRs de Time principal
- Começar cascata (1-2 teams)
- Ainda não Individual OKRs

**Foco**: PMF + Unit Economics
- KRs balanceiam crescimento e sustentabilidade
- CAC, LTV, retention são críticos

**Exemplo**:
```
Q1 2024 | Seed | R$200k MRR

COMPANY OKRs:
O1: Atingir product-market fit comprovado
  KR1: Crescer MRR de R$200k para R$400k
  KR2: Atingir NPS 50+
  KR3: Alcançar retention 90%+ mês a mês
  KR4: Conseguir 15 case studies de ROI positivo

O2: Provar economics sustentáveis
  KR1: Reduzir CAC de R$8k para R$4k
  KR2: Atingir LTV:CAC ratio 3:1
  KR3: CAC Payback <6 meses

PRODUCT OKRs (alinhado):
O: Criar produto indispensável
  KR1: Aumentar DAU/MAU de 20% para 40%
  KR2: 70% dos usuários usando ≥3 features core
  KR3: Reduzir churn de 8% para 3%
```

---

## 🚀 ESTÁGIO 3: Series A (Crescimento)

### Contexto
- **MRR**: R$500k-R$3M
- **Time**: 30-100 pessoas
- **Foco**: Escalar o que funciona
- **Incerteza**: Média

### Adaptações

**Ciclo**: Trimestral (padrão)

**Quantidade**: 4-5 OKRs Company + Cascata completa
- Company → Team (4-6 teams) → Individual (opcional)
- 60% alinhamento, 40% bottom-up

**Foco**: Crescimento Eficiente
- Balancear growth com eficiência
- Começar pensar em canais múltiplos

**Exemplo**:
```
Q2 2024 | Series A | R$1M MRR

COMPANY OKRs:
O1: Acelerar crescimento sustentável
  KR1: Crescer MRR de R$1M para R$2M
  KR2: Manter CAC Payback <6 meses
  KR3: Atingir NRR 120%+

O2: Dominar segmento mid-market
  KR1: Fechar 20 deals mid-market (ACV R$20-50k)
  KR2: Atingir 30% win rate em mid-market
  KR3: Reduzir sales cycle de 3 para 2 meses

SALES OKRs (cascata):
O: Construir engine de vendas escalável
  KR1: Crescer pipeline de 200 para 500 SQLs/mês
  KR2: Aumentar win rate de 20% para 30%
  KR3: Onboarding de 5 novos SDRs com ramp-up em 60 dias

MARKETING OKRs (cascata):
O: Estabelecer brand e demand gen
  KR1: Gerar 8.000 MQLs (4.000 atual)
  KR2: Atingir 30% brand awareness em mid-market
  KR3: Reduzir CPL de R$120 para R$80
```

---

## 📈 ESTÁGIO 4: Series B+ (Escala)

### Contexto
- **MRR**: R$3M+
- **Time**: 100+ pessoas
- **Foco**: Escala, processos, eficiência
- **Incerteza**: Baixa

### Adaptações

**Ciclo**: Trimestral + Anual
- Annual strategic OKRs (Company)
- Quarterly execution OKRs (todos níveis)

**Quantidade**: Cascata completa
- Company → Org (Sales, Product, Eng) → Team → Individual
- OKRs em todos níveis

**Foco**: Escala + Eficiência + Novos Mercados
- Otimização de processos
- Expansão (novos segmentos, geos)
- Liderança de mercado

**Exemplo**:
```
Q3 2024 | Series B | R$5M MRR

COMPANY OKRs:
O1: Dominar mercado brasileiro de CRM PME
  KR1: Crescer MRR de R$5M para R$8M
  KR2: Atingir 25% market share em PME (pesquisa)
  KR3: Manter NRR 140%+

O2: Expandir para Enterprise
  KR1: Lançar versão Enterprise do produto
  KR2: Fechar 10 deals Enterprise (ACV >R$100k)
  KR3: Construir pipeline Enterprise de R$20M

O3: Operar com eficiência de scale-up
  KR1: Reduzir burn rate de R$2M para R$1M/mês
  KR2: Atingir Rule of 40 (growth% + profit margin%)
  KR3: Manter headcount efficiency (revenue/FTE) >R$500k
```

---

## 🎯 Frameworks por Estágio

### Pre-Seed: Validação
```
O: Validar [hipótese principal]
  KR1: Conseguir X paying customers
  KR2: Atingir Y% retention
  KR3: Obter Z depoimentos/case studies
```

### Seed: PMF
```
O: Atingir product-market fit
  KR1: Crescer MRR 2-3x
  KR2: Atingir NPS 50+
  KR3: Alcançar retention 85-90%
  KR4: Provar unit economics (LTV:CAC 3:1)
```

### Series A: Escala Inicial
```
O: Escalar crescimento eficientemente
  KR1: Crescer MRR 2-3x mantendo economics
  KR2: Dominar 1-2 canais de aquisição
  KR3: Atingir NRR 120%+
```

### Series B+: Domínio
```
O: Dominar mercado / Expandir
  KR1: Atingir X% market share
  KR2: Expandir para novo segmento/geo
  KR3: Operar com Rule of 40
```

---

## ⚠️ Erros Comuns por Estágio

### Pre-Seed
❌ **Foco em crescimento antes de validação**
```
Ruim: KR = Crescer de 5 para 100 clientes
Bom: KR = Conseguir 10 clientes com retention >80%
```

❌ **Ciclos trimestrais (muito longos)**
```
Ruim: OKRs Q1 (13 semanas)
Bom: OKRs Janeiro (4 semanas)
```

### Seed
❌ **Escalar antes de provar PMF**
```
Ruim: Contratar 10 vendedores
Bom: Provar que 1 vendedor pode atingir quota, depois escalar
```

### Series A+
❌ **Crescimento a qualquer custo**
```
Ruim: Crescer 5x sem olhar CAC Payback
Bom: Crescer 2-3x mantendo economics saudáveis
```

---

## 📊 Métricas por Estágio

### Pre-Seed
Foco: **Validação**
```
Críticas:
- # paying customers
- Retention D7, D30
- Depoimentos/NPS qualitativo
- Time-to-value

Menos importantes:
- MRR absoluto (ainda pequeno)
- Market share
```

### Seed
Foco: **PMF + Economics**
```
Críticas:
- MRR growth rate
- NPS (quantitativo)
- Churn rate
- CAC, LTV, LTV:CAC
- Payback period

Emergentes:
- Pipeline de vendas
- Win rate
```

### Series A
Foco: **Crescimento Eficiente**
```
Críticas (todas acima +):
- NRR (expansion)
- Multiple channels (não apenas 1)
- Sales efficiency (CAC Payback <6mo)
- Cohort retention curves
```

### Series B+
Foco: **Escala + Domínio**
```
Críticas (todas acima +):
- Market share
- Rule of 40
- Revenue per FTE
- Gross margin
- Cash efficiency score
```

---

## 🧭 Priorização por Estágio

### Pre-Seed: 80% Product, 20% Sales
```
Maior parte da energia em:
- Construir produto que resolve dor real
- Validar com early adopters
- Iterar rápido
```

### Seed: 50% Product, 50% GTM
```
Balancear:
- Product: PMF, retention, engagement
- GTM: Provar canal de aquisição, fechar primeiros clientes
```

### Series A: 30% Product, 60% GTM, 10% Ops
```
Focar em:
- GTM: Escalar vendas, marketing, CS
- Product: Manter qualidade enquanto escala
- Ops: Começar pensar em processos
```

### Series B+: 20% Product, 50% GTM, 30% Ops
```
Maturidade:
- GTM: Multicanal, expansão
- Ops: Eficiência, processos, sistemas
- Product: Inovação + manutenção
```

---

## 💡 Dicas Específicas para Startups BR

### Considerar sazonalidade
```
Q4 (Out-Dez): Vendas fortes (fechar orçamento do ano)
Q1 (Jan-Mar): Vendas fracas (orçamento novo liberando)
Q2-Q3: Normal
```

### Ajustar para inflação
```
Ao definir KR de MRR, considerar:
- Reajuste de preços (8-12%/ano no BR)
- Churn por inadimplência (maior que US)
```

### Foco em eficiência (capital mais caro)
```
No BR, capital é mais caro e escasso:
- Priorize CAC Payback curto (<6 meses)
- Burn múltiplo <1.5x
- Cresça dentro do possível com capital disponível
```

---

**Resumo**: Adapte OKRs ao seu estágio. Pre-seed valida, Seed prova PMF, Series A escala, Series B+ domina.
