# Guia Completo: Como Escrever OKRs de Alta Qualidade

Guia prático sobre como escrever Objectives e Key Results que sejam inspiradores, mensuráveis e acionáveis.

---

## 🎯 Estrutura de um OKR

```
OBJECTIVE
├─ Key Result 1
├─ Key Result 2
├─ Key Result 3
└─ Key Result 4 (opcional)

Regra: 3-5 Key Results por Objective
```

---

## 📝 Como Escrever um OBJECTIVE

### Definição

**Objective** é a descrição **qualitativa** do que você quer alcançar.

**Características**:
- ✅ Qualitativo (não tem número)
- ✅ Inspirador e motivador
- ✅ Desafiador mas possível
- ✅ Time-bound (amarrado a um período)
- ✅ Acionável (o time tem controle)

---

### Fórmulas para Objectives

#### Fórmula 1: Verbo + O Quê + Contexto
```
[Verbo de ação] + [O que queremos alcançar] + [Contexto opcional]

Exemplos:
✅ "Tornar-se a plataforma líder de CRM para PMEs no Brasil"
✅ "Construir base sólida de receita recorrente"
✅ "Criar experiência de produto excepcional"
✅ "Dominar o mercado de analytics para e-commerce"
```

#### Fórmula 2: Verbo + Impacto
```
[Verbo] + [Impacto desejado]

Exemplos:
✅ "Acelerar crescimento exponencialmente"
✅ "Elevar satisfação do cliente a níveis excepcionais"
✅ "Estabelecer liderança em inovação"
✅ "Transformar time em high-performance team"
```

#### Fórmula 3: Estado Futuro Desejado
```
Descreva o estado futuro que você quer alcançar

Exemplos:
✅ "Produto indispensável para usuários"
✅ "Brand reconhecida como referência no segmento"
✅ "Engine de vendas previsível e escalável"
✅ "Time de engenharia de classe mundial"
```

---

### Verbos Fortes para Objectives

**Crescimento/Expansão**:
- Tornar-se, Dominar, Liderar, Conquistar
- Expandir, Escalar, Acelerar, Multiplicar

**Construção/Criação**:
- Construir, Criar, Estabelecer, Desenvolver
- Lançar, Implementar, Estruturar

**Melhoria/Excelência**:
- Elevar, Transformar, Otimizar, Aperfeiçoar
- Alcançar excelência, Atingir classe mundial

**Inovação**:
- Revolucionar, Inovar, Reinventar, Redefinir

---

### Checklist de Qualidade de um Objective

Pergunte-se:

- [ ] É inspirador? Motiva o time?
- [ ] É qualitativo? (não tem número)
- [ ] É ambicioso mas possível?
- [ ] Está claro o que queremos alcançar?
- [ ] Time tem controle sobre isso?
- [ ] É relevante para estratégia da empresa?
- [ ] Comunica direção, não apenas métrica?

---

### Exemplos: Bom vs Ruim

#### ❌ Objectives Ruins

```
1. "Melhorar produto"
   Problema: Vago, não inspirador, não diz O QUÊ melhorar

2. "Aumentar vendas"
   Problema: É uma métrica (KR), não Objective qualitativo

3. "Lançar nova versão do app"
   Problema: É um output (projeto), não outcome (impacto)

4. "Fazer o time trabalhar mais"
   Problema: Não inspirador, foca em input (esforço) não output (resultado)

5. "Manter status quo"
   Problema: Não é ambicioso, não desafia

6. "Aumentar MRR de R$100k para R$300k"
   Problema: É Key Result (tem número), não Objective
```

#### ✅ Objectives Bons

```
1. "Tornar-se a solução #1 de CRM para PMEs no Brasil"
   ✓ Inspirador, claro, ambicioso, qualitativo

2. "Criar produto que usuários recomendam entusiasticamente"
   ✓ Foca em outcome (amor ao produto), desafiador

3. "Construir engine de crescimento previsível e escalável"
   ✓ Descreve estado futuro desejado, acionável

4. "Estabelecer brand reconhecida como líder de pensamento"
   ✓ Claro, aspiracional, relevante

5. "Transformar experiência de onboarding em best-in-class"
   ✓ Específico, desafiador, inspirador

6. "Dominar canal de vendas Enterprise no segmento financeiro"
   ✓ Focado, ambicioso, estratégico
```

---

## 📊 Como Escrever KEY RESULTS

### Definição

**Key Result** é a métrica **quantitativa** que mede progresso rumo ao Objective.

**Características**:
- ✅ 100% mensurável (tem número)
- ✅ Verificável objetivamente (não subjetivo)
- ✅ Outcome, não output
- ✅ Ambicioso (score esperado: 0.6-0.7)
- ✅ Time tem controle
- ✅ Leading indicator quando possível

---

### Fórmulas para Key Results

#### Fórmula 1: De X para Y
```
[Verbo] + [Métrica] + de [Valor atual] para [Valor alvo]

Exemplos:
✅ "Crescer MRR de R$100k para R$300k"
✅ "Aumentar NPS de 30 para 60"
✅ "Reduzir churn de 8% para 3%"
✅ "Elevar win rate de 15% para 35%"
```

#### Fórmula 2: Atingir Z
```
[Verbo] + [Valor alvo] + [Métrica]

Exemplos:
✅ "Atingir 200 clientes pagantes"
✅ "Alcançar R$1M em ARR"
✅ "Conseguir 50+ NPS"
✅ "Atingir 90%+ retention rate"
```

#### Fórmula 3: X% de [Grupo] fazendo [Ação]
```
[Porcentagem] de [segmento] [fazendo ação desejada]

Exemplos:
✅ "80% dos usuários usando ≥3 features core"
✅ "70% dos novos usuários completando onboarding"
✅ "50% dos clientes fazendo upsell em 6 meses"
✅ "90% das vendas vindo de inbound"
```

---

### Tipos de Métricas para KRs

#### 1. Métricas de Crescimento
```
✅ MRR, ARR (receita recorrente)
✅ Número de clientes
✅ Tráfego, MAU, DAU
✅ Pipeline de vendas (SQLs, opportunities)
```

#### 2. Métricas de Qualidade
```
✅ NPS (Net Promoter Score)
✅ CSAT (Customer Satisfaction)
✅ Retention rate (mês a mês, cohort)
✅ Churn rate
✅ Time-to-value
```

#### 3. Métricas de Eficiência
```
✅ CAC (Customer Acquisition Cost)
✅ LTV (Lifetime Value)
✅ LTV:CAC ratio
✅ Payback period
✅ Win rate, conversion rate
```

#### 4. Métricas de Engajamento
```
✅ DAU/MAU (stickiness)
✅ Sessões por usuário
✅ Features adopted per user
✅ Time spent in app
```

#### 5. Métricas de Brand/Awareness
```
✅ Brand awareness % (pesquisa)
✅ Share of voice
✅ Tráfego orgânico
✅ Menções em mídia
```

---

### Leading vs Lagging Indicators

#### Lagging Indicators (Resultado Final)
```
Exemplos:
- Revenue, ARR, MRR
- Número de clientes
- Market share

Problema: Demora para mover, pouco controle direto
```

#### Leading Indicators (Antecedentes)
```
Exemplos:
- Pipeline de vendas (SQLs)
- Engagement (DAU/MAU)
- Activation rate
- Trial-to-paid conversion

Vantagem: Time tem mais controle, feedback mais rápido
```

**Melhor prática**: Combine leading + lagging

```
Exemplo:
O: Construir engine de crescimento sustentável
  KR1: Crescer MRR de R$100k para R$300k (lagging)
  KR2: Aumentar pipeline de 50 para 150 SQLs/mês (leading)
  KR3: Elevar trial-to-paid conversion de 10% para 25% (leading)
```

---

### Checklist de Qualidade de um KR

Pergunte-se:

- [ ] É 100% mensurável? (tem número claro)
- [ ] É verificável objetivamente? (todos concordam se foi atingido)
- [ ] É outcome, não output? (resultado de negócio, não tarefa)
- [ ] É ambicioso? (60-70% de confiança de atingir)
- [ ] Time tem controle direto ou forte influência?
- [ ] Cobre um aspecto importante do Objective?
- [ ] Conjunto de KRs cobre o Objective completamente?

---

### Exemplos: Bom vs Ruim

#### ❌ Key Results Ruins

```
1. "Lançar feature de relatórios"
   Problema: Output (entrega), não outcome (impacto)
   Fix: "Aumentar % de usuários tomando decisões baseadas em dados de 20% para 50%"

2. "Melhorar onboarding"
   Problema: Não é mensurável (não tem número)
   Fix: "Reduzir time-to-first-value de 7 dias para 2 dias"

3. "Fazer 30 cold calls por dia"
   Problema: Input (atividade), não outcome (resultado)
   Fix: "Crescer pipeline de 50 para 150 SQLs/mês"

4. "Aumentar satisfação"
   Problema: Vago, não específico
   Fix: "Atingir NPS de 60+"

5. "Contratar 5 engenheiros"
   Problema: Input, não resultado de negócio
   Fix: "Reduzir cycle time de deploy de 2 semanas para 2 dias"

6. "Trabalhar mais em marketing"
   Problema: Não mensurável, vago
   Fix: "Crescer tráfego orgânico de 5k para 20k visitas/mês"
```

#### ✅ Key Results Bons

```
1. "Crescer MRR de R$100k para R$300k"
   ✓ Mensurável, outcome, ambicioso

2. "Atingir NPS de 50+"
   ✓ Claro, verificável, outcome de qualidade

3. "Alcançar retention rate de 90%+ (mês a mês)"
   ✓ Específico, mensurável, outcome

4. "Reduzir CAC de R$5k para R$2.5k"
   ✓ Eficiência, mensurável, ambicioso

5. "80% dos usuários usando ≥3 features core"
   ✓ Engagement, verificável, outcome

6. "Aumentar win rate de 15% para 35%"
   ✓ Leading indicator, mensurável, controle do time
```

---

## 🎯 OKR Completo: Objective + KRs

### Template de OKR de Qualidade

```
OBJECTIVE: [Qualitativo, inspirador, desafiador]

  KR1: [Métrica de crescimento] de X para Y
  KR2: [Métrica de qualidade] de X para Y
  KR3: [Métrica de eficiência] de X para Y
  KR4: [Métrica de engagement/outro] de X para Y [opcional]

Regra: 3-5 KRs por Objective
```

---

### Exemplo 1: Product Team

```
O: Criar produto indispensável que usuários amam

  KR1: Aumentar DAU/MAU de 25% para 45% (engagement/stickiness)
  KR2: Atingir NPS de 60+ (amor ao produto)
  KR3: 80% dos usuários usando ≥3 features core (adoção profunda)
  KR4: Reduzir churn de 8% para 3% (retenção)

✓ Cobre completamente o Objective
✓ Mix de leading (KR1, KR3) e lagging (KR2, KR4)
✓ Todos mensuráveis e ambiciosos
```

---

### Exemplo 2: Sales Team

```
O: Construir engine de vendas previsível e escalável

  KR1: Crescer MRR de R$200k para R$600k (resultado final)
  KR2: Aumentar pipeline de 100 para 300 SQLs/mês (leading)
  KR3: Elevar win rate de 20% para 40% (eficiência)
  KR4: Reduzir CAC payback period de 12 para 6 meses (sustentabilidade)

✓ KR1: Resultado final (lagging)
✓ KR2, KR3, KR4: Drivers que levam ao KR1 (leading)
✓ "Escalável" coberto por eficiência (KR3, KR4)
```

---

### Exemplo 3: Marketing Team

```
O: Estabelecer brand como líder de pensamento no segmento PME

  KR1: Crescer tráfego orgânico de 5k para 30k visitas/mês
  KR2: Atingir 40% brand awareness no segmento PME (pesquisa)
  KR3: Publicar 20 artigos high-quality (>2k palavras) ranqueando em top 3
  KR4: Gerar 5.000 MQLs via conteúdo orgânico

⚠️ Problema: KR3 é output ("publicar 20 artigos")
Fix sugerido: "Atingir 50k pageviews mensais em artigos de blog"
```

---

## 🧪 Testes de Qualidade de OKRs

### Teste 1: "Jornal da Noite"

Imagine que seu OKR foi atingido. Como seria a manchete do jornal?

```
❌ Ruim:
"Empresa lançou 5 features novas"
└─ Ninguém se importa com features, importam com impacto

✅ Bom:
"Startup triplica receita e se torna líder de mercado"
└─ Impacto claro, inspirador
```

### Teste 2: "Teste do Porquê"

Pergunte "Por quê?" 5 vezes:

```
KR: "Lançar feature de relatórios"
Por quê? "Para usuários tomarem melhores decisões"
Por quê importa? "Para gerarem mais valor do produto"
Por quê importa? "Para aumentarem engagement e retention"

✅ KR melhorado:
"Aumentar DAU/MAU de 25% para 45%"
ou
"Reduzir churn de 8% para 3%"
```

### Teste 3: "Teste de Verificação"

Ao final do trimestre, consegue-se verificar objetivamente se foi atingido?

```
❌ Não verificável:
"Melhorar produto"
└─ Como saber se "melhorou"? Subjetivo

✅ Verificável:
"Atingir NPS de 50+"
└─ Objetivo: ou atingiu 50+ ou não atingiu
```

### Teste 4: "Teste de Ambição"

Qual é sua confiança de atingir 100% desse KR?

```
❌ Muito conservador:
"Crescer MRR de R$100k para R$105k (5%)"
└─ Confiança: 95% (muito fácil, não é stretch)

✅ Ambicioso:
"Crescer MRR de R$100k para R$200k (100%)"
└─ Confiança: 60-70% (desafiador mas possível)
```

### Teste 5: "Teste de Cobertura"

Os KRs cobrem completamente o Objective?

```
O: Criar produto indispensável

  KR1: Atingir NPS 60+

❌ Problema: Apenas KR1 não cobre completamente
  - Falta engagement, retenção, adoção

✅ Fix: Adicionar KRs complementares
  KR1: Atingir NPS 60+
  KR2: Aumentar DAU/MAU de 25% para 45%
  KR3: Alcançar retention 90%+
```

---

## 🔄 Iterando OKRs

### Versão 1 (Draft Inicial)

```
O: Melhorar produto

  KR1: Lançar 5 features novas
  KR2: Fazer redesign da homepage
  KR3: Aumentar satisfação

❌ Problemas:
- Objective vago
- KRs são outputs, não outcomes
- KR3 não mensurável
```

### Versão 2 (Após Review)

```
O: Criar experiência de produto excepcional

  KR1: Aumentar NPS de 30 para 60
  KR2: Reduzir churn de 10% para 4%
  KR3: Aumentar engagement (DAU/MAU) de 20% para 40%

✅ Melhorias:
- Objective mais inspirador
- KRs são outcomes mensuráveis
- Cobre qualidade, retenção, engagement
```

### Versão 3 (Final, Após Validação de Ambição)

```
O: Criar experiência de produto excepcional

  KR1: Aumentar NPS de 30 para 50
       (ajustado de 60 para 50 - 60 era muito moonshot)
  KR2: Reduzir churn de 10% para 5%
       (ajustado de 4% para 5% - 4% era inviável em 1 trimestre)
  KR3: Aumentar engagement (DAU/MAU) de 20% para 40%
       (mantido - ambicioso mas possível)
  KR4: Atingir 70% dos usuários usando ≥2 features core
       (adicionado para cobrir adoção profunda)

✅ Final: Ambicioso (score esperado 0.6-0.7), completo, acionável
```

---

## 📐 Calibrando Ambição

### Regra de Score Esperado: 0.6-0.7

Ao definir um KR, pergunte ao time:

```
"Qual é a probabilidade de atingirmos 100% disso?"

Se resposta for:
- 90%+: Não é ambicioso, ajuste para cima
- 60-70%: Sweet spot ✅
- 40-50%: Um pouco moonshot, considere ajustar
- <30%: Muito moonshot, desmotivador
```

### Exemplo de Calibração

```
Situação: Time está crescendo ~20%/trimestre organicamente

❌ Conservador (score esperado: 1.0):
KR: Crescer MRR de R$100k para R$120k (+20%)

✅ Stretch moderado (score esperado: 0.7):
KR: Crescer MRR de R$100k para R$180k (+80%)

⚠️ Moonshot (score esperado: 0.3):
KR: Crescer MRR de R$100k para R$500k (+400%)
```

---

## 🎨 Linguagem Clara e Concisa

### Evite Jargões Desnecessários

```
❌ Ruim:
"Operacionalizar sinergia cross-functional para maximizar throughput de value delivery"

✅ Bom:
"Aumentar velocidade de entrega de valor para clientes"
```

### Seja Específico

```
❌ Vago:
"Melhorar métricas de produto"

✅ Específico:
"Aumentar DAU/MAU de 25% para 45%"
```

### Use Números Concretos

```
❌ Abstrato:
"Crescer significativamente"

✅ Concreto:
"Crescer de R$100k para R$300k MRR"
```

---

## 📋 Templates por Área

### Product

```
O: [Criar/Tornar/Estabelecer] produto [adjetivo superlativo]

  KR1: Aumentar [métrica de engagement] de X para Y
  KR2: Atingir [métrica de satisfação] de Z+
  KR3: Reduzir [métrica de fricção] de A para B
  KR4: Alcançar [métrica de adoção] de C%
```

### Sales

```
O: Construir engine de [vendas/aquisição] [adjetivo]

  KR1: Crescer [MRR/ARR] de X para Y
  KR2: Aumentar [pipeline/SQLs] de A para B
  KR3: Elevar [win rate/conversion] de C% para D%
  KR4: Reduzir [CAC/cycle time] de E para F
```

### Marketing

```
O: Estabelecer [brand/presença] como [posicionamento]

  KR1: Crescer [tráfego/MQLs] de X para Y
  KR2: Atingir [brand awareness/share of voice] de Z%
  KR3: Gerar [leads qualificados] via [canal]
  KR4: Alcançar [ROI/ROAS] de W
```

### Engineering

```
O: Construir [infra/sistema] de [classe mundial/alta performance]

  KR1: Reduzir [latency/downtime] de X para Y
  KR2: Aumentar [reliability/uptime] para Z%
  KR3: Acelerar [deploy frequency/cycle time] de A para B
  KR4: Diminuir [bug rate/tech debt] em C%
```

### Customer Success

```
O: Transformar clientes em [promotores/usuários power]

  KR1: Aumentar [NPS/CSAT] de X para Y
  KR2: Reduzir [churn rate] de A% para B%
  KR3: Alcançar [GRR/NRR] de Z%
  KR4: Atingir [expansion revenue] de R$W
```

---

## 🚨 Erros Comuns ao Escrever

### Erro 1: Confundir O com KR

```
❌ Ruim:
O: Crescer MRR de R$100k para R$300k
└─ Isso é Key Result (tem número), não Objective

✅ Bom:
O: Construir base sustentável de receita
  KR1: Crescer MRR de R$100k para R$300k
```

### Erro 2: KRs são outputs

```
❌ Ruim:
KR1: Lançar feature X
KR2: Contratar 3 engenheiros
KR3: Fazer 50 cold calls

✅ Bom:
KR1: Aumentar engagement 50%
KR2: Reduzir time-to-market de 8 para 4 semanas
KR3: Crescer pipeline de 50 para 150 SQLs
```

### Erro 3: Não mensuráveis

```
❌ Ruim:
KR1: Melhorar produto
KR2: Aumentar qualidade
KR3: Fortalecer brand

✅ Bom:
KR1: Atingir NPS 60+
KR2: Reduzir bug rate de 10/sprint para 2/sprint
KR3: Alcançar 40% brand awareness (pesquisa)
```

### Erro 4: Muito genéricos

```
❌ Ruim:
O: Crescer a empresa
  KR1: Aumentar vendas
  KR2: Melhorar produto
  KR3: Contratar pessoas

✅ Bom:
O: Atingir product-market fit no segmento PME
  KR1: Crescer MRR de R$100k para R$300k
  KR2: Alcançar NPS 50+ e churn <3%
  KR3: Atingir 40% brand awareness em PME (pesquisa)
```

---

## ✅ Checklist Final de Qualidade

Antes de finalizar OKRs, valide:

### Objective
- [ ] É qualitativo (não tem número)?
- [ ] É inspirador e motivador?
- [ ] É ambicioso mas possível?
- [ ] Está claro o que queremos alcançar?
- [ ] Time tem controle/influência?

### Key Results
- [ ] Todos são 100% mensuráveis?
- [ ] São outcomes, não outputs?
- [ ] São ambiciosos (score esperado 0.6-0.7)?
- [ ] Time tem controle direto?
- [ ] Mix de leading e lagging indicators?

### Conjunto (O + KRs)
- [ ] KRs cobrem o Objective completamente?
- [ ] Tem 3-5 Objectives e 3-5 KRs por O?
- [ ] Está alinhado com OKRs superiores?
- [ ] Linguagem clara e específica?
- [ ] Todos entendem e concordam?

---

**Próximo passo**: Veja exemplos reais em [okr-examples-library.md](okr-examples-library.md)
