# Reforge Specialist

Especialista em aplicação prática de frameworks e metodologias Reforge para growth, product, e estratégia.

## 📋 Visão Geral

Esta skill transforma Claude em um especialista certificado em metodologias Reforge, com conhecimento profundo de todos os principais programas: Growth Series, Retention & Engagement, Monetization & Pricing, Advanced Growth Strategy, Product Strategy, Product-Led Growth, e outros.

## 🎯 Quando Usar

Use esta skill quando você:
- Mencionar "Reforge" ou programas específicos (Growth Series, Retention, etc.)
- Solicitar ajuda com North Star Metric, Growth Loops, Acquisition Channels
- Quiser aplicar frameworks de product strategy, pricing, ou PLG
- Precisar diagnosticar problemas de growth, retenção, ou monetização
- Buscar metodologias estruturadas para decisões de produto/growth

## 💡 Capacidades Principais

### Frameworks de Growth
- **North Star Framework**: Definir métrica única que captura valor
- **Growth Accounting**: Decomposição matemática de crescimento
- **Growth Loops**: Sistemas auto-reforçantes de crescimento
- **Acquisition Channels**: Framework para avaliar e escalar canais

### Retenção & Engagement
- **Engagement Hierarchy (MAP)**: Motivação + Habilidade + Prompts
- **Habit Formation (Hooked)**: Trigger → Action → Reward → Investment
- **Retention Cohorts**: Análise de cohort para diagnóstico
- **Feature Adoption**: Como fazer usuários adotarem features

### Monetização & Pricing
- **Value Metric**: Escolher métrica de valor certa
- **Pricing Model Canvas**: Estruturar tiers, add-ons, packaging
- **Willingness to Pay (WTP)**: Descobrir WTP cientificamente
- **Expansion Revenue**: Upsell, cross-sell, seat expansion

### Product Strategy
- **Product Strategy Stack**: Vision → Strategy → Roadmap → Backlog
- **Prioritization Frameworks**: RICE, ICE, Kano, Value vs. Complexity
- **Jobs-to-be-Done (JTBD)**: Entender trabalho do usuário
- **Opportunity Solution Trees**: Mapear oportunidades e soluções

### Product-Led Growth
- **PLG Flywheel**: Aquisição → Ativação → Adoção → Advocacy
- **Time to Value (TTV)**: Reduzir fricção até "aha moment"
- **PQL Scoring**: Product-Qualified Leads
- **Freemium vs. Free Trial**: Qual modelo escolher

## 📚 Conteúdo Incluído

### Guias de Referência (60.000+ palavras)

1. **north-star-framework.md** (18.000 palavras)
   - Como identificar sua North Star Metric
   - Input metrics e sub-inputs
   - Exemplos por tipo de produto (B2C, B2B, Marketplace)
   - Dashboard e instrumentação

2. **growth-loops.md** (20.000 palavras)
   - 6 tipos de growth loops (Viral, UGC, Paid, Sales, PLG, Marketplace)
   - Como identificar, construir e otimizar loops
   - Métricas (K-factor, cycle time, efficiency)
   - Stacking de múltiplos loops

3. **retention-cohorts.md** (12.000 palavras)
   - Tipos de retenção (Unbounded, Bounded, Smile Graph)
   - Como construir cohort tables
   - Padrões de retenção e diagnósticos
   - Benchmarks por tipo de produto

4. **plg-flywheel.md** (15.000 palavras)
   - 4 estágios do flywheel PLG
   - Aha moment e time-to-value
   - Freemium vs. Free Trial
   - PQL (Product-Qualified Leads)
   - Métricas de PLG

### Templates Práticos

1. **north-star-canvas.md**
   - Canvas completo para definir North Star Metric
   - Avaliação de candidatas (Value, Breadth, Leading)
   - Input metrics e sub-inputs
   - Mapa de contribuição por time
   - Plano de implementação

2. **growth-loop-canvas.md**
   - Mapeamento visual do loop
   - Métricas por tipo de loop
   - Análise de drop-off
   - Plano de otimização priorizad
   - Roadmap de implementação
   - Framework de experimentação

## 🚀 Exemplos de Uso

### Exemplo 1: Definir North Star Metric
```
"Como definir North Star Metric para meu SaaS de CRM?"

→ Skill guia através do framework:
  - Elicita contexto (estágio, produto, modelo)
  - Explica o que é North Star e por que importa
  - Avalia candidatas (Active Deals, Revenue Generated, MRR)
  - Recomenda métrica com justificativa
  - Define input metrics
  - Cria plano de implementação
  - Fornece template preenchido
```

### Exemplo 2: Diagnosticar Churn Alto
```
"Nosso churn está em 10%/mês, muito alto. Como resolver?"

→ Skill aplica frameworks:
  - Retention Cohorts (diagnosticar onde churn acontece)
  - Engagement Hierarchy (identificar gaps: Motivação? Habilidade? Prompts?)
  - Habit Formation (criar loops de uso)
  - Recomendações priorizadas com ICE score
  - Roadmap de implementação
  - Templates de análise
```

### Exemplo 3: Implementar PLG
```
"Quero crescer via produto, não sales. Como implementar PLG?"

→ Skill estrutura estratégia:
  - PLG Flywheel (Acquire → Activate → Engage → Expand)
  - Define aha moment do produto
  - Otimiza time-to-value
  - Cria modelo de PQL scoring
  - Define freemium vs. trial
  - Growth loops virais
  - Métricas e dashboard
```

### Exemplo 4: Construir Growth Loop
```
"Como criar um growth loop no meu produto de design?"

→ Skill mapeia loop:
  - Identifica tipo (PLG loop - artifacts virais)
  - Mapeia: User cria design → Compartilha → Recipient vê → Signup
  - Calcula K-factor atual
  - Identifica drop-offs
  - Otimizações priorizadas
  - Roadmap de implementação
  - Template preenchido
```

## 🎓 Filosofia Reforge

A skill segue os princípios fundamentais Reforge:

1. **Framework-First Thinking**: Usar frameworks estruturados para diagnóstico e decisão
2. **Data-Informed, Not Data-Driven**: Dados informam, mas contexto e julgamento decidem
3. **Systems Thinking**: Entender como peças se conectam (loops, flywheels)
4. **Experimentation Rigor**: Testar hipóteses de forma científica
5. **Context Matters**: O que funciona para Uber pode não funcionar para sua startup
6. **Cross-Functional Collaboration**: Growth/Product/Marketing/Data trabalham juntos

## 📊 Metodologia

### 1. Coleta de Contexto
Sempre começa elicitando:
- Estágio da empresa (Pre-PMF, Early, Scaling, Growth, Scale)
- Produto e mercado (ICP, modelo de monetização)
- Métricas atuais e desafios
- Contexto específico por categoria (Growth, Retention, Monetization, etc.)

### 2. Seleção de Framework
Com base no contexto, seleciona framework(s) apropriado(s):
- Growth stagnado? → Growth Accounting + Acquisition Channels
- Retenção baixa? → Retention Cohorts + Engagement Hierarchy
- Pricing? → Value Metric + Pricing Model Canvas
- Roadmap caótico? → Product Strategy Stack + Prioritization

### 3. Aplicação Prática
Para cada framework:
- Explica o conceito (o que é, quando usar, por que funciona)
- Diagnostica situação atual (preenche canvas com dados do usuário)
- Gera recomendações priorizadas (com ICE/RICE scores)
- Cria roadmap de implementação (Fase 1, 2, 3)

### 4. Suporte à Implementação
- Templates preenchidos
- Dashboards de métricas
- Experimentos estruturados
- Próximos passos claros

## 🎯 Empresas de Referência

A skill usa cases de empresas world-class:

**Growth Loops**: Dropbox, Airbnb, Slack, Calendly, Loom
**Retention**: Spotify, Netflix, Instagram, TikTok
**PLG**: Notion, Figma, Zoom, Slack, Calendly
**Monetization**: Salesforce, HubSpot, Superhuman
**Marketplace**: Uber, DoorDash, Etsy

## 📈 Métricas de Sucesso

A skill é bem-sucedida quando você:
- ✅ Entende claramente qual framework aplicar e por quê
- ✅ Framework é aplicado ao seu contexto específico (não genérico)
- ✅ Diagnóstico identifica gap crítico com dados
- ✅ Recomendações são priorizadas e acionáveis
- ✅ Plano de ação tem próximos passos claros
- ✅ Consegue implementar imediatamente
- ✅ Templates/ferramentas são fornecidos quando relevante
- ✅ Conceitos são ensinados (não apenas aplicados)

## 🛠️ Instalação

1. Copie a pasta `reforge-specialist/` para `~/.claude/skills/` (Mac/Linux) ou `%USERPROFILE%\.claude\skills\` (Windows)
2. Reinicie o Claude Desktop
3. A skill será ativada automaticamente quando você mencionar conceitos Reforge

## 💬 Suporte

Esta skill foi criada para aplicar frameworks Reforge de forma prática e acionável ao seu contexto específico. Frameworks são ferramentas poderosas, mas **execução** é o que gera resultado.

**Lembre-se**: Reforge ensina **como pensar**, não **o que pensar**. Adapte ao seu contexto, confie no seu julgamento.

---

**Autor:** Vitor Garcia
📷 Instagram: [@souvitorgarcia](https://www.instagram.com/souvitorgarcia/)
💼 LinkedIn: [vitorgarciamoreira](https://www.linkedin.com/in/vitorgarciamoreira/)

---

🚀 **"Frameworks são o início, não o fim. Teste, aprenda, itere!"**
