# Growth Loop Canvas Template

## 1. Identificação do Loop

**Nome do Loop:**
```

```

**Tipo de Loop:**
- [ ] Viral Loop (users trazem users via convites)
- [ ] UGC Loop (conteúdo atrai tráfego orgânico)
- [ ] Paid Loop (receita financia aquisição)
- [ ] Sales Loop (customers geram referrals)
- [ ] PLG Loop (produto cria artifacts compartilháveis)
- [ ] Marketplace Loop (supply atrai demand, vice-versa)
- [ ] Outro: _______________

---

## 2. Mapeamento do Loop

**Visual do Loop:**
```
┌─────────────────────────────────────────┐
│  1. INPUT: Novo Usuário/Cliente         │
│     Como ele chegou aqui?               │
│                                         │
│     Resposta:                           │
│                                         │
└────────────┬────────────────────────────┘
             ↓
┌─────────────────────────────────────────┐
│  2. ACTION: Ação Core no Produto        │
│     O que ele faz que gera valor?       │
│                                         │
│     Resposta:                           │
│                                         │
└────────────┬────────────────────────────┘
             ↓
┌─────────────────────────────────────────┐
│  3. OUTPUT: Resultado Compartilhável    │
│     O que essa ação gera?               │
│                                         │
│     Resposta:                           │
│                                         │
└────────────┬────────────────────────────┘
             ↓
┌─────────────────────────────────────────┐
│  4. TRIGGER: Gatilho para Próximo User  │
│     Como isso atrai novos usuários?     │
│                                         │
│     Resposta:                           │
│                                         │
└────────────┬────────────────────────────┘
             ↓
      ┌──────┴───────┐
      │  Loop Fecha  │
      │  (volta ao   │
      │   input)     │
      └──────────────┘
```

**Descrição narrativa do loop:**
_(Descreva o loop em 3-5 frases, como uma história)_

```
Exemplo (Loom):
1. User precisa comunicar algo → grava vídeo no Loom
2. User compartilha link do vídeo com colega/cliente
3. Recipient assiste vídeo, vê "Record your own" CTA no player
4. Recipient pensa "isso é útil!" → signup no Loom
5. Recipient grava seu próprio vídeo → compartilha → repete loop
```

**Seu loop:**
```




```

---

## 3. Métricas do Loop

### Métricas Fundamentais

| Métrica | Definição | Valor Atual | Benchmark | Status |
|---------|-----------|-------------|-----------|--------|
| **Loop Cycle Time** | Tempo para completar 1 ciclo completo | | < 7 dias ideal | |
| **Active Loops** | # de ciclos ativos simultaneamente | | - | |
| **Loop Efficiency** | % de ciclos que geram novo input | | > 10% | |
| **Loop Contribution** | % de crescimento vindo do loop | | > 30% | |

### Métricas Específicas por Tipo

**Para Viral Loops:**
| Métrica | Valor Atual | Target |
|---------|-------------|--------|
| **Invitation Rate** | ___% dos users enviam convites | > 30% |
| **Invites per User** | ___ invites por user | > 3 |
| **Invite Conversion** | ___% dos convidados viram users | > 10% |
| **K-Factor** | ___ (Invitation Rate × Invites × Conversion) | > 0.3 |

**Para UGC Loops:**
| Métrica | Valor Atual | Target |
|---------|-------------|--------|
| **Content Creation Rate** | ___% dos users criam conteúdo | > 20% |
| **Content Quality** | Avg engagement, dwell time | - |
| **SEO Performance** | Impressions, clicks orgânicos | - |
| **Organic Conversion** | ___% de visitantes orgânicos → users | > 3% |

**Para Paid Loops:**
| Métrica | Valor Atual | Target |
|---------|-------------|--------|
| **CAC** | $____ custo por aquisição | < $100 |
| **LTV** | $____ lifetime value | - |
| **LTV:CAC Ratio** | ____:1 | > 3:1 |
| **Payback Period** | ____ meses | < 12 meses |

**Para PLG Loops:**
| Métrica | Valor Atual | Target |
|---------|-------------|--------|
| **Share/Invite Rate** | ___% dos users compartilham artifacts | > 40% |
| **Artifact Reach** | ___ pessoas veem cada artifact | > 2 |
| **Virality CTR** | ___% clicam em signup CTA | > 5% |
| **K-Factor** | ___ | > 0.3 |

---

## 4. Análise de Drop-off

**Mapeie onde usuários estão caindo no loop:**

```
1000 Users START
    ↓ (____% take action)
____ Users Take Action
    ↓ (____% create output)
____ Outputs Created
    ↓ (____% reach external people)
____ People Reached
    ↓ (____% click/engage)
____ People Engaged
    ↓ (____% convert to user)
____ New Users Created

K-Factor ou Efficiency = ____ / 1000 = ____
```

**Identificar maior drop-off:**
- **Maior gap**: Entre etapa ___ e etapa ___ (____% → ____%)
- **Segundo maior**: Entre etapa ___ e etapa ___ (____% → ____%)

**Hipóteses do porquê:**
```
Gap 1:


Gap 2:


```

---

## 5. Plano de Otimização

### Otimização Prioritária #1

**Etapa do loop:** _______________

**Objetivo:** Aumentar [métrica X] de ___% para ___% (+__% improvement)

**Táticas (priorize top 3):**

| Tática | Descrição | Esforço (S/M/L) | Impacto Esperado | Owner |
|--------|-----------|-----------------|------------------|-------|
| 1.     |           |                 |                  |       |
| 2.     |           |                 |                  |       |
| 3.     |           |                 |                  |       |

**Impacto estimado no K-factor ou Efficiency:**
```
Antes: ____
Depois: ____ (+___%)
```

### Otimização Prioritária #2

**Etapa do loop:** _______________

**Objetivo:** Aumentar [métrica Y] de ___% para ___% (+__% improvement)

**Táticas:**

| Tática | Descrição | Esforço (S/M/L) | Impacto Esperado | Owner |
|--------|-----------|-----------------|------------------|-------|
| 1.     |           |                 |                  |       |
| 2.     |           |                 |                  |       |
| 3.     |           |                 |                  |       |

### Otimização Prioritária #3

**Etapa do loop:** _______________

**Objetivo:** Reduzir Cycle Time de ___ dias para ___ dias

**Táticas:**

| Tática | Descrição | Esforço (S/M/L) | Impacto Esperado | Owner |
|--------|-----------|-----------------|------------------|-------|
| 1.     |           |                 |                  |       |
| 2.     |           |                 |                  |       |

---

## 6. Roadmap de Implementação

### Fase 1: Quick Wins (Semanas 1-4)

**Objetivo:** Implementar otimizações de baixo esforço / alto impacto

- [ ] Otimização: _______________
  - Descrição:
  - Owner:
  - Prazo:
  - Métrica de sucesso:

- [ ] Otimização: _______________
  - Descrição:
  - Owner:
  - Prazo:
  - Métrica de sucesso:

### Fase 2: Structural Changes (Meses 2-3)

**Objetivo:** Mudanças maiores que requerem eng/product work

- [ ] Otimização: _______________
  - Descrição:
  - Owner:
  - Prazo:
  - Métrica de sucesso:

- [ ] Otimização: _______________
  - Descrição:
  - Owner:
  - Prazo:
  - Métrica de sucesso:

### Fase 3: Scale (Meses 4+)

**Objetivo:** Amplificar loop, adicionar loops secundários

- [ ] Iniciativa: _______________
  - Descrição:
  - Owner:
  - Prazo:
  - Métrica de sucesso:

---

## 7. Experimentação

**Framework de experimento para testar otimizações:**

### Experimento #1

**Hipótese:**
"Acreditamos que **[mudança X]** vai aumentar **[métrica Y]** de **[valor A]** para **[valor B]** porque **[rationale]**."

```
Sua hipótese:



```

**Setup do experimento:**
- **Variante de controle (A)**: Como está hoje
- **Variante de teste (B)**: Com a mudança
- **Split**: 50/50 ou ___
- **Sample size**: ___ users por variante
- **Duração**: ___ dias/semanas
- **Primary metric**: _______________
- **Secondary metrics**: _______________
- **Guardrail metrics**: _______________ (não pode piorar)

**Critério de sucesso:**
- [ ] Primary metric melhora > ___% (estatisticamente significativo)
- [ ] Guardrails não pioram
- [ ] Secondary metrics são neutras ou positivas

**Resultado:**
```
[Preencher após experimento]

Primary metric:
- Control: ___
- Test: ___
- Lift: ___% (sig: Y/N)

Decisão: [ ] Ship  [ ] Iterate  [ ] Kill
```

---

## 8. Monitoramento e Alertas

**Dashboard de Loop (atualização semanal)**

```
┌──────────────────────────────────────────────┐
│ Loop: _______________                        │
├──────────────────────────────────────────────┤
│ Cycle Time: ___ days (target: ___ days)     │
│   Trend: [ ] ↗ Improving  [ ] → Flat  [ ] ↘ Worsening
│                                              │
│ Active Cycles: ____ (+___% WoW)             │
│                                              │
│ Loop Efficiency: ___% (+___ pp WoW)         │
│                                              │
│ New Users from Loop: ____ (___% of total)   │
│                                              │
│ K-Factor / Loop Metric: ____ (+___ WoW)     │
└──────────────────────────────────────────────┘
```

**Alertas configurados:**
- [ ] Se Cycle Time aumenta > 20% → Alerta para Product Lead
- [ ] Se Loop Efficiency cai > 15% → Alerta para Growth Lead
- [ ] Se K-Factor < 0.15 por 2 semanas → Investigar urgente

---

## 9. Loops Secundários (Stacking)

**Este loop é Primary ou Secondary?**
- [ ] Primary Loop (foco principal de growth)
- [ ] Secondary Loop (amplifica primary)
- [ ] Tertiary Loop (otimização de nicho)

**Se houver outros loops, como eles interagem?**

| Loop | Tipo | Como interage com este loop? | Status |
|------|------|------------------------------|--------|
|      |      |                              |        |
|      |      |                              |        |
|      |      |                              |        |

**Oportunidades de stacking:**
_(Novos loops que poderiam ser construídos)_

```
Exemplo (Airbnb):
- Primary Loop: Marketplace (supply-demand)
- Secondary Loop #1: UGC/SEO (listings ranqueiam no Google)
- Secondary Loop #2: Referral (guests/hosts referem amigos)
- Opportunity: User expansion loop (guest becomes host)
```

**Seu stacking:**
```




```

---

## 10. Riscos e Mitigações

**Potenciais problemas do loop:**

| Risco | Probabilidade | Impacto | Mitigação |
|-------|---------------|---------|-----------|
| Loop fatigue (users cansam) | [ ] L [ ] M [ ] H | [ ] L [ ] M [ ] H | |
| Quality degradation | [ ] L [ ] M [ ] H | [ ] L [ ] M [ ] H | |
| Market saturation | [ ] L [ ] M [ ] H | [ ] L [ ] M [ ] H | |
| Platform risk (depende de 3rd party) | [ ] L [ ] M [ ] H | [ ] L [ ] M [ ] H | |
| Spam/abuse | [ ] L [ ] M [ ] H | [ ] L [ ] M [ ] H | |

**Detalhamento dos Top 3 Riscos:**

**Risco #1:**
```
Descrição:

Como mitigar:

Plano de contingência:
```

**Risco #2:**
```
Descrição:

Como mitigar:

Plano de contingência:
```

---

## 11. Casos de Estudo e Benchmarking

**Empresas com loops similares:**

| Empresa | Loop Similar | K-Factor / Efficiency | Cycle Time | Learnings |
|---------|--------------|----------------------|------------|-----------|
|         |              |                      |            |           |
|         |              |                      |            |           |
|         |              |                      |            |           |

**O que podemos aprender deles?**
```




```

---

## 12. Checklist de Validação

**Antes de investir pesado no loop, validar:**

### Fase de Validação

- [ ] Loop existe? (> 10% de users completam ciclo organicamente)
- [ ] K-factor ou Efficiency > 0.15 (base mínima viável)
- [ ] Cycle Time < 30 dias (idealmente < 14 dias)
- [ ] Loop contribui > 10% de novo crescimento
- [ ] Podemos instrumentar todas as métricas

**Se todas ✅ → Investir em otimização**
**Se alguma ❌ → Construir foundation do loop primeiro**

### Fase de Otimização

- [ ] Identificamos biggest drop-offs (análise de funil)
- [ ] Temos 3-5 hipóteses priorizadas de otimização
- [ ] Setup de experimentação está pronto (A/B testing)
- [ ] Dashboard de loop está automatizado

### Fase de Scale

- [ ] K-factor > 0.3 ou Efficiency > 20%
- [ ] Loop contribui > 40% de novo crescimento
- [ ] Cycle Time reduziu vs. baseline
- [ ] Consideramos adicionar loops secundários

---

## 13. Retrospectiva Mensal

**Data:** ___________

**Performance do Loop (último mês):**
- Cycle Time: ___ dias (target: ___)
- Active Cycles: ____
- Efficiency: ___% (target: ___%)
- New Users: ____ (% of total: ___%)

**O que funcionou? (Keep Doing)**
```


```

**O que não funcionou? (Stop Doing)**
```


```

**O que vamos testar próximo? (Start Doing)**
```


```

**Ajustes necessários ao canvas:**
```


```

---

**Próxima revisão agendada para:** ___________

---

**Lembre-se: Growth Loops são construídos, não descobertos. Itere, teste, otimize continuamente.** 🔄
