# North Star Canvas Template

## 1. Proposta de Valor Core

**Qual é o valor central que seu produto entrega?**
_Responda em 1-2 frases. Foco no "why" o cliente usa seu produto._

```
Exemplo (Airbnb): "Permitir que qualquer pessoa viaje e se hospede como um local,
tendo experiências únicas e autênticas."
```

**Sua resposta:**
```

```

---

## 2. Momentos de Valor

**Quando seu cliente percebe valor? Liste 3-7 momentos críticos.**

| # | Momento de Valor | Quando acontece? |
|---|------------------|------------------|
| 1 |                  |                  |
| 2 |                  |                  |
| 3 |                  |                  |
| 4 |                  |                  |
| 5 |                  |                  |

```
Exemplo (Airbnb):
1. Descobre acomodação única no destino desejado
2. Faz reserva de forma confiável e segura
3. Tem experiência positiva na estadia
4. Deixa review e ajuda outros viajantes
5. Retorna e reserva novamente
```

---

## 3. Candidatas a North Star Metric

**Liste 3-5 métricas que poderiam ser sua North Star**

| Métrica Candidata | Valor (1-10) | Breadth (1-10) | Leading (1-10) | Total | Notas |
|-------------------|--------------|----------------|----------------|-------|-------|
|                   |              |                |                |       |       |
|                   |              |                |                |       |       |
|                   |              |                |                |       |       |
|                   |              |                |                |       |       |

**Critérios de avaliação:**
- **Valor (Value)**: Reflete valor entregue ao cliente?
- **Breadth**: Captura amplitude de uso (quantos users, quão intenso)?
- **Leading**: Prediz sucesso futuro (receita, retenção, NPS)?

```
Exemplo (Airbnb):
- Noites Reservadas: Valor=10, Breadth=9, Leading=9 → Total=28 ⭐
- Buscas: Valor=3, Breadth=8, Leading=5 → Total=16
- GMV: Valor=7, Breadth=8, Leading=7 → Total=22
```

---

## 4. North Star Metric Selecionada

**Qual métrica você escolheu como North Star?**

```
North Star Metric: _______________________
```

**Por que esta métrica?**
_(Justifique com base nos 3 critérios)_

```
Justificativa:




```

**Como será medida?**
_(Frequência, fonte de dados, responsável)_

```
- Frequência: [ ] Diária  [ ] Semanal  [ ] Mensal
- Fonte de dados:
- Ferramenta:
- Responsável:
```

---

## 5. Input Metrics (Nível 1)

**Quais 3-5 métricas impulsionam sua North Star?**

```
         North Star Metric: _______________
                    ↑
         ___________|___________
        |           |           |
    INPUT 1     INPUT 2     INPUT 3
```

| Input Metric | Definição | Como influencia NSM | Meta Atual |
|--------------|-----------|---------------------|------------|
| 1.           |           |                     |            |
| 2.           |           |                     |            |
| 3.           |           |                     |            |
| 4.           |           |                     |            |

```
Exemplo (Airbnb - NSM: Nights Booked):

1. Active Bookers: # de pessoas que fazem reservas → Mais bookers = mais nights
2. Booking Frequency: Quantas vezes cada booker reserva → Frequência aumenta nights
3. Nights per Booking: Duração média de estadia → Estadias mais longas = mais nights

Fórmula: Nights Booked = Active Bookers × Booking Frequency × Nights per Booking
```

---

## 6. Sub-Input Metrics (Nível 2)

**Para cada Input Metric do nível 1, decompor em sub-inputs**

### Input 1: _______________

| Sub-Input | Como mover esta métrica? | Time Responsável |
|-----------|--------------------------|------------------|
|           |                          |                  |
|           |                          |                  |
|           |                          |                  |

### Input 2: _______________

| Sub-Input | Como mover esta métrica? | Time Responsável |
|-----------|--------------------------|------------------|
|           |                          |                  |
|           |                          |                  |
|           |                          |                  |

### Input 3: _______________

| Sub-Input | Como mover esta métrica? | Time Responsável |
|-----------|--------------------------|------------------|
|           |                          |                  |
|           |                          |                  |
|           |                          |                  |

```
Exemplo (Airbnb - Input: Active Bookers):

Sub-Inputs:
- New Bookers: Marketing atrai novos travelers → Growth Team
- Retained Bookers: Retenção de bookers existentes → Product Team
- Resurrected Bookers: Reativar churned bookers → CRM/Lifecycle Team
```

---

## 7. Mapa de Contribuição por Time

**Como cada time contribui para a North Star?**

| Time | Input Metric de Foco | Iniciativas Principais | Impacto Esperado |
|------|----------------------|------------------------|------------------|
|      |                      |                        |                  |
|      |                      |                        |                  |
|      |                      |                        |                  |
|      |                      |                        |                  |

```
Exemplo (Airbnb):

- Product Team → Booking Conversion → Melhorar search/booking UX → +10% conversion
- Growth Team → New Bookers → SEO, paid ads, partnerships → +20% new bookers
- Ops Team → Supply Quality → Curate hosts, quality control → +5% booking freq
- Engineering → Performance → Faster load times → +3% conversion
```

---

## 8. Plano de Implementação

### Fase 1: Definição e Validação (Semanas 1-2)

- [ ] Validar NSM com stakeholders (Product, Eng, Growth, Leadership)
- [ ] Confirmar que NSM pode ser rastreada tecnicamente
- [ ] Analisar correlação histórica (NSM vs. Receita/Retenção)
- [ ] Documentar definições claras (o que conta como "ativo"? etc.)

### Fase 2: Instrumentação (Semanas 3-4)

- [ ] Implementar tracking de NSM em produto (analytics)
- [ ] Instrumentar Input Metrics (nível 1 e 2)
- [ ] Criar dashboard automatizado (atualização diária/semanal)
- [ ] Definir alertas (quando NSM cai X%)

### Fase 3: Socialização (Semanas 4-6)

- [ ] Apresentar NSM em all-hands (toda empresa)
- [ ] Treinar times: como NSM funciona, como cada um contribui
- [ ] Adicionar NSM em rituais (sprint planning, retros, QBRs)
- [ ] Criar materiais de comunicação (one-pager, FAQs)

### Fase 4: Aplicação (Ongoing)

- [ ] Usar NSM para priorizar roadmap (impacto na NSM = critério #1)
- [ ] Estruturar experimentos baseados em inputs
- [ ] Revisar NSM semanalmente (leadership) e mensalmente (toda empresa)
- [ ] Iterar: refinar inputs, adicionar sub-inputs conforme aprende

---

## 9. Dashboards e Reporting

**Estrutura de Dashboard recomendada:**

### Seção 1: North Star Performance
```
┌────────────────────────────────────────┐
│ North Star: ___________                │
│                                        │
│  Current: _____  Target: _____        │
│  MoM: +X%       QoQ: +Y%              │
│                                        │
│  [Gráfico de linha: últimos 12 meses] │
└────────────────────────────────────────┘
```

### Seção 2: Input Metrics Breakdown
```
┌────────────────────────────────────────┐
│ Input Metrics Contribution             │
│                                        │
│  Input 1: _____ (40% da NSM)          │
│  Input 2: _____ (35% da NSM)          │
│  Input 3: _____ (25% da NSM)          │
│                                        │
│  [Gráfico de área empilhada]          │
└────────────────────────────────────────┘
```

### Seção 3: Cohort Analysis
```
┌────────────────────────────────────────┐
│ NSM por Cohort                         │
│                                        │
│  [Tabela de cohorts]                  │
│  Jan 24: NSM = X per user             │
│  Feb 24: NSM = Y per user             │
│  Mar 24: NSM = Z per user             │
└────────────────────────────────────────┘
```

### Seção 4: Segmentação
```
┌────────────────────────────────────────┐
│ NSM por Segmento                       │
│                                        │
│  ICP High: NSM = ____                 │
│  ICP Mid:  NSM = ____                 │
│  ICP Low:  NSM = ____                 │
│                                        │
│  Channel A: NSM = ____                │
│  Channel B: NSM = ____                │
└────────────────────────────────────────┘
```

---

## 10. Critérios de Sucesso

**Como você vai saber se a NSM está funcionando?**

**3 meses após implementação:**
- [ ] NSM é mencionada em toda reunião de planejamento
- [ ] 80%+ do time entende o que é e por que importa
- [ ] Roadmap é priorizado por impacto na NSM
- [ ] Dashboard é acessado semanalmente por liderança

**6 meses após implementação:**
- [ ] NSM cresceu X% (definir meta)
- [ ] Input metrics estão todas sendo rastreadas
- [ ] Times conseguem conectar suas iniciativas com NSM
- [ ] Decisões de produto citam impacto na NSM

**12 meses após implementação:**
- [ ] NSM prediz receita/retenção com alta correlação (R² > 0.7)
- [ ] Cohorts recentes têm NSM per user maior que antigos (melhoria)
- [ ] Empresa atingiu meta anual de crescimento da NSM
- [ ] NSM é parte da cultura (todos entendem e usam)

---

## 11. Revisão e Evolução

**Agendar revisões trimestrais da NSM**

### Q1 Review (após 3 meses)

**Data:** ___________

**Perguntas:**
- [ ] A NSM ainda reflete nosso core value?
- [ ] Input metrics estão corretas? Falta alguma?
- [ ] Time está alinhado em torno da NSM?
- [ ] NSM prediz as métricas de negócio (receita, retenção)?

**Ajustes necessários:**
```


```

### Q2 Review (após 6 meses)

**Data:** ___________

**Perguntas:**
- [ ] NSM cresceu conforme esperado?
- [ ] Algum input metric é mais importante que pensávamos?
- [ ] Alguma iniciativa teve grande impacto (positivo/negativo)?
- [ ] Precisamos adicionar/remover algum input?

**Ajustes necessários:**
```


```

---

## Recursos e Referências

**Leitura recomendada:**
- Amplitude: "The North Star Metric" (2016)
- Lenny Rachitsky: "How to Find Your North Star Metric"
- Reforge: Growth Series (North Star Framework module)

**Empresas para benchmarking:**
- Airbnb: Nights Booked
- Slack: Messages Sent
- Spotify: Time Listening
- HubSpot: Weekly Active Contacts
- [Adicione competitors ou similares]

---

**Lembre-se: North Star não é perfeita no dia 1. Itere, aprenda, refine. O importante é começar.** 🌟
