# Product-Led Growth (PLG) Flywheel

**Programa Reforge**: Product-Led Growth

## O que é Product-Led Growth

Product-Led Growth (PLG) é uma estratégia de go-to-market onde o **produto é o principal driver de aquisição, ativação, e expansão** - não sales ou marketing tradicional.

### Características de PLG

**Modelo tradicional (Sales-Led)**:
```
Marketing → MQL → SQL → Demo → Negociação → Fechamento
(Semanas/meses, alto toque, caro)
```

**Modelo PLG**:
```
Descoberta → Signup Self-Serve → Uso Imediato → Value → Upgrade
(Minutos/dias, low toque, escalável)
```

**Princípios Core**:
1. **Produto vem primeiro**: Usuário experimenta antes de comprar
2. **Self-serve**: Signup, onboarding, upgrade sem falar com humano
3. **Time-to-Value rápido**: Usuário vê valor em minutos/horas (não dias/semanas)
4. **Freemium ou Free Trial**: Barreira de entrada baixa
5. **Bottom-up adoption**: Usuário individual → time → empresa
6. **Product experience vende**: Features, UX, resultados convencem (não sales pitch)

## O PLG Flywheel

### 4 Estágios do Flywheel

```
   1. ACQUIRE
       ↓
   2. ACTIVATE  ←─────┐
       ↓              │
   3. ENGAGE          │
       ↓              │
   4. EXPAND ─────────┘
   (loop back: expansion users trazem mais users)
```

Cada estágio alimenta o próximo, criando **crescimento compounding**.

---

### 1. ACQUIRE (Aquisição)

**Objetivo**: Trazer usuários qualificados para o produto com **baixo CAC**

**Canais PLG típicos**:

**a) Viral/Word-of-Mouth**
- Usuários trazem usuários (referral loops)
- Ex: Slack (employees bring whole company)

**b) Product-Led (artifacts virais)**
- Produto cria assets compartilháveis com branding
- Ex: Loom (video links), Calendly (booking links)

**c) Content/SEO**
- Conteúdo educacional traz tráfego orgânico
- Ex: HubSpot (blog), Zapier (integration pages)

**d) Community**
- Comunidade ativa atrai usuários similarmente interessados
- Ex: Notion (templates community), Figma (Config conference)

**e) Marketplace/Integrations**
- Presença em app stores/marketplaces de outras plataformas
- Ex: Slack App Directory, Shopify App Store

**Métricas**:
- **Website Visitors**: Tráfego total
- **Signup Conversion Rate**: % visitors → signups (benchmark: 2-5%)
- **CAC**: Custo por signup (idealmente < $50 para PLG)
- **Channel Mix**: % de signups por canal

**Otimizações**:
- Landing page clara com value prop + CTA forte
- Signup friction mínima (email + senha, ou SSO)
- Social proof (# users, logos, testimonials)
- Free tier ou trial visível

---

### 2. ACTIVATE (Ativação)

**Objetivo**: Levar usuário até **"Aha Moment"** o mais rápido possível

**"Aha Moment"** = Momento onde usuário entende o valor do produto experimentando-o

**Exemplos de Aha Moments**:
- **Slack**: Enviar 2000 mensagens em time (engagement profundo)
- **Dropbox**: Upload primeiro arquivo e acessa de outro device
- **Calendly**: Agenda primeira meeting via link
- **Figma**: Colabora em design file em tempo real
- **Notion**: Cria e compartilha primeira doc/workspace

**Time to Value (TTV)**:
Tempo entre signup e aha moment
- ⭐ **Best-in-class**: < 5 minutos
- ✅ **Good**: < 30 minutos
- ⚠️ **Aceitável**: < 24 horas
- ❌ **Ruim**: > 24 horas

**Estrutura de Onboarding PLG**:

**Step 1: Welcome**
- Personalizar experiência (nome, use case)
- Set expectation (o que vai acontecer)
- Quick (1-2 telas, < 30 segundos)

**Step 2: Setup**
- Mínimo necessário para usar produto
- Progressive disclosure (não tudo de uma vez)
- Defaults inteligentes

**Step 3: First Action (Critical!)**
- Guiar usuário para ação que gera valor
- Tooltips, hotspots, checklist
- Celebrar quando completar

**Step 4: Aha Moment**
- Mostrar resultado da ação
- "Wow, isso foi rápido/fácil!"
- Próximos passos claros

**Exemplo: Canva**

1. **Welcome**: "O que você quer criar hoje?" (Instagram Post, Presentation, etc.)
2. **Setup**: Escolhe template (pula criar do zero)
3. **First Action**: Arrasta elemento, muda cor (fácil, imediato)
4. **Aha Moment**: Design está pronto em 2 min (vs. 2h no Photoshop)

**Métricas**:
- **Activation Rate**: % signups que atingem aha moment (benchmark: 30-60%)
- **Time to Aha Moment**: Mediana de tempo (quanto menor melhor)
- **Onboarding Drop-off**: Onde users abandonam (fix bottlenecks)

**Otimizações**:
- Mapear aha moment (qual ação correlaciona com retention?)
- Remover fricção (menos steps, menos campos, menos loading)
- Templates/samples pré-carregados (vs. blank slate)
- In-app guidance (tooltips, checklists, videos)
- Celebrate wins (confetti, progress bar, badges)

---

### 3. ENGAGE (Engajamento/Retenção)

**Objetivo**: Transformar usuário ativado em usuário **habitual** que volta frequentemente

**Frameworks**:

**a) Habit Formation (Hooked Model)**
- **Trigger**: Lembrar usuário de voltar (email, notif, external event)
- **Action**: Ação simples no produto (abrir, click, post)
- **Variable Reward**: Recompensa variável (social, hunt, self)
- **Investment**: Usuário investe (dados, config, content) aumentando switching cost

**b) Feature Adoption**
- Usuários ativados usam apenas 20% do produto
- Guiar para features que aumentam stickiness
- Ex: Slack→Integrations, Notion→Templates, Figma→Components

**c) Engagement Loops**
- Criar loops de uso recorrente
- Ex: LinkedIn→Profile views→Connect→Feed updates→Profile views

**Métricas**:
- **DAU/MAU Ratio**: Daily/Monthly Active (benchmark: 20%+ para produtos daily-use)
- **Weekly/Monthly Active**: Para produtos não-daily
- **Feature Adoption Rate**: % users usando key features
- **Engagement Breadth**: # de features usadas por user
- **Engagement Depth**: Intensidade de uso (actions/session, time spent)

**Otimizações**:
- Notifications estratégicas (não spam, mas triggers úteis)
- Email drip campaigns (dicas, cases, feature discovery)
- In-app prompts para features não usadas
- Power user playbooks (como users avançados usam)
- Integrations (lock-in via outras ferramentas)

---

### 4. EXPAND (Expansão/Monetização)

**Objetivo**: Converter free users em **paying users** e expandir **revenue por account**

**Modelos de Expansão**:

**a) Freemium → Paid (Individual)**
- Usuário free atinge limite ou quer feature premium
- Ex: Notion (free→$8/user), Calendly (1 event type→unlimited)

**b) Self-Serve Upgrade (Team)**
- Usuário convida time, time precisa de features de collab
- Ex: Figma (viewer→editor license), Slack (10k messages limit)

**c) Sales-Assisted (Enterprise)**
- Conta cresce organicamente, sales entra para enterprise deal
- Ex: Zoom (individual→enterprise security/SSO), Dropbox

**d) Seat Expansion**
- Adicionar mais usuários pagos na conta
- Ex: GitHub (5 devs→50 devs)

**e) Feature Upsell**
- Add-ons, advanced features, higher tiers
- Ex: Superhuman (Gmail→multi-account), Loom (HD video)

**Triggers de Conversão (PQL - Product-Qualified Leads)**:

**Engagement-based**:
- "Usou produto 10+ vezes em 14 dias"
- "Convidou > 3 team members"
- "Criou > 20 documents"

**Value-based**:
- "Savings $X usando nosso produto vs. alternativa"
- "Gerando $Y de revenue através de feature X"

**Limit-based**:
- "Atingiu 80% do limite de free tier"
- "Tentou usar feature premium 3+ vezes"

**Friction Estratégica**:
PLG não é "tudo grátis sempre". É **estratégico** onde colocar paywalls.

**Paywalls efetivos**:
✅ **Value metric**: Cobrar pelo que escala com valor (users, storage, API calls)
✅ **Advanced features**: Features que power users querem (analytics, integrations)
✅ **Collaboration**: Features que times precisam (permissions, sharing, SSO)
✅ **Support/SLA**: Response time, uptime guarantees

**Paywalls ruins**:
❌ **Core value**: Não bloqueie o aha moment (user nunca paga se não viu valor)
❌ **Muito cedo**: Não peça cartão antes de ativação
❌ **Arbitrary limits**: "3 projects" não casa com value (confuso)

**Exemplo: Slack**

**Free**:
- Unlimited users (core value é comunicação)
- 10k messages searchable (suficiente para testar)
- 10 integrations

**Paid ($6.67/user)**:
- Unlimited message history (limit é friction)
- Unlimited integrations (power users precisam)
- Screen sharing (team feature)

**Enterprise ($12.50/user)**:
- SSO, compliance (IT requirements)
- Advanced admin controls
- 99.99% uptime SLA

→ Freemium captura usuários, paid captura times, enterprise captura empresas

**Métricas**:
- **Free→Paid Conversion**: % de signups que pagam (benchmark: 2-5%)
- **Time to Conversion**: Tempo de signup → paid (benchmark: 30-90 dias)
- **PQL→Paid Rate**: % de PQLs que convertem (benchmark: 15-30%)
- **Expansion MRR**: MRR de upsells/expansions em accounts existentes
- **Net Revenue Retention (NRR)**: > 100% significa expansion > churn

**Otimizações**:
- Clear paywall messaging ("Upgrade to unlock X")
- In-app upgrade flows (sem sair do produto)
- Trial upgrades (free 14-day trial de paid tier)
- Sales-assist para deals > $X (ex: > $10k ARR)
- Usage-based nudges ("You're at 95% of free tier")

---

## PLG Flywheel em Ação

**Como os estágios se conectam**:

**Acquire → Activate**:
- High-intent signups (bom fit) ativam mais fácil
- Landing page deve atrair right users, não todos users

**Activate → Engage**:
- Usuários que atingem aha moment retornam 5x mais
- Ativação é pré-requisito de engagement

**Engage → Expand**:
- Usuários engajados veem mais valor → maior willingness to pay
- Engagement = leading indicator de conversão

**Expand → Acquire (Loop fecha!)**:
- Paying users trazem mais users (referrals, virality)
- Revenue financia aquisição (paid loops)
- Case studies de customers atraem prospects (sales loop)

**Exemplo: Notion**

1. **Acquire**: Designer descobre Notion via Twitter/Reddit
2. **Activate**: Cria primeira doc colaborativa, compartilha com time
3. **Engage**: Time começa a usar daily, cria wikis, databases
4. **Expand**: Time atinge limite free (5MB uploads), upgrade para $8/user
5. **Loop**: Time compartilha docs com contractors → contractors signup → repeat

**Crescimento Compounding**: Cada user pode trazer 0.3-0.5 new users (viral loop) + gerar $96/ano (expansion loop)

## PLG vs. Sales-Led: Quando usar cada um?

### PLG funciona melhor quando:

✅ **Low ACV** (< $10k/ano inicial):
- Self-serve é economicamente viável
- Sales team seria muito caro por deal

✅ **Produto é simples de entender**:
- Demo de 5 min é suficiente
- Value é óbvio (não requer educação extensa)

✅ **Quick time-to-value**:
- Usuário vê valor em minutos/horas
- Não requer implementação/onboarding longo

✅ **Bottom-up adoption**:
- Usuário individual pode começar a usar
- Não requer approval de C-level/procurement

✅ **Produto tem network effects ou virality**:
- Uso por um puxa outros (ex: collab tools)

**Exemplos PLG puro**: Notion, Figma, Calendly, Loom

### Sales-Led funciona melhor quando:

✅ **High ACV** (> $50k/ano):
- Deals grandes justificam sales team
- Requer customização, negociação, procurement

✅ **Produto é complexo**:
- Requer educação, consultoria, setup
- Múltiplos stakeholders (IT, security, legal)

✅ **Long implementation**:
- Integração com sistemas existentes
- Treinamento de times

✅ **Top-down adoption**:
- Decisão é C-level (CIO, CTO, CFO)
- Não pode começar bottom-up

**Exemplos Sales-Led**: Salesforce (enterprise), SAP, Oracle

### Hybrid (PLG + Sales) é comum

**Estrutura híbrida**:
- **PLG para SMB** (self-serve, < $10k deals)
- **Sales-Assist para Mid-Market** ($10k-$100k deals)
- **Enterprise Sales para Enterprise** (> $100k deals)

**Exemplos Hybrid**: Slack, Zoom, Dropbox, HubSpot, Atlassian

**Modelo típico**:
1. Usuário começa free/trial (PLG)
2. Time pequeno self-serve upgrade ($50-200/mês)
3. Se conta atinge $X MRR ou Y seats → sales entra para expandir

**Sinais de PQL para handoff**:
- Account com > 20 seats
- Usage > X (power users)
- Fortune 500 company
- Atingiu limite de tier (precisa enterprise features)

## Métricas-Chave de PLG

### Funil PLG Completo

```
10,000 Website Visitors
    ↓ (3% conversion)
  300 Signups ─────────────────────► CAC = $50 ($15k / 300)
    ↓ (40% activation)
  120 Activated Users
    ↓ (60% D30 retention)
   72 Retained Users (M1)
    ↓ (5% conversion)
    4 Paying Customers ──────────► Free→Paid = 4/300 = 1.3%
                                   ARPU = $100/mês
                                   LTV = $100 × 20 months = $2000
                                   LTV:CAC = $2000/$50 = 40:1 ⭐⭐⭐
```

### Dashboard PLG Essencial

**Aquisição**:
- Signups (total, por canal)
- Signup Conversion Rate
- CAC

**Ativação**:
- Activation Rate (% atingem aha moment)
- Time to Activation
- Onboarding Drop-off Funnel

**Engajamento**:
- WAU/MAU (weekly/monthly active)
- D7, D30 Retention
- Feature Adoption

**Expansão**:
- Free→Paid Conversion Rate
- PQL→Paid Rate
- ARPU (average revenue per user)
- Net Revenue Retention (NRR)

**Saúde Geral**:
- LTV:CAC Ratio (> 3)
- Payback Period (< 12 meses)
- Magic Number (efficiency de growth)

## Exemplos de Empresas PLG Best-in-Class

### Slack

**Flywheel**:
- Employee usa Slack pessoalmente
- Convida time (viral loop)
- Time atinge 10k messages (paywall)
- Upgrade para paid
- Team member vai para outra empresa → traz Slack

**Métricas**:
- 43% de Fortune 100 usam Slack
- $12B valuation no IPO
- 65% de revenue de expansão (não new logos)

### Calendly

**Flywheel**:
- User cria scheduling link
- Envia para 10 people para agendar meetings
- 10 people veem "Powered by Calendly"
- 5-10% desses signup
- K-factor ~0.3-0.5 (altíssimo!)

**Métricas**:
- 10M+ users
- $3B valuation
- 50M+ meetings agendados
- 99% do crescimento via PLG (quase zero sales)

### Figma

**Flywheel**:
- Designer usa Figma
- Compartilha file com devs/stakeholders
- Devs precisam de edit access → signup
- Design file vira source of truth
- Network effects (mais users = mais value)

**Métricas**:
- Cresceu 250% YoY (2019-2020)
- Adquirida por Adobe por $20B
- 90%+ growth via word-of-mouth

## Checklist de Implementação PLG

**Fase 1: Foundation**
- [ ] Definir "Aha Moment" claramente
- [ ] Medir Time to Value (TTV) atual
- [ ] Criar signup flow self-serve (< 2 min)
- [ ] Definir free tier (o que é free vs. paid?)
- [ ] Instrumentar analytics (acquisition → expand)

**Fase 2: Otimizar Onboarding**
- [ ] Mapear drop-off em onboarding (onde users desistem?)
- [ ] Reduzir steps para aha moment (< 5 min ideal)
- [ ] Adicionar templates/samples (evitar blank slate)
- [ ] Guiar first action (tooltips, checklist)

**Fase 3: Criar Engagement Loops**
- [ ] Identificar triggers de retorno (email, notif, etc.)
- [ ] Definir features core vs. advanced
- [ ] Criar feature adoption campaigns
- [ ] Medir DAU/MAU ou WAU/MAU

**Fase 4: Monetização**
- [ ] Definir PQL criteria (quando user está pronto para pagar?)
- [ ] Criar upgrade flows in-app
- [ ] Testar diferentes paywalls (A/B test)
- [ ] Medir free→paid conversion

**Fase 5: Growth Loops**
- [ ] Adicionar virality (referral, invites, sharing)
- [ ] Criar artifacts compartilháveis (com branding)
- [ ] Facilitar bottom-up adoption (individual→team)
- [ ] Medir viral coefficient (K-factor)

---

**PLG não é "set and forget". É experimentação contínua de produto como canal de crescimento.** 🚀
