# TODO: Finalizar Skill "Startup Legal & Tax Advisor"

**Status Atual:** Skill parcialmente criada (48k palavras de 108k total)

**Última atualização:** 2025-10-29

---

## ✅ Concluído (48.000 palavras)

### Arquivos Principais
- ✅ `SKILL.md` (18.000 palavras) - Completo e validado
- ✅ `references/corporate-structures.md` (15.000 palavras) - Completo
- ✅ `references/taxation-essentials.md` (15.000 palavras) - Completo

### Conteúdo Criado
- ✅ 8 capacidades principais detalhadas no SKILL.md
- ✅ Estruturas societárias completas (LTDA, SA, Holdings, Offshore)
- ✅ **Transfer pricing doméstico** (resolve caso de funcionários compartilhados)
- ✅ Tributação completa (Simples, Presumido, Real)
- ✅ Comparativos, tabelas, cálculos práticos
- ✅ Disclaimers legais
- ✅ Exemplos de uso

---

## 🔄 Em Progresso / Pendente (60.000 palavras restantes)

### 1. Guias de Referência Restantes (6 arquivos)

#### A. essential-contracts.md (15.000 palavras)
**Status:** Arquivo vazio criado
**Localização:** `references/essential-contracts.md`

**Conteúdo necessário:**

##### 1.1 SHA - Shareholders Agreement (3.000 palavras)
- Cláusulas essenciais
- Vesting de fundadores (4 anos, 1 ano cliff)
- Tag along e drag along (proteção minoritários/majoritários)
- Direito de preferência (right of first refusal)
- Deadlock provisions (empate de votos)
- Good leaver vs bad leaver
- Non-compete e non-solicit
- Exemplo de SHA em português com cláusulas comentadas

##### 1.2 MSA - Master Service Agreement (2.500 palavras)
- Para contratos B2B SaaS
- Cláusulas críticas: scope of services, payment terms, liability cap, indemnification
- Termination for cause vs convenience
- Data protection e LGPD
- Intellectual property ownership
- Exemplo de MSA para SaaS B2B

##### 1.3 NDA - Non-Disclosure Agreement (1.500 palavras)
- Mutual vs unilateral (quando usar cada)
- Definição de informação confidencial
- Exclusões (público, já conhecido, desenvolvido independentemente)
- Prazo: 2-5 anos típico
- Consequências: multa, obrigação devolução
- Exemplo de NDA mutual em português

##### 1.4 SLA - Service Level Agreement (2.000 palavras)
- Uptime commitments (99.5%, 99.9%, 99.99%)
- Cálculo de downtime permitido mensal
- Service credits (reembolso proporcional)
- Measurement methodology
- Exclusões (manutenção programada, força maior)
- Escalation procedures
- Exemplo de SLA para SaaS com cálculos

##### 1.5 SAFE - Simple Agreement for Future Equity (2.500 palavras)
- Como funciona: investe hoje, converte em equity depois
- Valuation cap (ex: R$20M)
- Discount (ex: 20%)
- Pro-rata rights (direito de manter %)
- MFN (Most Favored Nation)
- Conversão em ações: cálculo prático
- SAFE vs Convertible Note (comparativo)
- Exemplo de SAFE em português

##### 1.6 Contratos Comerciais (2.000 palavras)
- Distribuição: exclusividade, território, comissão
- Parceria estratégica: co-marketing, revenue share
- Reseller: margin, support, marketing
- White label: customização, branding, pricing

##### 1.7 Contratos Entre Empresas Relacionadas (1.500 palavras) ⭐ CRÍTICO
- Prestação de serviços com markup (arm's length)
- Cost sharing agreement (rateio de custos)
- Service level agreement interno
- Cláusulas de transfer pricing
- Exemplo completo em português

---

#### B. compliance-basics.md (12.000 palavras)
**Status:** Arquivo vazio criado
**Localização:** `references/compliance-basics.md`

**Conteúdo necessário:**

##### 2.1 LGPD Completo (5.000 palavras)
- 10 bases legais (consentimento, legítimo interesse, execução contrato, etc)
- Quando é necessário DPO (Data Protection Officer)
- ROPA - Registro de Operações de Tratamento
- Políticas necessárias:
  - Política de Privacidade
  - Política de Cookies
  - Política de Retenção de Dados
- DPA - Data Processing Agreement
  - Template para clientes (você é controller)
  - Template para fornecedores (você é processor)
- Direitos dos titulares (acesso, correção, eliminação, portabilidade, oposição)
- Incidentes de dados:
  - Comunicação ANPD (quando necessário)
  - Notificação titulares (48 horas se risco relevante)
  - Documentação obrigatória
- Penalidades: advertência, multa até 2% faturamento (max R$50M por infração)

##### 2.2 LGPD para SaaS (2.000 palavras)
- Controller vs processor (distinção crítica)
- DPA com clientes B2B (você é processor)
- DPA com AWS/Cloud (subprocessor)
- Data residency (dados em servidores Brasil vs exterior)
- Checklist compliance para SaaS B2B completo

##### 2.3 Compliance Trabalhista (3.000 palavras)
- Encargos CLT detalhados:
  - FGTS: 8% sobre salário
  - INSS patronal: 20%
  - RAT (Risco Ambiental Trabalho): 1-3%
  - Sistema S (SESI, SENAI, SEBRAE): ~3.3%
  - Férias: 11.11% (1/12 por mês + 1/3 constitucional)
  - 13º salário: 8.33% (1/12 por mês)
  - Provisão rescisão
  - **Total: ~38-42% sobre salário bruto**
- Cálculo prático: salário R$10.000 = custo empresa R$13.800-14.200
- Riscos de pejotização:
  - Requisitos vínculo: subordinação, habitualidade, pessoalidade, onerosidade
  - Jurisprudência TST
  - Penalidades: reconversão + multas + passivo 2 anos
- Rescisões: verbas por tipo (sem justa causa, pedido demissão, acordo)

##### 2.4 Compliance Fiscal (1.000 palavras)
- Obrigações mensais: DCTF, SPED, NFSe
- Certidões negativas (federal, estadual, municipal, FGTS)
- Calendário fiscal mensal
- Consequências inadimplência

##### 2.5 Regulamentações Setoriais (500 palavras)
- **Fintech:** Banco Central (SCD, SIP, SEP), CVM, PIX
- **Healthtech:** ANVISA (software classe I/II), CFM (telemedicina)
- **Edtech:** MEC, INEP

##### 2.6 Certificações (500 palavras)
- **ISO 27001:** Quando buscar (vendas enterprise), processo, custo R$30-80k
- **SOC 2:** Type I vs Type II, quando necessário, custo R$50-150k

---

#### C. fundraising-legal.md (12.000 palavras)
**Status:** Arquivo vazio criado
**Localização:** `references/fundraising-legal.md`

**Conteúdo necessário:**

##### 3.1 House Cleaning Pré-Rodada (2.000 palavras)
- Societário: contrato social, atas, cap table
- IP: marca, cessão código, licenças
- Trabalhista: CLT regularizado, sem PJ exclusivo
- Fiscal: tributos em dia, certidões
- Contratos: principais clientes e fornecedores
- Checklist completo por estágio (pre-seed, seed, Series A)

##### 3.2 Due Diligence Completo (4.000 palavras)
Checklist detalhado por área:

**Societário:**
- Contrato social + aditivos registrados
- Atas de assembleia (todas)
- Cap table bate com documentos
- Acordo de sócios atualizado
- Poderes de representação claros

**Propriedade Intelectual:**
- Código 100% da empresa (cessão IP fundadores/devs)
- Marca: registrada ou processo INPI iniciado
- Licenças open source compatíveis (MIT/Apache ok, GPL cuidado)
- Domínios registrados
- Sem violação IP terceiros

**Trabalhista:**
- CLT: todos registrados, folha em dia
- PJ: sem exclusividade (risco pejotização)
- Stock options: plano formal ou planejado
- Sem processos trabalhistas
- Provisões rescisórias adequadas

**Fiscal:**
- Impostos federais/estaduais/municipais em dia
- Certidões negativas válidas
- Declarações entregues (SPED, DCTF, ECF)
- Regime tributário adequado
- Sem parcelamentos ou dívidas

**Contratos:**
- Contratos clientes top 10
- Contratos fornecedores críticos (AWS, etc)
- NDAs com anteriores
- Sem cláusulas change of control problemáticas

**Compliance:**
- LGPD: política privacidade, DPAs
- Sem processos cíveis
- Sem investigações regulatórias

##### 3.3 Red Flags Críticos (1.500 palavras)
- **Impeditivos (deal-breakers):**
  - Sócio fantasma (cap table ≠ contrato social)
  - Dívida fiscal alta
  - Processo trabalhista grave
  - IP não pertence à empresa
  - Fraude contábil

- **Warnings (resolver antes):**
  - Marca não registrada
  - PJ exclusivo (3+ pessoas)
  - Sem acordo de sócios
  - Contratos clientes verbais
  - LGPD não implementado

##### 3.4 Term Sheet (2.500 palavras)
Cláusulas essenciais:
- **Valuation:**
  - Pre-money vs post-money (diferença crítica)
  - Cálculo de % do investidor
  - Fully diluted cap table
- **Liquidation Preference:**
  - 1x (padrão) vs 2x+ (agressivo)
  - Participating vs non-participating
  - Seniority (múltiplas rodadas)
- **Anti-dilution:**
  - Weighted average (padrão) vs ratchet (agressivo)
  - Broad-based vs narrow-based
- **Board Composition:**
  - Founders, investors, independent
  - Veto rights (orçamento, M&A, novas rodadas)
- **Vesting:**
  - Founders: 4 anos, 1 ano cliff (reverse vesting)
  - Acceleration: single trigger vs double trigger
- **Direitos:**
  - Pro-rata (manter %)
  - Information rights
  - Tag along, drag along

Exemplo de term sheet comentado

##### 3.5 SHA Investidor (1.500 palavras)
Diferenças SHA founders vs SHA investidor:
- Direitos de preferência (investidor compra primeiro)
- Veto rights (decisões críticas)
- Information rights (balancetes mensais)
- Reserved matters (quórum qualificado)
- Exit provisions (drag along após X anos)

Exemplo de SHA com investidor

##### 3.6 Documentação e Data Room (500 palavras)
Estrutura de data room:
```
data-room/
├── 01-corporate/
├── 02-ip/
├── 03-tax/
├── 04-labor/
├── 05-contracts/
└── 06-compliance/
```

---

#### D. labor-essentials.md (10.000 palavras)
**Status:** Arquivo vazio criado
**Localização:** `references/labor-essentials.md`

**Conteúdo necessário:**

##### 4.1 CLT Detalhado (3.000 palavras)
- Tipos de contrato: prazo indeterminado, determinado, parcial
- Jornada: 44h semanais, 220h mensais
- Horas extras: 50% (dias úteis), 100% (domingo/feriado)
- Adicional noturno: 20% (22h-5h)
- DSR - Descanso Semanal Remunerado
- Férias: 30 dias após 12 meses, vende 10 dias (1/3 abono)
- 13º salário: pago em 2 parcelas (nov 30, dez 20)

##### 4.2 Encargos CLT Completos (2.500 palavras)
Tabela detalhada com cálculo:

| Encargo | % | Base | Exemplo R$10k |
|---------|---|------|---------------|
| Salário | 100% | Bruto | R$10.000 |
| FGTS | 8% | Salário | R$800 |
| INSS patronal | 20% | Salário | R$2.000 |
| RAT | 1-3% | Salário | R$100-300 |
| Sistema S | 3.3% | Salário | R$330 |
| Férias | 11.11% | Salário | R$1.111 |
| 13º | 8.33% | Salário | R$833 |
| **TOTAL** | **~38-42%** | - | **R$13.800-14.200** |

Cálculo prático para diferentes salários:
- R$5k → R$6.9-7.1k
- R$10k → R$13.8-14.2k
- R$20k → R$27.6-28.4k

##### 4.3 CLT vs PJ (2.000 palavras)
Tabela comparativa completa:

| Critério | CLT | PJ |
|----------|-----|-----|
| Vínculo | Subordinação | Autonomia |
| Jornada | Fixa (44h/sem) | Flexível |
| Férias | 30 dias/ano | Não tem |
| 13º | Sim | Não |
| FGTS | 8% empresa | Não |
| Rescisão | Verbas + aviso | Sem verbas |
| Tributação | IR 0-27.5% | Simples ~6-15% ou Presumido ~13.33% |
| Custo empresa | ~138-142% | ~106-115% |
| Risco | Baixo | Pejotização |

**Quando usar CLT:**
- Subordinação (horário, local, ordens)
- Exclusividade ou quase
- Habitualidade (todo dia)
- Pessoalidade (não pode substituir)

**Quando usar PJ:**
- Autonomia real
- Múltiplos clientes
- Projeto específico
- Especialista pontual

##### 4.4 Riscos de Pejotização (1.500 palavras)
- Requisitos caracterização vínculo (TST):
  - Subordinação (segue ordens, horário)
  - Habitualidade (frequência contínua)
  - Pessoalidade (não pode enviar substituto)
  - Onerosidade (recebe para trabalhar)
- Jurisprudência TST: casos reais
- Penalidades:
  - Reconversão para CLT (retroativo 2 anos)
  - Multas trabalhistas
  - Passivo: férias, 13º, FGTS, rescisão
  - Custo típico: R$50-200k por funcionário
- Como evitar: checklist

##### 4.5 Rescisões (500 palavras)
Verbas por tipo:

**Sem justa causa (empresa demite):**
- Aviso prévio: 30 dias (+3d por ano, max 90d)
- Férias proporcionais + 1/3
- 13º proporcional
- Saldo salário
- FGTS + multa 40%
- Seguro-desemprego (se cumprir requisitos)

**Pedido de demissão (funcionário pede):**
- Apenas saldo salário e férias proporcionais + 1/3

**Acordo (Lei 13.467/2017):**
- 50% aviso, 20% multa FGTS, saca 80% FGTS

##### 4.6 Stock Options Trabalhista (500 palavras)
- Integra ou não salário? Geralmente NÃO se:
  - Gratuito (não desconta do salário)
  - Voluntário (pode recusar)
  - Condicional (vesting)
  - Aleatório (depende de valuation futuro)
- Precedentes TST
- Cláusula recomendada em contrato

---

#### E. ip-basics.md (6.000 palavras)
**Status:** Arquivo vazio criado
**Localização:** `references/ip-basics.md`

**Conteúdo necessário:**

##### 5.1 Registro de Marca INPI (3.000 palavras)
**Busca prévia:**
- Site: https://busca.inpi.gov.br/
- Buscar: idêntica, fonética, visual
- Classes (NCL): 42 para software SaaS essencial

**Classes relevantes:**
- **Classe 42** (Serviços TI) - ESSENCIAL
  - Software como serviço (SaaS)
  - Desenvolvimento de software
  - Hospedagem de aplicações
- **Classe 9** (Produtos) - Opcional
  - Programas de computador
  - Aplicativos móveis

**Processo completo:**
Timeline 12-24 meses:
```
Mês 0: Protocolo pedido (paga taxa)
  ↓
Mês 1-2: Exame formal (INPI verifica docs)
  ↓
Mês 6-12: Publicação RPI (Revista Propriedade Industrial)
  ↓
60 dias: Prazo oposições terceiros
  ↓
Mês 8-18: Exame substantivo (INPI analisa mérito)
  ↓
Mês 12-24: Deferimento ou indeferimento
  ↓
Se deferido: Paga concessão (10 anos proteção)
```

**Custos 2025:**
| Empresa | Protocolo | Concessão | Total |
|---------|-----------|-----------|-------|
| Micro/pequena | R$355 | R$298 | R$653 |
| Demais | R$980 | R$745 | R$1.725 |
| + Advogado | - | - | +R$1.500-3.000 |

**Proteção durante processo:**
- Antes registro: use TM™ (indica reivindicação)
- Após registro: use ® (Registered Trademark)
- Proteção 10 anos, renovável indefinidamente

##### 5.2 Código-Fonte e Copyright (1.000 palavras)
- Copyright automático (Lei 9.610/98)
- Cessão de IP obrigatória:
  - Fundadores: cláusula em contrato social ou termo separado
  - Funcionários: cláusula em contrato trabalho
  - Freelancers: contrato de prestação serviços
- Template de cessão de IP
- Obra coletiva vs obra sob encomenda

##### 5.3 Licenças Open Source (1.000 palavras)
Comparativo:

| Licença | Tipo | Pode usar comercialmente | Copyleft | Recomendação |
|---------|------|--------------------------|----------|--------------|
| MIT | Permissiva | ✅ Sim | ❌ Não | ✅ Ótima |
| Apache 2.0 | Permissiva | ✅ Sim | ❌ Não | ✅ Ótima |
| BSD | Permissiva | ✅ Sim | ❌ Não | ✅ Ótima |
| GPL v3 | Copyleft | ⚠️ Sim mas... | ✅ Sim | ⚠️ Cuidado |
| AGPL | Copyleft forte | ⚠️ Sim mas... | ✅ Sim (SaaS) | ❌ Evite |

**GPL/AGPL:**
- Copyleft: se usar, SEU código vira GPL também
- AGPL: até SaaS precisa abrir código
- Risco: investidor pode vetar deal

##### 5.4 Patentes de Software (500 palavras)
- Brasil: software puro NÃO é patenteável (Lei 9.279/96)
- Exceção: software + hardware (processo técnico)
- Alternativa: **segredo industrial**
  - Mantém código fechado
  - NDAs com funcionários
  - Controles de acesso
- Custo patente no Brasil: R$15-50k (processo longo, 5-10 anos)

##### 5.5 Proteção Internacional (500 palavras)
**Madrid Protocol (via INPI):**
- 1 pedido, múltiplos países (130+)
- Custo: CHF 653 (~R$3.500) + por país (~R$500-1k)
- Vantagem: centralizado, gerenciamento único

**Registro direto:**
- USPTO (EUA): US$250-350 (~R$1.200-1.700)
- EUIPO (Europa): €850-1.500 (~R$4.500-8.000)

**Quando fazer:**
- Series A+ ou receita internacional significativa
- Antes: foque Brasil

---

#### F. ma-fundamentals.md (5.000 palavras)
**Status:** Arquivo vazio criado
**Localização:** `references/ma-fundamentals.md`

**Conteúdo necessário:**

##### 6.1 Tipos de Aquisição (1.000 palavras)
- **Tuck-in:** Adicionar produto/tecnologia ao portfolio
- **Acqui-hire:** Adquirir equipe (tecnologia secundária)
- **Horizontal:** Concorrente direto (consolidação)
- **Vertical:** Fornecedor ou cliente (integração cadeia)

##### 6.2 LOI - Letter of Intent (1.000 palavras)
Termos típicos não vinculantes:
- Valuation preliminar (faixa: R$X-Y)
- Estrutura: stock purchase vs asset purchase
- Earn-out (se aplicável)
- Due diligence period (30-60 dias)
- Exclusivity (60-90 dias - vinculante)
- Break-up fee (se seller quebrar exclusividade)
- Confidencialidade
- Governing law (lei brasileira, foro SP)

Exemplo de LOI em português

##### 6.3 Due Diligence Buy-Side (1.000 palavras)
Checklist detalhado:
- Legal: cap table, IP, contratos, processos
- Fiscal: certidões, regime, passivos
- Tecnologia: code review, tech debt, dependencies, documentation
- Equipe: retention risk, salários abaixo mercado, key man dependency
- Clientes: churn, concentration (top 3 > 50% receita?), contracts
- Métricas: MRR real, churn real, CAC/LTV

##### 6.4 Stock Purchase vs Asset Purchase (500 palavras)
| Critério | Stock Purchase | Asset Purchase |
|----------|----------------|----------------|
| O que compra | Empresa inteira | Ativos selecionados |
| Passivos | Assume todos | Assume só escolhidos |
| Simplicidade | Mais simples | Mais complexo |
| Contratos | Transferem automático | Precisa renegociar |
| Tributação | Ganho capital seller | Pode ter IR/PIS/COFINS |
| Recomendado | Startup pequena clean | Se houver passivos |

##### 6.5 Earn-out (750 palavras)
**Estrutura típica:**
```
Pagamento total: R$1M

Upfront (closing): R$500k (50%)
Earn-out ano 1: R$250k (25%)
Earn-out ano 2: R$250k (25%)
```

**Gatilhos:**
- **Retention:** Founders assinam CLT 2 anos, se saírem perdem proporcional
- **Revenue:** MRR cresce X% ao ano
- **EBITDA:** Margem mantém Y%
- **Produto:** Integração concluída em Z meses

**Cláusulas:**
- Aceleração: se comprador vende empresa, earn-out pago 100%
- Penalidades: se founders não performam, reduz earn-out
- Disputa: arbitragem vs judicial

##### 6.6 SPA e Documentação (750 palavras)
**SPA - Stock Purchase Agreement:**
Cláusulas críticas:
- Purchase price e forma pagamento
- Reps & warranties (10-15 garantias seller):
  - Cap table correto
  - Sem passivos ocultos
  - IP pertence empresa
  - Contratos válidos
  - Sem processos
- Indemnification (indenização se rep falsa):
  - Cap: máximo 100% purchase price
  - Basket: franquia (ex: só acima R$50k)
  - Survival: prazo reps (12-36 meses)
- Escrow: 10-20% purchase price retido 12-24 meses

**Employment agreements founders:**
- Salário + equity na compradora
- Vesting 2-4 anos (golden handcuffs)
- Non-compete 12 meses
- Non-solicit 24 meses

**Timeline típica:**
| Semana | Etapa |
|--------|-------|
| 1-2 | Conversas iniciais + NDA |
| 3 | LOI assinada |
| 4-8 | Due diligence |
| 9-10 | Negociação SPA |
| 11 | Closing |

**Custos:**
- Advogado: R$20-50k
- Contador: R$5-10k
- Tech DD: R$10-20k (ou interno)
- **Total: R$35-80k**

---

### 2. Templates em Assets/ (15 arquivos)

**Status:** Pasta `assets/` criada, templates vazios ou inexistentes

**Localização:** `assets/`

#### Templates de Contratos (9 arquivos)

1. **nda-mutual-template.md** (NDA bilateral)
2. **nda-unilateral-template.md** (NDA unilateral)
3. **msa-template.md** (Master Service Agreement para SaaS B2B)
4. **sla-template.md** (Service Level Agreement com uptime 99.5%)
5. **safe-template.md** (SAFE com cap e discount)
6. **sha-founders-template.md** (Acordo sócios fundadores com vesting)
7. **sha-investor-template.md** (Acordo acionistas com investidor)
8. **service-agreement-related-parties.md** (Contrato empresas relacionadas - transfer pricing)
9. **cost-sharing-agreement.md** (Acordo rateio de custos)

#### Templates de Checklists (6 arquivos)

10. **due-diligence-checklist.md** (DD completo: legal, fiscal, trabalhista, IP, contratos, compliance)
11. **corporate-transformation-checklist.md** (LTDA → SA passo a passo)
12. **tax-regime-calculator.md** (Calculadora Simples vs Presumido vs Real)
13. **ip-protection-checklist.md** (Proteção IP completa: marca, código, domínios)
14. **loi-template.md** (Letter of Intent para aquisição)
15. **lgpd-compliance-kit/** (Diretório com 6 arquivos):
    - privacy-policy-template.md
    - dpa-controller-template.md (DPA com clientes)
    - dpa-processor-template.md (DPA com fornecedores)
    - cookie-policy-template.md
    - data-retention-policy-template.md
    - incident-response-plan-template.md

**Instruções para criar templates:**
- Todos em português do Brasil
- Formatação markdown
- Campos editáveis em [COLCHETES]
- Comentários explicativos em cada cláusula
- Exemplos práticos quando aplicável

---

### 3. Validação e Empacotamento

**Status:** Não iniciado

#### 3.1 Validar Skill
```bash
cd /Users/vitorgarcia/Documents/skills_claude/startup-legal-tax-advisor
python3 /Users/vitorgarcia/.claude/plugins/marketplaces/anthropic-agent-skills/skill-creator/scripts/package_skill.py
```

**Verificar:**
- ✅ Frontmatter SKILL.md correto (name, description)
- ✅ Todos references/ criados
- ✅ Todos assets/ criados
- ✅ Sem erros de validação

#### 3.2 Empacotar
Comando criará `startup-legal-tax-advisor.zip`

---

### 4. Documentação

**Status:** Não iniciado

#### 4.1 Atualizar README.md

Adicionar seção:

```markdown
### Startup Legal & Tax Advisor ⭐ NOVO

Especialista em questões tributárias, societárias, contratuais e de compliance para startups brasileiras.

- **Descrição**: Especialista completo em legal e tax para fundadores, cobrindo estruturação societária (LTDA/SA/holdings), tributação (regimes, transfer pricing), contratos (SHA, MSA, NDA, SAFE), compliance (LGPD, trabalhista), propriedade intelectual e M&A. Sempre elicita contexto sobre estágio da empresa e objetivos. NÃO substitui advogado ou contador.
- **Capacidades principais**:
  - Elicitação de contexto (estágio, estrutura, objetivos)
  - Estruturação societária (LTDA vs SA, holdings, transformações, offshore)
  - Tributação (regimes, transfer pricing, planejamento, obrigações)
  - Contratos essenciais (SHA, MSA, NDA, SLA, SAFE, comerciais)
  - Compliance (LGPD, trabalhista, fiscal, certificações)
  - Fundraising legal (due diligence, term sheet, SHA investidor)
  - Propriedade intelectual (marca INPI, código, licenças)
  - M&A fundamentals (aquisições, LOI, SPA, earn-out)
- **Recursos inclusos**:
  - 8 guias completos de referência (90.000+ palavras total)
  - Estruturas societárias - LTDA/SA, holdings, transformações (15.000 palavras)
  - Tributação essencial - regimes, tributos, transfer pricing (15.000 palavras)
  - Contratos essenciais - SHA, MSA, NDA, SLA, SAFE (15.000 palavras)
  - Compliance - LGPD, trabalhista, fiscal, setorial (12.000 palavras)
  - Fundraising legal - DD, term sheet, SHA investidor (12.000 palavras)
  - Direito trabalhista - CLT, encargos, PJ vs CLT (10.000 palavras)
  - Propriedade intelectual - marca INPI, IP, licenças (6.000 palavras)
  - M&A fundamentals - aquisições, LOI, SPA (5.000 palavras)
  - 15 templates profissionais prontos para uso
- **Download**: [`startup-legal-tax-advisor.zip`](startup-legal-tax-advisor.zip)

**Exemplos de uso:**
```
"Tenho LTDA seed, R$150k MRR, planejo Series A em 12 meses. Transformar para SA agora?"
"Funcionários da Empresa A trabalham para Empresa B (mesmos sócios). Como formalizar?"
"Qual regime tributário: Simples vs Lucro Real? Faturamento R$200k/mês SaaS."
"Preciso de MSA para SaaS B2B com uptime 99.5%. Como estruturar SLA?"
"Vou levantar R$3M seed. O que investidor revisa em due diligence?"
"Como registrar marca no INPI? Quais classes para SaaS?"
"Comprando startup 5 pessoas por R$800k. Como estruturar earn-out?"
"Implementar LGPD no SaaS de RH. Por onde começar?"
```
```

Adicionar à estrutura do repositório:
```markdown
├── startup-legal-tax-advisor.zip        # Skill: Startup Legal & Tax Advisor
└── startup-legal-tax-advisor/
    ├── SKILL.md                         # 18.000+ palavras
    ├── references/                      # 8 guias (90.000+ palavras)
    │   ├── corporate-structures.md      # LTDA/SA, holdings, transfer pricing (15.000)
    │   ├── taxation-essentials.md       # Regimes, tributos, planejamento (15.000)
    │   ├── essential-contracts.md       # SHA, MSA, NDA, SLA, SAFE (15.000)
    │   ├── compliance-basics.md         # LGPD, trabalhista, fiscal (12.000)
    │   ├── fundraising-legal.md         # DD, term sheet, SHA (12.000)
    │   ├── labor-essentials.md          # CLT, encargos, PJ (10.000)
    │   ├── ip-basics.md                 # Marca, código, licenças (6.000)
    │   └── ma-fundamentals.md           # Aquisições, LOI, SPA (5.000)
    └── assets/                          # 15 templates
        ├── nda-mutual-template.md
        ├── msa-template.md
        ├── sha-founders-template.md
        ├── service-agreement-related-parties.md
        ├── cost-sharing-agreement.md
        ├── due-diligence-checklist.md
        └── lgpd-compliance-kit/
```

#### 4.2 Criar Commit

```bash
git add startup-legal-tax-advisor/ startup-legal-tax-advisor.zip README.md
git commit -m "$(cat <<'EOF'
Adiciona skill Startup Legal & Tax Advisor completa

- Skill completa sobre legal e tax para startups brasileiras (108k palavras)
- 8 guias de referência: societário, tributação, contratos, compliance, fundraising, trabalhista, IP, M&A
- 15 templates prontos: contratos, checklists, calculadoras
- Resolve casos: LTDA vs SA, holdings, transfer pricing, regimes tributários, contratos B2B, due diligence, LGPD, marca INPI, M&A

Skill educacional para fundadores. NÃO substitui advogado ou contador.

🤖 Generated with [Claude Code](https://claude.com/claude-code)

Co-Authored-By: Claude <noreply@anthropic.com>
EOF
)"
```

---

## 📋 Checklist Final

Antes de considerar concluído:

- [ ] Todos 8 guias de referência criados e completos
- [ ] Todos 15 templates criados e funcionais
- [ ] Skill validada sem erros
- [ ] Skill empacotada (.zip criado)
- [ ] README.md atualizado
- [ ] Commit criado
- [ ] Testado com casos de uso reais

---

## 💡 Dicas para Continuar

### Criando Guias de Referência

**Abordagem recomendada:**
1. Leia os 2 guias já criados (corporate-structures, taxation-essentials) para entender o padrão
2. Crie cada guia em sequência (não paralelo)
3. Use Write tool para cada arquivo
4. Siga a estrutura especificada acima
5. Inclua sempre: tabelas comparativas, cálculos práticos, exemplos brasileiros, checklists

**Densidade de conteúdo:**
- Seja extremamente prático (não teórico)
- Use exemplos reais (Nubank, Stone, startups brasileiras)
- Tabelas para comparar opções
- Cálculos com valores reais em R$
- Checklists acionáveis
- Red flags a evitar

### Criando Templates

**Formato:**
```markdown
# [NOME DO CONTRATO]

**Entre:**
- [NOME EMPRESA A], [CNPJ], [ENDEREÇO] ("Parte A")
- [NOME EMPRESA B], [CNPJ], [ENDEREÇO] ("Parte B")

## Cláusula 1 - Objeto
[Descrição do objeto do contrato]

<!-- Explicação: Esta cláusula define o escopo... -->

## Cláusula 2 - [Nome]
[Conteúdo]

<!-- Explicação: ... -->

...
```

**Incluir:**
- Todos campos editáveis em [COLCHETES]
- Comentários HTML explicando cada cláusula
- Valores exemplo quando aplicável
- Lei e foro (lei brasileira, foro SP típico)

---

## 🎯 Prioridade de Criação

Se tiver limitações de tempo/contexto, crie nesta ordem:

**Essencial (faz skill funcionar para 80% casos):**
1. ✅ corporate-structures.md (JÁ CRIADO)
2. ✅ taxation-essentials.md (JÁ CRIADO)
3. essential-contracts.md
4. compliance-basics.md
5. service-agreement-related-parties.md (template)
6. cost-sharing-agreement.md (template)
7. nda-mutual-template.md

**Importante (complementa bem):**
8. fundraising-legal.md
9. labor-essentials.md
10. sha-founders-template.md
11. msa-template.md
12. due-diligence-checklist.md

**Nice-to-have (completa 100%):**
13. ip-basics.md
14. ma-fundamentals.md
15. Demais templates

---

## 📞 Questões a Considerar

Ao criar conteúdo, sempre pergunte:

1. **É prático?** Fundador consegue usar imediatamente?
2. **Tem números reais?** Custos em R$, prazos em meses, % corretos?
3. **É brasileiro?** LTDA/SA (não LLC), INPI (não USPTO), CLT, LGPD?
4. **Stage-appropriate?** Diferencia pre-seed vs Series A?
5. **Tem disclaimer?** Lembra que NÃO substitui profissional?
6. **Tem exemplos?** Startups brasileiras, casos práticos?
7. **Tem checklists?** Lista acionável de passos?

---

## ✅ Critérios de Sucesso

A skill está completa quando:

1. **Resolve casos reais:**
   - ✅ LTDA vs SA → Decisão fundamentada
   - ✅ Holding sim ou não → Análise custo-benefício
   - ✅ Funcionários compartilhados → 3 soluções compliant
   - ✅ Regime tributário → Simulação comparativa
   - ✅ Contrato B2B → Template customizável
   - ✅ Due diligence → Checklist completo
   - ✅ Marca INPI → Processo passo a passo
   - ✅ M&A pequeno → Estrutura earn-out

2. **Validação técnica:**
   - ✅ package_skill.py roda sem erros
   - ✅ ZIP é criado
   - ✅ Todos arquivos existem

3. **Qualidade conteúdo:**
   - ✅ Legislação brasileira correta
   - ✅ Custos e prazos realistas
   - ✅ Exemplos práticos
   - ✅ Disclaimers presentes

---

**Boa sorte com a continuação! 🚀**

Esta skill será EXTREMAMENTE valiosa para fundadores brasileiros navegarem o complexo ambiente legal/fiscal/tributário sem precisar de 5 assessores diferentes.
