# Nano Banana Pro - API Reference Guide

## Models (December 2025)

| Model | API ID | Tier | Best For |
|-------|--------|------|----------|
| **Flash** | `gemini-2.5-flash-image` | Free | Fast prototyping, balanced quality |
| **Pro** | `gemini-3-pro-image-preview` | Paid | Best quality, text rendering, references |

### Model Capabilities

| Feature | Flash | Pro |
|---------|-------|-----|
| Text-to-Image | Yes | Yes |
| Image Editing | Yes | Yes |
| Reference Images | Up to 3 | Up to 14 |
| Custom Aspect Ratio | No | Yes |
| Custom Resolution | No | Yes (1K/2K/4K) |
| Text Rendering | Basic | Superior |
| Character Consistency | Limited | Full support |

## Pricing

| Model | Resolution | Cost per Image |
|-------|------------|----------------|
| Flash | Default | ~$0.039 |
| Pro | 1K | ~$0.069 |
| Pro | 2K | ~$0.134 |
| Pro | 4K | ~$0.240 |

> Pricing based on ~1290 output tokens per image. See [Google AI Pricing](https://ai.google.dev/pricing) for current rates.

## Aspect Ratios

| Ratio | Use Case |
|-------|----------|
| `1:1` | Social media squares, profile pictures |
| `16:9` | Landscapes, YouTube thumbnails, banners |
| `9:16` | Mobile/portrait, Instagram Stories, TikTok |
| `4:3` | Standard photos, presentations |
| `3:4` | Portrait photos |
| `4:5` | Instagram feed posts |
| `5:4` | Standard prints |
| `2:3` | Classic portrait |
| `3:2` | Classic landscape, DSLR photos |
| `21:9` | Ultra-wide, cinematic |

> **Note**: Custom aspect ratios only work with Pro model. Flash uses default 1:1.

## Resolutions

| Size | Dimensions | Best For |
|------|------------|----------|
| `1K` | ~1024px | Quick previews, web thumbnails |
| `2K` | ~2048px | Social media, web content |
| `4K` | ~4096px | Print, high-quality displays |

> **Note**: Higher resolutions only available with Pro model.

## Safety Features

### SynthID Watermark
All images generated by Gemini include an invisible **SynthID digital watermark**:
- Identifies images as AI-generated
- Cannot be removed by cropping/editing
- Verifiable through Google's API

### Content Filtering
Google applies safety filters that may block:
- Harmful or violent content
- Adult/explicit content
- Copyrighted characters/brands
- Real people (public figures)

If your prompt is blocked, try:
1. Rephrasing without specific names
2. Using generic descriptions
3. Avoiding potentially sensitive topics

## Rate Limits

| Tier | Requests per Minute | Requests per Day |
|------|---------------------|------------------|
| Free | 15 | 1,500 |
| Paid | 60 | 10,000 |

> Limits may vary. Check [Google AI quotas](https://ai.google.dev/gemini-api/docs/quota) for current limits.

## Best Practices

### Prompt Writing

**Do:**
- Be specific and descriptive
- Include style references (e.g., "in watercolor style", "photorealistic")
- Specify lighting, mood, and composition
- Use clear language for text rendering

**Don't:**
- Use vague prompts like "a nice picture"
- Request copyrighted characters by name
- Expect exact reproductions of real people

### Examples of Good Prompts

```
"A cozy coffee shop interior with warm lighting, wooden furniture,
and plants hanging from the ceiling, photorealistic style"

"Logo design for 'BREW HOUSE' coffee brand, minimalist,
black and white, modern sans-serif font"

"Product photo of a sleek smartwatch on white background,
studio lighting, professional photography"
```

### Model Selection Guide

| Scenario | Recommended Model |
|----------|-------------------|
| Quick mockups | Flash |
| Final production images | Pro |
| Text-heavy designs | Pro |
| Reference-based generation | Pro |
| Budget-conscious projects | Flash |
| 4K print quality | Pro |

## API Response Handling

The API may return:
- **Single image**: Most common for simple prompts
- **Multiple images**: For complex prompts or variations
- **Text + Image**: Model may include explanatory text

Always handle multiple outputs:
```python
for part in response.parts:
    if part.inline_data:
        # Handle image
    elif part.text:
        # Handle text response
```

## Troubleshooting

### "Safety filter blocked"
- Rephrase your prompt to be less specific about people/brands
- Avoid potentially sensitive topics

### "Rate limit exceeded"
- Wait a few minutes before retrying
- Consider upgrading to paid tier for higher limits

### "Model not available"
- Check if you're using the correct model ID
- Verify your API key has access to the model

### "Invalid aspect ratio"
- Flash model doesn't support custom ratios
- Use Pro model for custom aspect ratios

## Resources

- [Google AI Studio](https://aistudio.google.com/) - Get API key & test prompts
- [Gemini API Docs](https://ai.google.dev/gemini-api/docs/image-generation) - Official documentation
- [Pricing](https://ai.google.dev/pricing) - Current pricing
- [Model Cards](https://ai.google.dev/gemini-api/docs/models) - Model specifications
