---
name: nano-banana-pro
description: Use this skill when the user asks to generate images, create AI art, edit photos, or mentions "nano banana", "gemini image", "tạo ảnh", "chỉnh sửa ảnh". Provides AI image generation and editing using Google's Nano Banana Pro API.
---

# Nano Banana Pro - AI Image Generation & Editing

You can generate and edit images using Google's Nano Banana Pro (Gemini 3 Pro Image) API.

## Script Location

The script is located at: `${CLAUDE_PLUGIN_ROOT}/skills/nano-banana-pro/scripts/nano_banana.py`

## Prerequisites

Before using, ensure:
1. `GOOGLE_AI_API_KEY` environment variable is set
2. Required packages installed: `pip install google-genai>=1.52.0 Pillow python-dotenv`

## Commands

### 1. Generate Image from Text

```bash
python "${CLAUDE_PLUGIN_ROOT}/skills/nano-banana-pro/scripts/nano_banana.py" generate "prompt" [options]
```

Options:
- `-o, --output`: Output file path (default: generated_image.png)
- `-m, --model`: `flash` (default, free tier) or `pro` (best quality, paid)
- `-r, --ratio`: Aspect ratio (1:1, 16:9, 9:16, 4:3, 3:4, 4:5, 5:4, 2:3, 3:2, 21:9)
- `-s, --size`: Resolution (1K, 2K, 4K)

### 2. Edit Existing Image

```bash
python "${CLAUDE_PLUGIN_ROOT}/skills/nano-banana-pro/scripts/nano_banana.py" edit "input.png" "edit instructions" [options]
```

### 3. Generate with Reference Images

```bash
python "${CLAUDE_PLUGIN_ROOT}/skills/nano-banana-pro/scripts/nano_banana.py" reference "prompt" ref1.png ref2.png [options]
```

Supports up to 14 reference images. Best with `--model pro`.

## Guidelines

1. **Model Selection**:
   - Use `flash` (default) for balanced quality and speed - FREE tier
   - Use `pro` for highest quality, text rendering, or reference images - PAID tier
   - Pro model supports custom aspect ratio and resolution; Flash uses defaults

2. **Output Paths**:
   - Always specify meaningful output paths
   - Use the current working directory or a path the user can easily access

3. **Aspect Ratios** (Pro model only):
   - `16:9` for landscapes, banners, YouTube thumbnails
   - `9:16` for mobile/portrait, Stories, TikTok
   - `1:1` for social media squares, profile pictures
   - `4:3` or `3:2` for standard photos
   - `21:9` for ultra-wide, cinematic

4. **After Generation**:
   - Report the saved file path to the user
   - If there's text output from the model, share it

5. **Advanced Features** (Pro model):
   - **Character Consistency**: Use reference images to maintain character appearance across generations
   - **Text Rendering**: Pro model excels at generating legible text in images (logos, posters, menus)
   - **Targeted Edits**: Natural language editing like "blur the background", "remove the person", "add color to this B&W photo"

6. **Best Practices**:
   - Be specific in prompts: include style, lighting, mood, composition
   - For text in images, use Pro model and specify font style
   - Use reference images (up to 14) for consistent results
   - Check API_GUIDE.md for pricing and rate limits

## Examples

Generate a simple image:
```bash
python "${CLAUDE_PLUGIN_ROOT}/skills/nano-banana-pro/scripts/nano_banana.py" generate "a futuristic city at sunset" -o city.png -r 16:9
```

Edit a photo:
```bash
python "${CLAUDE_PLUGIN_ROOT}/skills/nano-banana-pro/scripts/nano_banana.py" edit photo.jpg "remove the background and add a beach scene" -o edited_photo.png
```

Use style references:
```bash
python "${CLAUDE_PLUGIN_ROOT}/skills/nano-banana-pro/scripts/nano_banana.py" reference "product photo in this style" style1.png style2.png -m pro -o product.png
```
