# Nano Banana Pro API Quick Reference

## Models (Updated Dec 2025)

| Model | ID | Tier | Best For |
|-------|-----|------|----------|
| Flash | `gemini-2.5-flash-image` | Free | Balanced quality and speed (GA stable) |
| Pro | `gemini-3-pro-image-preview` | Paid | Best quality, text in images, references |

> **Note:** `gemini-2.5-flash-image-preview` will be shut down **January 15, 2026**. Use `gemini-2.5-flash-image` instead.

## Aspect Ratios

| Ratio | Use Case |
|-------|----------|
| `1:1` | Social media squares, profile pictures |
| `16:9` | Landscapes, YouTube thumbnails, banners |
| `9:16` | Mobile screens, Instagram stories, TikTok |
| `4:3` | Standard photos, presentations |
| `3:4` | Portrait photos |
| `3:2` | Classic photo format |
| `2:3` | Portrait classic format |
| `4:5` | Instagram portrait |
| `5:4` | Large format photography |
| `21:9` | Ultra-wide, cinematic |

## Resolutions

| Size | Best For | Pro Price |
|------|----------|-----------|
| `1K` | Quick previews, web thumbnails | ~$0.069 |
| `2K` | Standard quality, social media | ~$0.134 |
| `4K` | Print quality, professional use | ~$0.24 |

## Pricing (as of Dec 2025)

- **Flash model**: $0.039/image (has free tier)
- **Pro model**: $0.069/image for 1K, $0.134 for 2K, $0.24 for 4K
- **Batch API**: 50% discount, up to 24h processing

## Capabilities

### Flash Model
- Text-to-image generation
- Basic image editing
- Up to 3 reference images
- Good for prototyping

### Pro Model
- Superior text rendering in images
- Up to 14 reference images
- Search Grounding (real-time data)
- Character consistency
- 4K output support
- Better visual quality

## Important Notes

1. **SynthID Watermark**: All generated images have invisible SynthID watermark
2. **Safety Filters**: Some prompts may be blocked by safety filters
3. **Rate Limits**: Check Google AI Studio for current limits
4. **API Key**: Get at https://aistudio.google.com/apikey

## Common Prompt Tips

- Be specific about style, lighting, composition
- Include "high quality", "detailed", "professional" for better results
- For text in images, use Pro model and be explicit about text content
- Reference images should have consistent style for best results
