---
name: prompt-optimizer
description: Advanced prompt optimization and composition system for all prompt types (system prompts, task-specific, creative, technical, agentic). Use when users need to refine, optimize, or transform prompts to achieve better AI outputs. Triggers include requests to improve prompts, make prompts more effective, analyze prompt quality, create prompts from scratch, optimize existing prompts for specific goals, or optimize for Claude 4.x models. Also use when users share prompts that could be improved or ask for prompt engineering guidance.
---

# AI Best Prompt Optimizer and Composer

Transform prompts from functional to exceptional through deep analysis, strategic optimization, and iterative refinement. This skill applies "ultrathink" principles to prompt engineering—questioning assumptions, obsessing over details, and iterating relentlessly to create prompts that don't just work, but excel.

## Philosophy: Think Different About Prompts

Most prompts merely work. Great prompts are inevitable—they feel like the only right way to ask. Achieve this by:

- **Question every assumption**: Why this structure? What if we started from zero?
- **Obsess over details**: Every word choice matters. Every instruction must be precise yet clear.
- **Plan before writing**: Understand the goal deeply before crafting a single sentence.
- **Iterate relentlessly**: The first version is never the final version.
- **Simplify ruthlessly**: Remove complexity without losing power.

## Core Optimization Framework

### 1. Deep Understanding Phase

Before optimization, understand the prompt's true purpose:

**Questions to explore:**
- What is the desired output format and quality?
- Who is the audience? What's their expertise level?
- What context is essential vs. nice-to-have?
- What are the failure modes to prevent?
- Are there implicit assumptions that should be explicit?

**Analyze current prompt for:**
- Clarity of instructions
- Completeness of context
- Ambiguity or vagueness
- Missing constraints or guidelines
- Structural organization
- Token efficiency

### 2. Strategic Optimization by Prompt Type

#### For System Prompts (AI Agents/Chatbots)
- Define clear role and persona
- Establish behavioral boundaries and guardrails
- Specify output format and tone
- Include response patterns and examples
- Add error handling and edge cases
- Balance flexibility with consistency

#### For Task-Specific Prompts
- Break down complex tasks into clear steps
- Provide concrete examples (input/output pairs)
- Specify success criteria explicitly
- Include context about what NOT to do
- Add verification checkpoints
- Use structured formatting for clarity

#### For Creative Prompts
- Set the creative direction and constraints
- Inspire without over-constraining
- Provide style references or examples
- Balance guidance with creative freedom
- Include quality markers or criteria
- Encourage iteration and exploration

#### For Technical Prompts
- Maximize precision and specificity
- Include technical context and constraints
- Specify format requirements strictly
- Add validation criteria
- Consider edge cases explicitly
- Provide technical examples

#### For Agentic Prompts (AI Coding Tools)
- Define clear task boundaries and scope
- Specify file handling and code style expectations
- Include verification and testing requirements
- Add rollback and error recovery patterns
- Balance autonomy with user control
- Include progress reporting requirements

### 3. Structural Excellence

Apply these structural principles:

**Progressive disclosure:**
- Start with overview/context
- Move to specific instructions
- End with examples or constraints
- Use clear section headers

**Layered specificity:**
- General principles first
- Specific requirements second
- Edge cases and exceptions last

**Token efficiency:**
- Every sentence must justify its existence
- Prefer concise clarity over verbose explanation
- Remove redundancy ruthlessly
- Use formatting (bullets, headers) for scannability

### 4. Quality Markers

Excellent prompts exhibit:

- **Clarity**: No ambiguity in what's expected
- **Completeness**: All necessary context provided
- **Conciseness**: No unnecessary verbosity
- **Specificity**: Concrete rather than abstract
- **Structure**: Logically organized and scannable
- **Examples**: Show, don't just tell
- **Constraints**: Clear boundaries and guardrails
- **Testability**: Output quality can be verified

## Optimization Process

### Step 1: Analyze
Deeply understand the current prompt:
- Identify the core objective
- Note strengths and weaknesses
- Spot missing elements
- Find opportunities for improvement

### Step 2: Plan
Design the optimization strategy:
- Determine which type of optimization needed (quick polish vs. deep transformation)
- Identify key improvements to make
- Plan the new structure
- Consider alternative approaches

### Step 3: Optimize
Transform the prompt:
- Rewrite unclear instructions
- Add missing context
- Reorganize for clarity
- Insert concrete examples
- Refine word choices
- Apply structural principles

### Step 4: Validate
Ensure quality:
- Does it meet all quality markers?
- Will it produce the desired output?
- Are there edge cases to handle?
- Is it token-efficient?
- Can it be simplified further?

### Step 5: Present
Show the transformation:
- Present optimized prompt
- Explain key changes made
- Describe expected output improvements
- Highlight structural enhancements
- Note any assumptions or decisions

## Output Format

When presenting optimized prompts, provide:

### 1. Optimized Prompt
The complete, ready-to-use optimized prompt with clear formatting.

### 2. Key Improvements
Concise list of major enhancements:
- What changed and why
- Expected impact on outputs
- Any trade-offs made

### 3. Expected Output Changes
Describe how the output will improve:
- Quality enhancements
- Consistency improvements
- Better handling of edge cases
- More aligned with goals

### 4. Implementation Notes (if applicable)
- Suggested variations for different contexts
- Tips for further customization
- Potential iterative refinements

## Adaptive Optimization Levels

### Quick Polish
For prompts that are mostly good but need refinement:
- Fix clarity issues
- Add missing constraints
- Improve structure
- Refine word choices
- ~10-30% transformation

### Balanced Enhancement
For prompts that work but could be significantly better:
- Restructure for clarity
- Add examples and context
- Enhance specificity
- Apply quality markers
- ~30-60% transformation

### Deep Transformation
For prompts that need fundamental redesign:
- Question core approach
- Redesign from principles
- Add comprehensive framework
- Include extensive examples
- ~60-100% transformation

Automatically adapt the optimization level based on prompt quality and user goals.

## Iterative Refinement

When users want to iterate on an optimized prompt:

1. **Gather feedback**: What works? What doesn't?
2. **Identify specific issues**: Pinpoint exact problems
3. **Propose targeted fixes**: Address specific concerns
4. **Test and refine**: Iterate until excellent
5. **Document learnings**: Note patterns for future prompts

## Ultrathink Principles Applied to Prompting

From the "ultrathink" philosophy:

**Think Different:**
- Challenge conventional prompt structures
- Explore unconventional approaches
- Question what's "always done this way"

**Obsess Over Details:**
- Every word choice matters
- Punctuation affects interpretation
- Structure influences parsing
- Examples shape understanding

**Plan Like Da Vinci:**
- Understand the goal completely
- Sketch the architecture mentally
- Design before writing
- Make every element intentional

**Craft, Don't Code:**
- Elegance in simplicity
- Natural flow of instructions
- Beautiful structure
- Intuitive organization

**Iterate Relentlessly:**
- First version is just the beginning
- Test against edge cases
- Refine based on results
- Never settle for "good enough"

**Simplify Ruthlessly:**
- Remove all unnecessary complexity
- Clear > clever
- Concise > comprehensive
- Essential > exhaustive

## Final Principles

Excellence in prompt engineering isn't about length—it's about precision, clarity, and thoughtful design. Apply ultrathink principles consistently:

1. **Question assumptions** - Why does it have to work this way?
2. **Obsess over details** - Every word matters
3. **Plan thoroughly** - Design before writing
4. **Craft beautifully** - Elegant, intuitive structure
5. **Iterate relentlessly** - First version is never final
6. **Simplify ruthlessly** - Remove all excess

The best prompts feel inevitable—like there's no other way they could have been written.
