# Resume Optimization Report

**Date**: [YYYY-MM-DD]
**Resume**: [filename]
**Target Role**: [role or "general optimization"]

---

## Executive Summary

[2-3 sentence overview of current state and key recommendations]

**Overall Assessment**: [Strong/Good/Needs Improvement]

**Priority Level**:
- 🔴 Critical Issues: [count]
- 🟡 Improvements: [count]
- 🟢 Enhancements: [count]

---

## 🔴 Critical Issues (Must Fix)

### 1. [Issue Category]

**Location**: [Section name or line reference]

**Current**:
```
[Current text or formatting]
```

**Issue**: [Clear explanation of what's wrong]

**Fix**:
```
[Specific corrected version]
```

**Rationale**: [Why this fix works better - cite hiring manager insights]

---

### 2. [Next Critical Issue]

[Repeat format...]

---

## 🟡 Improvement Opportunities

### 1. [Improvement Category]

**Location**: [Section or specific bullets]

**Current**:
```
[Current text]
```

**Suggested Improvement**:
```
[Improved version]
```

**Why This Works**: [Explanation with STAR/XYZ/CAR framework application]

---

### 2. [Next Improvement]

[Repeat format...]

---

## 🟢 Enhancement Suggestions

### 1. [Enhancement Area]

**Recommendation**: [What to add/change]

**Implementation**:
```
[Concrete example or template]
```

**Expected Impact**: [How this enhances the resume]

---

## Section-by-Section Analysis

### Professional Summary / Header
- **Current state**: [assessment]
- **Recommendations**: [list]

### Skills Section
- **Current state**: [assessment]
- **Missing keywords**: [list if job description provided]
- **Recommendations**: [list]

### Work Experience
- **Number of positions**: [count]
- **STAR/XYZ compliance**: [X/Y bullets comply]
- **Quantification rate**: [X% of bullets quantified]
- **Recommendations**: [list]

### Education
- **Current state**: [assessment]
- **Recommendations**: [list]

### Projects (if applicable)
- **Current state**: [assessment]
- **Recommendations**: [list]

---

## Keyword Analysis

[Only if job description was provided]

### Required Keywords Present
- ✅ [keyword 1]
- ✅ [keyword 2]
- ❌ [missing keyword 3]

### Recommended Additions
1. [keyword]: [where/how to integrate]
2. [keyword]: [where/how to integrate]

---

## Action Verb Audit

### Weak Verbs to Replace

| Current Verb | Location | Suggested Replacement |
|-------------|----------|---------------------|
| helped | Experience, Bullet 3 | implemented / led |
| worked on | Experience, Bullet 5 | developed / built |

### Strong Verbs Already Used ✅
- [verb 1], [verb 2], [verb 3]

---

## Formatting Checklist

- [ ] Single page (or appropriate for experience level)
- [ ] Single spacing with good white space
- [ ] Standard font, 10.5pt+ black text
- [ ] Clean single-column layout
- [ ] All bullets 1-2 lines max
- [ ] No bullets extending past dates
- [ ] Consistent date formatting
- [ ] No orphan words on line wraps
- [ ] All links functional

---

## Quantification Opportunities

### Bullets Currently Lacking Metrics

**Line/Location**: [reference]
```
Current: [bullet text]

Questions to Ask:
- How many users/services/requests?
- What was the performance improvement?
- How much time/cost saved?
- What was the scale/scope?

Suggested with estimates:
[example with reasonable quantification]
```

---

## ATS Optimization Score

**Current ATS-Friendliness**: [Score out of 10]

### Strengths:
- ✅ [strength 1]
- ✅ [strength 2]

### Areas for Improvement:
- ⚠️ [issue 1]
- ⚠️ [issue 2]

---

## Job-Specific Tailoring

[Only if job description provided]

### Role Match Analysis
- **Alignment with job requirements**: [High/Medium/Low]
- **Keyword coverage**: [X/Y required keywords present]
- **Experience relevance**: [assessment]

### Tailoring Recommendations
1. [Specific change for this role]
2. [Specific change for this role]
3. [Specific change for this role]

---

## Next Steps (Prioritized)

1. **Immediate (Do first)**:
   - [ ] [Critical fix 1]
   - [ ] [Critical fix 2]

2. **Short-term (This week)**:
   - [ ] [Important improvement 1]
   - [ ] [Important improvement 2]

3. **Ongoing optimization**:
   - [ ] [Enhancement 1]
   - [ ] [Enhancement 2]

---

## Before/After Examples

### Example 1: [Bullet Point Improvement]

**Before**:
```
Worked on backend APIs using Python
```

**After**:
```
Built RESTful API serving 50K requests/second using Python FastAPI
with PostgreSQL, supporting real-time notifications for 500K+ users
```

**Improvements Applied**:
- ✅ Changed weak verb ("worked on" → "built")
- ✅ Added quantification (50K req/s, 500K users)
- ✅ Technical specificity (FastAPI, PostgreSQL, RESTful)
- ✅ Business context (real-time notifications)

---

### Example 2: [Another Improvement]

[Repeat format...]

---

## Resources & References

**Methodologies Applied**:
- STAR Method (Situation, Task, Action, Result)
- XYZ Formula (Accomplished X measured by Y, by doing Z)
- CAR Method (Challenge, Action, Result)

**Sources**:
- r/EngineeringResumes Wiki formatting guidelines
- Tech Interview Handbook FAANG strategies
- Hiring manager direct feedback (Meta, defense/aerospace)
- ATS optimization research (Jobscan 2.5M resume analysis)

---

## Questions for Clarification

[If any details need user input]

1. [Question about specific experience/metric]
2. [Question about target role/company]
3. [Question about technical details]

---

**Report prepared by**: Resume Optimizer Skill
**Optimization framework**: STAR/XYZ/CAR + ATS Best Practices + Hiring Manager Insights
