---
name: consistency-checker
description: 写作过程中自动检查角色行为、世界规则和时间线一致性，在问题成为严重错误前主动提醒
allowed-tools: ["Read", "Grep"]
triggers:
  - type: keyword
    keywords: ["一致性", "检查", "consistency", "check"]
  - type: context
    condition: "during /write"
  - type: always
---

# 故事一致性监控

## 自动检查系统

本技能在后台自动运行，无需用户主动调用。

### 监控范围

#### 角色一致性

- **物理特征**：眼睛颜色、身高、年龄、疤痕等
- **性格特质**：行为符合已建立的角色性格
- **知识状态**：角色只知道他们应该知道的信息
- **成长弧线**：变化与角色发展逻辑一致

#### 世界规则

- **能力体系**：魔法/科技/武功等力量使用一致
- **地理设定**：距离和地点保持稳定
- **社会规则**：文化和习俗不矛盾
- **物理法则**：已建立的规则不随机改变

#### 时间线逻辑

- **事件顺序**：A 在逻辑上发生在 B 之前
- **时间流逝**：角色适当地老化/成长
- **同时事件**：多视角时间线对齐
- **历史一致性**：对过去的引用保持一致

### 工作原理

**被动监控**：当你写作或讨论故事时，我会自动交叉参考：

1. `spec/knowledge/characters/` 目录中的角色档案
2. `spec/knowledge/worldbuilding/` 目录中的世界构建文档
3. `spec/tracking/timeline.json` 中的时间线数据
4. 之前章节的内容

**无需额外操作** - 监控在后台自动进行。

## 检测到问题时

### 警报格式

当检测到潜在不一致时，会这样提醒你：

**⚠️ 一致性检查警报**

```
问题类型：角色特征不匹配
位置：当前章节，第3段
参考：characters/mary-chen.md，第15行

当前文本："玛丽的绿色眼睛眯起..."
已建立特征："眼睛颜色：蓝色"（在第3章中设定）

可能的解决方案：
1. 将当前文本改为"蓝色眼睛"
2. 如果要修改设定，同时更新角色档案
3. 这是一个同名的不同角色？

你想让我自动修复这个，还是你自己处理？
```

### 严重程度级别

| 级别 | 图标 | 响应 | 示例 |
|------|------|------|------|
| **严重** | 🔴 | 立即停止并修复 | 角色突然知道不应知道的秘密 |
| **警告** | ⚠️ | 尽快修复 | 角色的言语模式改变了 |
| **注意** | 📝 | 考虑检查 | 时间线感觉略微压缩 |

## 与命令集成

### 在 `/write` 期间

- 实时一致性检查
- 对严重问题即时警报
- 自动参考规格文档

### 在 `/analyze` 期间

- 全面的一致性报告
- 所有累积的警告和注意事项
- 按严重性排序的修复建议

## 配置严格程度

### 严格模式（非奇幻作品默认）

- 标记所有矛盾
- 执行真实世界物理规则
- 时间线必须完全合理

### 灵活模式（推荐用于奇幻/科幻）

- 允许"酷炫规则"例外
- 魔法/科技可以弯曲现实
- 允许艺术许可，但会通知

### 最小模式

- 只标记严重矛盾
- 专注于角色和主要情节点
- 让小的不一致通过

## 常见误报处理

有时会标记实际上正确的内容：

### 有意的矛盾

**示例**：角色谎报自己的眼睛颜色

**修复**：在角色档案中添加注释：
```
// 眼睛实际上是蓝色的，但告诉别人是绿色的
```

### 不可靠叙述者

**示例**：第一人称叙述者记错事件

**修复**：在宪法中注明：
```
不可靠叙述者 - 记忆不一致是有意的
```

### 时间跳跃

**示例**：角色年龄突然增加

**修复**：在章节中明确说明：
```
"三年后..."
```

## 最佳实践

### 保持参考文档更新

一致性检查只能和你的文档一样好：

- 特征变化时更新角色档案
- 清楚地记录世界规则
- 维护时间线文件

### 及时处理警报

不要让一致性问题累积：

- 立即修复严重警报
- 在写作会话结束时审查警告
- 在修订阶段批处理注意事项

## 检查类别详解

### 角色一致性检查

**物理描述**：
```
✓ 检查：身高、体重、年龄、发色、眼色
✓ 检查：疤痕、纹身、独特标记
✓ 检查：服装风格、配饰
```

**行为模式**：
```
✓ 检查：言语模式是否一致
✓ 检查：反应是否符合性格
✓ 检查：决策是否符合价值观
✓ 检查：技能/能力是否一致
```

**知识状态**：
```
✓ 检查：角色知道什么时候知道的
✓ 检查：他们不知道不应该知道的秘密
✓ 检查：记忆与已建立事实一致
```

### 世界规则检查

**能力系统**：
```
✓ 检查：力量在已建立限制内使用
✓ 检查：代价/成本一致应用
✓ 检查：规则不为情节便利而改变
✓ 检查：例外有前期铺垫
```

**地理和距离**：
```
✓ 检查：地点保持一致
✓ 检查：旅行时间合理
✓ 检查：气候与地理匹配
✓ 检查：地标不移动
```

### 时间线检查

**事件序列**：
```
✓ 检查：原因发生在结果之前
✓ 检查：角色不在不可能的地方
✓ 检查：事件在合理时间内发生
```

**时间流逝**：
```
✓ 检查：角色适当地老化
✓ 检查：季节按顺序改变
✓ 检查：怀孕/康复需要适当时间
✓ 检查：技能习得需要练习时间
```

## 自动修复功能

对于某些简单问题，我可以提供自动修复：

### 自动修复类型

**拼写变化**：
```
检测：角色名字拼写不一致
建议：标准化为最常见的拼写
行动：全局查找并替换（经你批准）
```

**数字不一致**：
```
检测：角色年龄在章节间不匹配
建议：基于时间线计算正确年龄
行动：更新到正确数字
```

**时间线冲突**：
```
检测：事件日期与已建立时间线冲突
建议：调整日期以适应已知序列
行动：更新时间线参考
```

## 报告和追踪

### 一致性报告示例

```markdown
## 一致性报告 - 2024-01-15

### 章节范围：第1-15章

### 检测到的问题

#### 严重（必须修复）
1. 第12章：角色知道只在第14章揭示的信息
   - 修复：重写第12章场景或移动第14章揭示更早

#### 警告（应该修复）
1. 第8章：角色的眼睛颜色从蓝色变为绿色
   - 修复建议：将第8章更新为蓝色或更新角色档案
   
2. 第10章：从首都到边境的旅行只用了1天（之前建立为3天）
   - 修复建议：添加时间跳跃或调整天数

#### 注意事项（考虑检查）
1. 第5章：角色反应似乎不符合特征
   - 审查：这是有意的成长还是不一致？

### 统计
- 总检查：456
- 问题发现：8
- 自动修复：3
- 需要审查：5

### 一致性得分：94%
```

---

**记住**：一致性不是关于完美 - 它是关于读者的信任。当世界规则可靠时，读者会沉浸其中。当规则似乎随意改变时，他们会被拉出体验。我在这里帮助维持这种信任。

**你总是有最后的决定权** - 如果不一致是艺术选择，告诉我，我会停止标记它。

