---
name: fantasy-world-building
description: "当用户提到奇幻、魔法系统或世界构建时使用 - 提供奇幻类型规范、魔法系统设计模式和世界构建框架"
allowed-tools: Read, Grep
---

# 奇幻小说世界构建规范

## 快速参考

| 元素          | 指导原则       | 关键点             |
| ------------- | -------------- | ------------------ |
| **魔法系统**  | 必须有清晰规则 | 限制比力量更重要   |
| **世界设定**  | 内在自洽       | 每个规则都有原因   |
| **种族/生物** | 独特且有逻辑   | 避免单纯的人类翻版 |
| **历史深度**  | 至少三代历史   | 过去影响现在       |
| **政治结构**  | 权力分布清晰   | 冲突有根源         |

## 核心原则

### Sanderson 魔法法则

**第一法则**：读者从魔法中获得的满足感，与其理解魔法的程度成正比

- 如果魔法要解决问题，读者必须理解它的规则
- 软魔法系统（神秘）用于氛围和奇观
- 硬魔法系统（规则明确）用于解决问题

**第二法则**：限制比力量更有趣

- 强大的魔法需要强大的代价
- 限制创造冲突和策略
- 完美的系统无法创造戏剧

**第三法则**：在添加新东西之前，先扩展已有的

- 深化现有元素胜过添加新元素
- 相互关联的系统比孤立的更强
- 复杂度应该有机生长

## 魔法系统设计

### 硬魔法系统（规则明确）

**必要元素**：

1. **能量来源**
    - 魔法从哪里来？
    - 是有限的还是无限的？
    - 可以耗尽吗？

2. **使用规则**
    - 谁能使用？如何获得？
    - 需要什么条件？
    - 有什么限制？

3. **代价/后果**
    - 使用魔法的成本是什么？
    - 过度使用会怎样？
    - 是否有长期影响？

4. **可能与不可能**
    - 魔法能做什么？
    - 明确不能做什么
    - 边界在哪里？

**示例框架**：

```
魔法系统：元素操控
来源：每个人出生时拥有一种元素亲和
规则：只能操控自己的元素，需要该元素存在于周围
限制：精神疲劳，过度使用导致元素反噬
代价：使用魔法时消耗生命力，需要休息恢复
禁忌：不能创造元素，只能操控；不能操控生物体内的元素
```

### 软魔法系统（神秘感）

**特征**：

- 规则不完全为读者所知
- 更多用于氛围和奇观
- 不应该方便地解决主要冲突
- 保持神秘感和敬畏

**使用场景**：

- 古老的魔法，已部分遗失
- 神祇力量，超越凡人理解
- 背景奇观和世界建设
- 不影响主线解决的辅助情节

## 世界构建框架

### 地理与环境

**必须考虑**：

1. **地形**
    - 山脉、河流、海洋如何影响文明？
    - 气候如何塑造文化？
    - 资源分布如何影响经济？

2. **生态系统**
    - 食物链是什么样的？
    - 魔法生物如何适应环境？
    - 人类/其他智慧种族如何生存？

3. **魔法对地理的影响**
    - 魔法如何改变自然？
    - 有魔法造成的地标吗？
    - 魔法灾难留下了什么痕迹？

### 社会与文化

**层次架构**：

**政治层面**：

- 政府形式（君主制、民主、神权等）
- 权力如何传递？
- 魔法如何影响政治？
- 不同派系的冲突

**经济层面**：

- 贸易什么？为什么？
- 货币系统
- 魔法如何影响经济？
- 资源稀缺性

**社会层面**：

- 阶级结构
- 种族关系
- 魔法使用者的地位
- 教育和知识传播

**文化层面**：

- 宗教和信仰
- 艺术和娱乐
- 节日和传统
- 价值观和禁忌

### 历史深度

**最少三代历史**：

**当代**（故事发生时）：

- 现状是什么？
- 主要冲突和问题
- 主要势力和人物

**父辈代**（30-50年前）：

- 什么事件塑造了当代？
- 老一辈记得什么？
- 遗留的问题

**祖辈代**（60-100年前）：

- 传说和故事
- 失落的知识
- 历史创伤

**古代**（更久远）：

- 神话和传说
- 文明的兴衰
- 为当代设定埋下种子

## 种族与生物设计

### 智慧种族

**避免单一特征**：
❌ 所有精灵都优雅高贵
❌ 所有矮人都贪婪暴躁
❌ 所有兽人都野蛮好战

**创造深度**：
✅ 内部多样性（不同文化、价值观）
✅ 个体差异（性格各异）
✅ 历史复杂性（好的和坏的历史）

**种族特征应该有原因**：

- 生理特征如何帮助生存？
- 文化特征从何而来？
- 与其他种族的关系历史

### 魔法生物

**设计原则**：

1. **生态位**
    - 它在生态系统中的角色？
    - 吃什么？被什么吃？
    - 如何繁殖？

2. **魔法来源**
    - 为什么有魔法？
    - 魔法如何帮助它生存？
    - 有什么代价或限制？

3. **与人类的关系**
    - 危险还是有用？
    - 能驯养吗？
    - 人类如何应对？

## 常见陷阱

### ❌ 过度解释

**问题**：花费章节解释世界设定，停止故事推进

**解决**：

- 在行动中展示设定
- 只解释角色需要知道的
- 让读者自己拼凑一些东西
- 信息应该服务于情节或角色

### ❌ 不一致的规则

**问题**：魔法/世界规则为了情节便利而改变

**解决**：

- 提前建立所有主要规则
- 跟踪已建立的规则
- 例外需要早期暗示
- 让角色在限制内创造性地解决问题

### ❌ 欧洲中世纪默认设置

**问题**：所有奇幻都是欧洲中世纪的翻版

**解决**：

- 探索其他文化和时期
- 混合多个文化元素
- 创造独特的社会结构
- 考虑魔法如何改变社会发展

### ❌ 选中之人陷阱

**问题**：主角因为预言/血统特殊，而非行动

**解决**：

- 让主角通过选择变得特殊
- 即使有预言，也让他们努力实现
- 颠覆或解构陷阱
- 专注于角色成长，而非天赋

## 奇幻子类型

### 高奇幻（史诗奇幻）

- 完全虚构的世界
- 善恶对抗
- 史诗般的规模和风险
- 魔法是世界的一部分

### 低奇幻

- 现实世界+魔法元素
- 较小的个人风险
- 魔法稀有且神秘
- 更接地气的基调

### 城市奇幻

- 现代城市设定
- 隐藏的魔法世界
- 通常有侦探/神秘元素
- 两个世界的碰撞

### 黑暗奇幻

- 道德灰色
- 恐怖和暴力元素
- 反英雄主角
- 更严酷的后果

## 与 Novel-Writer 命令集成

### 当 `/specify` 执行时

- 定义核心世界元素（魔法、种族、地理）
- 识别奇幻子类型
- 列出必须建立的主要规则
- 计划信息揭示的节奏

### 在 `/plan` 期间

- 绘制世界元素如何影响情节
- 计划魔法系统的展示
- 设计不同文化的碰撞
- 确保世界规则的一致性

### 在 `/write` 时

- 在行动中展示世界，而非倾倒
- 让角色对世界元素做出反应
- 使用感官细节使世界生动
- 保持已建立规则的一致性

### 在 `/analyze` 期间

- 检查世界规则的一致性
- 验证魔法系统的逻辑
- 确认所有世界元素都有目的
- 确保设定服务于故事

## 世界构建检查清单

- [ ] 魔法系统有清晰的规则和限制
- [ ] 地理和气候影响文化和情节
- [ ] 至少三代历史深度
- [ ] 多个政治势力有清晰动机
- [ ] 经济和贸易有逻辑基础
- [ ] 种族/文化有内部多样性
- [ ] 魔法生物有生态位和目的
- [ ] 宗教/信仰系统有影响
- [ ] 社会结构有明确阶级和流动性
- [ ] 所有规则在整个故事中保持一致

## 信息揭示策略

### 冰山原则

**创造的 vs 展示的**：

- 创造 100%，但只展示 10-20%
- 读者不需要知道所有东西
- 深度创造自信和一致性
- 作者知道的比展示的多

### 展示时机

**第一章**：

- 基本世界观（不是详尽说明）
- 一个引人注目的魔法/奇幻元素
- 主角在世界中的位置

**前 25%**：

- 核心魔法系统规则
- 主要种族/文化
- 中心冲突及其世界根源

**中段**：

- 深化已建立元素
- 复杂化世界政治
- 揭示历史影响

**后段**：

- 连接所有世界线索
- 揭示深层历史
- 展示世界元素如何解决冲突

## 读者期望

**奇幻读者想要什么**：

- 沉浸式、可信的世界
- 一致且有趣的魔法系统
- 复杂的文化和政治
- 对经典陷阱的新鲜视角
- 世界感觉比故事更大

**让奇幻读者沮丧的是什么**：

- 不一致的世界规则
- 方便情节的魔法
- 单薄的欧洲中世纪抄袭
- 缺乏深度的世界
- 信息倾倒而非有机揭示

---

**记住**：伟大的世界构建是故事的基础，而非目的。世界应该服务于角色和情节，而角色的行动应该受到世界规则的塑造和限制。平衡深度与叙事流畅性是关键。
