---
name: mystery-novel-conventions
description: "Use when user mentions mystery, detective, crime, or suspense-focused narrative - provides genre conventions, clue placement, and fair play principles for mystery writing"
allowed-tools: Read, Grep
---

# 悬疑推理小说创作规范

## 快速参考

| 元素 | 指导原则 | 位置 |
|------|---------|------|
| **触发事件** | 案件/谜团发生 | 前 10% |
| **误导线索** | 错误的引导 | 贯穿全文，3-5 个 |
| **真实线索** | 公平游戏的证据 | 75% 之前 |
| **真相揭露** | 真相揭示 | 85-95% |
| **收尾** | 结束所有线索 | 最后 5% |

## 核心原则

### 公平游戏原则

**黄金法则**：读者必须在侦探之前获得所有解决谜团所需的线索。

1. **没有隐藏信息**
   - 所有关键线索都必须呈现给读者
   - 侦探不能基于读者不知道的信息破案
   - 只在结尾揭示的秘密证据违反公平游戏

2. **逻辑推理**
   - 解决方案必须能从呈现的事实中逻辑推导
   - 巧合可以使情况复杂化，但永远不能解决
   - 直觉可以，但必须基于已展示的证据

3. **不使用机械降神**
   - 不能突然出现新角色作为罪犯
   - 不能有之前未提及的能力或工具
   - 不能有神的干预或纯粹的运气

## 悬疑小说结构

### 第一幕：铺垫（0-25%）

**建立常态世界**：
- 介绍主角和他们的世界
- 展示角色能力
- 埋下性格怪癖的种子

**案件发生**：
- 在前 10% 发生
- 必须足够有趣/不寻常以证明调查的必要性
- 风险应该清晰

**初步调查**：
- 主角接受案件
- 首次访谈和证据收集
- 建立关键嫌疑人

### 第二幕：调查（25-75%）

**收集线索**：
- 呈现所有公平游戏的证据
- 混合真实线索与误导线索
- 每条线索都应该感觉重要

**误导线索**：
- 3-5 条看似有希望的虚假线索
- 必须足够可信以误导
- 最终通过逻辑调查证伪

**复杂化升级**：
- 新证据与旧理论矛盾
- 嫌疑人有不在场证明或秘密
- 风险升级（更多案件、主角面临危险）

**中点转折**（约 50%）：
- 重新框架谜团的重大揭示
- 主角的理论被证明错误
- 新角度出现

### 第三幕：解决（75-100%）

**黑暗之夜**（75-85%）：
- 主角似乎被难住
- 所有理论都失败了
- 绝望或怀疑的时刻

**真相揭露**（85-95%）：
- 关键洞察连接所有点
- 主角重构真相
- 与罪犯对峙

**收尾**（95-100%）：
- 解释如何/为什么
- 所有松散的线索被收紧
- 正义得到伸张（或有意颠覆）

## 线索布置策略

### 线索类型

**物理证据**：
- 物品、指纹、DNA
- 必须在需要之前埋下
- 重要性最初可能不清楚

**证言证据**：
- 证人陈述
- 不在场证明及其矛盾
- 谎言（有意或无意）

**行为证据**：
- 角色对事件的反应
- 不寻常的行为模式
- 通过行动揭示的动机

**circumstantial证据**：
- 机会、手段、动机
- 模式和联系
- 时间线不一致

### 线索布置时机

**早期线索**（0-25%）：
- 建立基准事实
- 埋下看似无辜的种子
- 介绍所有关键嫌疑人

**中期线索**（25-75%）：
- 混合真实线索与误导线索
- 使情况复杂化
- 揭示角色动机

**后期线索**（75-85%）：
- 使其可解的最后一块拼图
- 可以是一直存在的东西
- 主角的顿悟时刻

## 误导线索最佳实践

### 有效的误导线索

**特征**：
- 足够可信以显得真实
- 有一些证据支持
- 最终通过逻辑被证伪
- 揭示为虚假时不显得廉价

**示例**：
- 有强烈动机但坚实不在场证明的嫌疑人
- 被栽赃的有罪证据
- 巧合出现在犯罪现场
- 看起来有罪但实际无辜的秘密活动

### 常见错误

❌ **太明显**：读者立即看穿
❌ **太勉强**：感觉强迫和人为
❌ **从不解释**：悬而未决没有解决
❌ **太多**：读者失去追踪并感到沮丧

## 嫌疑人管理

### 经典设置

**至少 3 个嫌疑人**：
- 每个都需要动机、手段和机会
- 每个在某个时刻都应该显得有罪
- 至少一个应该是同情的

**罪犯**：
- 应该在介绍的角色中（公平游戏）
- 必须有最终揭示的逻辑动机
- 他们有罪的线索必须从早期就存在

**误导嫌疑人**：
- 最明显的选择
- 强烈的动机和间接证据
- 最终通过调查被排除

**同情嫌疑人**：
- 读者希望不是有罪的
- 有值得保护的秘密
- 通常帮助解决真正的谜团

### 角色秘密

**每个嫌疑人都应该有秘密**：
- 不是所有秘密都与案件相关
- 秘密创造误导
- 揭示秘密推进调查
- 有些秘密比案件更具破坏性

## 常见陷阱

### ❌ 不可知的解决方案

**问题**：罪犯或方法依赖读者没有的信息

**解决**：在 75% 标记之前埋下所有必要线索；读者应该能够解决

### ❌ 无能的侦探

**问题**：主角错过明显线索或行为不合逻辑

**解决**：让侦探有能力但人性化；他们可以犯错，但不是愚蠢

### ❌ 太多巧合

**问题**：情节通过方便的运气而非调查推进

**解决**：巧合可以使情况复杂化，永远不能解决；侦探必须努力寻找答案

### ❌ 无聊的中段

**问题**：调查变成重复的访谈接访谈

**解决**：变化调查方法；添加动作、危险、个人风险

### ❌ 仓促的解释

**问题**：复杂的解决方案在最后一章的对话中倾倒

**解决**：分散揭示；让读者拼凑；保持解释清晰但不冗长

## 子类型变化

### 温馨推理
- 业余侦探
- 有限的暴力描写
- 小社区背景
- 角色驱动
- 通常幽默的基调

### 硬派侦探
- 专业调查员
- 粗糙、现实的暴力
- 道德复杂的世界
- 愤世嫉俗的基调
- 动作导向

### 警察程序
- 专注于调查过程
- 多个侦探/团队
- 现实的程序
- 技术细节重要
- 官僚主义作为障碍

### 密室推理
- 不可能的犯罪场景
- 有限的嫌疑人（谁有机会）
- 巧妙的方法是关键
- 解决方案必须合乎逻辑

## 与 Novel-Writer 命令集成

### 当 `/specify` 执行时
- 清晰定义中心谜团
- 列出所有主要嫌疑人及其动机
- 识别关键线索及其出现位置
- 决定公平游戏规则

### 在 `/plan` 期间
- 绘制线索布置时间线
- 设计误导线索模式
- 计划调查序列
- 结构揭示和反转

### 在 `/write` 时
- 确保线索可见但不明显
- 平衡调查与角色发展
- 保持节奏（动作、揭示、复杂化）
- 跟踪读者知道什么vs侦探知道什么

### 在 `/analyze` 期间
- 验证公平游戏 - 读者能解决吗？
- 检查所有线索是否已埋下
- 确保没有机械降神
- 确认令人满意的解决

## 悬疑写作检查清单

- [ ] 中心谜团引人入胜且清晰
- [ ] 3-5 个有动机的可行嫌疑人
- [ ] 揭示前呈现所有关键线索
- [ ] 误导线索可信且最终得到解释
- [ ] 侦探有能力且合乎逻辑
- [ ] 解决方案可从给定信息推导
- [ ] 没有巧合解决谜团
- [ ] 时间线一致且可追踪
- [ ] 所有松散的线索都被收紧
- [ ] 揭示令人满意，而非令人失望

## 线索可见性框架

### 三个层次

**层次 1 - 明显**（25% 的线索）：
- 引入时明确重要
- 主角和读者一起注意到
- 建立基准事实

**层次 2 - 微妙**（50% 的线索）：
- 提及但不强调
- 重要性后来变得清晰
- 奖励细心的读者

**层次 3 - 藏在显眼处**（25% 的线索）：
- 引入时看似无关紧要
- 只有在回顾时才有意义
- "啊哈！"时刻

### 示例

**层次 1**："窗户从里面解锁"  
**层次 2**：角色在闲聊中提到自己是左撇子  
**层次 3**：房间描述包括烟灰缸中的特定品牌香烟

## 读者期望

**悬疑读者想要什么**：
- 与侦探一起解决的公平机会
- 事后有意义的聪明转折
- 有能力但会犯错的主角
- 令人满意的"啊哈！"时刻
- 正义（或有目的的有意颠覆）

**让悬疑读者沮丧的是什么**：
- 只在结尾揭示的隐藏信息
- 通过未展示的推理解决的主角
- 勉强的巧合
- 没有误导的明显罪犯
- 松散的线索悬而未决

---

**记住**：一个伟大的谜团让读者因解决它而感到聪明，或因没有看到它而印象深刻 - 但总是满意线索一直都在那里。
