---
name: getting-started-guide
description: "Activates when users start a new novel project - guides them through the seven-step methodology (constitution → specify → clarify → plan → tasks → write → analyze) with gentle prompts and explanations"
allowed-tools: Read
---

# 新用户入门引导

## 激活条件

当用户说出以下内容时自动激活：
- "我想写小说"
- "我要开始一个新项目"
- "怎么使用novel-writer"
- "从哪里开始"

---

## 七步方法论引导

### 欢迎消息

```
👋 欢迎使用Novel Writer Skills！

我注意到你要开始一个新的小说项目。
Novel Writer使用系统化的七步方法论，帮助你从想法到完稿。

让我带你快速了解流程：

第1步：/constitution - 创建创作宪法
第2步：/specify - 定义故事规格
第3步：/clarify - 澄清模糊点（5个问题）
第4步：/plan - 制定创作计划
第5步：/tasks - 分解任务清单
第6步：/write - 执行章节写作
第7步：/analyze - 质量验证分析

想要详细了解每一步吗？还是直接开始第1步？
```

### 步骤详解（根据需要提供）

```
【第1步：/constitution】
创建你的创作宪法 - 这是最高原则。
- 核心价值观（你想传达什么？）
- 质量标准（什么算好的章节？）
- 禁忌红线（不能写什么？）

为什么重要：后续所有创作都要符合宪法。

【第2步：/specify】
定义故事规格 - 明确你要写什么。
- 故事概念、类型、主题
- 目标读者、字数、结局
- 必须包含的元素（P0）

为什么重要：规格是技术需求，避免写到一半发现偏题。

【第3步：/clarify】
AI提出5个关键问题，帮你澄清模糊点。
- 针对specification中的不明确之处
- 逼迫你想清楚细节

为什么重要：模糊的规格=模糊的故事。

【第4步：/plan】
制定创作计划 - 技术方案。
- 章节架构、节奏设计
- 关键情节点时间线
- 技术难点的解决方案

为什么重要：计划详细，执行才顺畅。

【第5步：/tasks】
分解任务清单 - 可执行的步骤。
- 每个章节一个任务
- 标记状态（pending/in_progress/completed）
- 追踪进度

为什么重要：大目标拆解成小任务，不overwhelm。

【第6步：/write】
执行写作 - 基于任务清单。
- 自动加载所有context
- 遵循宪法、规格、计划
- 质量自检后保存

为什么重要：这是七步方法论的优势集中体现。

【第7步：/analyze】
质量验证 - 确保一致性。
- 框架检查（结构、节奏）
- 内容检查（一致性、质量）
- 发现问题，建议修复

为什么重要：定期分析，及时调整，避免大返工。
```

---

## 常见问题快速解答

### Q: 必须按顺序执行吗？

**A**: 推荐按顺序，但不强制。

```
推荐流程：1→2→3→4→5→6→7（循环6-7）

允许跳步：
- 有经验的作者可以跳过/clarify
- 短篇可以简化/plan

不推荐：
- 直接跳到/write（缺少规格和计划，容易写乱）
```

### Q: 七步走完要多久？

**A**: 取决于故事复杂度。

```
简单故事（5万字短篇）：
- 步骤1-5：2-3小时
- 步骤6-7：执行写作，持续进行

复杂故事（50万字长篇）：
- 步骤1-5：1-2天
- 步骤6-7：数月

前期投入换来后期顺畅。
```

### Q: 可以中途修改吗？

**A**: 当然！

```
发现规格不对：
→ 修改specification.md
→ 重新运行/plan调整计划

计划需要调整：
→ 修改creative-plan.md
→ 更新tasks.md

这是迭代过程，不是一次定死。
```

---

## 第一次使用建议

### 从简单项目开始

```
✓ 推荐：
- 5-10万字的中短篇
- 单一类型（言情/悬疑/历史）
- 简单情节（1-2条主线）

⚠️ 不推荐初次就写：
- 50万字+的长篇
- 多类型融合（如言情+悬疑+奇幻+历史）
- 超复杂世界观

先熟悉流程，再挑战复杂项目。
```

### 执行第一个命令

```
准备好了？让我们开始第1步：

执行命令：/constitution

我会引导你创建创作宪法。
准备回答以下问题：
1. 这个故事你想传达什么核心理念？
2. 你对质量的标准是什么？
3. 有哪些内容是绝对不能写的？

准备好了就输入：/constitution
```

---

## 与workflow-guide的配合

```
getting-started：
- 初次使用时激活
- 提供完整流程概览
- 回答入门问题

workflow-guide：
- 整个创作过程中持续激活
- 偏离流程时温和提醒
- 提供最佳实践建议

两者互补：
getting-started = 入门教程
workflow-guide = 持续顾问
```

---

## 总结

getting-started-guide = 你的**入门向导**

✓ 自动识别新用户
✓ 引导七步方法论
✓ 回答常见问题
✓ 给出第一步建议

**让第一次使用不再迷茫！** 🚀

---

**本Skill版本**: v1.0
**最后更新**: 2025-10-18
