---
name: requirement-detector
description: "探测用户的写作规范需求并加载对应文档。当用户提到AI味重、去AI味、自然、爽文、快节奏、爽点、无毒点、不降智、严肃文学、有深度、强情绪、打动人、甜文、撒糖、虐文、虐心、BE等关键词时自动激活。适用于讨论写作要求、AI去味方法、节奏控制、情感表达时使用。"
allowed-tools: Read, Edit
---

# 写作规范探测器

## 核心功能

自动探测用户的写作规范需求，并无缝加载对应的规范知识库。

## 可探测的规范

### 1. anti-ai-v4（强力AI去味）
- **适合**：对AI味零容忍的作品、需要极致口语化的小说
- **特点**：200+ 禁用词汇表、6层规则体系、极致自然化
- **触发词**：AI味重、去AI味、太机器、不自然、最强去味

### 2. anti-ai-v3（标准AI去味）
- **适合**：大部分现代小说、需要平衡自然感和文学性
- **特点**：平衡的去AI策略、适度的词汇限制
- **触发词**：自然一点、少一点AI感、适度去AI、标准去味

### 3. fast-paced（快节奏/爽文规范）
- **适合**：都市爽文、玄幻升级流、系统文、重生文
- **特点**：每章至少2个爽点、打脸/装逼/升级公式
- **触发词**：爽文、快节奏、爽点、打脸、装逼、升级

### 4. no-poison（无毒点规范）
- **适合**：所有类型小说（通用）、重视逻辑性的作品
- **特点**：避免降智、强行误会、玛丽苏、工具人、逻辑漏洞
- **触发词**：无毒点、不降智、逻辑自洽、合理、不强行

### 5. serious-literature（严肃文学规范）
- **适合**：现实主义小说、历史小说、社会问题小说
- **特点**：现实主义手法、思想性和哲学探讨、语言克制
- **触发词**：严肃文学、纯文学、有深度、思想性、人性探讨

### 6. strong-emotion（强情绪规范）
- **适合**：情感类小说、虐文、需要感染力的作品
- **特点**：每10-15章至少1个情绪爆发点、波浪式情绪节奏
- **触发词**：情绪饱满、情感强烈、有感染力、打动人心

### 7. romance-sweet（甜文规范）
- **适合**：言情甜文、现代甜宠、轻松向恋爱故事
- **特点**：糖分密度配置、冲突控制、禁止BE倾向
- **触发词**：甜文、撒糖、高糖、齁甜、甜宠、HE

### 8. romance-angst（虐文规范）
- **适合**：虐恋小说、悲剧向爱情、刀子文
- **特点**：虐要有理有度、虐点设计、虐度等级控制
- **触发词**：虐文、虐心、BE、刀子、分离虐、时机虐

详细关键词列表和触发场景请参阅 [KEYWORDS.md](KEYWORDS.md)。

---

## 激活后的工作流程

### 步骤 1：确认规范选择

当探测到关键词后，首先确认用户意图：

```
我注意到你提到了【AI味重、去AI味】，这通常对应 anti-ai-v4 规范。

我可以：
1. 📖 展示这个规范的详细文档
2. ✅ 直接应用这个规范到你的项目
3. 🔍 看看其他规范选项

你想要哪一个？
```

### 步骤 2：加载规范知识库

如果用户确认，使用 Read 工具读取对应的知识库文件：

```
📖 读取：.claude/knowledge-base/requirements/{requirement-name}.md
```

然后展示核心要点，完整规范已加载到上下文中。

### 步骤 3：写入配置标记

使用 Edit 工具在用户的 `specification.md` 中添加配置：

```yaml
---
writing-requirements:
  - anti-ai-v4
  - fast-paced
---
```

提示用户配置已保存，在执行 /write 时会自动遵守这些规范。

---

## 多规范处理

当探测到多个规范关键词时，进行兼容性检测：

- **兼容组合**：自动组合并说明综合效果
- **冲突组合**：提示矛盾并给出解决方案

详细的冲突处理逻辑请参阅 [CONFLICT_RESOLUTION.md](CONFLICT_RESOLUTION.md)。

---

## 主动建议

- **基于风格建议规范**：如果 style-detector 已激活，主动推荐配套规范
- **中途调整支持**：持续监控用户反馈，支持规范调整

---

## 与 style-detector 的配合

本 Skill 专注于规范层面，与 style-detector（文风层）协同工作：

```
用户输入："我要写都市爽文，口语化，去AI味"

style-detector → 识别：natural-voice
requirement-detector → 识别：fast-paced + anti-ai-v4

最终配置：
writing-style: natural-voice
writing-requirements:
  - fast-paced
  - anti-ai-v4

效果：自然人声的快节奏爽文，强力去AI味
```

---

## 使用示例

完整的对话示例和成功案例请参阅 [EXAMPLES.md](EXAMPLES.md)。

---

**Skill 版本**：v1.1
**最后更新**：2025-10-19
**兼容版本**：novel-writer-skills v1.0.5+
