# 多风格探测与冲突处理

当探测到多个风格关键词时，需要进行冲突检测并提供解决方案。

---

## 场景 1：兼容的组合

### 示例：natural-voice + literary

**用户说**：
> "我要写都市小说，口语化一点，但也要有点文学性"

**探测结果**：
- natural-voice（口语化）
- literary（文学性）

**处理方式**：
```markdown
🔍 多风格探测结果

检测到：
- natural-voice（因为"口语化"）
- literary（因为"文学性"）

这两个风格可以混合使用！

建议方案：
1. 主风格：natural-voice (70%) + 辅助：literary (30%)
   - 对话和日常用口语化
   - 关键时刻加入文学化描写

2. 主风格：literary (60%) + 辅助：natural-voice (40%)
   - 整体保持文学性
   - 对话部分口语化

你倾向哪种比例？
```

---

## 场景 2：冲突的组合

### 示例：minimal + literary

**用户说**：
> "我要极简风格，但也要华丽的辞藻"

**探测结果**：
- minimal（极简）
- literary（华丽）- 冲突！

**处理方式**：
```markdown
⚠️ 风格冲突检测

检测到：
- minimal（极简风格） - 要求删除所有修饰
- literary（文学风格） - 需要优美的语言

这两个风格有冲突：
- 极简要求：删除形容词、极短句、零修饰
- 文学要求：精准词汇、美感、适度修饰

建议：
1. 选择 minimal，放弃华丽辞藻
2. 选择 literary，调整"极简"为"简洁"
3. 考虑使用 natural-voice（介于两者之间）

你倾向哪个方向？
```

---

## 冲突矩阵

| 组合 | 兼容性 | 处理方式 |
|------|--------|---------|
| natural-voice + literary | ✅ 兼容 | 提供比例混合方案 |
| natural-voice + web-novel | ✅ 兼容 | 口语化网文，推荐 |
| natural-voice + ancient-style | ⚠️ 谨慎 | 现代口语 vs 古韵，需要平衡 |
| natural-voice + minimal | ⚠️ 谨慎 | 都强调简洁，可以组合 |
| literary + web-novel | ⚠️ 谨慎 | 文学性 vs 爽文套路，需取舍 |
| literary + ancient-style | ✅ 兼容 | 都重视意境，推荐 |
| literary + minimal | ❌ 冲突 | 华丽 vs 极简，矛盾 |
| web-novel + ancient-style | ⚠️ 谨慎 | 快节奏 vs 古韵留白，需平衡 |
| web-novel + minimal | ❌ 冲突 | 套路化 vs 极简主义，矛盾 |
| ancient-style + minimal | ⚠️ 谨慎 | 意象 vs 克制，可以尝试 |

---

## 中途调整风格

即使项目已经开始，仍然持续监控用户反馈。

### 场景：中途切换风格

**用户在第10章时说**：
> "这几章写得太文艺了，我想换成口语化一点"

**探测器激活**：
```markdown
🎨 风格调整探测

检测到你想调整风格：
当前风格：literary
建议新风格：natural-voice

这会影响后续章节的写作。

调整建议：
1. 从下一章开始使用新风格
2. 不修改已写章节（保持一致性）

确认调整吗？
```

---

## 处理原则

1. **优先用户意图**：当用户明确表达偏好时，尊重用户选择
2. **提供选项**：遇到冲突时，给出2-3个解决方案
3. **解释原因**：说明为什么冲突，帮助用户理解
4. **支持混合**：对于兼容的组合，提供比例建议
5. **允许调整**：支持中途切换，但提醒影响范围
