---
name: style-detector
description: "探测用户的写作风格需求并加载对应指南。当用户提到口语化、生活化、真实感、文学性、严肃文学、纯文学、网文、爽文、快节奏、古风、武侠、古韵、极简、海明威、克制等关键词时自动激活。适用于讨论小说风格、写作文风、创作方向时使用。"
allowed-tools: Read, Edit
---

# 写作风格探测器

## 核心功能

自动探测用户的写作风格需求，并无缝加载对应的风格知识库。

## 可探测的风格

### 1. natural-voice（自然人声风格）
- **适合**：都市现代小说、现实题材、情感类小说
- **特点**：口语化、生活化、真实感强
- **触发词**：口语化、真实感、接地气、像说话一样

### 2. literary（文学风格）
- **适合**：严肃文学作品、历史小说、需要思想深度的故事
- **特点**：优美、深刻、有文学性、注重意境
- **触发词**：文学性、严肃文学、纯文学、有深度

### 3. web-novel（网文风格）
- **适合**：玄幻小说、都市爽文、系统流、重生流
- **特点**：节奏快、冲突密集、爽点频繁
- **触发词**：网文、爽文、打脸、装逼、升级流

### 4. ancient-style（古风）
- **适合**：武侠小说、仙侠、古代背景小说
- **特点**：有古韵但不纯文言、意象丰富、诗意化
- **触发词**：古风、古韵、武侠风、江湖味

### 5. minimal（极简风格）
- **适合**：悬疑推理、冷硬派小说、实验性作品
- **特点**：高度简洁、海明威式克制、留白艺术
- **触发词**：极简、海明威、克制、冷硬

详细关键词列表和触发场景请参阅 [KEYWORDS.md](KEYWORDS.md)。

---

## 激活后的工作流程

### 步骤 1：确认风格选择

当探测到关键词后，首先确认用户意图：

```
我注意到你提到了【口语化】，这通常对应 natural-voice 风格。

我可以：
1. 📖 展示这个风格的详细指南
2. ✅ 直接应用这个风格到你的项目
3. 🔍 看看其他风格选项

你想要哪一个？
```

### 步骤 2：加载风格知识库

如果用户确认，使用 Read 工具读取对应的知识库文件：

```
📖 读取：.claude/knowledge-base/styles/{style-name}.md
```

然后展示核心要点，完整规范已加载到上下文中。

### 步骤 3：写入配置标记

使用 Edit 工具在用户的 `specification.md` 中添加配置：

```yaml
---
writing-style: natural-voice
---
```

提示用户配置已保存，在执行 /write 时会自动遵守该风格规范。

---

## 多风格处理

当探测到多个风格关键词时，进行兼容性检测：

- **兼容组合**：提供混合方案和比例建议
- **冲突组合**：提示矛盾并给出解决方案

详细的冲突处理逻辑请参阅 [CONFLICT_RESOLUTION.md](CONFLICT_RESOLUTION.md)。

---

## 主动建议

- **基于故事类型建议风格**：分析 specification 中的故事类型，主动推荐适合的风格
- **中途调整支持**：持续监控用户反馈，支持风格调整

---

## 与 requirement-detector 的配合

本 Skill 专注于文风层面，与 requirement-detector（规范层）协同工作：

```
style-detector → 识别文风 → 加载 styles/*.md
requirement-detector → 识别规范 → 加载 requirements/*.md

最终组合效果示例：
natural-voice (风格) + anti-ai-v4 + fast-paced (规范)
= 自然人声的快节奏爽文，强力去AI味
```

---

## 使用示例

完整的对话示例和成功案例请参阅 [EXAMPLES.md](EXAMPLES.md)。

---

**Skill 版本**：v1.1
**最后更新**：2025-10-19
**兼容版本**：novel-writer-skills v1.0.5+
