---
name: scene-structure-techniques
description: "Use when structuring scenes or planning chapter content - provides scene-sequel framework, tension management, and beat-by-beat structure for compelling scenes"
allowed-tools: Read
---

# 场景结构写作技巧

## 什么是场景？

**场景**是实时发生的冲突单元，角色追求目标并面对障碍。

**不是场景**：说明、背景故事、旅行、时间流逝  
**是场景**：争论、谈判、追逐、揭露

## 场景-续场模型

每个场景都应该遵循这个模式：

```
场景（行动）           续场（反应）
├── 目标              ├── 情绪
├── 冲突              ├── 困境
└── 灾难/成功          └── 决定
```

## 场景结构（行动）

### 1. 目标

**POV角色在这个场景想要什么？**

必须是：
- **具体的**："拿到钥匙" 而非 "搞清楚事情"
- **可实现的**：可能在这个场景成功或失败
- **紧迫的**：现在重要，不是最终

**你的角色的场景目标**：
> [明确、具体、紧迫]

**他们为什么现在想要这个？**：
> [情境/紧迫性]

### 2. 冲突

**什么阻止他们得到想要的？**

冲突类型：
- **外部**：另一个角色反对他们
- **环境**：物理障碍
- **内部**：他们自己的恐惧或犹豫
- **时间**：时间不够
- **信息**：缺少关键知识

**最好的场景结合 2-3 种冲突类型。**

**你的场景冲突**：
1. > [主要障碍]
2. > [次要障碍]
3. > [可选第三个]

### 3. 灾难或成功

**场景如何解决？**

**灾难**（更常见）：
- 他们未能得到想要的
- 他们得到了，但代价可怕
- 他们得到了更糟的东西

**成功**（谨慎使用）：
- 他们实现目标
- 但揭示更大的问题
- 或成功是空洞的

**你的场景解决**：
> [灾难或成功 + 后果]

## 续场结构（反应）

在紧张场景之后，读者需要**续场** - 角色处理的安静时刻。

### 1. 情绪反应

**角色对刚发生的事情感觉如何？**

展示不要说：
- **不好**："莎拉感到悲伤"
- **好**："莎拉的手不停颤抖"

**你的角色的即时情绪**：
> [情绪的身体表现]

### 2. 困境

**灾难创造了一个困境 - 没有好选择：**

- 选项 A：安全但妥协价值观
- 选项 B：冒险但保持正直
- 选项 C：中间路线，但不确定

**你的角色的困境**：
- 选项 A：> [安全选择]
- 选项 B：> [冒险选择]
- 选项 C：> [中间地带]

### 3. 决定

**他们决定做什么？**

这个决定成为下一个场景的目标。

**你的角色的决定**：
> [他们接下来要做什么]

**这成为下一个场景的目标**，创造无缝的场景到场景连接。

## 场景节奏点

现在让我们构建场景的实际节奏（微时刻）：

### 开场节奏

**我们如何进入场景？**

- 尽可能晚地开始
- 直接进入冲突/张力
- 快速建立 POV 和地点

**糟糕的开场**："莎拉醒来，刷牙，吃早餐..."
**好的开场**："莎拉的手机嗡嗡响。信息来自她死去的姐姐。"

**你的开场节奏**：
> [用户提供]

### 上升张力节奏

**冲突如何升级？**

每个节奏应该：
1. **提高风险**
2. **使情况复杂化**
3. **揭示角色**

**示例升级**：
```
节奏 1：莎拉要求文件 → 被拒绝
节奏 2：莎拉诉诸友谊 → 老板揭示他知道她的秘密
节奏 3：莎拉威胁辞职 → 老板揭示他一直在保护她
节奏 4：莎拉意识到她错了 → 现在必须在忠诚中选择
```

**你的升级节奏（3-5个）**：
1. > [第一个节奏]
2. > [第二个节奏]
3. > [第三个节奏]
4. > [可选第四个]
5. > [可选第五个]

### 高潮节奏

**最高张力的时刻**

这是：
- 角色做出关键选择的地方
- 真相被揭示的地方
- 行动达到峰值强度的地方
- 一切悬而未决的地方

**你的高潮节奏**：
> [用户提供]

### 解决节奏

**即时后果**

不要在高潮结束 - 给一个节奏的余波：
- 角色的即时反应
- 什么改变了
- 暗示接下来会发生什么

**你的解决节奏**：
> [用户提供]

## 张力管理

### 张力级别

场景应该在强度上有所不同：

```
高张力（30%）   ⚡️ 行动、对抗、揭露
中等张力（50%） 🔥 调查、计划、建立
低张力（20%）   🌊 反思、连接、设置
```

**太多高张力** = 读者疲劳
**太多低张力** = 读者无聊

**这个场景的张力级别是什么？**
> [用户选择]

**上一个场景的张力是什么？**
> [用户提供或我参考追踪数据]

**基于节奏的建议**：
> [我建议这是否是好的节奏或是否应该调整]

## 场景检查清单

在你写这个场景之前，验证：

- [ ] **明确目标**：POV 角色想要具体的东西
- [ ] **有意义的风险**：目标对角色重要
- [ ] **重大冲突**：真正的障碍，不容易克服
- [ ] **上升张力**：每个节奏增加压力
- [ ] **灾难或成功**：场景以变化结束
- [ ] **情感真实**：角色的反应是真实的
- [ ] **故事推进**：场景推进情节或角色弧
- [ ] **感官细节**：设定生动，不通用
- [ ] **对话中的潜台词**：角色不直接说所有事情
- [ ] **这个角色独有**：只有这个角色能以这种方式体验场景

**准备写了吗？** 我将根据你的答案提供场景大纲。

## 生成的场景大纲

基于你的答案，这是你的场景结构：

```markdown
## 场景：[场景名称/描述]

**POV**：[角色名称]
**地点**：[哪里]
**时间**：[故事中的何时]
**张力级别**：[高/中/低]

### 场景目标
[角色] 想要 [具体目标] 因为 [紧迫性/动机]。

### 冲突
1. [主要障碍]
2. [次要障碍]
3. [额外复杂化]

### 场景节奏

**开场**：[进入场景...]

**节奏 1 - 设置**：[角色行动/情况]
**节奏 2 - 复杂化**：[引入冲突]
**节奏 3 - 升级**：[风险提高]
**节奏 4 - 危机**：[不归路]
**节奏 5 - 高潮**：[最高张力时刻]

**解决**：[即时后果]

### 灾难/成功
[场景如何结束] → [后果]

### 续场（如果需要）

**情绪**：[角色的反应]
**困境**：[他们权衡的选项]
**决定**：[他们选择做什么]
→ 这导致下一个场景目标：[下一个场景目标]

### 要包含的关键元素
- [ ] 感官细节：[特定的景象、声音、气味]
- [ ] 对话潜台词：[什么没有被说]
- [ ] 角色特定反应：[他们如何独特地响应]
- [ ] 主题连接：[场景如何与故事主题相关]

### 写作笔记
[这个场景的任何特定指导]
```

## 与 Novel-Writer 命令集成

**保存大纲到**：`scenes/[章节号]-[场景名称].md`

**写作时**：使用 `/write` 并参考这个大纲：
```
/write 第5章 - 对抗场景

参考：scenes/chapter-5-confrontation.md
```

场景大纲将指导写作，相关技能将激活：
- 对话技巧用于对话节奏
- 节奏监控用于张力管理
- 一致性检查用于角色行为

## 高级场景类型

一旦你熟悉基本场景，我可以指导你通过专门的场景类型：

- **动作场景**：管理多个同时发生的事件
- **揭露场景**：控制信息披露
- **亲密场景**：平衡身体和情感
- **群体场景**：管理多个角色动态
- **回忆场景**：整合过去与现在

**你想要任何这些专门场景类型的指导吗？**

## 场景续场平衡

**场景（行动）vs 续场（反应）的比例**：

- **快节奏惊悚**：80% 场景，20% 续场
- **平衡故事**：60% 场景，40% 续场
- **角色驱动**：50% 场景，50% 续场

**调整基于**：
- 类型期望
- 当前故事阶段
- 最近的张力级别
- 读者需要喘息

## 常见场景问题

### 问题：场景拖沓，没有前进

**诊断**：
- 没有明确目标？
- 冲突太弱？
- 太多描述，不够行动？

**解决**：
- 明确目标
- 增加障碍
- 削减到本质

### 问题：场景感觉通用

**诊断**：
- 可能发生在任何角色身上？
- 设定是通用的"房间"或"街道"？
- 对话可以被任何人说？

**解决**：
- 添加角色特定的反应
- 使用具体、独特的设定细节
- 应用角色声音到对话

### 问题：读者困惑

**诊断**：
- POV 不清楚？
- 太多角色同时？
- 物理空间不清楚？

**解决**：
- 早期建立清晰的 POV
- 限制活跃角色到 2-4
- 描述空间布局

---

**记住**：一个精心构建的场景是有目的的伟大故事讲述的构建块。每个场景都应该改变某些东西 - 情况、关系或角色理解。如果场景结束时一切都一样，就删除它或重写它。

