---
name: employment-contract-templates
description: Create employment contracts, offer letters, and HR policy documents following legal best practices. Use when drafting employment agreements, creating HR policies, or standardizing employment documentation.
---

# Employment Contract Templates

Templates and patterns for creating legally sound employment documentation including contracts, offer letters, and HR policies.

## When to Use This Skill

- Drafting employment contracts
- Creating offer letters
- Writing employee handbooks
- Developing HR policies
- Standardizing employment documentation
- Onboarding documentation

## Core Concepts

### 1. Employment Document Types

| Document | Purpose | When Used |
|----------|---------|-----------|
| **Offer Letter** | Initial job offer | Pre-hire |
| **Employment Contract** | Formal agreement | Hire |
| **Employee Handbook** | Policies & procedures | Onboarding |
| **NDA** | Confidentiality | Before access |
| **Non-Compete** | Competition restriction | Hire/Exit |

### 2. Key Legal Considerations

```
Employment Relationship:
├── At-Will vs. Contract
├── Employee vs. Contractor
├── Full-Time vs. Part-Time
├── Exempt vs. Non-Exempt
└── Jurisdiction-Specific Requirements
```

**DISCLAIMER: These templates are for informational purposes only and do not constitute legal advice. Consult with qualified legal counsel before using any employment documents.**

## Templates

### Template 1: Offer Letter

```markdown
# EMPLOYMENT OFFER LETTER

[Company Letterhead]

Date: [DATE]

[Candidate Name]
[Address]
[City, State ZIP]

Dear [Candidate Name],

We are pleased to extend an offer of employment for the position of [JOB TITLE]
at [COMPANY NAME]. We believe your skills and experience will be valuable
additions to our team.

## Position Details

**Title:** [Job Title]
**Department:** [Department]
**Reports To:** [Manager Name/Title]
**Location:** [Office Location / Remote]
**Start Date:** [Proposed Start Date]
**Employment Type:** [Full-Time/Part-Time], [Exempt/Non-Exempt]

## Compensation

**Base Salary:** $[AMOUNT] per [year/hour], paid [bi-weekly/semi-monthly/monthly]
**Bonus:** [Eligible for annual bonus of up to X% based on company and individual
performance / Not applicable]
**Equity:** [X shares of stock options vesting over 4 years with 1-year cliff /
Not applicable]

## Benefits

You will be eligible for our standard benefits package, including:
- Health insurance (medical, dental, vision) effective [date]
- 401(k) with [X]% company match
- [X] days paid time off per year
- [X] paid holidays
- [Other benefits]

Full details will be provided during onboarding.

## Contingencies

This offer is contingent upon:
- Successful completion of background check
- Verification of your right to work in [Country]
- Execution of required employment documents including:
  - Confidentiality Agreement
  - [Non-Compete Agreement, if applicable]
  - [IP Assignment Agreement]

## At-Will Employment

Please note that employment with [Company Name] is at-will. This means that
either you or the Company may terminate the employment relationship at any time,
with or without cause or notice. This offer letter does not constitute a
contract of employment for any specific period.

## Acceptance

To accept this offer, please sign below and return by [DEADLINE DATE]. This
offer will expire if not accepted by that date.

We are excited about the possibility of you joining our team. If you have any
questions, please contact [HR Contact] at [email/phone].

Sincerely,

_________________________
[Hiring Manager Name]
[Title]
[Company Name]

---

## ACCEPTANCE

I accept this offer of employment and agree to the terms stated above.

Signature: _________________________

Printed Name: _________________________

Date: _________________________

Anticipated Start Date: _________________________
```

### Template 2: Employment Agreement (Contract Position)

```markdown
# EMPLOYMENT AGREEMENT

This Employment Agreement ("Agreement") is entered into as of [DATE]
("Effective Date") by and between:

**Employer:** [COMPANY LEGAL NAME], a [State] [corporation/LLC]
with principal offices at [Address] ("Company")

**Employee:** [EMPLOYEE NAME], an individual residing at [Address] ("Employee")

## 1. EMPLOYMENT

1.1 **Position.** The Company agrees to employ Employee as [JOB TITLE],
reporting to [Manager Title]. Employee accepts such employment subject to
the terms of this Agreement.

1.2 **Duties.** Employee shall perform duties consistent with their position,
including but not limited to:
- [Primary duty 1]
- [Primary duty 2]
- [Primary duty 3]
- Other duties as reasonably assigned

1.3 **Best Efforts.** Employee agrees to devote their full business time,
attention, and best efforts to the Company's business during employment.

1.4 **Location.** Employee's primary work location shall be [Location/Remote].
[Travel requirements, if any.]

## 2. TERM

2.1 **Employment Period.** This Agreement shall commence on [START DATE] and
continue until terminated as provided herein.

2.2 **At-Will Employment.** [FOR AT-WILL STATES] Notwithstanding anything
herein, employment is at-will and may be terminated by either party at any
time, with or without cause or notice.

[OR FOR FIXED TERM:]
2.2 **Fixed Term.** This Agreement is for a fixed term of [X] months/years,
ending on [END DATE], unless terminated earlier as provided herein or extended
by mutual written agreement.

## 3. COMPENSATION

3.1 **Base Salary.** Employee shall receive a base salary of $[AMOUNT] per year,
payable in accordance with the Company's standard payroll practices, subject to
applicable withholdings.

3.2 **Bonus.** Employee may be eligible for an annual discretionary bonus of up
to [X]% of base salary, based on [criteria]. Bonus payments are at Company's
sole discretion and require active employment at payment date.

3.3 **Equity.** [If applicable] Subject to Board approval and the Company's
equity incentive plan, Employee shall be granted [X shares/options] under the
terms of a separate Stock Option Agreement.

3.4 **Benefits.** Employee shall be entitled to participate in benefit plans
offered to similarly situated employees, subject to plan terms and eligibility
requirements.

3.5 **Expenses.** Company shall reimburse Employee for reasonable business
expenses incurred in accordance with Company policy.

## 4. CONFIDENTIALITY

4.1 **Confidential Information.** Employee acknowledges access to confidential
and proprietary information including: trade secrets, business plans, customer
lists, financial data, technical information, and other non-public information
("Confidential Information").

4.2 **Non-Disclosure.** During and after employment, Employee shall not
disclose, use, or permit use of any Confidential Information except as required
for their duties or with prior written consent.

4.3 **Return of Materials.** Upon termination, Employee shall immediately return
all Company property and Confidential Information in any form.

4.4 **Survival.** Confidentiality obligations survive termination indefinitely
for trade secrets and for [3] years for other Confidential Information.

## 5. INTELLECTUAL PROPERTY

5.1 **Work Product.** All inventions, discoveries, works, and developments
created by Employee during employment, relating to Company's business, or using
Company resources ("Work Product") shall be Company's sole property.

5.2 **Assignment.** Employee hereby assigns to Company all rights in Work
Product, including all intellectual property rights.

5.3 **Assistance.** Employee agrees to execute documents and take actions
necessary to perfect Company's rights in Work Product.

5.4 **Prior Inventions.** Attached as Exhibit A is a list of any prior
inventions that Employee wishes to exclude from this Agreement.

## 6. NON-COMPETITION AND NON-SOLICITATION

[NOTE: Enforceability varies by jurisdiction. Consult local counsel.]

6.1 **Non-Competition.** During employment and for [12] months after
termination, Employee shall not, directly or indirectly, engage in any business
competitive with Company's business within [Geographic Area].

6.2 **Non-Solicitation of Customers.** During employment and for [12] months
after termination, Employee shall not solicit any customer of the Company for
competing products or services.

6.3 **Non-Solicitation of Employees.** During employment and for [12] months
after termination, Employee shall not recruit or solicit any Company employee
to leave Company employment.

## 7. TERMINATION

7.1 **By Company for Cause.** Company may terminate immediately for Cause,
defined as:
(a) Material breach of this Agreement
(b) Conviction of a felony
(c) Fraud, dishonesty, or gross misconduct
(d) Failure to perform duties after written notice and cure period

7.2 **By Company Without Cause.** Company may terminate without Cause upon
[30] days written notice.

7.3 **By Employee.** Employee may terminate upon [30] days written notice.

7.4 **Severance.** [If applicable] Upon termination without Cause, Employee
shall receive [X] weeks base salary as severance, contingent upon execution
of a release agreement.

7.5 **Effect of Termination.** Upon termination:
- All compensation earned through termination date shall be paid
- Unvested equity shall be forfeited
- Benefits terminate per plan terms
- Sections 4, 5, 6, 8, and 9 survive termination

## 8. GENERAL PROVISIONS

8.1 **Entire Agreement.** This Agreement constitutes the entire agreement and
supersedes all prior negotiations, representations, and agreements.

8.2 **Amendments.** This Agreement may be amended only by written agreement
signed by both parties.

8.3 **Governing Law.** This Agreement shall be governed by the laws of [State],
without regard to conflicts of law principles.

8.4 **Dispute Resolution.** [Arbitration clause or jurisdiction selection]

8.5 **Severability.** If any provision is unenforceable, it shall be modified
to the minimum extent necessary, and remaining provisions shall remain in effect.

8.6 **Notices.** Notices shall be in writing and delivered to addresses above.

8.7 **Assignment.** Employee may not assign this Agreement. Company may assign
to a successor.

8.8 **Waiver.** Failure to enforce any provision shall not constitute waiver.

## 9. ACKNOWLEDGMENTS

Employee acknowledges:
- Having read and understood this Agreement
- Having opportunity to consult with counsel
- Agreeing to all terms voluntarily

---

IN WITNESS WHEREOF, the parties have executed this Agreement as of the
Effective Date.

**[COMPANY NAME]**

By: _________________________
Name: [Authorized Signatory]
Title: [Title]
Date: _________________________

**EMPLOYEE**

Signature: _________________________
Name: [Employee Name]
Date: _________________________

---

## EXHIBIT A: PRIOR INVENTIONS

[Employee to list any prior inventions, if any, or write "None"]

_________________________
```

### Template 3: Employee Handbook Policy Section

```markdown
# EMPLOYEE HANDBOOK - POLICY SECTION

## EMPLOYMENT POLICIES

### Equal Employment Opportunity

[Company Name] is an equal opportunity employer. We do not discriminate based on
race, color, religion, sex, sexual orientation, gender identity, national
origin, age, disability, veteran status, or any other protected characteristic.

This policy applies to all employment practices including:
- Recruitment and hiring
- Compensation and benefits
- Training and development
- Promotions and transfers
- Termination

### Anti-Harassment Policy

[Company Name] is committed to providing a workplace free from harassment.
Harassment based on any protected characteristic is strictly prohibited.

**Prohibited Conduct Includes:**
- Unwelcome sexual advances or requests for sexual favors
- Offensive comments, jokes, or slurs
- Physical conduct such as assault or unwanted touching
- Visual conduct such as displaying offensive images
- Threatening, intimidating, or hostile acts

**Reporting Procedure:**
1. Report to your manager, HR, or any member of leadership
2. Reports may be made verbally or in writing
3. Anonymous reports are accepted via [hotline/email]

**Investigation:**
All reports will be promptly investigated. Retaliation against anyone who
reports harassment is strictly prohibited and will result in disciplinary
action up to termination.

### Work Hours and Attendance

**Standard Hours:** [8:00 AM - 5:00 PM, Monday through Friday]
**Core Hours:** [10:00 AM - 3:00 PM] - Employees expected to be available
**Flexible Work:** [Policy on remote work, flexible scheduling]

**Attendance Expectations:**
- Notify your manager as soon as possible if you will be absent
- Excessive unexcused absences may result in disciplinary action
- [X] unexcused absences in [Y] days considered excessive

### Paid Time Off (PTO)

**PTO Accrual:**
| Years of Service | Annual PTO Days |
|------------------|-----------------|
| 0-2 years        | 15 days         |
| 3-5 years        | 20 days         |
| 6+ years         | 25 days         |

**PTO Guidelines:**
- PTO accrues per pay period
- Maximum accrual: [X] days (use it or lose it after)
- Request PTO at least [2] weeks in advance
- Manager approval required
- PTO may not be taken during [blackout periods]

### Sick Leave

- [X] days sick leave per year
- May be used for personal illness or family member care
- Doctor's note required for absences exceeding [3] days

### Holidays

The following paid holidays are observed:
- New Year's Day
- Martin Luther King Jr. Day
- Presidents Day
- Memorial Day
- Independence Day
- Labor Day
- Thanksgiving Day
- Day after Thanksgiving
- Christmas Day
- [Floating holiday]

### Code of Conduct

All employees are expected to:
- Act with integrity and honesty
- Treat colleagues, customers, and partners with respect
- Protect company confidential information
- Avoid conflicts of interest
- Comply with all laws and regulations
- Report any violations of this code

**Violations may result in disciplinary action up to and including termination.**

### Technology and Communication

**Acceptable Use:**
- Company technology is for business purposes
- Limited personal use is permitted if it doesn't interfere with work
- No illegal activities or viewing inappropriate content

**Monitoring:**
- Company reserves the right to monitor company systems
- Employees should have no expectation of privacy on company devices

**Security:**
- Use strong passwords and enable 2FA
- Report security incidents immediately
- Lock devices when unattended

### Social Media Policy

**Personal Social Media:**
- Clearly state opinions are your own, not the company's
- Do not share confidential company information
- Be respectful and professional

**Company Social Media:**
- Only authorized personnel may post on behalf of the company
- Follow brand guidelines
- Escalate negative comments to [Marketing/PR]

---

## ACKNOWLEDGMENT

I acknowledge that I have received a copy of the Employee Handbook and
understand that:

1. I am responsible for reading and understanding its contents
2. The handbook does not create a contract of employment
3. Policies may be changed at any time at the company's discretion
4. Employment is at-will [if applicable]

I agree to abide by the policies and procedures outlined in this handbook.

Employee Signature: _________________________

Employee Name (Print): _________________________

Date: _________________________
```

## Best Practices

### Do's
- **Consult legal counsel** - Employment law varies by jurisdiction
- **Keep copies signed** - Document all agreements
- **Update regularly** - Laws and policies change
- **Be clear and specific** - Avoid ambiguity
- **Train managers** - On policies and procedures

### Don'ts
- **Don't use generic templates** - Customize for your jurisdiction
- **Don't make promises** - That could create implied contracts
- **Don't discriminate** - In language or application
- **Don't forget at-will language** - Where applicable
- **Don't skip review** - Have legal counsel review all documents

## Resources

- [SHRM Employment Templates](https://www.shrm.org/)
- [Department of Labor](https://www.dol.gov/)
- [EEOC Guidance](https://www.eeoc.gov/)
- State-specific labor departments
