# 图像生成提示词参考

本文档提供了针对不同主题的图像生成提示词模板，确保生成的插画符合 Skill 规范。

## 通用模板

```
Create a cute, rounded, cartoon 3D illustration with a [主题] theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
[具体描述元素和场景]
Composition: Main 3D elements MUST be positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% MUST be clean empty space with a subtle [颜色] gradient background.
Lighting: Bright and soft lighting.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

## 主题示例

### 科技/AI 主题

```
Create a cute, rounded, cartoon 3D illustration with an AI/robot theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: A friendly round robot with simple geometric shapes, holding a glowing lightbulb, surrounded by floating cute cloud icons.
Composition: Robot positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle blue-to-white gradient background.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：蓝色系（#E3F2FD → #FFFFFF）

---

### 阅读/书籍主题

```
Create a cute, rounded, cartoon 3D illustration with a reading/books theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: A stack of colorful rounded books with a cute reading lamp, some books slightly open with soft pages.
Composition: Books positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle warm beige gradient background.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：暖米色系（#FFF8E1 → #FFFBF0）

---

### 咖啡/饮品主题

```
Create a cute, rounded, cartoon 3D illustration with a coffee theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: A rounded coffee cup with steam swirls, surrounded by cute coffee beans and a small plate with cookies.
Composition: Coffee cup positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle brown-to-cream gradient background.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：棕色系（#EFEBE9 → #FFF3E0）

---

### 健康/运动主题

```
Create a cute, rounded, cartoon 3D illustration with a health/fitness theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: Cute dumbbells, a yoga mat rolled up, a water bottle, and a heart icon, all with rounded edges.
Composition: Elements positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle green-to-white gradient background.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：绿色系（#E8F5E9 → #FFFFFF）

---

### 旅行/探险主题

```
Create a cute, rounded, cartoon 3D illustration with a travel/adventure theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: A cute rounded suitcase with travel stickers, a camera, a globe, and a paper airplane.
Composition: Elements positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle sky blue gradient background.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：天蓝色系（#E1F5FE → #F1F8FF）

---

### 美食/烹饪主题

```
Create a cute, rounded, cartoon 3D illustration with a food/cooking theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: A cute chef's hat, a rounded pot with steam, some vegetables with happy faces.
Composition: Elements positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle orange-to-cream gradient background.
Lighting: Bright and soft lighting with warm tones.
Aspect ratio: 2.35:1 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：橙色系（#FFF3E0 → #FFFAF0）

---

### 音乐/艺术主题

```
Create a cute, rounded, cartoon 3D illustration with a music/art theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: Cute rounded musical notes, a simplified guitar or keyboard, headphones with soft edges.
Composition: Elements positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle purple-to-white gradient background.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：紫色系（#F3E5F5 → #FAFAFA）

---

### 金融/商业主题

```
Create a cute, rounded, cartoon 3D illustration with a finance/business theme.
Style: Pixar-like animation, toy-like texture, soft edges, matte/clay-like materials, bright and soft lighting, vibrant colors.
Features: Cute rounded coins, a piggy bank with friendly face, a simple bar chart made of rounded blocks.
Composition: Elements positioned in the RIGHT 30-40% of the image.
The LEFT 60-70% is clean empty space with a subtle gold-to-cream gradient background.
Aspect ratio: 21:9 (ultra-wide)
IMPORTANT: NO text, NO letters, NO numbers, NO borders, NO neon, NO cyberpunk, NO dark themes, NO abstract tech lines, NO glassmorphism, NO photorealism.
```

**配色建议**：金色系（#FFF8E1 → #FFFEF7）

---

## 关键词速查表

| 主题类别 | 核心元素关键词 | 推荐配色 |
|---------|--------------|---------|
| 科技/AI | robot, computer, lightbulb, gears, clouds | 蓝色系 |
| 阅读 | books, lamp, glasses, bookmark | 米色系 |
| 咖啡 | coffee cup, steam, beans, cookies | 棕色系 |
| 健康 | dumbbells, yoga mat, heart, water bottle | 绿色系 |
| 旅行 | suitcase, globe, camera, airplane | 天蓝色 |
| 美食 | chef hat, pot, vegetables, utensils | 橙色系 |
| 音乐 | notes, instruments, headphones | 紫色系 |
| 金融 | coins, piggy bank, chart, wallet | 金色系 |

## 使用技巧

1. **保持简洁**：每个场景 3-5 个元素最佳
2. **强调圆润**：多次提及 "rounded", "soft edges", "cute"
3. **明确材质**：始终包含 "matte/clay-like materials" 和 "toy-like texture"
4. **严格禁止**：始终包含完整的禁止条款，包括 "NO glassmorphism, NO photorealism"
5. **留白区域**：明确指出左侧 60-70% 必须是干净的渐变背景
6. **尺寸规范**：严格使用 21:9 宽高比（3024x1296像素）
