# 公众号封面生成器 - 使用指南

## 快速开始

### 安装 Skill

1. 将 `mp-cover-generator` 文件夹压缩为 `mp-cover-generator.zip`
2. 在 Claude Code 中打开设置 > Capabilities
3. 上传 ZIP 文件
4. 启用该 Skill

### 基本使用

只需告诉 Claude 你要生成公众号封面，并提供主题和标题即可：

```
生成一个公众号封面，主题是"人工智能"，标题是"AI如何改变我们的生活"
```

Claude 会自动：
1. 生成符合规范的 3D 插画底图
2. 叠加标题、日期、作者等文字
3. 输出完整的 HTML 文件

## 输入参数说明

### 必填参数

- **主题关键词**：用于生成插画的主题，例如：
  - AI / 人工智能
  - 科技 / Technology
  - 阅读 / Reading
  - 健康 / Health
  - 旅行 / Travel

- **标题**：封面的核心标题文字，建议 8-15 个字

### 自动生成参数

- **日期**：自动使用当前日期（格式：`Fri. 11.11`）
- **作者名**：固定为"纯白精选"

## 示例

### 示例 1：科技主题

**输入：**
```
生成公众号封面
主题：人工智能
标题：未来已来，AI重塑世界
```

**输出：**
- 底图：右侧有可爱的机器人 3D 插画
- 文字：左侧显示标题、日期、作者
- 风格：明亮、柔和、圆润

### 示例 2：生活方式主题

**输入：**
```
做一个封面图，关于咖啡文化，标题"一杯咖啡的故事"
```

**输出：**
- 底图：右侧有可爱的咖啡杯 3D 插画
- 背景：温暖的棕色渐变
- 文字：深色标题确保可读性

### 示例 3：完整参数

**输入：**
```
生成公众号封面
主题：阅读
标题：书籍是心灵的港湾
```

（注意：日期和作者名将自动生成，无需手动指定）

## 常见问题

### Q: 生成的图片比例不对怎么办？
A: Skill 会严格遵循 21:9 的宽高比（3024x1296像素）。如果显示异常，请检查浏览器缩放设置。

### Q: 标题太长怎么办？
A: 建议标题控制在 8-15 个字。如果过长，系统会自动换行，但可能影响美观。

### Q: 可以自定义颜色吗？
A: 当前版本会根据背景自动选择文字颜色。如需自定义，可以在生成后手动编辑 HTML 文件中的颜色值。

### Q: 生成的风格不够可爱怎么办？
A: Skill 会严格遵循"皮克斯风格"的规范。如果风格不符，可以重新生成，或者在提示中强调"extra cute"、"more rounded"等关键词。

## 技术细节

### 文件输出

生成的 HTML 文件包含：
- 内联 CSS 样式
- Base64 编码的图片（可选）或图片 URL
- 响应式设计，支持不同屏幕尺寸

### 自定义修改

生成后可以手动编辑 HTML 文件来调整：
- 文字大小（修改 `font-size` 值）
- 文字颜色（修改 `color` 值）
- 文字位置（修改 `top`/`left`/`bottom` 百分比）
- 字体（修改 `font-family` 列表）

### 导出使用

1. **直接使用**：在浏览器中打开 HTML 文件查看
2. **截图**：使用浏览器截图功能导出为图片
3. **转换**：使用 HTML-to-Image 工具转换为 PNG/JPG

## 最佳实践

1. **主题选择**：选择具象的主题更容易生成好看的插画（如"机器人"比"技术"更具体）
2. **标题长度**：8-12 字最佳，过长会导致字体缩小
3. **颜色对比**：如果自动颜色不理想,可以在生成后手动调整
4. **批量生成**：可以一次性提供多个标题,批量生成多个封面

## 版本更新

- **v2.0.0** (当前版本)
  - 更新为21:9宽高比（3024x1296像素）
  - 调整布局比例（右侧30-40%主体，左侧60-70%留白）
  - 日期格式改为英文星期格式（Fri. 11.11）
  - 作者名固定为"纯白精选"
  - 简化HTML模板，去除副标题标签等元素

- **v1.0.0** (2025-11-10)
  - 初始版本
  - 支持基础封面生成
  - 自动颜色适配
  - 3D 插画风格

## 反馈与支持

如遇到问题或有改进建议，请：
1. 检查输入参数是否完整
2. 确认 Claude 有图像生成能力
3. 尝试调整主题关键词的具体程度
