---
name: siliconflow-api-skills
description: 硅基流动（SiliconFlow）云服务平台文档。用于大语言模型 API 调用、图片生成、向量模型、在 Claude Code 中使用硅基流动、Chat Completions API、Stream 模式等。
---

# SiliconFlow API Skills

Comprehensive assistance with SiliconFlow API development, generated from official documentation.

## When to Use This Skill

This skill should be triggered when:
- Working with SiliconFlow API
- Asking about SiliconFlow features or APIs
- Implementing SiliconFlow solutions
- Debugging SiliconFlow code
- Learning SiliconFlow best practices

## Quick Reference

### Common Patterns

*Quick reference patterns will be added as you use the skill.*

## Reference Files

This skill includes comprehensive documentation in `references/`:

- **api_reference.md** - Api Reference documentation
- **deployment.md** - Deployment documentation
- **faqs.md** - Faqs documentation
- **features.md** - Features documentation
- **models.md** - Models documentation
- **other.md** - Other documentation
- **use_cases.md** - Use Cases documentation
- **userguide.md** - Userguide documentation

Use `view` to read specific reference files when detailed information is needed.

## Working with This Skill

### For Beginners
Start with the getting_started or tutorials reference files for foundational concepts.

### For Specific Features
Use the appropriate category reference file (api, guides, etc.) for detailed information.

### For Code Examples
The quick reference section above contains common patterns extracted from the official docs.

## Resources

### references/
Organized documentation extracted from official sources. These files contain:
- Detailed explanations
- Code examples with language annotations
- Links to original documentation
- Table of contents for quick navigation

### scripts/
Add helper scripts here for common automation tasks.

### assets/
Add templates, boilerplate, or example projects here.

## Notes

- This skill was automatically generated from official documentation
- Reference files preserve the structure and examples from source docs
- Code examples include language detection for better syntax highlighting
- Quick reference patterns are extracted from common usage examples in the docs

## Updating

To refresh this skill with updated documentation:
1. Re-run the scraper with the same configuration
2. The skill will be rebuilt with the latest information
